/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.site;

import java.util.Arrays;
import java.util.Map;
import org.hippoecm.hst.configuration.hosting.Mount;

public class MountSiteMapConfiguration {
    private final Map<String, String> parameters;
    private final String[] defaultSiteMapItemHandlerIds;
    private final String locale;
    private final String namedPipeline;
    private final boolean cacheable;
    private final String scheme;
    private final boolean schemeAgnostic;
    private final int schemeNotMatchingResponseCode;
    private final String[] defaultResourceBundleIds;
    private int hashCode;
    private final String mountContentPath;
    private final String mountContextPath;

    public MountSiteMapConfiguration(Mount mount) {
        this.parameters = mount.getParameters();
        this.defaultSiteMapItemHandlerIds = mount.getDefaultSiteMapItemHandlerIds();
        this.locale = mount.getLocale();
        this.namedPipeline = mount.getNamedPipeline();
        this.cacheable = mount.isCacheable();
        this.scheme = mount.getScheme();
        this.schemeAgnostic = mount.isSchemeAgnostic();
        this.schemeNotMatchingResponseCode = mount.getSchemeNotMatchingResponseCode();
        this.defaultResourceBundleIds = mount.getDefaultResourceBundleIds();
        this.hashCode = this.computeHashCode();
        this.mountContentPath = mount.getContentPath();
        this.mountContextPath = mount.getContextPath();
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String[] getDefaultSiteMapItemHandlerIds() {
        return this.defaultSiteMapItemHandlerIds;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getNamedPipeline() {
        return this.namedPipeline;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isSchemeAgnostic() {
        return this.schemeAgnostic;
    }

    public int getSchemeNotMatchingResponseCode() {
        return this.schemeNotMatchingResponseCode;
    }

    public String[] getDefaultResourceBundleIds() {
        return this.defaultResourceBundleIds;
    }

    public String getMountContentPath() {
        return this.mountContentPath;
    }

    public String getMountContextPath() {
        return this.mountContextPath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MountSiteMapConfiguration that = (MountSiteMapConfiguration)o;
        if (this.cacheable != that.cacheable) {
            return false;
        }
        if (this.schemeAgnostic != that.schemeAgnostic) {
            return false;
        }
        if (this.schemeNotMatchingResponseCode != that.schemeNotMatchingResponseCode) {
            return false;
        }
        if (!Arrays.equals(this.defaultResourceBundleIds, that.defaultResourceBundleIds)) {
            return false;
        }
        if (!Arrays.equals(this.defaultSiteMapItemHandlerIds, that.defaultSiteMapItemHandlerIds)) {
            return false;
        }
        if (this.locale != null ? !this.locale.equals(that.locale) : that.locale != null) {
            return false;
        }
        if (this.namedPipeline != null ? !this.namedPipeline.equals(that.namedPipeline) : that.namedPipeline != null) {
            return false;
        }
        if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) {
            return false;
        }
        if (this.scheme != null ? !this.scheme.equals(that.scheme) : that.scheme != null) {
            return false;
        }
        if (this.mountContentPath != null ? !this.mountContentPath.equals(that.mountContentPath) : that.mountContentPath != null) {
            return false;
        }
        return !(this.mountContextPath != null ? !this.mountContextPath.equals(that.mountContextPath) : that.mountContextPath != null);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int result = this.parameters != null ? this.parameters.hashCode() : 0;
        result = 31 * result + (this.defaultSiteMapItemHandlerIds != null ? Arrays.hashCode(this.defaultSiteMapItemHandlerIds) : 0);
        result = 31 * result + (this.locale != null ? this.locale.hashCode() : 0);
        result = 31 * result + (this.namedPipeline != null ? this.namedPipeline.hashCode() : 0);
        result = 31 * result + (this.cacheable ? 1 : 0);
        result = 31 * result + (this.scheme != null ? this.scheme.hashCode() : 0);
        result = 31 * result + (this.schemeAgnostic ? 1 : 0);
        result = 31 * result + this.schemeNotMatchingResponseCode;
        result = 31 * result + (this.defaultResourceBundleIds != null ? Arrays.hashCode(this.defaultResourceBundleIds) : 0);
        result = 31 * result + (this.mountContentPath != null ? this.mountContentPath.hashCode() : 0);
        result = 31 * result + (this.mountContextPath != null ? this.mountContextPath.hashCode() : 0);
        return result;
    }
}

