/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.site;

import com.google.common.base.Optional;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.cache.CompositeConfigurationNodes;
import org.hippoecm.hst.configuration.cache.HstConfigurationLoadingCache;
import org.hippoecm.hst.configuration.cache.HstNodeLoadingCache;
import org.hippoecm.hst.configuration.channel.ChannelInfo;
import org.hippoecm.hst.configuration.channel.ChannelLazyLoadingChangedBySet;
import org.hippoecm.hst.configuration.channel.ChannelPropertyMapper;
import org.hippoecm.hst.configuration.channel.ChannelUtils;
import org.hippoecm.hst.configuration.components.HstComponentConfiguration;
import org.hippoecm.hst.configuration.components.HstComponentsConfiguration;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.hosting.VirtualHost;
import org.hippoecm.hst.configuration.model.HstManager;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.model.ModelLoadingException;
import org.hippoecm.hst.configuration.site.HstSite;
import org.hippoecm.hst.configuration.site.MountSiteMapConfiguration;
import org.hippoecm.hst.configuration.sitemap.HstNoopSiteMap;
import org.hippoecm.hst.configuration.sitemap.HstSiteMap;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapService;
import org.hippoecm.hst.configuration.sitemapitemhandlers.HstSiteMapItemHandlersConfiguration;
import org.hippoecm.hst.configuration.sitemenu.HstSiteMenusConfiguration;
import org.hippoecm.hst.configuration.sitemenu.HstSiteMenusConfigurationService;
import org.hippoecm.hst.core.linking.LocationMapTree;
import org.hippoecm.hst.core.linking.LocationMapTreeComponentDocuments;
import org.hippoecm.hst.core.linking.LocationMapTreeSiteMap;
import org.hippoecm.hst.site.HstServices;
import org.onehippo.cms7.services.hst.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstSiteService
implements HstSite {
    private static final Logger log = LoggerFactory.getLogger(HstSiteService.class);
    volatile Optional<HstSiteMap> siteMap;
    volatile LocationMapTree locationMapTree;
    volatile LocationMapTree locationMapTreeComponentDocuments;
    volatile Optional<HstSiteMapItemHandlersConfiguration> siteMapItemHandlersConfigurationService;
    volatile Optional<Channel> channel;
    volatile Optional<HstComponentsConfiguration> componentsConfiguration;
    volatile Optional<HstSiteMenusConfiguration> siteMenusConfigurations;
    private String name;
    private boolean hasPreviewConfiguration;
    private String canonicalIdentifier;
    private String configurationPath;
    private MountSiteMapConfiguration mountSiteMapConfiguration;
    private HstConfigurationLoadingCache configLoadingCache;
    private final Object hstModelMutex = HstServices.getComponentManager().getComponent("hstModelMutex");

    HstSiteService(HstNode site, Mount mount, MountSiteMapConfiguration mountSiteMapConfiguration, HstNodeLoadingCache hstNodeLoadingCache, boolean isPreviewSite) throws ModelLoadingException {
        this.configLoadingCache = (HstConfigurationLoadingCache)HstServices.getComponentManager().getComponent(HstConfigurationLoadingCache.class.getName());
        this.name = site.getValueProvider().getName();
        this.canonicalIdentifier = site.getValueProvider().getIdentifier();
        this.mountSiteMapConfiguration = mountSiteMapConfiguration;
        this.findAndSetConfigurationPath(site, hstNodeLoadingCache, isPreviewSite);
        this.init(site, mount, isPreviewSite, hstNodeLoadingCache, null);
    }

    public HstSiteService(HstNode site, Mount mount, MountSiteMapConfiguration mountSiteMapConfiguration, HstNodeLoadingCache hstNodeLoadingCache, String configurationPath, boolean isPreviewSite, Channel master) {
        this.configLoadingCache = (HstConfigurationLoadingCache)HstServices.getComponentManager().getComponent(HstConfigurationLoadingCache.class.getName());
        this.name = site.getValueProvider().getName();
        this.canonicalIdentifier = site.getValueProvider().getIdentifier();
        this.mountSiteMapConfiguration = mountSiteMapConfiguration;
        this.configurationPath = configurationPath;
        this.hasPreviewConfiguration = configurationPath.endsWith("-preview") ? true : hstNodeLoadingCache.getNode(configurationPath + "-preview") != null;
        this.init(site, mount, isPreviewSite, hstNodeLoadingCache, master);
    }

    private void findAndSetConfigurationPath(HstNode site, HstNodeLoadingCache hstNodeLoadingCache, boolean isPreviewSite) {
        this.configurationPath = site.getValueProvider().hasProperty("hst:configurationpath") ? site.getValueProvider().getString("hst:configurationpath") : hstNodeLoadingCache.getRootPath() + "/" + "hst:configurations" + "/" + site.getValueProvider().getName();
        String previewConfigurationPath = this.configurationPath + "-preview";
        HstNode previewConfig = hstNodeLoadingCache.getNode(previewConfigurationPath);
        if (previewConfig != null) {
            this.hasPreviewConfiguration = true;
            if (isPreviewSite) {
                this.configurationPath = previewConfigurationPath;
            }
        }
    }

    private void init(HstNode site, Mount mount, boolean isPreviewSite, HstNodeLoadingCache hstNodeLoadingCache, Channel master) {
        log.debug("Loading channel configuration for '{}'", (Object)this.configurationPath);
        this.loadChannel(site, mount, isPreviewSite, hstNodeLoadingCache, master);
        HstComponentsConfiguration ccs = this.configLoadingCache.getComponentsConfiguration(this.configurationPath, false);
        if (ccs != null) {
            log.debug("Reusing cached HstComponentsConfiguration for '{}'", (Object)this.configurationPath);
            this.componentsConfiguration = Optional.of((Object)ccs);
        } else {
            log.debug("No cached HstComponentsConfiguration for '{}' present. On first access it will be loaded lazily", (Object)this.configurationPath);
        }
        HstSiteMapItemHandlersConfiguration hsihcs = this.configLoadingCache.getSiteMapItemHandlersConfiguration(this.configurationPath, false);
        if (hsihcs != null) {
            log.debug("Reusing cached HstSiteMapItemHandlersConfigurationService for '{}'", (Object)this.configurationPath);
            this.siteMapItemHandlersConfigurationService = Optional.of((Object)hsihcs);
        } else {
            log.debug("No cached HstSiteMapItemHandlersConfigurationService for '{}' present. On first access it will be loaded lazily", (Object)this.configurationPath);
        }
    }

    private void loadChannel(HstNode site, Mount mount, boolean isPreviewSite, HstNodeLoadingCache hstNodeLoadingCache, Channel master) {
        HstManager mngr = (HstManager)HstServices.getComponentManager().getComponent(HstManager.class.getName());
        if (mount.getContextPath() != null && !mount.getContextPath().equals(mngr.getContextPath())) {
            log.info("channel for different context path can't be loaded because of channel info class");
            this.channel = Optional.absent();
            return;
        }
        Channel ch = mount.hasNoChannelInfo() ? null : this.configLoadingCache.loadChannel(this.configurationPath, isPreviewSite, mount.getIdentifier(), mount.getContextPath());
        if (ch != null) {
            int port;
            HstNode rootConfigNode = hstNodeLoadingCache.getNode(this.configurationPath);
            if (master != null) {
                if (!rootConfigNode.getValueProvider().hasProperty("hst:branchof") || !rootConfigNode.getValueProvider().hasProperty("hst:branchid")) {
                    throw new ModelLoadingException(String.format("Cannot load branch '%s' since misses mandatory property '%s' or '%s'", this.configLoadingCache, "hst:branchof", "hst:branchid"));
                }
                ch.setBranchOf(rootConfigNode.getValueProvider().getString("hst:branchof"));
                ch.setBranchId(rootConfigNode.getValueProvider().getString("hst:branchid"));
            }
            if (rootConfigNode == null) {
                throw new ModelLoadingException("No configuration node found at '" + this.configurationPath + "'. Cannot load model for it.");
            }
            ch.setHstMountPoint(mount.getMountPoint());
            ch.setContentRoot(this.mountSiteMapConfiguration.getMountContentPath());
            ch.setHstConfigPath(this.configurationPath);
            ch.setPreviewHstConfigExists(this.hasPreviewConfiguration);
            if (rootConfigNode.getNode("hst:workspace") != null) {
                ch.setWorkspaceExists(true);
            }
            ch.setHasCustomProperties(this.hasChannelCustomProperties(ch));
            String mountPath = mount.getMountPath();
            ch.setLocale(this.mountSiteMapConfiguration.getLocale());
            ch.setMountId(mount.getIdentifier());
            ch.setMountPath(mountPath);
            ch.setContextPath(this.mountSiteMapConfiguration.getMountContextPath());
            CompositeConfigurationNodes.CompositeConfigurationNode siteMapNode = this.findSiteMapNode();
            if (siteMapNode == null) {
                log.warn("Missing sitemap below '{}' and also no sitemap is inherited.", (Object)this.configurationPath);
            } else {
                ch.setSiteMapId(siteMapNode.getMainConfigNode().getValueProvider().getIdentifier());
            }
            VirtualHost virtualHost = mount.getVirtualHost();
            ch.setCmsPreviewPrefix(virtualHost.getVirtualHosts().getCmsPreviewPrefix());
            ch.setHostname(virtualHost.getHostName());
            StringBuilder url = new StringBuilder();
            url.append(mount.getScheme());
            url.append("://");
            url.append(virtualHost.getHostName());
            if (mount.isPortInUrl() && (port = mount.getPort()) != 0 && port != 80 && port != 443) {
                url.append(':');
                url.append(mount.getPort());
            }
            if (virtualHost.isContextPathInUrl() && mount.getContextPath() != null) {
                url.append(mount.getContextPath());
            }
            if (StringUtils.isNotEmpty((String)mountPath)) {
                if (!mountPath.startsWith("/")) {
                    url.append('/');
                }
                url.append(mountPath);
            }
            ch.setUrl(url.toString());
            if (isPreviewSite) {
                ch.setPreview(true);
                ch.setChangedBySet((Set)new ChannelLazyLoadingChangedBySet(site, this, ch, hstNodeLoadingCache));
            }
        }
        this.channel = Optional.fromNullable(ch);
    }

    private CompositeConfigurationNodes.CompositeConfigurationNode findSiteMapNode() {
        CompositeConfigurationNodes ccn = this.configLoadingCache.getCompositeConfigurationNodes(this.configurationPath, "hst:sitemap");
        return ccn.getCompositeConfigurationNodes().get("hst:sitemap");
    }

    private boolean hasChannelCustomProperties(Channel channel) {
        Class<? extends ChannelInfo> channelInfoClass = this.getChannelInfoClass(channel);
        if (channelInfoClass == null) {
            return false;
        }
        return channelInfoClass != ChannelInfo.class;
    }

    private Class<? extends ChannelInfo> getChannelInfoClass(Channel channel) {
        String channelInfoClassName = channel.getChannelInfoClassName();
        if (channelInfoClassName == null) {
            log.debug("No channelInfoClassName defined. Return just the ChannelInfo interface class");
            return ChannelInfo.class;
        }
        try {
            return ChannelPropertyMapper.class.getClassLoader().loadClass(channelInfoClassName);
        }
        catch (ClassNotFoundException cnfe) {
            log.warn("Configured class '{}' was not found", (Object)channelInfoClassName, (Object)cnfe);
        }
        catch (ClassCastException cce) {
            log.warn("Configured class '{}' does not extend ChannelInfo", (Object)channelInfoClassName, (Object)cce);
        }
        return null;
    }

    public <T extends ChannelInfo> T getChannelInfo() {
        Channel channel = this.getChannel();
        if (channel == null) {
            return null;
        }
        Class<? extends ChannelInfo> channelInfoClass = this.getChannelInfoClass(channel);
        if (channelInfoClass == null) {
            return null;
        }
        return ChannelUtils.getChannelInfo(channel.getProperties(), channelInfoClass);
    }

    public Channel getChannel() {
        return (Channel)this.channel.orNull();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HstComponentsConfiguration getComponentsConfiguration() {
        if (this.componentsConfiguration != null) {
            return (HstComponentsConfiguration)this.componentsConfiguration.get();
        }
        log.debug("Loading HstComponentsConfiguration for '{}'", (Object)this.configurationPath);
        Object object = this.hstModelMutex;
        synchronized (object) {
            if (this.componentsConfiguration != null) {
                return (HstComponentsConfiguration)this.componentsConfiguration.get();
            }
            try {
                long start = System.currentTimeMillis();
                HstComponentsConfiguration ccs = this.configLoadingCache.getComponentsConfiguration(this.configurationPath, true);
                this.componentsConfiguration = Optional.of((Object)ccs);
                if (this.siteMap != null) {
                    this.checkAndLogAccessibleRootComponents(ccs, (HstSiteMap)this.siteMap.get());
                }
                log.info("Loading HstComponentsConfiguration for '{}' took '{}' ms.", (Object)this.configurationPath, (Object)String.valueOf(System.currentTimeMillis() - start));
                return ccs;
            }
            catch (Exception e) {
                this.componentsConfiguration = Optional.of((Object)HstComponentsConfiguration.NOOP);
                log.warn("Could not load HstComponentsConfiguration for '{}'. Return a NOOP HstComponentsConfiguration instance", (Object)this.configurationPath, (Object)e);
                return HstComponentsConfiguration.NOOP;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HstSiteMap getSiteMap() {
        if (this.siteMap != null) {
            return (HstSiteMap)this.siteMap.get();
        }
        Object object = this.hstModelMutex;
        synchronized (object) {
            if (this.siteMap != null) {
                return (HstSiteMap)this.siteMap.get();
            }
            try {
                long start = System.currentTimeMillis();
                CompositeConfigurationNodes.CompositeConfigurationNode siteMapNode = this.findSiteMapNode();
                if (siteMapNode == null) {
                    HstNoopSiteMap sm = new HstNoopSiteMap(this);
                    this.siteMap = Optional.of((Object)sm);
                    log.warn("Could not load HstSiteMap for '{}'. Return a NOOP sitemap for this site config", (Object)this.configurationPath);
                    return sm;
                }
                HstSiteMapService sm = new HstSiteMapService(this, siteMapNode, this.mountSiteMapConfiguration, this.getSiteMapItemHandlersConfiguration());
                this.siteMap = Optional.of((Object)sm);
                if (this.componentsConfiguration != null) {
                    this.checkAndLogAccessibleRootComponents((HstComponentsConfiguration)this.componentsConfiguration.get(), sm);
                }
                log.info("Loading HstSiteMap for '{}' took '{}' ms.", (Object)this.configurationPath, (Object)String.valueOf(System.currentTimeMillis() - start));
                return sm;
            }
            catch (ModelLoadingException e) {
                HstNoopSiteMap sm = new HstNoopSiteMap(this);
                this.siteMap = Optional.of((Object)sm);
                log.warn("Could not load HstSiteMap for '{}'. Return a NOOP sitemap for this site config", (Object)this.configurationPath, (Object)e);
                return sm;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HstSiteMapItemHandlersConfiguration getSiteMapItemHandlersConfiguration() {
        if (this.siteMapItemHandlersConfigurationService != null) {
            return (HstSiteMapItemHandlersConfiguration)this.siteMapItemHandlersConfigurationService.get();
        }
        log.debug("Loading HstComponentsConfiguration for '{}'", (Object)this.configurationPath);
        Object object = this.hstModelMutex;
        synchronized (object) {
            if (this.siteMapItemHandlersConfigurationService != null) {
                return (HstSiteMapItemHandlersConfiguration)this.siteMapItemHandlersConfigurationService.get();
            }
            try {
                long start = System.currentTimeMillis();
                HstSiteMapItemHandlersConfiguration hsihcs = this.configLoadingCache.getSiteMapItemHandlersConfiguration(this.configurationPath, true);
                this.siteMapItemHandlersConfigurationService = Optional.of((Object)hsihcs);
                log.info("Loading HstSiteMapItemHandlersConfiguration for '{}' took '{}' ms.", (Object)this.configurationPath, (Object)String.valueOf(System.currentTimeMillis() - start));
                return hsihcs;
            }
            catch (ModelLoadingException e) {
                this.siteMapItemHandlersConfigurationService = Optional.of((Object)HstSiteMapItemHandlersConfiguration.NOOP);
                log.warn("Could not load HstComponentsConfigurationService for '{}'. Return HstSiteMapItemHandlersConfiguration NOOP instance", (Object)this.configurationPath, (Object)e);
                return HstSiteMapItemHandlersConfiguration.NOOP;
            }
        }
    }

    public String getCanonicalIdentifier() {
        return this.canonicalIdentifier;
    }

    public String getConfigurationPath() {
        return this.configurationPath;
    }

    public long getVersion() {
        return -1L;
    }

    public boolean hasPreviewConfiguration() {
        return this.hasPreviewConfiguration;
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocationMapTree getLocationMapTree() {
        if (this.locationMapTree != null) {
            return this.locationMapTree;
        }
        Object object = this.hstModelMutex;
        synchronized (object) {
            if (this.locationMapTree != null) {
                return this.locationMapTree;
            }
            this.locationMapTree = new LocationMapTreeSiteMap(this.getSiteMap().getSiteMapItems());
            return this.locationMapTree;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocationMapTree getLocationMapTreeComponentDocuments() {
        if (this.locationMapTreeComponentDocuments != null) {
            return this.locationMapTreeComponentDocuments;
        }
        Object object = this.hstModelMutex;
        synchronized (object) {
            if (this.locationMapTreeComponentDocuments != null) {
                return this.locationMapTreeComponentDocuments;
            }
            this.locationMapTreeComponentDocuments = new LocationMapTreeComponentDocuments(this.getSiteMap().getSiteMapItems(), this.getComponentsConfiguration(), this.mountSiteMapConfiguration.getMountContentPath(), this.mountSiteMapConfiguration.getMountContextPath());
            return this.locationMapTreeComponentDocuments;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HstSiteMenusConfiguration getSiteMenusConfiguration() {
        if (this.siteMenusConfigurations != null) {
            return (HstSiteMenusConfiguration)this.siteMenusConfigurations.orNull();
        }
        Object object = this.hstModelMutex;
        synchronized (object) {
            if (this.siteMenusConfigurations != null) {
                return (HstSiteMenusConfiguration)this.siteMenusConfigurations.orNull();
            }
            CompositeConfigurationNodes ccn = this.configLoadingCache.getCompositeConfigurationNodes(this.configurationPath, "hst:sitemenus");
            CompositeConfigurationNodes.CompositeConfigurationNode siteMenusNode = ccn.getCompositeConfigurationNodes().get("hst:sitemenus");
            if (siteMenusNode == null) {
                log.info("There is no sitemenu configuration for '{}'. Return null", (Object)this.configurationPath);
                this.siteMenusConfigurations = Optional.absent();
                return null;
            }
            HstSiteMenusConfigurationService sc = new HstSiteMenusConfigurationService(this, siteMenusNode);
            this.siteMenusConfigurations = Optional.of((Object)sc);
            return sc;
        }
    }

    private void checkAndLogAccessibleRootComponents(HstComponentsConfiguration hstComponentsConfiguration, HstSiteMap sm) {
        for (HstSiteMapItem hstSiteMapItem : sm.getSiteMapItems()) {
            this.sanitizeSiteMapItem(hstSiteMapItem, hstComponentsConfiguration);
        }
    }

    private void sanitizeSiteMapItem(HstSiteMapItem hstSiteMapItem, HstComponentsConfiguration hstComponentsConfiguration) {
        HstComponentConfiguration hstComponentConfiguration = hstComponentsConfiguration.getComponentConfiguration(hstSiteMapItem.getComponentConfigurationId());
        if (hstComponentConfiguration == null) {
            log.info("HST Configuration info: The sitemap item '{}' does not point to a HST Component.", (Object)hstSiteMapItem.getId());
        } else {
            this.sanitizeHstComponentConfiguration(hstComponentConfiguration);
        }
        for (HstSiteMapItem child : hstSiteMapItem.getChildren()) {
            this.sanitizeSiteMapItem(child, hstComponentsConfiguration);
        }
    }

    private void sanitizeHstComponentConfiguration(HstComponentConfiguration hstComponentConfiguration) {
        String renderPath = hstComponentConfiguration.getRenderPath();
        if (renderPath == null) {
            log.info("HST Configuration info: the component '{}' does not have a render path. Component id = '{}'", (Object)hstComponentConfiguration.getName(), (Object)hstComponentConfiguration.getId());
        }
        for (HstComponentConfiguration child : hstComponentConfiguration.getChildren().values()) {
            this.sanitizeHstComponentConfiguration(child);
        }
    }

    public String toString() {
        return "HstSiteService{name='" + this.name + '\'' + ",configurationPath='" + this.configurationPath + '\'' + '}';
    }
}

