/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.site;

import java.util.Collections;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.cache.HstNodeLoadingCache;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.model.ModelLoadingException;
import org.hippoecm.hst.configuration.site.CompositeHstSiteImpl;
import org.hippoecm.hst.configuration.site.HstSite;
import org.hippoecm.hst.configuration.site.HstSiteService;
import org.hippoecm.hst.configuration.site.MountSiteMapConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstSiteFactory {
    private static final Logger log = LoggerFactory.getLogger(HstSiteFactory.class);

    public HstSite createLiveSiteService(HstNode site, Mount mount, MountSiteMapConfiguration mountSiteMapConfiguration, HstNodeLoadingCache hstNodeLoadingCache) throws ModelLoadingException {
        return this.createSiteService(site, mount, mountSiteMapConfiguration, hstNodeLoadingCache, false);
    }

    public HstSite createPreviewSiteService(HstNode site, Mount mount, MountSiteMapConfiguration mountSiteMapConfiguration, HstNodeLoadingCache hstNodeLoadingCache) throws ModelLoadingException {
        return this.createSiteService(site, mount, mountSiteMapConfiguration, hstNodeLoadingCache, true);
    }

    private HstSite createSiteService(HstNode site, Mount mount, MountSiteMapConfiguration mountSiteMapConfiguration, HstNodeLoadingCache hstNodeLoadingCache, boolean isPreviewSite) {
        HstSiteService master = new HstSiteService(site, mount, mountSiteMapConfiguration, hstNodeLoadingCache, isPreviewSite);
        if (master.getChannel() == null) {
            log.debug("Branches can only exist for configurations that have a channel");
            return master;
        }
        String masterConfigPath = master.getConfigurationPath();
        HstNode masterConfiguration = hstNodeLoadingCache.getNode(masterConfigPath);
        if (masterConfiguration.getValueProvider().hasProperty("hst:branchof")) {
            throw new ModelLoadingException(String.format("Invalid HST configuration for '%s' : It should be a master branch because directly referenced by an hst:site but '%s' does have the property '%s' which is only alowed on branches. Correct the configuration.", masterConfigPath, masterConfigPath, "hst:branchof"));
        }
        HstNode configurationsNode = masterConfiguration.getParent();
        HashMap<String, HstSiteService> branches = new HashMap<String, HstSiteService>();
        for (HstNode branchNode : configurationsNode.getNodes()) {
            String branchOf;
            if (!branchNode.getValueProvider().hasProperty("hst:branchof")) {
                log.debug("Skipping config '{}' which is not a branch.", (Object)branchNode.getName());
                continue;
            }
            String masterName = isPreviewSite ? StringUtils.substringBefore((String)StringUtils.substringAfterLast((String)masterConfigPath, (String)"/"), (String)"-preview") : StringUtils.substringAfterLast((String)masterConfigPath, (String)"/");
            if (!masterName.equals(branchOf = branchNode.getValueProvider().getString("hst:branchof"))) {
                log.debug("Skipping branch '{}' because not a branch of '{}'.", (Object)branchNode.getName(), (Object)masterName);
                continue;
            }
            if (isPreviewSite && !branchNode.getName().endsWith("-preview")) {
                log.debug("Skip loading live branch '{}' for preview master.", (Object)branchNode.getName());
                continue;
            }
            if (!isPreviewSite && branchNode.getName().endsWith("-preview")) {
                log.debug("Skip loading preview branch '{}' for live master.", (Object)branchNode.getName());
                continue;
            }
            log.info("Found branch '{}' for configuration '{}'. Loading branch.", (Object)branchNode.getName(), (Object)branchOf);
            try {
                HstSiteService branch = new HstSiteService(site, mount, mountSiteMapConfiguration, hstNodeLoadingCache, branchNode.getValueProvider().getPath(), isPreviewSite, master.getChannel());
                branches.put(branch.getChannel().getBranchId(), branch);
            }
            catch (ModelLoadingException e) {
                log.error("Could not load branch '{}'. Skip that branch.", (Object)branchNode.getName(), (Object)e);
            }
        }
        if (branches.isEmpty()) {
            return master;
        }
        log.info("Return CompositeHstSite consisting of master '{}' and branches '{}'", (Object)master, branches);
        return new CompositeHstSiteImpl(master, Collections.unmodifiableMap(branches));
    }
}

