/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.site;

import java.util.Map;
import org.hippoecm.hst.configuration.channel.ChannelInfo;
import org.hippoecm.hst.configuration.components.HstComponentsConfiguration;
import org.hippoecm.hst.configuration.site.CompositeHstSite;
import org.hippoecm.hst.configuration.site.DelegatingHstSiteProvider;
import org.hippoecm.hst.configuration.site.HstSite;
import org.hippoecm.hst.configuration.sitemap.HstSiteMap;
import org.hippoecm.hst.configuration.sitemapitemhandlers.HstSiteMapItemHandlersConfiguration;
import org.hippoecm.hst.configuration.sitemenu.HstSiteMenusConfiguration;
import org.hippoecm.hst.container.RequestContextProvider;
import org.hippoecm.hst.core.linking.LocationMapTree;
import org.hippoecm.hst.site.HstServices;
import org.onehippo.cms7.services.hst.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeHstSiteImpl
implements CompositeHstSite {
    private static final Logger log = LoggerFactory.getLogger(CompositeHstSiteImpl.class);
    private final HstSite master;
    private final Map<String, HstSite> branches;
    private final DelegatingHstSiteProvider delegatingHstSiteProvider;

    public CompositeHstSiteImpl(HstSite master, Map<String, HstSite> branches) {
        this.master = master;
        this.branches = branches;
        this.delegatingHstSiteProvider = (DelegatingHstSiteProvider)HstServices.getComponentManager().getComponent(DelegatingHstSiteProvider.class);
        if (this.delegatingHstSiteProvider == null) {
            log.warn("No DelegatingHstSiteProvider is found.");
        }
    }

    public HstSite getMaster() {
        return this.master;
    }

    public Map<String, HstSite> getBranches() {
        return this.branches;
    }

    private HstSite getActiveHstSite() {
        if (this.branches.isEmpty() || this.delegatingHstSiteProvider == null) {
            return this.master;
        }
        return this.delegatingHstSiteProvider.getHstSite(this, RequestContextProvider.get());
    }

    public String getName() {
        return this.getActiveHstSite().getName();
    }

    public String getCanonicalIdentifier() {
        return this.getActiveHstSite().getCanonicalIdentifier();
    }

    public HstSiteMapItemHandlersConfiguration getSiteMapItemHandlersConfiguration() {
        return this.getActiveHstSite().getSiteMapItemHandlersConfiguration();
    }

    public HstComponentsConfiguration getComponentsConfiguration() {
        return this.getActiveHstSite().getComponentsConfiguration();
    }

    public HstSiteMap getSiteMap() {
        return this.getActiveHstSite().getSiteMap();
    }

    public LocationMapTree getLocationMapTree() {
        return this.getActiveHstSite().getLocationMapTree();
    }

    public LocationMapTree getLocationMapTreeComponentDocuments() {
        return this.getActiveHstSite().getLocationMapTreeComponentDocuments();
    }

    public HstSiteMenusConfiguration getSiteMenusConfiguration() {
        return this.getActiveHstSite().getSiteMenusConfiguration();
    }

    public String getConfigurationPath() {
        return this.getActiveHstSite().getConfigurationPath();
    }

    @Deprecated
    public long getVersion() {
        return this.getActiveHstSite().getVersion();
    }

    public boolean hasPreviewConfiguration() {
        return this.getActiveHstSite().hasPreviewConfiguration();
    }

    public Channel getChannel() {
        return this.getActiveHstSite().getChannel();
    }

    public <T extends ChannelInfo> T getChannelInfo() {
        return (T)this.getActiveHstSite().getChannelInfo();
    }

    public String toString() {
        return "CompositeHstSiteImpl{master=" + this.master + ", branches=" + this.branches + '}';
    }
}

