/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.site;

import java.util.Map;
import javax.servlet.http.HttpSession;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.site.CompositeHstSite;
import org.hippoecm.hst.configuration.site.HstSite;
import org.hippoecm.hst.configuration.site.HstSiteProvider;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManagerHstSiteProvider
implements HstSiteProvider {
    private static final Logger log = LoggerFactory.getLogger(ChannelManagerHstSiteProvider.class);

    public HstSite getHstSite(CompositeHstSite compositeHstSite, HstRequestContext requestContext) {
        HttpSession session = requestContext.getServletRequest().getSession();
        Map mountToBranchIdMapping = (Map)session.getAttribute(HST_SITE_PROVIDER_HTTP_SESSION_KEY);
        String renderingMountId = (String)session.getAttribute("org.hippoecm.hst.container.render_mount");
        Mount mount = renderingMountId == null ? requestContext.getResolvedMount().getMount() : requestContext.getVirtualHost().getVirtualHosts().getMountByIdentifier(renderingMountId);
        if (mountToBranchIdMapping == null) {
            log.debug("No branch selected for mount '{}'. Return master", (Object)mount);
            return compositeHstSite.getMaster();
        }
        String branchId = (String)mountToBranchIdMapping.get(mount.getIdentifier());
        if (branchId == null) {
            log.debug("No branch selected for mount '{}'. Return master", (Object)mount);
            return compositeHstSite.getMaster();
        }
        HstSite branch = (HstSite)compositeHstSite.getBranches().get(branchId);
        if (branch == null) {
            log.info("Unexpected branchId '{}' for mount '{}' found on http session because no such branch present. Removing branch now and return master.", (Object)branchId, (Object)mount);
            mountToBranchIdMapping.remove(branchId);
            return compositeHstSite.getMaster();
        }
        log.info("Using branch '{}' for mount '{}'", (Object)branch.getName(), (Object)mount);
        return branch;
    }
}

