/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.model;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletContext;
import org.hippoecm.hst.cache.HstCache;
import org.hippoecm.hst.configuration.cache.HstEventsDispatcher;
import org.hippoecm.hst.configuration.cache.HstNodeLoadingCache;
import org.hippoecm.hst.configuration.hosting.MutableVirtualHosts;
import org.hippoecm.hst.configuration.hosting.VirtualHosts;
import org.hippoecm.hst.configuration.hosting.VirtualHostsService;
import org.hippoecm.hst.configuration.model.HstConfigurationAugmenter;
import org.hippoecm.hst.configuration.model.HstManager;
import org.hippoecm.hst.configuration.model.ModelLoadingException;
import org.hippoecm.hst.core.component.HstURLFactory;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.HstComponentRegistry;
import org.hippoecm.hst.core.request.HstSiteMapMatcher;
import org.hippoecm.hst.core.sitemapitemhandler.HstSiteMapItemHandlerFactory;
import org.hippoecm.hst.core.sitemapitemhandler.HstSiteMapItemHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.context.ServletContextAware;

public class HstManagerImpl
implements HstManager,
ServletContextAware {
    private static final Logger log = LoggerFactory.getLogger(HstManagerImpl.class);
    private Object hstModelMutex;
    private volatile VirtualHosts prevVirtualHostsModel;
    private volatile VirtualHosts virtualHostsModel;
    protected volatile BuilderState state = BuilderState.UNDEFINED;
    volatile int consecutiveBuildFailCounter = 0;
    private boolean staleConfigurationSupported = false;
    private HstURLFactory urlFactory;
    private HstSiteMapMatcher siteMapMatcher;
    private HstSiteMapItemHandlerFactory siteMapItemHandlerFactory;
    private HstComponentRegistry componentRegistry;
    private HstSiteMapItemHandlerRegistry siteMapItemHandlerRegistry;
    private HstCache pageCache;
    private boolean clearPageCacheAfterModelLoad;
    private HstNodeLoadingCache hstNodeLoadingCache;
    private HstEventsDispatcher hstEventsDispatcher;
    private String cmsPreviewPrefix;
    private String pathSuffixDelimiter = "./";
    private String[] hstFilterPrefixExclusions;
    private String[] hstFilterSuffixExclusions;
    private ServletContext servletContext;
    List<HstConfigurationAugmenter> hstConfigurationAugmenters = new ArrayList<HstConfigurationAugmenter>();

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setHstModelMutex(Object hstModelMutex) {
        this.hstModelMutex = hstModelMutex;
    }

    public void setHstNodeLoadingCache(HstNodeLoadingCache hstNodeLoadingCache) {
        this.hstNodeLoadingCache = hstNodeLoadingCache;
    }

    public void setHstEventsDispatcher(HstEventsDispatcher hstEventsDispatcher) {
        this.hstEventsDispatcher = hstEventsDispatcher;
    }

    public void setComponentRegistry(HstComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    public void setSiteMapItemHandlerRegistry(HstSiteMapItemHandlerRegistry siteMapItemHandlerRegistry) {
        this.siteMapItemHandlerRegistry = siteMapItemHandlerRegistry;
    }

    public void setPageCache(HstCache pageCache) {
        this.pageCache = pageCache;
    }

    public void setClearPageCacheAfterModelLoad(boolean clearPageCacheAfterModelLoad) {
        this.clearPageCacheAfterModelLoad = clearPageCacheAfterModelLoad;
    }

    public String getCmsPreviewPrefix() {
        return this.cmsPreviewPrefix;
    }

    public void setCmsPreviewPrefix(String cmsPreviewPrefix) {
        this.cmsPreviewPrefix = cmsPreviewPrefix;
    }

    @Deprecated
    public void setUrlFactory(HstURLFactory urlFactory) {
        this.urlFactory = urlFactory;
    }

    @Deprecated
    public HstURLFactory getUrlFactory() {
        return this.urlFactory;
    }

    public void setSiteMapMatcher(HstSiteMapMatcher siteMapMatcher) {
        this.siteMapMatcher = siteMapMatcher;
    }

    public HstSiteMapMatcher getSiteMapMatcher() {
        return this.siteMapMatcher;
    }

    public List<HstConfigurationAugmenter> getHstConfigurationAugmenters() {
        return this.hstConfigurationAugmenters;
    }

    public void addHstConfigurationAugmenter(HstConfigurationAugmenter augmenter) {
        this.hstConfigurationAugmenters.add(augmenter);
    }

    @Deprecated
    public void setSiteMapItemHandlerFactory(HstSiteMapItemHandlerFactory siteMapItemHandlerFactory) {
        this.siteMapItemHandlerFactory = siteMapItemHandlerFactory;
    }

    @Deprecated
    public HstSiteMapItemHandlerFactory getSiteMapItemHandlerFactory() {
        return this.siteMapItemHandlerFactory;
    }

    public String getPathSuffixDelimiter() {
        return this.pathSuffixDelimiter;
    }

    public void setPathSuffixDelimiter(String pathSuffixDelimiter) {
        this.pathSuffixDelimiter = pathSuffixDelimiter;
    }

    public void setHstFilterPrefixExclusions(String[] hstFilterPrefixExclusions) {
        this.hstFilterPrefixExclusions = hstFilterPrefixExclusions;
    }

    public void setHstFilterSuffixExclusions(String[] hstFilterSuffixExclusions) {
        this.hstFilterSuffixExclusions = hstFilterSuffixExclusions;
    }

    public String getContextPath() {
        return this.servletContext.getContextPath();
    }

    public void setStaleConfigurationSupported(boolean staleConfigurationSupported) {
        log.info("Is stale configuration for HST model supported: '{}'", (Object)staleConfigurationSupported);
        this.staleConfigurationSupported = staleConfigurationSupported;
    }

    @Deprecated
    public boolean isExcludedByHstFilterInitParameter(String pathInfo) {
        return this.isHstFilterExcludedPath(pathInfo);
    }

    public boolean isHstFilterExcludedPath(String pathInfo) {
        if (this.hstFilterPrefixExclusions != null) {
            for (String excludePrefix : this.hstFilterPrefixExclusions) {
                if (!pathInfo.startsWith(excludePrefix)) continue;
                log.debug("pathInfo '{}' is excluded by init parameter containing excludePrefix '{}'", (Object)pathInfo, (Object)excludePrefix);
                return true;
            }
        }
        if (this.hstFilterSuffixExclusions != null) {
            for (String excludeSuffix : this.hstFilterSuffixExclusions) {
                if (!pathInfo.endsWith(excludeSuffix)) continue;
                log.debug("pathInfo '{}' is excluded by init parameter containing excludeSuffix '{}'", (Object)pathInfo, (Object)excludeSuffix);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void asynchronousBuild() {
        Object object = this.hstModelMutex;
        synchronized (object) {
            if (this.state == BuilderState.UP2DATE) {
                return;
            }
            if (this.state == BuilderState.SCHEDULED) {
                return;
            }
            if (this.state == BuilderState.RUNNING) {
                log.error("BuilderState should not be possible to be in RUNNING state at this point. Return");
                return;
            }
            this.state = BuilderState.SCHEDULED;
            log.info("Asynchronous hst model build will be scheduled");
            Thread scheduled = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        long reloadDelay = HstManagerImpl.this.computeReloadDelay(HstManagerImpl.this.consecutiveBuildFailCounter);
                        if (reloadDelay > 0L) {
                            Thread.sleep(reloadDelay);
                        }
                        HstManagerImpl.this.synchronousBuild();
                    }
                    catch (ContainerException e) {
                        log.warn("Exception during building virtualhosts model. ", (Throwable)e);
                    }
                    catch (InterruptedException e) {
                        log.info("InterruptedException ", (Throwable)e);
                    }
                }
            });
            scheduled.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    log.warn("Runtime exception " + e.getClass().getName() + " during building asynchronous HST model. Reason : " + e.getMessage(), e);
                }
            });
            scheduled.start();
        }
    }

    public VirtualHosts getVirtualHosts(boolean allowStale) throws ContainerException {
        if (this.state == BuilderState.UP2DATE) {
            return this.virtualHostsModel;
        }
        if (this.state == BuilderState.UNDEFINED) {
            return this.synchronousBuild();
        }
        if (allowStale && this.staleConfigurationSupported) {
            this.asynchronousBuild();
            return this.prevVirtualHostsModel;
        }
        return this.synchronousBuild();
    }

    public VirtualHosts getVirtualHosts() throws ContainerException {
        return this.getVirtualHosts(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private VirtualHosts synchronousBuild() throws ContainerException {
        if (this.state == BuilderState.UP2DATE) {
            return this.virtualHostsModel;
        }
        Object object = this.hstModelMutex;
        synchronized (object) {
            if (this.state == BuilderState.UP2DATE) {
                return this.virtualHostsModel;
            }
            try {
                this.state = BuilderState.RUNNING;
                try {
                    this.buildSites();
                    this.state = BuilderState.UP2DATE;
                }
                catch (ModelLoadingException e) {
                    this.state = BuilderState.FAILED;
                    ++this.consecutiveBuildFailCounter;
                    if (this.prevVirtualHostsModel == null) {
                        throw new ContainerException("HST model failed to load : " + e.toString(), (Throwable)e);
                    }
                    log.warn("Exception during model loading happened. Return previous stale model. Reason: " + e.toString(), (Throwable)e);
                    VirtualHosts virtualHosts = this.prevVirtualHostsModel;
                    if (this.state == BuilderState.RUNNING) {
                        log.warn("Model failed to built. Serve old virtualHosts model.");
                        ++this.consecutiveBuildFailCounter;
                        this.state = BuilderState.FAILED;
                    }
                    return virtualHosts;
                }
            }
            finally {
                if (this.state == BuilderState.RUNNING) {
                    log.warn("Model failed to built. Serve old virtualHosts model.");
                    ++this.consecutiveBuildFailCounter;
                    this.state = BuilderState.FAILED;
                }
            }
            if (this.state == BuilderState.FAILED) {
                return this.prevVirtualHostsModel;
            }
            if (this.clearPageCacheAfterModelLoad) {
                log.info("Clearing page cache after new model is loaded");
                this.pageCache.clear();
            } else {
                log.debug("Page cache won't be cleared because 'clearPageCacheAfterModelLoad = false'");
            }
            if (this.state == BuilderState.UP2DATE) {
                this.consecutiveBuildFailCounter = 0;
                this.prevVirtualHostsModel = this.virtualHostsModel;
            }
            return this.virtualHostsModel;
        }
    }

    private long computeReloadDelay(int consecutiveBuildFailCounter) {
        switch (consecutiveBuildFailCounter) {
            case 0: {
                return 0L;
            }
            case 1: {
                return 0L;
            }
            case 2: {
                return 100L;
            }
            case 3: {
                return 1000L;
            }
            case 4: {
                return 10000L;
            }
            case 5: {
                return 30000L;
            }
        }
        return 60000L;
    }

    private void buildSites() {
        this.hstEventsDispatcher.dispatchHstEvents();
        log.info("Start building in memory hst configuration model");
        try {
            long start = System.currentTimeMillis();
            VirtualHostsService newModel = new VirtualHostsService(this, this.hstNodeLoadingCache);
            for (HstConfigurationAugmenter configurationAugmenter : this.hstConfigurationAugmenters) {
                log.info("Configuration augmenter '{}' will be augmented.", (Object)configurationAugmenter.getClass().getName());
                configurationAugmenter.augment((MutableVirtualHosts)newModel);
            }
            this.componentRegistry.unregisterAllComponents();
            this.siteMapItemHandlerRegistry.unregisterAllSiteMapItemHandlers();
            log.info("Finished build in memory hst configuration model in '{}' ms.", (Object)(System.currentTimeMillis() - start));
            this.virtualHostsModel = newModel;
        }
        catch (ModelLoadingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ModelLoadingException("Could not load hst node model due to Runtime Exception :", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markStale() {
        Object object = this.hstModelMutex;
        synchronized (object) {
            if (this.state != BuilderState.UNDEFINED) {
                this.state = BuilderState.STALE;
            }
        }
    }

    protected static enum BuilderState {
        UNDEFINED,
        UP2DATE,
        FAILED,
        STALE,
        SCHEDULED,
        RUNNING;

    }
}

