/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.hosting;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.ConfigurationUtils;
import org.hippoecm.hst.configuration.cache.HstNodeLoadingCache;
import org.hippoecm.hst.configuration.channel.Blueprint;
import org.hippoecm.hst.configuration.channel.BlueprintHandler;
import org.hippoecm.hst.configuration.channel.ChannelException;
import org.hippoecm.hst.configuration.channel.ChannelInfo;
import org.hippoecm.hst.configuration.channel.ChannelInfoClassProcessor;
import org.hippoecm.hst.configuration.channel.ChannelPropertyMapper;
import org.hippoecm.hst.configuration.channel.ChannelUtils;
import org.hippoecm.hst.configuration.channel.HstPropertyDefinition;
import org.hippoecm.hst.configuration.hosting.MatchException;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.hosting.MutableVirtualHost;
import org.hippoecm.hst.configuration.hosting.MutableVirtualHosts;
import org.hippoecm.hst.configuration.hosting.PortMount;
import org.hippoecm.hst.configuration.hosting.VirtualHost;
import org.hippoecm.hst.configuration.hosting.VirtualHostService;
import org.hippoecm.hst.configuration.internal.ContextualizableMount;
import org.hippoecm.hst.configuration.model.HstManager;
import org.hippoecm.hst.configuration.model.HstManagerImpl;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.model.ModelLoadingException;
import org.hippoecm.hst.configuration.site.CompositeHstSite;
import org.hippoecm.hst.configuration.site.HstSite;
import org.hippoecm.hst.core.container.HstContainerURL;
import org.hippoecm.hst.core.request.ResolvedMount;
import org.hippoecm.hst.core.request.ResolvedSiteMapItem;
import org.hippoecm.hst.core.request.ResolvedVirtualHost;
import org.hippoecm.hst.diagnosis.HDC;
import org.hippoecm.hst.diagnosis.Task;
import org.hippoecm.hst.provider.ValueProvider;
import org.hippoecm.hst.site.request.ResolvedVirtualHostImpl;
import org.hippoecm.hst.util.DuplicateKeyNotAllowedHashMap;
import org.hippoecm.hst.util.PathUtils;
import org.onehippo.cms7.services.HippoServiceRegistry;
import org.onehippo.cms7.services.hst.Channel;
import org.onehippo.repository.l10n.LocalizationService;
import org.onehippo.repository.l10n.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualHostsService
implements MutableVirtualHosts {
    private static final Logger log = LoggerFactory.getLogger(VirtualHostsService.class);
    private static final String WILDCARD = "_default_";
    private static final String CHANNEL_PARAMETERS_TRANSLATION_LOCATION = "hippo:hst.channelparameters";
    private HstManagerImpl hstManager;
    private HstNodeLoadingCache hstNodeLoadingCache;
    private Map<String, Map<String, MutableVirtualHost>> rootVirtualHostsByGroup = new DuplicateKeyNotAllowedHashMap();
    private Map<String, List<Mount>> mountByHostGroup = new HashMap<String, List<Mount>>();
    private Map<String, Mount> mountsByIdentifier = new HashMap<String, Mount>();
    private Map<String, Map<String, Mount>> mountByGroupAliasAndType = new HashMap<String, Map<String, Mount>>();
    private List<Mount> registeredMounts = new ArrayList<Mount>();
    private String defaultHostName;
    public static final String DEFAULT_HOMEPAGE_SITEMAP_ITEM = "root";
    private String homepage = "root";
    public static final String DEFAULT_PAGE_NOT_FOUND_PATH_INFO = "error";
    private String pageNotFound = "error";
    public static final String DEFAULT_LOCALE_STRING = "en_US";
    private String locale = "en_US";
    private boolean versionInPreviewHeader = true;
    private boolean virtualHostsConfigured;
    public static final String DEFAULT_SCHEME = "http";
    private String scheme = "http";
    private int schemeNotMatchingResponseCode = 301;
    private boolean contextPathInUrl = true;
    private String defaultContextPath;
    private boolean showPort = true;
    private String cmsPreviewPrefix;
    private int diagnosticsDepth = -1;
    private long diagnosticsThresholdMillis = -1L;
    private long diagnosticsUnitThresholdMillis = -1L;
    private boolean diagnosticsEnabled;
    private boolean cacheable = false;
    private String[] defaultResourceBundleIds;
    private boolean channelMngrSiteAuthenticationSkipped;
    private Set<String> diagnosticsForIps = new HashSet<String>(0);
    private static final String DEFAULT_CHANNEL_MNGR_SITES_NODE_NAME = "hst:sites";
    private String channelMngrSitesNodeName = "hst:sites";
    private Map<String, ResolvedVirtualHost> resolvedMapCache = new HashMap<String, ResolvedVirtualHost>();
    private String channelsRoot;
    private final Map<String, Map<String, Channel>> channelsByHostGroup = new HashMap<String, Map<String, Channel>>();
    private final Map<String, Blueprint> blueprints = new HashMap<String, Blueprint>();
    private boolean bluePrintsPrototypeChecked;

    public VirtualHostsService(HstManagerImpl hstManager, HstNodeLoadingCache hstNodeLoadingCache) {
        String sites;
        long start = System.currentTimeMillis();
        this.hstNodeLoadingCache = hstNodeLoadingCache;
        this.hstManager = hstManager;
        this.channelsRoot = hstNodeLoadingCache.getRootPath() + "/" + "hst:channels" + "/";
        this.virtualHostsConfigured = true;
        this.quickModelCheck();
        HstNode vhostsNode = hstNodeLoadingCache.getNode(hstNodeLoadingCache.getRootPath() + "/hst:hosts");
        if (vhostsNode == null) {
            throw new ModelLoadingException("No hst node found for '" + hstNodeLoadingCache.getRootPath() + "/hst:hosts'. Cannot load model.'");
        }
        ValueProvider vHostConfValueProvider = vhostsNode.getValueProvider();
        if (vHostConfValueProvider.hasProperty("hst:showcontextpath")) {
            this.contextPathInUrl = vHostConfValueProvider.getBoolean("hst:showcontextpath");
        }
        if (vHostConfValueProvider.hasProperty("hst:defaultcontextpath")) {
            this.defaultContextPath = vHostConfValueProvider.getString("hst:defaultcontextpath");
        }
        if (!ConfigurationUtils.isValidContextPath((String)this.defaultContextPath)) {
            String msg = String.format("Incorrect configured defaultContextPath '%s' for '%s': It must start with a '/' to be usedand is not allowed to contain any other '/', but it is '%s'. Skipping host from hst model.", this.defaultContextPath, hstNodeLoadingCache.getRootPath() + "/hst:hosts", this.defaultContextPath);
            log.error(msg);
            throw new ModelLoadingException(msg);
        }
        this.cmsPreviewPrefix = vHostConfValueProvider.getString("hst:cmspreviewprefix");
        this.diagnosticsEnabled = vHostConfValueProvider.getBoolean("hst:diagnosticsenabled");
        if (vHostConfValueProvider.hasProperty("hst:diagnosticsdepth")) {
            this.diagnosticsDepth = vHostConfValueProvider.getLong("hst:diagnosticsdepth").intValue();
        }
        if (vHostConfValueProvider.hasProperty("hst:diagnosticsthresholdmillisec")) {
            this.diagnosticsThresholdMillis = vHostConfValueProvider.getLong("hst:diagnosticsthresholdmillisec");
        }
        if (vHostConfValueProvider.hasProperty("hst:diagnosticsunitthresholdmillisec")) {
            this.diagnosticsUnitThresholdMillis = vHostConfValueProvider.getLong("hst:diagnosticsunitthresholdmillisec");
        }
        String[] ips = vHostConfValueProvider.getStrings("hst:diagnosticsforips");
        Collections.addAll(this.diagnosticsForIps, ips);
        if (this.cmsPreviewPrefix == null) {
            this.cmsPreviewPrefix = hstManager.getCmsPreviewPrefix();
            if (this.cmsPreviewPrefix == null) {
                this.cmsPreviewPrefix = "";
            }
        }
        if (StringUtils.isEmpty((String)this.cmsPreviewPrefix)) {
            log.info("cmsPreviewPrefix property '{}' on hst:hosts is configured to be empty. This means that when the cms and site run on the same host that a client who visited the preview in cms alsosees the preview without the cms where he expected to see the live. ", (Object)"hst:cmspreviewprefix");
        } else {
            this.cmsPreviewPrefix = PathUtils.normalizePath((String)this.cmsPreviewPrefix);
        }
        if (vHostConfValueProvider.hasProperty("hst:channelmanagerhostgroup")) {
            log.warn("Property '{}' on hst:hosts node has been deprecated and is not used any more. Can be removed.", (Object)"hst:channelmanagerhostgroup");
        }
        if (!StringUtils.isEmpty((String)(sites = vHostConfValueProvider.getString("hst:channelmanagersites")))) {
            log.info("Channel manager will load work with hst:sites node '{}' instead of the default '{}'.", (Object)sites, (Object)DEFAULT_CHANNEL_MNGR_SITES_NODE_NAME);
            this.channelMngrSitesNodeName = sites;
        }
        if (vHostConfValueProvider.hasProperty("hst:showport")) {
            this.showPort = vHostConfValueProvider.getBoolean("hst:showport");
        }
        if (vHostConfValueProvider.hasProperty("hst:prefixexclusions")) {
            this.logUnusedExclusionsProperty("hst:prefixexclusions");
        }
        if (vHostConfValueProvider.hasProperty("hst:suffixexclusions")) {
            this.logUnusedExclusionsProperty("hst:suffixexclusions");
        }
        if (vHostConfValueProvider.hasProperty("hst:scheme")) {
            this.scheme = vHostConfValueProvider.getString("hst:scheme");
        }
        if (vHostConfValueProvider.hasProperty("hst:locale")) {
            this.locale = vHostConfValueProvider.getString("hst:locale");
        }
        if (vHostConfValueProvider.hasProperty("hst:homepage")) {
            this.homepage = vHostConfValueProvider.getString("hst:homepage");
        }
        if (vHostConfValueProvider.hasProperty("hst:pagenotfound")) {
            this.pageNotFound = vHostConfValueProvider.getString("hst:pagenotfound");
        }
        if (vHostConfValueProvider.hasProperty("hst:channelmanagersiteauthenticationskipped")) {
            this.channelMngrSiteAuthenticationSkipped = vHostConfValueProvider.getBoolean("hst:channelmanagersiteauthenticationskipped");
        } else {
            log.info("No '{}' configured on hst:hosts node. Setting it by default to true", (Object)"hst:channelmanagersiteauthenticationskipped");
            this.channelMngrSiteAuthenticationSkipped = true;
        }
        if (vHostConfValueProvider.hasProperty("hst:versioninpreviewheader")) {
            this.versionInPreviewHeader = vHostConfValueProvider.getBoolean("hst:versioninpreviewheader");
        }
        if (vHostConfValueProvider.hasProperty("hst:cacheable")) {
            this.cacheable = vHostConfValueProvider.getBoolean("hst:cacheable");
            log.info("Page caching for HST is set to : {} ", (Object)this.cacheable);
        }
        this.defaultHostName = vHostConfValueProvider.getString("hst:defaulthostname");
        if (this.defaultHostName != null) {
            this.defaultHostName = this.defaultHostName.toLowerCase();
        }
        if (this.scheme == null || "".equals(this.scheme)) {
            this.scheme = DEFAULT_SCHEME;
        }
        if (vHostConfValueProvider.hasProperty("hst:schemenotmatchresponsecode")) {
            int statusCode = (int)vHostConfValueProvider.getLong("hst:schemenotmatchresponsecode").longValue();
            if (ConfigurationUtils.isSupportedSchemeNotMatchingResponseCode((int)statusCode)) {
                this.schemeNotMatchingResponseCode = statusCode;
            } else {
                log.warn("Invalid '{}' configured on '{}'. Use inherited value. Supported values are '{}'", (Object[])new String[]{"hst:schemenotmatchresponsecode", vHostConfValueProvider.getPath(), ConfigurationUtils.supportedSchemeNotMatchingResponseCodesAsString()});
            }
        }
        this.defaultResourceBundleIds = StringUtils.split((String)vHostConfValueProvider.getString("hst:defaultresourcebundleid"), (String)" ,\t\f\r\n");
        for (HstNode hostGroupNode : vhostsNode.getNodes()) {
            if (!"hst:virtualhostgroup".equals(hostGroupNode.getNodeTypeName())) {
                throw new ModelLoadingException("Expected a hostgroup node of type 'hst:virtualhostgroup' but found a node of type '" + hostGroupNode.getNodeTypeName() + "' at '" + hostGroupNode.getValueProvider().getPath() + "'");
            }
            HashMap<String, MutableVirtualHost> rootVirtualHosts = VirtualHostsService.virtualHostHashMap();
            try {
                this.rootVirtualHostsByGroup.put(hostGroupNode.getValueProvider().getName(), rootVirtualHosts);
            }
            catch (IllegalArgumentException e) {
                throw new ModelLoadingException("It should not be possible to have two hostgroups with the same name. We found duplicate group with name '" + hostGroupNode.getValueProvider().getName() + "'");
            }
            ArrayList<String> validCmsLocations = new ArrayList<String>();
            String[] cmsLocations = StringUtils.split((String)hostGroupNode.getValueProvider().getString("hst:cmslocation"), (String)" ,\t\f\r\n");
            if (cmsLocations == null) {
                log.warn("VirtualHostGroup '{}' does not have a property hst:cmslocation configured.", (Object)hostGroupNode.getValueProvider().getName());
            } else {
                for (String cmsLocation : cmsLocations) {
                    cmsLocation = cmsLocation.toLowerCase();
                    try {
                        URI testLocation = new URI(cmsLocation);
                        log.info("Cms host location for hostGroup '{}' is '{}'", (Object)hostGroupNode.getValueProvider().getName(), (Object)testLocation.getHost());
                        validCmsLocations.add(cmsLocation);
                    }
                    catch (URISyntaxException e) {
                        log.warn("'{}' is an invalid cmsLocation. cms location can't be used and skipped for hostGroup '{}'", (Object)cmsLocation, (Object)hostGroupNode.getValueProvider().getName());
                    }
                }
            }
            int defaultPort = 0;
            Long longDefaultPort = hostGroupNode.getValueProvider().getLong("hst:defaultport");
            if (longDefaultPort == null) {
                log.info("VirtualHostGroup '{}' does not have a property hst:defaultport configured. It is necessary for the channel manager to generate correct URLs, when the site should be available on a specific port (not 80 or 443).", (Object)hostGroupNode.getValueProvider().getName());
            } else {
                defaultPort = longDefaultPort.intValue();
            }
            for (HstNode virtualHostNode : hostGroupNode.getNodes()) {
                try {
                    VirtualHostService virtualHost = new VirtualHostService(this, virtualHostNode, null, hostGroupNode.getValueProvider().getName(), validCmsLocations, defaultPort, hstNodeLoadingCache);
                    rootVirtualHosts.put(virtualHost.getName(), virtualHost);
                }
                catch (ModelLoadingException e) {
                    log.error("Unable to add virtualhost with name '" + virtualHostNode.getValueProvider().getName() + "'. Fix the configuration. This virtualhost will be skipped.", (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    log.error("VirtualHostMap is not allowed to have duplicate hostnames. This problem might also result from having two hosts configuredsomething like 'preview.mycompany.org' and 'www.mycompany.org'. This results in 'mycompany.org' being a duplicate in a hierarchical presentation which the model makes from hosts splitted by dots. In this case, make sure to configure them hierarchically as org -> mycompany -> (preview , www)");
                }
            }
        }
        long startChannelLoading = System.currentTimeMillis();
        this.loadChannelsMap();
        log.info("Loading channels took '{}' ms", (Object)(System.currentTimeMillis() - startChannelLoading));
        this.loadBluePrints(hstNodeLoadingCache);
        log.info("VirtualHostsService loading took '{}' ms.", (Object)String.valueOf(System.currentTimeMillis() - start));
    }

    private void loadChannelsMap() {
        for (String hostGroupName : this.getHostGroupNames()) {
            if (!this.channelsByHostGroup.containsKey(hostGroupName)) {
                this.channelsByHostGroup.put(hostGroupName, new HashMap());
            }
            Map<String, Channel> hostGroupChannels = this.channelsByHostGroup.get(hostGroupName);
            for (Mount mount : this.getMountsByHostGroup(hostGroupName)) {
                if (mount.getContextPath() == null || !mount.getContextPath().equals(this.hstManager.getContextPath())) {
                    log.info("Skipping channel for mount {} because the mount is for contextpath'{}' and current webapp's contextpath is '{}'", new Object[]{mount, mount.getContextPath(), this.hstManager.getContextPath()});
                    continue;
                }
                if (!(mount instanceof ContextualizableMount)) continue;
                if (mount.isPreview()) {
                    log.debug("Explicit preview mounts are not added as channel (only their live equivalent");
                    continue;
                }
                HstSite hstSite = mount.getHstSite();
                if (!mount.isMapped() || hstSite == null || hstSite.getChannel() == null) {
                    log.debug("Mount '{}' does not have channel associated with it", (Object)mount.getName());
                    continue;
                }
                Channel channel = hstSite.getChannel();
                if (hostGroupChannels.containsKey(channel.getId())) {
                    this.warnDuplicateChannel(hostGroupName, mount, channel);
                    continue;
                }
                HstSite previewHstSite = ((ContextualizableMount)mount).getPreviewHstSite();
                Channel previewChannel = previewHstSite.getChannel();
                if (previewChannel != null && hostGroupChannels.containsKey(previewChannel.getId())) {
                    this.warnDuplicateChannel(hostGroupName, mount, previewChannel);
                    continue;
                }
                hostGroupChannels.put(channel.getId(), channel);
                if (previewChannel != null) {
                    if (previewChannel.getId().equals(channel.getId())) {
                        log.debug("For channel '{}' there is no explicit preview configuration (yet).", (Object)channel);
                    } else {
                        hostGroupChannels.put(previewChannel.getId(), previewChannel);
                    }
                }
                for (HstSite s : new HstSite[]{hstSite, previewHstSite}) {
                    if (!(s instanceof CompositeHstSite)) continue;
                    CompositeHstSite compositeHstSite = (CompositeHstSite)s;
                    for (HstSite site : compositeHstSite.getBranches().values()) {
                        Channel branch = site.getChannel();
                        if (hostGroupChannels.containsKey(branch.getId())) {
                            this.warnDuplicateChannel(hostGroupName, mount, branch);
                            continue;
                        }
                        hostGroupChannels.put(branch.getId(), branch);
                    }
                }
            }
        }
    }

    private void warnDuplicateChannel(String hostGroupName, Mount mount, Channel channel) {
        log.warn("Skip channel with id '{}' because already present for host group '{}'. Most likely there is a parent channel that already is a channel mngr channel. Set '{} = true' on mount '{}' to avoid this problem.", new Object[]{channel.getId(), hostGroupName, "hst:nochannelinfo", mount});
    }

    private void quickModelCheck() {
        String[] mandatoryNodes;
        String rootPath = this.hstNodeLoadingCache.getRootPath();
        for (String mandatoryNode : mandatoryNodes = new String[]{rootPath + "/hst:hosts", rootPath + "/hst:sites", rootPath + "/hst:configurations"}) {
            if (this.hstNodeLoadingCache.getNode(mandatoryNode) != null) continue;
            throw new ModelLoadingException("Hst Model cannot be loaded because missing node '" + mandatoryNode + "'");
        }
    }

    public HstManager getHstManager() {
        return this.hstManager;
    }

    @Deprecated
    public boolean isExcluded(String pathInfo) {
        return this.isHstFilterExcludedPath(pathInfo);
    }

    public boolean isHstFilterExcludedPath(String pathInfo) {
        return this.hstManager.isHstFilterExcludedPath(pathInfo);
    }

    public void addVirtualHost(MutableVirtualHost virtualHost) throws IllegalArgumentException {
        Map<String, MutableVirtualHost> rootVirtualHosts = this.rootVirtualHostsByGroup.get(virtualHost.getHostGroupName());
        if (rootVirtualHosts == null) {
            rootVirtualHosts = VirtualHostsService.virtualHostHashMap();
            this.rootVirtualHostsByGroup.put(virtualHost.getHostGroupName(), rootVirtualHosts);
        }
        rootVirtualHosts.put(virtualHost.getName(), virtualHost);
    }

    public Map<String, Map<String, MutableVirtualHost>> getRootVirtualHostsByGroup() {
        return this.rootVirtualHostsByGroup;
    }

    public void addMount(Mount mount) {
        if (this.registeredMounts.contains(mount)) {
            log.debug(" Mount '{}' already added. Return", (Object)mount);
            return;
        }
        this.registeredMounts.add(mount);
        String hostGroup = mount.getVirtualHost().getHostGroupName();
        List<Mount> mountsForGroup = this.mountByHostGroup.get(hostGroup);
        if (mountsForGroup == null) {
            mountsForGroup = new ArrayList<Mount>();
            this.mountByHostGroup.put(hostGroup, mountsForGroup);
        }
        mountsForGroup.add(mount);
        DuplicateKeyNotAllowedHashMap aliasTypeMap = this.mountByGroupAliasAndType.get(hostGroup);
        if (aliasTypeMap == null) {
            aliasTypeMap = new DuplicateKeyNotAllowedHashMap();
            this.mountByGroupAliasAndType.put(hostGroup, (Map<String, Mount>)aliasTypeMap);
        }
        for (String type : mount.getTypes()) {
            if (mount.getAlias() == null) continue;
            String aliasTypeKey = this.getAliasTypeKey(mount.getAlias(), type);
            try {
                aliasTypeMap.put(aliasTypeKey, mount);
            }
            catch (IllegalArgumentException e) {
                log.error("Incorrect hst:hosts configuration. Not allowed to have multiple mount's having the same 'alias/type/types' combination within a single hst:hostgroup. Failed for mount '{}' in hostgroup '" + mount.getVirtualHost().getHostGroupName() + "' for host '" + mount.getVirtualHost().getHostName() + "'. Make sure that you add a unique 'alias' in combination with the 'types' on the mount within a single hostgroup. The mount '{}' cannot be used for lookup. Change alias for it. Conflicting mounts are " + mount + " that conflicts with " + aliasTypeMap.get(aliasTypeKey), (Object)mount.getName(), (Object)mount.getName());
            }
        }
        this.mountsByIdentifier.put(mount.getIdentifier(), mount);
    }

    @Deprecated
    public ResolvedSiteMapItem matchSiteMapItem(HstContainerURL hstContainerURL) throws MatchException {
        ResolvedVirtualHost resolvedVirtualHost = this.matchVirtualHost(hstContainerURL.getHostName());
        if (resolvedVirtualHost == null) {
            throw new MatchException("Unknown host '" + hstContainerURL.getHostName() + "'");
        }
        ResolvedMount resolvedMount = resolvedVirtualHost.matchMount(hstContainerURL.getContextPath(), hstContainerURL.getRequestPath());
        if (resolvedMount == null) {
            throw new MatchException("resolvedVirtualHost '" + hstContainerURL.getHostName() + "' does not have a mount");
        }
        return resolvedMount.matchSiteMapItem(hstContainerURL.getPathInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolvedMount matchMount(String hostName, String contextPath, String requestPath) throws MatchException {
        Task matchingTask = null;
        try {
            if (HDC.isStarted()) {
                matchingTask = HDC.getCurrentTask().startSubtask("Host and Mount Matching");
            }
            ResolvedVirtualHost resolvedVirtualHost = this.matchVirtualHost(hostName);
            ResolvedMount resolvedMount = null;
            if (resolvedVirtualHost != null) {
                resolvedMount = resolvedVirtualHost.matchMount(contextPath, requestPath);
            }
            ResolvedMount resolvedMount2 = resolvedMount;
            return resolvedMount2;
        }
        finally {
            if (matchingTask != null) {
                matchingTask.stop();
            }
        }
    }

    public ResolvedVirtualHost matchVirtualHost(String hostName) throws MatchException {
        ResolvedVirtualHost host;
        if (!this.virtualHostsConfigured) {
            throw new MatchException("No correct virtual hosts configured. Cannot continue request");
        }
        if (hostName == null) {
            throw new MatchException("HostName not allowed to be null");
        }
        ResolvedVirtualHost rvHost = this.resolvedMapCache.get(hostName = hostName.toLowerCase());
        if (rvHost != null) {
            return rvHost;
        }
        int portNumber = 0;
        String portStrippedHostName = hostName;
        int offset = portStrippedHostName.lastIndexOf(58);
        if (offset != -1) {
            try {
                portNumber = Integer.parseInt(portStrippedHostName.substring(offset + 1));
            }
            catch (NumberFormatException nfe) {
                throw new MatchException("The hostName '" + portStrippedHostName + "' contains an invalid portnumber");
            }
            portStrippedHostName = portStrippedHostName.substring(0, offset);
        }
        if ((host = this.findMatchingVirtualHost(portStrippedHostName, portNumber)) == null && this.getDefaultHostName() != null && !this.getDefaultHostName().equals(portStrippedHostName)) {
            log.debug("Cannot find a mapping for servername '{}'. We try the default servername '{}'", (Object)portStrippedHostName, (Object)this.getDefaultHostName());
            host = portNumber != 0 ? this.matchVirtualHost(this.getDefaultHostName() + ":" + Integer.toString(portNumber)) : this.matchVirtualHost(this.getDefaultHostName());
        }
        if (host == null) {
            log.info("We cannot find a servername mapping for '{}'. Even the default servername '{}' cannot be found. Return null", (Object)portStrippedHostName, (Object)this.getDefaultHostName());
        }
        this.resolvedMapCache.put(hostName, host);
        return host;
    }

    protected ResolvedVirtualHost findMatchingVirtualHost(String hostName, int portNumber) {
        String[] requestServerNameSegments = hostName.split("\\.");
        int depth = requestServerNameSegments.length - 1;
        VirtualHost host = null;
        PortMount portMount = null;
        for (Map<String, MutableVirtualHost> rootVirtualHosts : this.rootVirtualHostsByGroup.values()) {
            VirtualHost tryHost = (VirtualHost)rootVirtualHosts.get(requestServerNameSegments[depth]);
            if (tryHost == null || (tryHost = this.traverseInToHost(tryHost, requestServerNameSegments, depth)) == null) continue;
            PortMount tryPortMount = tryHost.getPortMount(portNumber);
            if (tryPortMount != null && tryPortMount.getRootMount() != null) {
                host = tryHost;
                portMount = tryPortMount;
                break;
            }
            if (tryPortMount != null || portNumber == 0) continue;
            log.debug("Could not match the request to port '{}'. If there is a default port '0', we'll try this one", (Object)String.valueOf(portNumber));
            tryPortMount = tryHost.getPortMount(0);
            if (tryPortMount == null || tryPortMount.getRootMount() == null) continue;
            if (host != null) {
                log.debug("We already did find a possible matching host ('{}') with not an explicit portnumber match but we'll use host ('{}') as this one is equally suited.", (Object)(host.getHostName() + " (hostgroup=" + host.getHostGroupName() + ")"), (Object)(tryHost.getHostName() + " (hostgroup=" + tryHost.getHostGroupName() + ")"));
            }
            host = tryHost;
            portMount = tryPortMount;
        }
        if (host == null) {
            return null;
        }
        return new ResolvedVirtualHostImpl(host, hostName, portMount);
    }

    protected VirtualHost traverseInToHost(VirtualHost matchedHost, String[] hostNameSegments, int depth) {
        VirtualHost vhost;
        if (depth == 0) {
            return matchedHost;
        }
        if ((vhost = matchedHost.getChildHost(hostNameSegments[--depth])) == null) {
            vhost = matchedHost.getChildHost(WILDCARD);
            if (vhost != null) {
                return vhost;
            }
        } else {
            return this.traverseInToHost(vhost, hostNameSegments, depth);
        }
        return null;
    }

    public boolean isContextPathInUrl() {
        return this.contextPathInUrl;
    }

    public String getDefaultContextPath() {
        return this.defaultContextPath;
    }

    public boolean isPortInUrl() {
        return this.showPort;
    }

    public String getScheme() {
        return this.scheme;
    }

    public int getSchemeNotMatchingResponseCode() {
        return this.schemeNotMatchingResponseCode;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getDefaultHostName() {
        return this.defaultHostName;
    }

    public String getHomePage() {
        return this.homepage;
    }

    public String getPageNotFound() {
        return this.pageNotFound;
    }

    public boolean isVersionInPreviewHeader() {
        return this.versionInPreviewHeader;
    }

    public Mount getMountByGroupAliasAndType(String hostGroupName, String alias, String type) {
        Map<String, Mount> aliasTypeMap = this.mountByGroupAliasAndType.get(hostGroupName);
        if (aliasTypeMap == null) {
            return null;
        }
        if (alias == null || type == null) {
            throw new IllegalArgumentException("Alias and type are not allowed to be null");
        }
        return aliasTypeMap.get(this.getAliasTypeKey(alias, type));
    }

    public List<Mount> getMountsByHostGroup(String hostGroupName) {
        List<Object> l = this.mountByHostGroup.get(hostGroupName);
        if (l == null) {
            l = Collections.emptyList();
        }
        return Collections.unmodifiableList(l);
    }

    public List<String> getHostGroupNames() {
        return new ArrayList<String>(this.mountByHostGroup.keySet());
    }

    public static HashMap<String, MutableVirtualHost> virtualHostHashMap() {
        return new DuplicateKeyNotAllowedHashMap();
    }

    private String getAliasTypeKey(String alias, String type) {
        return alias.toLowerCase() + '\uffff' + type;
    }

    public Mount getMountByIdentifier(String uuid) {
        return this.mountsByIdentifier.get(uuid);
    }

    public String getCmsPreviewPrefix() {
        return this.cmsPreviewPrefix;
    }

    public String getChannelManagerSitesName() {
        return this.channelMngrSitesNodeName;
    }

    public boolean isDiagnosticsEnabled(String ip) {
        return this.diagnosticsEnabled && (ip == null || this.diagnosticsForIps.isEmpty() || this.diagnosticsForIps.contains(ip));
    }

    public int getDiagnosticsDepth() {
        return this.diagnosticsDepth;
    }

    public long getDiagnosticsThresholdMillis() {
        return this.diagnosticsThresholdMillis;
    }

    public long getDiagnosticsUnitThresholdMillis() {
        return this.diagnosticsUnitThresholdMillis;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public String getDefaultResourceBundleId() {
        if (this.defaultResourceBundleIds == null || this.defaultResourceBundleIds.length == 0) {
            return null;
        }
        return this.defaultResourceBundleIds[0];
    }

    public String[] getDefaultResourceBundleIds() {
        if (this.defaultResourceBundleIds == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return (String[])ArrayUtils.clone((Object[])this.defaultResourceBundleIds);
    }

    public boolean isChannelMngrSiteAuthenticationSkipped() {
        return this.channelMngrSiteAuthenticationSkipped;
    }

    public Map<String, Channel> getChannels(String hostGroup) {
        Map<String, Channel> channels = this.channelsByHostGroup.get(hostGroup);
        if (channels == null) {
            return Collections.emptyMap();
        }
        return channels;
    }

    public Map<String, Map<String, Channel>> getChannels() {
        return this.channelsByHostGroup;
    }

    public Channel getChannelByJcrPath(String hostGroup, String channelPath) {
        Map<String, Channel> channels = this.channelsByHostGroup.get(hostGroup);
        if (channels == null) {
            return null;
        }
        if (StringUtils.isBlank((String)channelPath) || !channelPath.startsWith(this.channelsRoot)) {
            throw new IllegalArgumentException("Expected a valid channel JCR path which should start with '" + this.channelsRoot + "', but got '" + channelPath + "' instead");
        }
        String channelId = channelPath.substring(this.channelsRoot.length());
        return channels.get(channelId);
    }

    public Channel getChannelById(String hostGroup, String id) {
        Map<String, Channel> channels = this.channelsByHostGroup.get(hostGroup);
        if (channels == null) {
            return null;
        }
        if (StringUtils.isBlank((String)id)) {
            throw new IllegalArgumentException("Expected a channel id, but got '" + id + "' instead");
        }
        return channels.get(id);
    }

    public List<Blueprint> getBlueprints() {
        if (!this.bluePrintsPrototypeChecked) {
            this.setBluePrintsPrototypes();
        }
        return new ArrayList<Blueprint>(this.blueprints.values());
    }

    public Blueprint getBlueprint(String id) {
        if (!this.bluePrintsPrototypeChecked) {
            this.setBluePrintsPrototypes();
        }
        return this.blueprints.get(id);
    }

    public Class<? extends ChannelInfo> getChannelInfoClass(Channel channel) throws ChannelException {
        if (channel == null) {
            throw new ChannelException("Cannot get ChannelInfoClass for null");
        }
        String channelInfoClassName = channel.getChannelInfoClassName();
        if (channelInfoClassName == null) {
            log.debug("No channelInfoClassName defined. Return just the ChannelInfo interface class");
            return ChannelInfo.class;
        }
        try {
            return ChannelPropertyMapper.class.getClassLoader().loadClass(channelInfoClassName);
        }
        catch (ClassNotFoundException cnfe) {
            throw new ChannelException("Configured class " + channelInfoClassName + " was not found", (Throwable)cnfe);
        }
        catch (ClassCastException cce) {
            throw new ChannelException("Configured class " + channelInfoClassName + " does not extend ChannelInfo", (Throwable)cce);
        }
    }

    public Class<? extends ChannelInfo> getChannelInfoClass(String hostGroup, String id) throws ChannelException {
        try {
            return this.getChannelInfoClass(this.getChannelById(hostGroup, id));
        }
        catch (IllegalArgumentException e) {
            throw new ChannelException("ChannelException for getChannelInfoClass", (Throwable)e);
        }
    }

    public <T extends ChannelInfo> T getChannelInfo(Channel channel) throws ChannelException {
        Class<? extends ChannelInfo> channelInfoClass = this.getChannelInfoClass(channel);
        return ChannelUtils.getChannelInfo(channel.getProperties(), channelInfoClass);
    }

    public java.util.ResourceBundle getResourceBundle(Channel channel, Locale locale) {
        String channelInfoClassName = channel.getChannelInfoClassName();
        if (channelInfoClassName != null) {
            String bundleName;
            ResourceBundle repositoryResourceBundle;
            LocalizationService localizationService = (LocalizationService)HippoServiceRegistry.getService(LocalizationService.class);
            if (localizationService != null && (repositoryResourceBundle = localizationService.getResourceBundle(bundleName = "hippo:hst.channelparameters." + channelInfoClassName, locale)) != null) {
                return repositoryResourceBundle.toJavaResourceBundle();
            }
            try {
                return java.util.ResourceBundle.getBundle(channelInfoClassName, locale);
            }
            catch (MissingResourceException e) {
                log.info("Could not load repository or Java resource bundle for class '{}' and locale '{}', using untranslated labels for channel properties.", (Object)channelInfoClassName, (Object)locale);
                return null;
            }
        }
        return null;
    }

    public List<HstPropertyDefinition> getPropertyDefinitions(Channel channel) {
        try {
            Class<? extends ChannelInfo> channelInfoClass;
            if (channel.getChannelInfoClassName() != null && (channelInfoClass = this.getChannelInfoClass(channel)) != null) {
                return ChannelInfoClassProcessor.getProperties(channelInfoClass);
            }
        }
        catch (ChannelException ex) {
            log.warn("Could not load properties", (Throwable)ex);
        }
        return Collections.emptyList();
    }

    public List<HstPropertyDefinition> getPropertyDefinitions(String hostGroup, String channelId) {
        return this.getPropertyDefinitions(this.getChannelById(hostGroup, channelId));
    }

    private void loadBlueprints(HstNode rootConfigNode) {
        HstNode blueprintsNode = rootConfigNode.getNode("hst:blueprints");
        if (blueprintsNode != null) {
            for (HstNode blueprintNode : blueprintsNode.getNodes()) {
                String blueprintContextPath = blueprintNode.getValueProvider().getString("hst:contextpath");
                if (blueprintContextPath == null) {
                    blueprintContextPath = this.getDefaultContextPath();
                }
                if (!this.hstManager.getContextPath().equals(blueprintContextPath)) {
                    log.info("Skipping blueprint '{}' because only suited for contextPath '{}' and current webapp's contextPath is '{}'.", new Object[]{blueprintNode.getValueProvider().getPath(), blueprintContextPath, this.hstManager.getContextPath()});
                    continue;
                }
                if (!ConfigurationUtils.isValidContextPath((String)blueprintContextPath)) {
                    String msg = String.format("Incorrect configured contextPath '%s' for blueprint '%s': It must start with a '/' to be usedand is not allowed to contain any other '/', but it is '%s'. Skipping blueprint from hst model.", blueprintContextPath, blueprintNode.getValueProvider().getPath(), blueprintContextPath);
                    log.error(msg);
                    continue;
                }
                try {
                    this.blueprints.put(blueprintNode.getName(), BlueprintHandler.buildBlueprint(blueprintNode, blueprintContextPath));
                }
                catch (ModelLoadingException e) {
                    log.error("Cannot load blueprint '{}' :", (Object)blueprintNode.getValueProvider().getPath(), (Object)e);
                }
            }
        }
    }

    private void loadBluePrints(HstNodeLoadingCache hstNodeLoadingCache) {
        HstNode rootConfigNode = hstNodeLoadingCache.getNode(hstNodeLoadingCache.getRootPath());
        this.bluePrintsPrototypeChecked = false;
        this.loadBlueprints(rootConfigNode);
    }

    private void setBluePrintsPrototypes() {
        if (this.bluePrintsPrototypeChecked) {
            return;
        }
        try (HstNodeLoadingCache.LazyCloseableSession session = this.hstNodeLoadingCache.createLazyCloseableSession();){
            for (Blueprint blueprint : this.blueprints.values()) {
                String prototypePath = "/hippo:configuration/hippo:queries/hippo:templates/new-subsite/hippostd:templates/" + blueprint.getId();
                if (!session.getSession().nodeExists(prototypePath)) continue;
                blueprint.setHasContentPrototype(true);
            }
        }
        catch (Exception e) {
            throw new ModelLoadingException("Could not check blueprint prototypes : ", e);
        }
        this.bluePrintsPrototypeChecked = true;
    }

    private void logUnusedExclusionsProperty(String property) {
        log.warn("Property '{}' not used any more. Remove it from hst:hosts node. Use a (hst:default) sitemap item to account for prefixes/suffixes that need special handling or use hst-config.properties to set comma separated list for filter.prefix.exclusions or filter.suffix.exclusions.", (Object)property);
    }
}

