/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.hosting;

import com.google.common.net.InetAddresses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.ConfigurationUtils;
import org.hippoecm.hst.configuration.cache.HstNodeLoadingCache;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.hosting.MountService;
import org.hippoecm.hst.configuration.hosting.MutablePortMount;
import org.hippoecm.hst.configuration.hosting.MutableVirtualHost;
import org.hippoecm.hst.configuration.hosting.PortMount;
import org.hippoecm.hst.configuration.hosting.PortMountService;
import org.hippoecm.hst.configuration.hosting.VirtualHost;
import org.hippoecm.hst.configuration.hosting.VirtualHosts;
import org.hippoecm.hst.configuration.hosting.VirtualHostsService;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.model.ModelLoadingException;
import org.hippoecm.hst.core.internal.StringPool;
import org.hippoecm.hst.util.HstRequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VirtualHostService
implements MutableVirtualHost {
    private static final Logger log = LoggerFactory.getLogger(VirtualHostService.class);
    private Map<String, MutableVirtualHost> childVirtualHosts = VirtualHostsService.virtualHostHashMap();
    private String name;
    private String hostName;
    private String homepage;
    private String pageNotFound;
    private String locale;
    private boolean versionInPreviewHeader;
    private VirtualHosts virtualHosts;
    private String hostGroupName;
    private VirtualHostService parentHost;
    private Map<Integer, MutablePortMount> portMounts = new HashMap<Integer, MutablePortMount>();
    private boolean contextPathInUrl;
    private String contextPath;
    private boolean showPort;
    private String scheme;
    private boolean schemeAgnostic;
    private int schemeNotMatchingResponseCode = -1;
    private final List<String> cmsLocations;
    private Integer defaultPort;
    private final boolean cacheable;
    private String[] defaultResourceBundleIds;
    private String cdnHost;
    private boolean customHttpsSupported;

    public VirtualHostService(VirtualHostsService virtualHosts, HstNode virtualHostNode, VirtualHostService parentHost, String hostGroupName, List<String> cmsLocations, int defaultPort, HstNodeLoadingCache hstNodeLoadingCache) throws ModelLoadingException {
        PortMountService portMount;
        this.parentHost = parentHost;
        this.virtualHosts = virtualHosts;
        this.hostGroupName = StringPool.get((String)hostGroupName);
        this.cmsLocations = cmsLocations;
        this.defaultPort = defaultPort;
        this.contextPathInUrl = virtualHostNode.getValueProvider().hasProperty("hst:showcontextpath") ? virtualHostNode.getValueProvider().getBoolean("hst:showcontextpath") : (parentHost != null ? parentHost.contextPathInUrl : virtualHosts.isContextPathInUrl());
        if (virtualHostNode.getValueProvider().hasProperty("hst:onlyforcontextpath")) {
            log.warn("Property '{}' on Mount '{}' is deprecated. Use property '{}' instead", new Object[]{"hst:onlyforcontextpath", virtualHostNode.getValueProvider().getPath(), "hst:contextpath"});
            this.contextPath = virtualHostNode.getValueProvider().getString("hst:onlyforcontextpath");
        }
        if (virtualHostNode.getValueProvider().hasProperty("hst:contextpath")) {
            this.contextPath = virtualHostNode.getValueProvider().getString("hst:contextpath");
        }
        if (this.contextPath == null) {
            this.contextPath = parentHost == null ? virtualHosts.getDefaultContextPath() : parentHost.getContextPath();
        }
        if (!ConfigurationUtils.isValidContextPath((String)this.contextPath)) {
            String msg = String.format("Incorrect configured contextPath '%s' for host '%s': It must start with a '/' to be usedand is not allowed to contain any other '/', but it is '%s'. Skipping host from hst model.", this.contextPath, virtualHostNode.getValueProvider().getPath(), this.contextPath);
            log.warn(msg);
            throw new ModelLoadingException(msg);
        }
        this.showPort = virtualHostNode.getValueProvider().hasProperty("hst:showport") ? virtualHostNode.getValueProvider().getBoolean("hst:showport") : (parentHost != null ? parentHost.showPort : virtualHosts.isPortInUrl());
        if (virtualHostNode.getValueProvider().hasProperty("hst:scheme")) {
            this.scheme = StringPool.get((String)virtualHostNode.getValueProvider().getString("hst:scheme"));
        }
        if (StringUtils.isBlank((String)this.scheme)) {
            String string = this.scheme = parentHost != null ? parentHost.getScheme() : virtualHosts.getScheme();
        }
        if (virtualHostNode.getValueProvider().hasProperty("hst:schemeagnostic")) {
            this.schemeAgnostic = virtualHostNode.getValueProvider().getBoolean("hst:schemeagnostic");
        } else if (parentHost != null) {
            this.schemeAgnostic = parentHost.isSchemeAgnostic();
        }
        if (virtualHostNode.getValueProvider().hasProperty("hst:schemenotmatchresponsecode")) {
            this.schemeNotMatchingResponseCode = (int)virtualHostNode.getValueProvider().getLong("hst:schemenotmatchresponsecode").longValue();
            if (!ConfigurationUtils.isSupportedSchemeNotMatchingResponseCode((int)this.schemeNotMatchingResponseCode)) {
                log.warn("Invalid '{}' configured on '{}'. Use inherited value. Supported values are '{}'", (Object[])new String[]{"hst:schemenotmatchresponsecode", virtualHostNode.getValueProvider().getPath(), ConfigurationUtils.supportedSchemeNotMatchingResponseCodesAsString()});
                this.schemeNotMatchingResponseCode = -1;
            }
        }
        if (this.schemeNotMatchingResponseCode == -1) {
            int n = this.schemeNotMatchingResponseCode = parentHost != null ? parentHost.getSchemeNotMatchingResponseCode() : virtualHosts.getSchemeNotMatchingResponseCode();
        }
        if (virtualHostNode.getValueProvider().hasProperty("hst:customhttpssupport")) {
            this.customHttpsSupported = virtualHostNode.getValueProvider().getBoolean("hst:customhttpssupport");
        } else {
            boolean bl = this.customHttpsSupported = parentHost != null ? parentHost.isCustomHttpsSupported() : false;
        }
        this.locale = virtualHostNode.getValueProvider().hasProperty("hst:locale") ? virtualHostNode.getValueProvider().getString("hst:locale") : (parentHost != null ? parentHost.locale : virtualHosts.getLocale());
        this.locale = StringPool.get((String)this.locale);
        this.homepage = virtualHostNode.getValueProvider().hasProperty("hst:homepage") ? virtualHostNode.getValueProvider().getString("hst:homepage") : (parentHost != null ? parentHost.homepage : virtualHosts.getHomePage());
        this.homepage = StringPool.get((String)this.homepage);
        this.pageNotFound = virtualHostNode.getValueProvider().hasProperty("hst:pagenotfound") ? virtualHostNode.getValueProvider().getString("hst:pagenotfound") : (parentHost != null ? parentHost.pageNotFound : virtualHosts.getPageNotFound());
        this.pageNotFound = StringPool.get((String)this.pageNotFound);
        this.versionInPreviewHeader = virtualHostNode.getValueProvider().hasProperty("hst:versioninpreviewheader") ? virtualHostNode.getValueProvider().getBoolean("hst:versioninpreviewheader") : (parentHost != null ? parentHost.versionInPreviewHeader : virtualHosts.isVersionInPreviewHeader());
        this.cacheable = virtualHostNode.getValueProvider().hasProperty("hst:cacheable") ? virtualHostNode.getValueProvider().getBoolean("hst:cacheable") : (parentHost != null ? parentHost.isCacheable() : virtualHosts.isCacheable());
        this.defaultResourceBundleIds = virtualHostNode.getValueProvider().hasProperty("hst:defaultresourcebundleid") ? StringUtils.split((String)virtualHostNode.getValueProvider().getString("hst:defaultresourcebundleid"), (String)" ,\t\f\r\n") : (parentHost != null ? parentHost.getDefaultResourceBundleIds() : virtualHosts.getDefaultResourceBundleIds());
        if (virtualHostNode.getValueProvider().hasProperty("hst:cdnhost")) {
            this.cdnHost = virtualHostNode.getValueProvider().getString("hst:cdnhost");
        } else if (parentHost != null) {
            this.cdnHost = parentHost.getCdnHost();
        }
        if (StringUtils.isBlank((String)this.cdnHost) && !StringUtils.isEmpty((String)this.cdnHost)) {
            this.cdnHost = "";
        }
        if (StringUtils.isNotBlank((String)this.cdnHost) && !this.validCdnHost(this.cdnHost)) {
            log.error("Ignoring invalid CDN host '{}'. Supported format is : //hostname or //hostname:portnumber. It is not allowed to start with http: or https: and is not allowed to end with a /. Ignoring configured cdnHost '{}'.", (Object)this.cdnHost, (Object)this.cdnHost);
            this.cdnHost = null;
        }
        String fullName = virtualHostNode.getValueProvider().getName();
        String[] nameSegments = fullName.split("[.]");
        VirtualHostService attachPortMountToHost = this;
        if (nameSegments.length > 1) {
            if (!InetAddresses.isInetAddress((String)fullName)) {
                throw new ModelLoadingException("Node hst:virtualhost is not allowed to be '" + fullName + "'. Only ip-addresses are allowed to have a '.' in the nodename. Re-configure the host to a hierarchical structure");
            }
            this.name = StringPool.get((String)nameSegments[nameSegments.length - 1]);
            int depth = nameSegments.length - 2;
            if (depth > -1) {
                VirtualHostService childHost = new VirtualHostService(this, nameSegments, depth, hostGroupName, cmsLocations, defaultPort);
                this.childVirtualHosts.put(childHost.name, childHost);
            }
            while (depth > -1) {
                if (attachPortMountToHost == null) {
                    throw new ModelLoadingException("Something went wrong because attachMountToHost should never be possible to be null.");
                }
                attachPortMountToHost = (VirtualHostService)attachPortMountToHost.getChildHost(nameSegments[depth]);
                --depth;
            }
        } else {
            this.name = virtualHostNode.getValueProvider().getName().toLowerCase();
        }
        this.hostName = StringPool.get((String)this.buildHostName());
        HstNode mountRoot = virtualHostNode.getNode("hst:root");
        if (mountRoot != null) {
            log.info("Host '{}' does have a root Mount configured without PortMount. This Mount is port agnostic ", (Object)this.getHostName());
            HstNode mountNode = virtualHostNode.getNode("hst:root");
            if ("hst:mount".equals(mountNode.getNodeTypeName())) {
                try {
                    MountService mount = new MountService(mountNode, null, (VirtualHost)attachPortMountToHost, hstNodeLoadingCache, defaultPort);
                    portMount = new PortMountService((Mount)mount);
                    attachPortMountToHost.portMounts.put(portMount.getPortNumber(), portMount);
                }
                catch (ModelLoadingException e) {
                    String path = mountNode.getValueProvider().getPath();
                    log.error("Skipping incorrect mount or port mount for mount node '" + path + "'. ", (Throwable)e);
                }
            } else {
                log.error("Expected a node of type '{}' at '{}' but was of type '" + mountNode.getNodeTypeName() + "'", (Object)"hst:mount", (Object)mountNode.getValueProvider().getPath());
            }
        }
        for (HstNode child : virtualHostNode.getNodes()) {
            if ("hst:virtualhost".equals(child.getNodeTypeName())) {
                try {
                    VirtualHostService childHost = new VirtualHostService(virtualHosts, child, attachPortMountToHost, hostGroupName, cmsLocations, defaultPort, hstNodeLoadingCache);
                    attachPortMountToHost.childVirtualHosts.put(childHost.name, childHost);
                }
                catch (ModelLoadingException e) {
                    log.error("Skipping incorrect virtual host for node '" + child.getValueProvider().getPath() + "'", (Throwable)e);
                }
                continue;
            }
            if (!"hst:portmount".equals(child.getNodeTypeName())) continue;
            try {
                portMount = new PortMountService(child, (VirtualHost)attachPortMountToHost, hstNodeLoadingCache);
                attachPortMountToHost.portMounts.put(portMount.getPortNumber(), portMount);
            }
            catch (ModelLoadingException e) {
                log.error("The host '" + attachPortMountToHost.getHostName() + "' for port '" + child.getName() + "' contains an incorrect configured Mount. The host with port cannot be used for hst request processing", (Throwable)e);
            }
        }
    }

    public VirtualHostService(VirtualHostService parent, String[] nameSegments, int position, String hostGroupName, List<String> cmsLocations, Integer defaultPort) {
        this.parentHost = parent;
        this.virtualHosts = parent.virtualHosts;
        this.hostGroupName = hostGroupName;
        this.cmsLocations = cmsLocations;
        this.defaultPort = defaultPort;
        this.scheme = parent.scheme;
        this.schemeAgnostic = parent.schemeAgnostic;
        this.schemeNotMatchingResponseCode = parent.schemeNotMatchingResponseCode;
        this.locale = parent.locale;
        this.homepage = parent.homepage;
        this.pageNotFound = parent.pageNotFound;
        this.versionInPreviewHeader = parent.versionInPreviewHeader;
        this.contextPathInUrl = parent.contextPathInUrl;
        this.contextPath = parent.contextPath;
        this.showPort = parent.showPort;
        this.cacheable = parent.cacheable;
        this.defaultResourceBundleIds = parent.defaultResourceBundleIds;
        this.cdnHost = parent.cdnHost;
        this.customHttpsSupported = parent.customHttpsSupported;
        this.name = nameSegments[position];
        int nextPosition = position - 1;
        if (nextPosition > -1) {
            VirtualHostService childHost = new VirtualHostService(this, nameSegments, nextPosition, hostGroupName, cmsLocations, defaultPort);
            this.childVirtualHosts.put(childHost.name, childHost);
        }
        this.hostName = StringPool.get((String)this.buildHostName());
    }

    public void addVirtualHost(MutableVirtualHost virtualHost) throws IllegalArgumentException {
        this.childVirtualHosts.put(virtualHost.getName(), virtualHost);
    }

    public void addPortMount(MutablePortMount portMount) throws IllegalArgumentException {
        if (this.portMounts.containsKey(portMount.getPortNumber())) {
            throw new IllegalArgumentException("Cannot add a portMount for port '" + portMount.getPortNumber() + "' because portMount already exists.");
        }
        this.portMounts.put(portMount.getPortNumber(), portMount);
    }

    private boolean validCdnHost(String cdnHost) {
        if (!cdnHost.startsWith("//")) {
            return false;
        }
        return !cdnHost.endsWith("/");
    }

    public String getName() {
        return this.name;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostGroupName() {
        return this.hostGroupName;
    }

    public boolean isContextPathInUrl() {
        return this.contextPathInUrl;
    }

    @Deprecated
    public String onlyForContextPath() {
        return this.contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean isPortInUrl() {
        return this.showPort;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isSchemeAgnostic() {
        return this.schemeAgnostic;
    }

    public int getSchemeNotMatchingResponseCode() {
        return this.schemeNotMatchingResponseCode;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getHomePage() {
        return this.homepage;
    }

    public String getPageNotFound() {
        return this.pageNotFound;
    }

    public boolean isVersionInPreviewHeader() {
        return this.versionInPreviewHeader;
    }

    @Deprecated
    public String getCmsLocation() {
        if (!this.cmsLocations.isEmpty()) {
            return this.cmsLocations.get(0);
        }
        return null;
    }

    public List<String> getCmsLocations() {
        return this.cmsLocations;
    }

    public Integer getDefaultPort() {
        return this.defaultPort;
    }

    public VirtualHosts getVirtualHosts() {
        return this.virtualHosts;
    }

    public PortMount getPortMount(int portNumber) {
        return (PortMount)this.portMounts.get(portNumber);
    }

    public VirtualHost getChildHost(String name) {
        return (VirtualHost)this.childVirtualHosts.get(name);
    }

    public String getBaseURL(HttpServletRequest request) {
        StringBuilder builder = new StringBuilder();
        String scheme = HstRequestUtils.getFarthestRequestScheme((HttpServletRequest)request);
        String serverName = HstRequestUtils.getFarthestRequestHost((HttpServletRequest)request, (boolean)false);
        builder.append(scheme);
        builder.append("://").append(serverName);
        return builder.toString();
    }

    public List<VirtualHost> getChildHosts() {
        return new ArrayList<MutableVirtualHost>(this.childVirtualHosts.values());
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    public String getDefaultResourceBundleId() {
        if (this.defaultResourceBundleIds == null || this.defaultResourceBundleIds.length == 0) {
            return null;
        }
        return this.defaultResourceBundleIds[0];
    }

    public String[] getDefaultResourceBundleIds() {
        if (this.defaultResourceBundleIds == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return (String[])ArrayUtils.clone((Object[])this.defaultResourceBundleIds);
    }

    public String getCdnHost() {
        return this.cdnHost;
    }

    public boolean isCustomHttpsSupported() {
        return this.customHttpsSupported;
    }

    private String buildHostName() {
        StringBuilder builder = new StringBuilder(this.name);
        VirtualHostService ancestor = this.parentHost;
        while (ancestor != null) {
            builder.append(".").append(ancestor.name);
            ancestor = ancestor.parentHost;
        }
        return builder.toString();
    }

    public String toString() {
        return "VirtualHostService [name=" + this.name + ", hostName =" + this.hostName + ", hostGroupName=" + this.hostGroupName + "]";
    }
}

