/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.hosting;

import org.hippoecm.hst.configuration.cache.HstNodeLoadingCache;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.hosting.MountService;
import org.hippoecm.hst.configuration.hosting.MutableMount;
import org.hippoecm.hst.configuration.hosting.MutablePortMount;
import org.hippoecm.hst.configuration.hosting.VirtualHost;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.model.ModelLoadingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortMountService
implements MutablePortMount {
    private static final Logger log = LoggerFactory.getLogger(PortMountService.class);
    private int portNumber;
    private Mount rootMount;

    public PortMountService(HstNode portMount, VirtualHost virtualHost, HstNodeLoadingCache hstNodeLoadingCache) throws ModelLoadingException {
        String nodeName = portMount.getValueProvider().getName();
        try {
            this.portNumber = Integer.parseInt(nodeName);
            if (this.portNumber < 1) {
                throw new ModelLoadingException("Not allowed PortMount name '" + nodeName + "' : PortMount must be a positive integer larger than 0");
            }
        }
        catch (NumberFormatException e) {
            throw new ModelLoadingException("Not allowed PortMount name '" + nodeName + "' : PortMount must be a positive integer larger than 0");
        }
        HstNode mount = portMount.getNode("hst:root");
        if (mount != null && "hst:mount".equals(mount.getNodeTypeName())) {
            this.rootMount = new MountService(mount, null, virtualHost, hstNodeLoadingCache, this.portNumber);
        }
    }

    public PortMountService(Mount rootMount) {
        this.rootMount = rootMount;
        this.portNumber = 0;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public Mount getRootMount() {
        return this.rootMount;
    }

    public void setRootMount(MutableMount mount) {
        this.rootMount = mount;
    }

    public String toString() {
        return "PortMountService [portNumber=" + this.portNumber + "]";
    }
}

