/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.hosting;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.ConfigurationUtils;
import org.hippoecm.hst.configuration.cache.HstNodeLoadingCache;
import org.hippoecm.hst.configuration.channel.ChannelInfo;
import org.hippoecm.hst.configuration.hosting.Mount;
import org.hippoecm.hst.configuration.hosting.MutableMount;
import org.hippoecm.hst.configuration.hosting.MutableVirtualHosts;
import org.hippoecm.hst.configuration.hosting.VirtualHost;
import org.hippoecm.hst.configuration.hosting.VirtualHostService;
import org.hippoecm.hst.configuration.hosting.VirtualHostsService;
import org.hippoecm.hst.configuration.internal.ContextualizableMount;
import org.hippoecm.hst.configuration.model.HstManager;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.model.ModelLoadingException;
import org.hippoecm.hst.configuration.site.HstSite;
import org.hippoecm.hst.configuration.site.HstSiteFactory;
import org.hippoecm.hst.configuration.site.MountSiteMapConfiguration;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.core.internal.CollectionOptimizer;
import org.hippoecm.hst.core.internal.StringPool;
import org.hippoecm.hst.core.request.HstSiteMapMatcher;
import org.hippoecm.hst.site.HstServices;
import org.hippoecm.hst.util.PathUtils;
import org.onehippo.cms7.services.hst.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MountService
implements ContextualizableMount,
MutableMount {
    private static final Logger log = LoggerFactory.getLogger(MountService.class);
    private static final String DEFAULT_TYPE = "live";
    private String name;
    private String jcrLocation;
    private String uuid;
    private VirtualHost virtualHost;
    private Mount parent;
    private HstSite hstSite;
    private HstSite previewHstSite;
    private Map<String, MutableMount> childMountServices = new HashMap<String, MutableMount>();
    private String alias;
    private Map<String, Object> allProperties;
    private String type = "live";
    private List<String> types;
    private boolean versionInPreviewHeader;
    private String namedPipeline;
    private String mountPath;
    private String contentPath;
    private String mountPoint;
    private boolean noChannelInfo;
    private boolean isMapped = true;
    private String homepage;
    private String pageNotFound;
    private boolean contextPathInUrl;
    private boolean showPort;
    private int port;
    private String contextPath;
    private String scheme;
    private boolean schemeAgnostic;
    private volatile Boolean containsMultipleSchemes = null;
    private int schemeNotMatchingResponseCode = -1;
    private String locale;
    private boolean authenticated;
    private Set<String> roles;
    private Set<String> users;
    private boolean subjectBasedSession;
    private boolean sessionStateful;
    private final boolean cacheable;
    private String[] defaultResourceBundleIds;
    private String formLoginPage;
    private String[] defaultSiteMapItemHandlerIds;
    private List<String> cmsLocations;
    private Map<String, String> parameters;
    private HstSiteMapMatcher matcher;

    public MountService(HstNode mount, Mount parent, VirtualHost virtualHost, HstNodeLoadingCache hstNodeLoadingCache, int port) throws ModelLoadingException {
        this.virtualHost = virtualHost;
        this.parent = parent;
        this.port = port;
        this.name = StringPool.get((String)mount.getValueProvider().getName());
        this.jcrLocation = mount.getValueProvider().getPath();
        this.uuid = mount.getValueProvider().getIdentifier();
        this.allProperties = mount.getValueProvider().getProperties();
        this.parameters = new HashMap<String, String>();
        String[] parameterNames = mount.getValueProvider().getStrings("hst:parameternames");
        String[] parameterValues = mount.getValueProvider().getStrings("hst:parametervalues");
        if (parameterNames != null && parameterValues != null) {
            if (parameterNames.length != parameterValues.length) {
                log.warn("Skipping parameters for mount '{}' at '{}' because they only make sense if there are equal number of names and values", (Object)this.getName(), (Object)mount.getValueProvider().getPath());
            } else {
                for (int i = 0; i < parameterNames.length; ++i) {
                    this.parameters.put(StringPool.get((String)parameterNames[i]), StringPool.get((String)parameterValues[i]));
                }
            }
        }
        if (parent != null) {
            for (Map.Entry parentParam : parent.getParameters().entrySet()) {
                if (this.parameters.containsKey(parentParam.getKey())) continue;
                this.parameters.put(StringPool.get((String)((String)parentParam.getKey())), StringPool.get((String)((String)parentParam.getValue())));
            }
        }
        this.parameters = CollectionOptimizer.optimizeHashMap(this.parameters);
        if (mount.getValueProvider().hasProperty("hst:alias")) {
            this.alias = StringPool.get((String)mount.getValueProvider().getString("hst:alias").toLowerCase());
        }
        this.mountPath = parent == null ? "" : StringPool.get((String)(parent.getMountPath() + "/" + this.name));
        this.contextPathInUrl = mount.getValueProvider().hasProperty("hst:showcontextpath") ? mount.getValueProvider().getBoolean("hst:showcontextpath") : (parent != null ? parent.isContextPathInUrl() : virtualHost.isContextPathInUrl());
        this.showPort = mount.getValueProvider().hasProperty("hst:showport") ? mount.getValueProvider().getBoolean("hst:showport") : (parent != null ? parent.isPortInUrl() : virtualHost.isPortInUrl());
        if (mount.getValueProvider().hasProperty("hst:onlyforcontextpath")) {
            log.warn("Property '{}' on Mount '{}' is deprecated. Use property '{}' instead", new Object[]{"hst:onlyforcontextpath", this.jcrLocation, "hst:contextpath"});
            this.contextPath = mount.getValueProvider().getString("hst:onlyforcontextpath");
        }
        if (mount.getValueProvider().hasProperty("hst:contextpath")) {
            this.contextPath = mount.getValueProvider().getString("hst:contextpath");
        }
        if (this.contextPath == null) {
            this.contextPath = parent == null ? virtualHost.getContextPath() : parent.getContextPath();
        }
        if (!ConfigurationUtils.isValidContextPath((String)this.contextPath)) {
            String msg = String.format("Incorrect configured contextPath '%s' for mount '%s': It must start with a '/' to be usedand is not allowed to contain any other '/', but it is '%s'. Skipping mount from hst model.", this.contextPath, this.jcrLocation, this.contextPath);
            log.error(msg);
            throw new ModelLoadingException(msg);
        }
        if (mount.getValueProvider().hasProperty("hst:scheme")) {
            this.scheme = StringPool.get((String)mount.getValueProvider().getString("hst:scheme"));
        }
        if (StringUtils.isBlank((String)this.scheme)) {
            String string = this.scheme = parent != null ? parent.getScheme() : virtualHost.getScheme();
        }
        if (mount.getValueProvider().hasProperty("hst:schemeagnostic")) {
            this.schemeAgnostic = mount.getValueProvider().getBoolean("hst:schemeagnostic");
        } else {
            boolean bl = this.schemeAgnostic = parent != null ? parent.isSchemeAgnostic() : virtualHost.isSchemeAgnostic();
        }
        if (mount.getValueProvider().hasProperty("hst:schemenotmatchresponsecode")) {
            this.schemeNotMatchingResponseCode = (int)mount.getValueProvider().getLong("hst:schemenotmatchresponsecode").longValue();
            if (!ConfigurationUtils.isSupportedSchemeNotMatchingResponseCode((int)this.schemeNotMatchingResponseCode)) {
                log.warn("Invalid '{}' configured on '{}'. Use inherited value. Supported values are '{}'", (Object[])new String[]{"hst:schemenotmatchresponsecode", mount.getValueProvider().getPath(), ConfigurationUtils.supportedSchemeNotMatchingResponseCodesAsString()});
                this.schemeNotMatchingResponseCode = -1;
            }
        }
        if (this.schemeNotMatchingResponseCode == -1) {
            int n = this.schemeNotMatchingResponseCode = parent != null ? parent.getSchemeNotMatchingResponseCode() : virtualHost.getSchemeNotMatchingResponseCode();
        }
        if (mount.getValueProvider().hasProperty("hst:homepage")) {
            this.homepage = mount.getValueProvider().getString("hst:homepage");
            this.homepage = StringPool.get((String)this.homepage);
        } else {
            this.homepage = parent != null ? parent.getHomePage() : virtualHost.getHomePage();
        }
        if (mount.getValueProvider().hasProperty("hst:locale")) {
            this.locale = mount.getValueProvider().getString("hst:locale");
            this.locale = StringPool.get((String)this.locale);
        } else {
            this.locale = parent != null ? parent.getLocale() : virtualHost.getLocale();
        }
        if (mount.getValueProvider().hasProperty("hst:pagenotfound")) {
            this.pageNotFound = mount.getValueProvider().getString("hst:pagenotfound");
            this.pageNotFound = StringPool.get((String)this.pageNotFound);
        } else {
            this.pageNotFound = parent != null ? parent.getPageNotFound() : virtualHost.getPageNotFound();
        }
        this.versionInPreviewHeader = mount.getValueProvider().hasProperty("hst:versioninpreviewheader") ? mount.getValueProvider().getBoolean("hst:versioninpreviewheader") : (parent != null ? parent.isVersionInPreviewHeader() : virtualHost.isVersionInPreviewHeader());
        if (mount.getValueProvider().hasProperty("hst:type")) {
            this.type = mount.getValueProvider().getString("hst:type");
            this.type = StringPool.get((String)this.type);
            if (!DEFAULT_TYPE.equals(this.type) && !"preview".equals(this.type)) {
                log.error("Invalid type '{}' found for mount '{}'. Only supported values are '{}' or '{}'", new Object[]{this.type, this.jcrLocation, DEFAULT_TYPE, "preview"});
            }
        } else if (parent != null) {
            this.type = parent.getType();
        }
        if (mount.getValueProvider().hasProperty("hst:types")) {
            String[] typesProperty = mount.getValueProvider().getStrings("hst:types");
            for (int i = 0; i < typesProperty.length; ++i) {
                typesProperty[i] = StringPool.get((String)typesProperty[i]);
            }
            this.types = Arrays.asList(typesProperty);
        } else if (parent != null) {
            this.types = ((MountService)parent).types;
        }
        if (mount.getValueProvider().hasProperty("hst:ismapped")) {
            this.isMapped = mount.getValueProvider().getBoolean("hst:ismapped");
        } else if (parent != null) {
            this.isMapped = parent.isMapped();
        }
        if (mount.getValueProvider().hasProperty("hst:isSite")) {
            log.warn("Property '{}' has been deprecated and can be removed.", (Object)"hst:isSite");
        }
        if (mount.getValueProvider().hasProperty("hst:namedpipeline")) {
            this.namedPipeline = mount.getValueProvider().getString("hst:namedpipeline");
            this.namedPipeline = StringPool.get((String)this.namedPipeline);
        } else if (parent != null) {
            this.namedPipeline = parent.getNamedPipeline();
        }
        if (mount.getValueProvider().hasProperty("hst:mountpoint")) {
            this.mountPoint = mount.getValueProvider().getString("hst:mountpoint");
            this.mountPoint = StringPool.get((String)this.mountPoint);
            if ("".equals(this.mountPoint)) {
                this.mountPoint = null;
            }
        } else if (parent != null) {
            this.mountPoint = ((MountService)parent).mountPoint;
            if (this.mountPoint != null) {
                log.info("mountPoint for Mount '{}' is inherited from its parent Mount and is '{}'", (Object)this.getName(), (Object)this.mountPoint);
            }
        }
        if (mount.getValueProvider().hasProperty("hst:nochannelinfo")) {
            this.noChannelInfo = mount.getValueProvider().getBoolean("hst:nochannelinfo");
        }
        if (mount.getValueProvider().hasProperty("hst:authenticated")) {
            this.authenticated = mount.getValueProvider().getBoolean("hst:authenticated");
        } else if (parent != null) {
            this.authenticated = parent.isAuthenticated();
        }
        if (mount.getValueProvider().hasProperty("hst:roles")) {
            Object[] rolesProp = mount.getValueProvider().getStrings("hst:roles");
            this.roles = new HashSet<String>();
            CollectionUtils.addAll(this.roles, (Object[])rolesProp);
        } else {
            this.roles = parent != null ? new HashSet<String>(parent.getRoles()) : new HashSet<String>();
        }
        if (mount.getValueProvider().hasProperty("hst:users")) {
            Object[] usersProp = mount.getValueProvider().getStrings("hst:users");
            this.users = new HashSet<String>();
            CollectionUtils.addAll(this.users, (Object[])usersProp);
        } else {
            this.users = parent != null ? new HashSet<String>(parent.getUsers()) : new HashSet<String>();
        }
        if (mount.getValueProvider().hasProperty("hst:subjectbasedsession")) {
            this.subjectBasedSession = mount.getValueProvider().getBoolean("hst:subjectbasedsession");
        } else if (parent != null) {
            this.subjectBasedSession = parent.isSubjectBasedSession();
        }
        if (mount.getValueProvider().hasProperty("hst:sessionstateful")) {
            this.sessionStateful = mount.getValueProvider().getBoolean("hst:sessionstateful");
        } else if (parent != null) {
            this.sessionStateful = parent.isSessionStateful();
        }
        if (mount.getValueProvider().hasProperty("hst:formloginpage")) {
            this.formLoginPage = StringPool.get((String)mount.getValueProvider().getString("hst:formloginpage"));
        } else if (parent != null) {
            this.formLoginPage = parent.getFormLoginPage();
        }
        this.cacheable = mount.getValueProvider().hasProperty("hst:cacheable") ? mount.getValueProvider().getBoolean("hst:cacheable") : (parent != null ? parent.isCacheable() : virtualHost.isCacheable());
        this.defaultResourceBundleIds = mount.getValueProvider().hasProperty("hst:defaultresourcebundleid") ? StringUtils.split((String)mount.getValueProvider().getString("hst:defaultresourcebundleid"), (String)" ,\t\f\r\n") : (parent != null ? parent.getDefaultResourceBundleIds() : virtualHost.getDefaultResourceBundleIds());
        this.cmsLocations = ((VirtualHostService)virtualHost).getCmsLocations();
        if (mount.getValueProvider().hasProperty("hst:defaultsitemapitemhandlerids")) {
            this.defaultSiteMapItemHandlerIds = mount.getValueProvider().getStrings("hst:defaultsitemapitemhandlerids");
        } else if (parent != null) {
            this.defaultSiteMapItemHandlerIds = parent.getDefaultSiteMapItemHandlerIds();
        }
        if (mount.getValueProvider().hasProperty("hst:channelpath")) {
            log.warn("Property '{}' has been deprecated and is not used any more but still present on '{}'. Property will be ignored.", (Object)"hst:channelpath", (Object)mount.getValueProvider().getPath());
        }
        try {
            if (this.mountPoint == null) {
                log.info("Mount '{}' at '{}' does have an empty mountPoint. This means the Mount is not using a HstSite and does not have a content path", (Object)this.getName(), (Object)mount.getValueProvider().getPath());
            } else {
                if (!this.mountPoint.startsWith("/")) {
                    throw new ModelLoadingException("Mount at '" + mount.getValueProvider().getPath() + "' has an invalid mountPoint '" + this.mountPoint + "'. A mount point is absolute and must start with a '/'");
                }
                if (!this.isMapped()) {
                    HstNode hstSiteNodeForMount;
                    log.info("Mount '{}' at '{}' does contain a mountpoint, but is configured to not use a HstSiteMap because isMapped() is false", (Object)this.getName(), (Object)mount.getValueProvider().getPath());
                    this.contentPath = this.mountPoint.startsWith(hstNodeLoadingCache.getRootPath()) ? ((hstSiteNodeForMount = hstNodeLoadingCache.getNode(this.mountPoint)) != null && hstSiteNodeForMount.getNodeTypeName().equals("hst:site") ? hstSiteNodeForMount.getValueProvider().getString("hst:content") : this.mountPoint) : this.mountPoint;
                    if (StringUtils.isNotEmpty((String)this.contentPath)) {
                        this.contentPath = "/" + PathUtils.normalizePath((String)this.contentPath);
                    }
                    this.assertContentPathNotEmpty(mount, this.contentPath);
                    ((VirtualHostsService)virtualHost.getVirtualHosts()).addMount((Mount)this);
                } else {
                    HstNode hstSiteNodeForMount;
                    if (!this.mountPoint.startsWith(hstNodeLoadingCache.getRootPath())) {
                        this.mountException(mount);
                    }
                    if ((hstSiteNodeForMount = hstNodeLoadingCache.getNode(this.mountPoint)) == null) {
                        this.mountException(mount);
                    }
                    this.contentPath = hstSiteNodeForMount.getValueProvider().getString("hst:content");
                    if (StringUtils.isNotEmpty((String)this.contentPath)) {
                        this.contentPath = "/" + PathUtils.normalizePath((String)this.contentPath);
                    }
                    MountSiteMapConfiguration mountSiteMapConfiguration = new MountSiteMapConfiguration((Mount)this);
                    long start = System.currentTimeMillis();
                    if ("preview".equals(this.type)) {
                        this.hstSite = this.previewHstSite = new HstSiteFactory().createPreviewSiteService(hstSiteNodeForMount, (Mount)this, mountSiteMapConfiguration, hstNodeLoadingCache);
                    } else {
                        this.hstSite = new HstSiteFactory().createLiveSiteService(hstSiteNodeForMount, (Mount)this, mountSiteMapConfiguration, hstNodeLoadingCache);
                        this.previewHstSite = new HstSiteFactory().createPreviewSiteService(hstSiteNodeForMount, (Mount)this, mountSiteMapConfiguration, hstNodeLoadingCache);
                    }
                    this.assertContentPathNotEmpty(mount, this.contentPath);
                    log.info("Successfull initialized hstSite '{}' for Mount '{}' in '{}' ms.", (Object[])new String[]{this.hstSite.getName(), this.getName(), String.valueOf(System.currentTimeMillis() - start)});
                    ((VirtualHostsService)virtualHost.getVirtualHosts()).addMount((Mount)this);
                }
            }
        }
        catch (ModelLoadingException e) {
            log.warn("Configured Mount '{}' is incorrect. Available child mounts will still be loaded.", (Object)this.jcrLocation, (Object)e);
        }
        for (HstNode childMount : mount.getNodes()) {
            if (!"hst:mount".equals(childMount.getNodeTypeName())) continue;
            try {
                MountService childMountService = new MountService(childMount, (Mount)this, virtualHost, hstNodeLoadingCache, port);
                this.childMountServices.put(childMountService.getName(), childMountService);
            }
            catch (ModelLoadingException e) {
                String path = childMount.getValueProvider().getPath();
                if (log.isDebugEnabled()) {
                    log.warn("Skipping incorrect mount for mount node '" + path + "'. ", (Throwable)e);
                    continue;
                }
                log.warn("Skipping incorrect mount for mount node '{}' because of '{}'. ", (Object)path, (Object)e.toString());
            }
        }
    }

    private void assertContentPathNotEmpty(HstNode mount, String contentPath) throws ModelLoadingException {
        if (StringUtils.isEmpty((String)contentPath)) {
            throw new ModelLoadingException("Mount '" + mount.getValueProvider().getPath() + "' does have an empty or null contentPath, hence has broken configuration. Fix the hst:content property when the mountpoint points to a hst:site node, or make sure hst:ismapped = false if this mount does not need a mountpoint to a hst:site node. Available child mounts will still be loaded");
        }
    }

    private void mountException(HstNode mount) throws ModelLoadingException {
        throw new ModelLoadingException("mountPoint '" + this.mountPoint + "' does not point to a hst:site node for Mount '" + mount.getValueProvider().getPath() + "'. Cannot create HstSite for Mount. Either fix the mountpoint or add 'hst:ismapped=false' if this mount is not meant to have a mount point");
    }

    private Boolean multipleSchemesUsed(List<HstSiteMapItem> siteMapItems) {
        for (HstSiteMapItem siteMapItem : siteMapItems) {
            if (siteMapItem.isSchemeAgnostic()) continue;
            if (!this.scheme.equals(siteMapItem.getScheme())) {
                return Boolean.TRUE;
            }
            if (!this.multipleSchemesUsed(siteMapItem.getChildren()).booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public void addMount(MutableMount mount) throws ModelLoadingException {
        if (this.childMountServices.containsKey(mount.getName())) {
            throw new ModelLoadingException("Cannot add Mount with name '" + mount.getName() + "' because already exists for " + this.toString());
        }
        this.childMountServices.put(mount.getName(), mount);
        ((MutableVirtualHosts)this.virtualHost.getVirtualHosts()).addMount((Mount)mount);
    }

    public List<Mount> getChildMounts() {
        return Collections.unmodifiableList(new ArrayList<MutableMount>(this.childMountServices.values()));
    }

    public Mount getChildMount(String name) {
        return (Mount)this.childMountServices.get(name);
    }

    public HstSite getHstSite() {
        return this.hstSite;
    }

    public HstSite getPreviewHstSite() {
        return this.previewHstSite;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifier() {
        return this.uuid;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getMountPath() {
        return this.mountPath;
    }

    public String getContentPath() {
        return this.contentPath;
    }

    @Deprecated
    public String getCanonicalContentPath() {
        return this.getContentPath();
    }

    public String getMountPoint() {
        return this.mountPoint;
    }

    public boolean hasNoChannelInfo() {
        return this.noChannelInfo;
    }

    public boolean isMapped() {
        return this.isMapped;
    }

    public Mount getParent() {
        return this.parent;
    }

    public String getScheme() {
        return this.scheme;
    }

    public boolean isSchemeAgnostic() {
        return this.schemeAgnostic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsMultipleSchemes() {
        if (this.containsMultipleSchemes != null) {
            return this.containsMultipleSchemes;
        }
        MountService mountService = this;
        synchronized (mountService) {
            if (this.containsMultipleSchemes != null) {
                return this.containsMultipleSchemes;
            }
            if (this.hstSite == null) {
                this.containsMultipleSchemes = Boolean.FALSE;
                return false;
            }
            this.containsMultipleSchemes = this.multipleSchemesUsed(this.hstSite.getSiteMap().getSiteMapItems());
            return this.containsMultipleSchemes;
        }
    }

    public int getSchemeNotMatchingResponseCode() {
        return this.schemeNotMatchingResponseCode;
    }

    public String getLocale() {
        return this.locale;
    }

    public String getHomePage() {
        return this.homepage;
    }

    public String getPageNotFound() {
        return this.pageNotFound;
    }

    public VirtualHost getVirtualHost() {
        return this.virtualHost;
    }

    public boolean isContextPathInUrl() {
        return this.contextPathInUrl;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isPortInUrl() {
        return this.showPort;
    }

    @Deprecated
    public boolean isSite() {
        log.warn("Mount#isSite has been deprecated.");
        return false;
    }

    @Deprecated
    public String onlyForContextPath() {
        return this.contextPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public boolean isPreview() {
        return this.isOfType("preview");
    }

    public String getType() {
        return this.type;
    }

    public List<String> getTypes() {
        ArrayList<String> combined = new ArrayList<String>();
        combined.add(this.getType());
        if (this.types != null) {
            if (this.types.contains(this.getType())) {
                for (String extraType : this.types) {
                    if (extraType == null || extraType.equals(this.getType())) continue;
                    combined.add(extraType);
                }
            } else {
                combined.addAll(this.types);
            }
        }
        return Collections.unmodifiableList(combined);
    }

    public boolean isOfType(String type) {
        return this.getTypes().contains(type);
    }

    public boolean isVersionInPreviewHeader() {
        return this.versionInPreviewHeader;
    }

    @Deprecated
    public String getCmsLocation() {
        if (!this.cmsLocations.isEmpty()) {
            return this.cmsLocations.get(0);
        }
        return null;
    }

    public List<String> getCmsLocations() {
        return this.cmsLocations;
    }

    public String getNamedPipeline() {
        return this.namedPipeline;
    }

    public HstSiteMapMatcher getHstSiteMapMatcher() {
        if (this.matcher != null) {
            return this.matcher;
        }
        HstManager mngr = (HstManager)HstServices.getComponentManager().getComponent(HstManager.class.getName());
        this.matcher = mngr.getSiteMapMatcher();
        return this.matcher;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public Set<String> getRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    public Set<String> getUsers() {
        return Collections.unmodifiableSet(this.users);
    }

    public boolean isSubjectBasedSession() {
        return this.subjectBasedSession;
    }

    public boolean isSessionStateful() {
        return this.sessionStateful;
    }

    public String getFormLoginPage() {
        return this.formLoginPage;
    }

    public String getProperty(String name) {
        Object o = this.allProperties.get(name);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    public List<String> getPropertyNames() {
        return ImmutableList.copyOf(this.allProperties.keySet());
    }

    public String[] getDefaultSiteMapItemHandlerIds() {
        return this.defaultSiteMapItemHandlerIds;
    }

    public boolean isCacheable() {
        return this.cacheable;
    }

    @Deprecated
    public String getDefaultResourceBundleId() {
        if (this.defaultResourceBundleIds == null || this.defaultResourceBundleIds.length == 0) {
            return null;
        }
        return this.defaultResourceBundleIds[0];
    }

    public String[] getDefaultResourceBundleIds() {
        if (this.defaultResourceBundleIds == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        return (String[])ArrayUtils.clone((Object[])this.defaultResourceBundleIds);
    }

    public Map<String, String> getMountProperties() {
        HashMap<String, String> mountProperties = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.allProperties.entrySet()) {
            if (!(entry.getValue() instanceof String) || !entry.getKey().startsWith("hst:mount") || entry.getKey().equals("hst:mountpoint")) continue;
            mountProperties.put(entry.getKey().substring("hst:mount".length()).toLowerCase(), ((String)entry.getValue()).toLowerCase());
        }
        return mountProperties;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    @Deprecated
    public String getChannelPath() {
        Channel channel = this.getChannel();
        if (channel == null) {
            return null;
        }
        return channel.getChannelPath();
    }

    public Channel getChannel() {
        HstSite hstSite = this.getHstSite();
        if (hstSite == null) {
            return null;
        }
        return hstSite.getChannel();
    }

    @Deprecated
    public String getPreviewChannelPath() {
        Channel previewChannel = this.getPreviewChannel();
        if (previewChannel == null) {
            return null;
        }
        return previewChannel.getChannelPath();
    }

    public Channel getPreviewChannel() {
        HstSite hstSite = this.getPreviewHstSite();
        if (hstSite == null) {
            return null;
        }
        return hstSite.getChannel();
    }

    public <T extends ChannelInfo> T getChannelInfo() {
        HstSite hstSite = this.getHstSite();
        if (hstSite == null) {
            return null;
        }
        return (T)hstSite.getChannelInfo();
    }

    public <T extends ChannelInfo> T getPreviewChannelInfo() {
        HstSite hstSite = this.getPreviewHstSite();
        if (hstSite == null) {
            return null;
        }
        return (T)hstSite.getChannelInfo();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MountService [jcrPath=");
        builder.append(this.jcrLocation).append(", hostName=").append(this.virtualHost.getHostName()).append("]");
        return builder.toString();
    }
}

