/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.environment;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.hippoecm.repository.util.NodeIterable;
import org.onehippo.cms7.services.HippoServiceRegistry;
import org.onehippo.cms7.services.environment.EnvironmentSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostConfigPublisher {
    private static final Logger log = LoggerFactory.getLogger(HostConfigPublisher.class);
    private final EnvironmentSettings environmentSettings = (EnvironmentSettings)HippoServiceRegistry.getService(EnvironmentSettings.class);
    private final ExecutorService executorService;
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private Repository repository;
    private Credentials credentials;

    public HostConfigPublisher() {
        if (this.environmentSettings == null) {
            this.executorService = null;
            return;
        }
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void asyncPublishHosts(String hostGroupPath) {
        if (this.environmentSettings == null) {
            return;
        }
        this.executorService.submit(new HostConfigPublisherTask(this.repository, this.credentials, hostGroupPath, this.environmentSettings));
    }

    private static class HostConfigPublisherTask
    implements Runnable {
        private final Repository repository;
        private final Credentials credentials;
        private final String hostGroupPath;
        private EnvironmentSettings environmentSettings;

        private HostConfigPublisherTask(Repository repository, Credentials credentials, String hostGroupPath, EnvironmentSettings environmentSettings) {
            this.repository = repository;
            this.credentials = credentials;
            this.hostGroupPath = hostGroupPath;
            this.environmentSettings = environmentSettings;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Session session = null;
            try {
                session = this.repository.login(this.credentials);
                Node root = session.getNode(this.hostGroupPath);
                if (!root.isNodeType("hst:virtualhostgroup")) {
                    throw new IllegalArgumentException(String.format("Invalid root '%s' for publishing hosts info.", this.hostGroupPath));
                }
                List<String> hostList = this.buildHostsList(root);
                this.environmentSettings.put("org.onehippo.environment.settings.hosts", objectMapper.writeValueAsString(hostList));
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.error("Exception while trying to publish environment host information for '{}'", (Object)this.hostGroupPath, (Object)e);
                } else {
                    log.error("Exception while trying to publish environment host information for '{}' : {}", (Object)this.hostGroupPath, (Object)e.toString());
                }
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }

        private List<String> buildHostsList(Node root) throws RepositoryException {
            ArrayList<String> hosts = new ArrayList<String>();
            this.populateHostsList(root, hosts);
            return hosts;
        }

        private void populateHostsList(Node current, List<String> hosts) throws RepositoryException {
            for (Node child : new NodeIterable(current.getNodes())) {
                if (child.isNodeType("hst:virtualhost")) {
                    this.populateHostsList(child, hosts);
                    continue;
                }
                if (!child.isNodeType("hst:portmount") && !child.isNodeType("hst:mount")) continue;
                this.addHost(child.getParent(), hosts);
            }
        }

        private void addHost(Node leafHostNode, List<String> hosts) throws RepositoryException {
            StringBuilder hostName = new StringBuilder(leafHostNode.getName());
            Node current = leafHostNode;
            while (current.getParent().isNodeType("hst:virtualhost")) {
                current = current.getParent();
                hostName.append(".").append(current.getName());
            }
            hosts.add(hostName.toString());
        }
    }
}

