/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.environment;

import java.util.Optional;
import org.hippoecm.hst.site.HstServices;
import org.onehippo.cms7.services.HippoServiceRegistry;
import org.onehippo.cms7.services.environment.EnvironmentSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentUtils {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentUtils.class);
    static Optional<String> activeHostGroupOptional;

    private EnvironmentUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getActiveHostGroup() {
        if (activeHostGroupOptional != null) {
            return activeHostGroupOptional.orElse(null);
        }
        Class<EnvironmentUtils> clazz = EnvironmentUtils.class;
        synchronized (EnvironmentUtils.class) {
            if (activeHostGroupOptional != null) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return activeHostGroupOptional.orElse(null);
            }
            EnvironmentSettings environmentSettings = (EnvironmentSettings)HippoServiceRegistry.getService(EnvironmentSettings.class);
            if (environmentSettings == null) {
                log.info("EnvironmentSettings are not available");
                activeHostGroupOptional = Optional.empty();
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            String activeHostGroup = environmentSettings.get("org.onehippo.environment.settings.activeHostGroup");
            if (activeHostGroup == null) {
                log.info("EnvironmentSettings does not provide an active host group value for '{}'.", (Object)"org.onehippo.environment.settings.activeHostGroup");
                activeHostGroupOptional = Optional.empty();
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            activeHostGroupOptional = Optional.of(activeHostGroup);
            // ** MonitorExit[var0] (shouldn't be in output)
            return activeHostGroup;
        }
    }

    static String getActiveHostGroupPath() {
        String activeHostGroup = EnvironmentUtils.getActiveHostGroup();
        if (activeHostGroup == null) {
            return null;
        }
        return EnvironmentUtils.getHstRootPath() + "/" + "hst:hosts" + "/" + activeHostGroup;
    }

    static String getHstRootPath() {
        return HstServices.getComponentManager().getContainerConfiguration().getString("hst.configuration.rootPath");
    }
}

