/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.components;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.cache.CompositeConfigurationNodes;
import org.hippoecm.hst.configuration.components.HstComponentConfiguration;
import org.hippoecm.hst.configuration.components.HstComponentConfigurationService;
import org.hippoecm.hst.configuration.components.HstComponentsConfiguration;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.model.ModelLoadingException;
import org.hippoecm.hst.core.internal.StringPool;
import org.hippoecm.hst.provider.ValueProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstComponentsConfigurationService
implements HstComponentsConfiguration {
    private static final Logger log = LoggerFactory.getLogger(HstComponentsConfigurationService.class);
    private final String id;
    private Map<String, HstComponentConfiguration> canonicalComponentConfigurations;
    private Map<String, HstComponentConfiguration> prototypePages = new HashMap<String, HstComponentConfiguration>();
    private List<HstComponentConfiguration> availableContainerItems = new ArrayList<HstComponentConfiguration>();
    private final Set<String> usedReferenceNames = new HashSet<String>();
    private int autoCreatedCounter = 0;
    private final Map<String, Template> templateResourceMap;

    public HstComponentsConfigurationService(CompositeConfigurationNodes ccn, List<HstComponentConfiguration> commonCatalogItem) throws ModelLoadingException {
        this.id = ccn.getConfigurationRootNode().getValueProvider().getPath();
        CompositeConfigurationNodes.CompositeConfigurationNode referableContainersCCN = ccn.getCompositeConfigurationNodes().get("hst:workspace/hst:containers");
        Map<Object, Object> referableContainers = referableContainersCCN != null ? referableContainersCCN.getCompositeChildren() : Collections.emptyMap();
        String[] mainComponentNodeNames = new String[]{"hst:components", "hst:abstractpages", "hst:pages", "hst:prototypepages"};
        String rootConfigurationPathPrefix = ccn.getConfigurationRootNode().getValueProvider().getPath() + "/";
        ArrayList<HstComponentConfiguration> nonPrototypeRootComponents = new ArrayList<HstComponentConfiguration>();
        for (String mainComponentNodeName : mainComponentNodeNames) {
            log.debug("Initializing the {}", (Object)mainComponentNodeName);
            CompositeConfigurationNodes.CompositeConfigurationNode componentNodes = ccn.getCompositeConfigurationNodes().get(mainComponentNodeName);
            if (componentNodes == null) {
                log.debug("No configuration nodes present for {}", (Object)mainComponentNodeName);
                continue;
            }
            this.init(componentNodes, mainComponentNodeName, rootConfigurationPathPrefix, referableContainers, nonPrototypeRootComponents);
        }
        this.prototypePages = Collections.unmodifiableMap(this.prototypePages);
        CompositeConfigurationNodes.CompositeConfigurationNode catalog = ccn.getCompositeConfigurationNodes().get("hst:catalog");
        if (catalog != null) {
            log.debug("Initializing the catalog");
            this.initCatalog(catalog, rootConfigurationPathPrefix);
        }
        if (commonCatalogItem != null) {
            this.availableContainerItems.addAll(commonCatalogItem);
        }
        this.availableContainerItems = this.availableContainerItems.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this.availableContainerItems);
        this.canonicalComponentConfigurations = nonPrototypeRootComponents.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.flattened(nonPrototypeRootComponents).collect(Collectors.toMap(hstComponentConfiguration -> hstComponentConfiguration.getId(), hstComponentConfiguration -> hstComponentConfiguration)));
        this.templateResourceMap = Collections.unmodifiableMap(this.getTemplateResourceMap(ccn.getCompositeConfigurationNodes().get("hst:templates")));
        this.enhanceComponentTree(this.templateResourceMap, nonPrototypeRootComponents);
    }

    private void enhanceComponentTree(Map<String, Template> templateResourceMap, List<HstComponentConfiguration> childComponents) {
        ArrayList<HstComponentConfiguration> populated = new ArrayList<HstComponentConfiguration>();
        for (HstComponentConfiguration child : this.canonicalComponentConfigurations.values()) {
            if (populated.contains(child)) continue;
            ((HstComponentConfigurationService)child).populateComponentReferences(this.canonicalComponentConfigurations, populated);
        }
        for (HstComponentConfiguration child : childComponents) {
            this.autocreateReferenceNames(child);
        }
        for (HstComponentConfiguration child : childComponents) {
            ((HstComponentConfigurationService)child).setRenderPath(templateResourceMap);
            ((HstComponentConfigurationService)child).setServeResourcePath(templateResourceMap);
        }
        for (HstComponentConfiguration child : childComponents) {
            ((HstComponentConfigurationService)child).inheritParameters();
        }
        for (HstComponentConfiguration child : childComponents) {
            ((HstComponentConfigurationService)child).populateVariants();
        }
        HashSet allMountVariants = new HashSet();
        for (HstComponentConfiguration child : childComponents) {
            allMountVariants.addAll(child.getVariants());
        }
        for (HstComponentConfiguration child : childComponents) {
            ArrayList allVariants = new ArrayList(allMountVariants);
            ((HstComponentConfigurationService)child).setMountVariants(Collections.unmodifiableList(allVariants));
        }
        for (HstComponentConfiguration child : childComponents) {
            ((HstComponentConfigurationService)child).populateIsCompositeCacheable();
        }
        for (HstComponentConfiguration child : childComponents) {
            ((HstComponentConfigurationService)child).makeCollectionsImmutableAndOptimize();
        }
    }

    public HstComponentConfiguration getComponentConfiguration(String id) {
        return this.canonicalComponentConfigurations.get(id);
    }

    public Map<String, HstComponentConfiguration> getComponentConfigurations() {
        return this.canonicalComponentConfigurations;
    }

    public List<HstComponentConfiguration> getAvailableContainerItems() {
        return this.availableContainerItems;
    }

    public Map<String, HstComponentConfiguration> getPrototypePages() {
        return this.prototypePages;
    }

    public Map<String, Template> getTemplates() {
        return this.templateResourceMap;
    }

    private void autocreateReferenceNames(HstComponentConfiguration componentConfiguration) {
        if (componentConfiguration.getReferenceName() == null || "".equals(componentConfiguration.getReferenceName())) {
            String autoRefName = "r" + ++this.autoCreatedCounter;
            while (this.usedReferenceNames.contains(autoRefName)) {
                autoRefName = "r" + ++this.autoCreatedCounter;
            }
            ((HstComponentConfigurationService)componentConfiguration).setReferenceName(StringPool.get((String)autoRefName));
        }
        ((HstComponentConfigurationService)componentConfiguration).autocreateReferenceNames();
    }

    private void init(CompositeConfigurationNodes.CompositeConfigurationNode node, String rootNodeName, String rootConfigurationPathPrefix, Map<String, HstNode> referableContainers, List<HstComponentConfiguration> nonPrototypeRootComponents) {
        for (HstNode child : node.getCompositeChildren().values()) {
            if (this.isHstComponentType(child)) {
                if (child.getValueProvider().hasProperty("hst:referencename")) {
                    this.usedReferenceNames.add(StringPool.get((String)child.getValueProvider().getString("hst:referencename")));
                }
                try {
                    HstComponentConfigurationService componentConfiguration = new HstComponentConfigurationService(child, null, rootNodeName, referableContainers, rootConfigurationPathPrefix);
                    if (rootNodeName.equals("hst:prototypepages")) {
                        this.prototypePages.put(componentConfiguration.getId(), componentConfiguration);
                    } else {
                        nonPrototypeRootComponents.add(componentConfiguration);
                    }
                    log.debug("Added component service with key '{}'", (Object)componentConfiguration.getId());
                }
                catch (ModelLoadingException e) {
                    if (log.isDebugEnabled()) {
                        log.warn("Skipping component '" + child.getValueProvider().getPath() + "'", (Throwable)e);
                        continue;
                    }
                    if (!log.isWarnEnabled()) continue;
                    log.warn("Skipping component '{}' : '{}'", (Object)child.getValueProvider().getPath(), (Object)e.toString());
                }
                continue;
            }
            log.warn("Skipping node '{}' because is not of type '{}'", (Object)child.getValueProvider().getPath(), (Object)"hst:component");
        }
    }

    private boolean isHstComponentType(HstNode node) {
        return "hst:component".equals(node.getNodeTypeName()) || "hst:containercomponent".equals(node.getNodeTypeName()) || "hst:containeritemcomponent".equals(node.getNodeTypeName());
    }

    private void initCatalog(CompositeConfigurationNodes.CompositeConfigurationNode catalog, String rootConfigurationPathPrefix) {
        for (HstNode itemPackage : catalog.getCompositeChildren().values()) {
            if ("hst:containeritempackage".equals(itemPackage.getNodeTypeName())) {
                for (HstNode containerItem : itemPackage.getNodes()) {
                    if ("hst:containeritemcomponent".equals(containerItem.getNodeTypeName())) {
                        try {
                            HstComponentConfigurationService componentConfiguration = new HstComponentConfigurationService(containerItem, null, "hst:components", true, null, rootConfigurationPathPrefix, null);
                            this.availableContainerItems.add(componentConfiguration);
                            log.debug("Added catalog component to availableContainerItems with key '{}'", (Object)componentConfiguration.getId());
                        }
                        catch (ModelLoadingException e) {
                            if (log.isDebugEnabled()) {
                                log.warn("Skipping catalog component '" + containerItem.getValueProvider().getPath() + "'", (Throwable)e);
                                continue;
                            }
                            if (!log.isWarnEnabled()) continue;
                            log.warn("Skipping catalog component '{}' : '{}'", (Object)containerItem.getValueProvider().getPath(), (Object)e.toString());
                        }
                        continue;
                    }
                    log.warn("Skipping catalog component '{}' because is not of type '{}'", (Object)containerItem.getValueProvider().getPath(), (Object)"hst:component");
                }
                continue;
            }
            log.warn("Skipping node '{}' because is not of type '{}'", (Object)itemPackage.getValueProvider().getPath(), (Object)"hst:containeritempackage");
        }
    }

    private Map<String, Template> getTemplateResourceMap(CompositeConfigurationNodes.CompositeConfigurationNode templateNodes) throws ModelLoadingException {
        if (templateNodes == null) {
            log.info("Configuration for '{}' does not have hst:templates. Model will be loaded without templates", (Object)this.id);
            return Collections.emptyMap();
        }
        HashMap<String, Template> templateResourceMap = new HashMap<String, Template>();
        for (HstNode templateNode : templateNodes.getCompositeChildren().values()) {
            Template template = new Template(templateNode);
            if (!template.isValid()) continue;
            templateResourceMap.put(template.getName(), template);
        }
        return templateResourceMap;
    }

    public String toString() {
        return "HstComponentsConfigurationService [id='" + this.id + "', hashcode = '" + this.hashCode() + "']";
    }

    public static class Template {
        private final String name;
        private final String uuid;
        private final String path;
        private final String configuredRenderPath;
        private final String effectiveRenderPath;
        private final String script;
        private final boolean named;

        public Template(HstNode templateNode) {
            ValueProvider valueProvider = templateNode.getValueProvider();
            this.name = valueProvider.getName();
            this.path = valueProvider.getPath();
            this.uuid = valueProvider.getIdentifier();
            this.configuredRenderPath = valueProvider.getString("hst:renderpath");
            this.script = valueProvider.getString("hst:script");
            this.named = valueProvider.getBoolean("hst:isnamed");
            if (StringUtils.isNotBlank((String)this.configuredRenderPath)) {
                this.effectiveRenderPath = this.configuredRenderPath;
            } else if (StringUtils.isNotBlank((String)this.script)) {
                this.effectiveRenderPath = "jcr:" + this.path;
            } else {
                log.warn("Template '{}' is invalid, supply a hst:renderpath or hst:script.", (Object)this.getPath());
                this.effectiveRenderPath = null;
            }
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public String getUuid() {
            return this.uuid;
        }

        public String getEffectiveRenderPath() {
            return this.effectiveRenderPath;
        }

        public boolean isNamed() {
            return this.named;
        }

        public boolean isValid() {
            return this.getEffectiveRenderPath() != null;
        }
    }
}

