/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.components;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.ConfigurationUtils;
import org.hippoecm.hst.configuration.components.HstComponentConfiguration;
import org.hippoecm.hst.configuration.components.HstComponentsConfigurationService;
import org.hippoecm.hst.configuration.internal.ConfigurationLockInfo;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.model.ModelLoadingException;
import org.hippoecm.hst.core.internal.StringPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstComponentConfigurationService
implements HstComponentConfiguration,
ConfigurationLockInfo {
    private static final Logger log = LoggerFactory.getLogger(HstComponentConfigurationService.class);
    private Map<String, HstComponentConfiguration> componentConfigurations = new LinkedHashMap<String, HstComponentConfiguration>();
    private Map<String, HstComponentConfigurationService> childConfByName = new HashMap<String, HstComponentConfigurationService>();
    private List<HstComponentConfigurationService> orderedListConfigs = new ArrayList<HstComponentConfigurationService>();
    private HstComponentConfiguration parent;
    private String id;
    private String name;
    private String componentClassName;
    private String hstTemplate;
    private String hstResourceTemplate;
    private boolean isNamedRenderer;
    private boolean isNamedResourceServer;
    private String renderPath;
    private String serveResourcePath;
    private String xtype;
    private String componentFilterTag;
    private HstComponentConfiguration.Type type;
    private String referenceName;
    private String referenceComponent;
    private String pageErrorHandlerClassName;
    private List<String> usedChildReferenceNames = new ArrayList<String>();
    private int autocreatedCounter = 0;
    private Map<String, String> parameters = new LinkedHashMap<String, String>();
    private Set<String> parameterNamePrefixSet = new HashSet<String>();
    private Map<String, String> localParameters = new LinkedHashMap<String, String>();
    private String canonicalStoredLocation;
    private String canonicalIdentifier;
    private boolean inherited;
    private boolean prototype;
    private Boolean standalone = null;
    private Boolean async = null;
    private String asyncMode = null;
    private boolean compositeCacheable = true;
    private Boolean cacheable = null;
    private Boolean suppressWasteMessage = null;
    private String iconPath;
    private String label;
    private List<String> variants = Collections.emptyList();
    private List<String> mountVariants = Collections.emptyList();
    private String lockedBy;
    private Calendar lockedOn;
    private Calendar lastModified;
    private Boolean markedDeleted;

    private HstComponentConfigurationService(String id) {
        this.id = StringPool.get((String)id);
    }

    public HstComponentConfigurationService(HstNode node, HstComponentConfiguration parent, String rootNodeName, Map<String, HstNode> referableContainers, String rootConfigurationPathPrefix) {
        this(node, parent, rootNodeName, false, referableContainers, rootConfigurationPathPrefix, null);
    }

    public HstComponentConfigurationService(HstNode node, HstComponentConfiguration parent, String rootNodeName, boolean isCatalogItem, Map<String, HstNode> referableContainers, String rootConfigurationPathPrefix, String explicitName) {
        int i;
        this.canonicalStoredLocation = StringPool.get((String)node.getValueProvider().getCanonicalPath());
        this.canonicalIdentifier = StringPool.get((String)node.getValueProvider().getIdentifier());
        this.inherited = !this.canonicalStoredLocation.startsWith(rootConfigurationPathPrefix);
        this.parent = parent;
        this.prototype = "hst:prototypepages".equals(rootNodeName);
        this.name = explicitName == null ? StringPool.get((String)node.getValueProvider().getName()) : explicitName;
        this.id = parent == null ? StringPool.get((String)(rootNodeName + "/" + this.name)) : StringPool.get((String)(parent.getId() + "/" + this.name));
        this.componentClassName = StringPool.get((String)node.getValueProvider().getString("hst:componentclassname"));
        if ("hst:component".equals(node.getNodeTypeName())) {
            this.type = HstComponentConfiguration.Type.COMPONENT;
        } else if ("hst:containercomponent".equals(node.getNodeTypeName())) {
            this.type = HstComponentConfiguration.Type.CONTAINER_COMPONENT;
            if (this.componentClassName == null) {
                log.debug("Setting componentClassName to '{}' for a component of type '{}' because there is no explicit componentClassName configured on component '{}'", (Object[])new String[]{"org.hippoecm.hst.pagecomposer.builtin.components.StandardContainerComponent", "hst:containercomponent", this.id});
                this.componentClassName = "org.hippoecm.hst.pagecomposer.builtin.components.StandardContainerComponent";
            }
        } else if ("hst:containeritemcomponent".equals(node.getNodeTypeName())) {
            this.type = HstComponentConfiguration.Type.CONTAINER_ITEM_COMPONENT;
            this.componentFilterTag = node.getValueProvider().getString("hst:componentfiltertag");
            if (!(isCatalogItem || parent != null && HstComponentConfiguration.Type.CONTAINER_COMPONENT.equals((Object)parent.getComponentType()))) {
                log.warn("Component of type '{}' at '{}' is not configured below a '{}' node. This is not allowed. Either change the primary nodetype to '{}' or '{}' or move the node below a node of type '{}'.", (Object[])new String[]{"hst:containeritemcomponent", this.canonicalStoredLocation, "hst:containercomponent", "hst:containercomponent", "hst:component", "hst:containercomponent"});
            }
        } else {
            throw new ModelLoadingException("Unknown componentType '" + node.getNodeTypeName() + "' for '" + this.canonicalStoredLocation + "'. Cannot build configuration.");
        }
        this.referenceName = StringPool.get((String)node.getValueProvider().getString("hst:referencename"));
        this.referenceComponent = StringPool.get((String)node.getValueProvider().getString("hst:referencecomponent"));
        if (this.referenceComponent != null) {
            if (this.type == HstComponentConfiguration.Type.CONTAINER_COMPONENT) {
                throw new ModelLoadingException("ContainerComponents are not allowed to have a reference. Pls fix theconfiguration for '" + this.canonicalStoredLocation + "'");
            }
            if (this.type == HstComponentConfiguration.Type.CONTAINER_ITEM_COMPONENT) {
                log.warn("Component '{}' is not allowed to have a '{}' property as this is not supported for components of type '{}'. Setting reference to null.", (Object[])new String[]{this.canonicalStoredLocation, "hst:referencecomponent", "hst:containeritemcomponent"});
                this.referenceComponent = null;
            }
        }
        this.hstTemplate = StringPool.get((String)node.getValueProvider().getString("hst:template"));
        this.hstResourceTemplate = StringPool.get((String)node.getValueProvider().getString("hst:resourcetemplate"));
        this.pageErrorHandlerClassName = StringPool.get((String)node.getValueProvider().getString("hst:page_errorhandlerclassname"));
        this.label = StringPool.get((String)node.getValueProvider().getString("hst:label"));
        this.iconPath = StringPool.get((String)node.getValueProvider().getString("hst:iconpath"));
        if (this.type == HstComponentConfiguration.Type.CONTAINER_COMPONENT || this.type == HstComponentConfiguration.Type.CONTAINER_ITEM_COMPONENT) {
            this.xtype = StringPool.get((String)node.getValueProvider().getString("hst:xtype"));
        }
        String[] parameterNames = node.getValueProvider().getStrings("hst:parameternames");
        String[] parameterValues = node.getValueProvider().getStrings("hst:parametervalues");
        String[] parameterNamePrefixes = node.getValueProvider().getStrings("hst:parameternameprefixes");
        if (parameterNames.length != parameterValues.length) {
            log.warn("Skipping parameters for component '{}' because they only make sense if there are equal number of names and values", (Object)this.id);
        } else if (parameterNamePrefixes.length > 0) {
            if (parameterNamePrefixes.length != parameterNames.length) {
                log.warn("Skipping parameters for component '{}' because there are hst:parameternameprefixes configured, but if it is configured it MUST be of equal length as the hst:parameternames", (Object)this.id);
            } else {
                for (i = 0; i < parameterNames.length; ++i) {
                    if (StringUtils.isEmpty((String)parameterNamePrefixes[i])) {
                        this.parameters.put(StringPool.get((String)parameterNames[i]), StringPool.get((String)parameterValues[i]));
                        this.localParameters.put(StringPool.get((String)parameterNames[i]), StringPool.get((String)parameterValues[i]));
                        continue;
                    }
                    if (!this.parameterNamePrefixSet.contains(parameterNamePrefixes[i])) {
                        this.parameterNamePrefixSet.add(parameterNamePrefixes[i]);
                    }
                    String prefixedParameterName = ConfigurationUtils.createPrefixedParameterName((String)parameterNamePrefixes[i], (String)parameterNames[i]);
                    this.parameters.put(StringPool.get((String)prefixedParameterName), StringPool.get((String)parameterValues[i]));
                    this.localParameters.put(StringPool.get((String)prefixedParameterName), StringPool.get((String)parameterValues[i]));
                }
            }
        } else {
            for (i = 0; i < parameterNames.length; ++i) {
                this.parameters.put(StringPool.get((String)parameterNames[i]), StringPool.get((String)parameterValues[i]));
                this.localParameters.put(StringPool.get((String)parameterNames[i]), StringPool.get((String)parameterValues[i]));
            }
        }
        if (node.getValueProvider().hasProperty("hst:standalone")) {
            this.standalone = node.getValueProvider().getBoolean("hst:standalone");
        }
        if (node.getValueProvider().hasProperty("hst:async")) {
            this.async = node.getValueProvider().getBoolean("hst:async");
        }
        if (node.getValueProvider().hasProperty("hst:asyncmode")) {
            this.asyncMode = node.getValueProvider().getString("hst:asyncmode");
        }
        if (node.getValueProvider().hasProperty("hst:cacheable")) {
            this.cacheable = node.getValueProvider().getBoolean("hst:cacheable");
        }
        if (node.getValueProvider().hasProperty("hst:suppresswastemessage")) {
            this.suppressWasteMessage = node.getValueProvider().getBoolean("hst:suppresswastemessage");
        }
        if (this.type == HstComponentConfiguration.Type.CONTAINER_COMPONENT) {
            this.lockedBy = node.getValueProvider().getString("hst:lockedby");
            this.lockedOn = node.getValueProvider().getDate("hst:lockedon");
            this.lastModified = node.getValueProvider().getDate("hst:lastmodified");
        }
        if (parent != null) {
            this.lockedBy = this.lockedBy == null ? ((ConfigurationLockInfo)parent).getLockedBy() : this.lockedBy;
            this.lockedOn = this.lockedOn == null ? ((ConfigurationLockInfo)parent).getLockedOn() : this.lockedOn;
            Calendar calendar = this.lastModified = this.lastModified == null ? parent.getLastModified() : this.lastModified;
        }
        if (node.getValueProvider().hasProperty("hst:state")) {
            if ("deleted".equals(node.getValueProvider().getString("hst:state"))) {
                this.markedDeleted = true;
            }
        } else if (parent != null) {
            this.markedDeleted = parent.isMarkedDeleted();
        }
        if (isCatalogItem) {
            return;
        }
        for (HstNode child : node.getNodes()) {
            HstComponentConfigurationService childComponent = this.loadChildComponent(child, rootNodeName, rootConfigurationPathPrefix, referableContainers);
            if (childComponent == null) continue;
            this.componentConfigurations.put(StringPool.get((String)childComponent.getId()), childComponent);
            this.orderedListConfigs.add(childComponent);
            this.childConfByName.put(StringPool.get((String)childComponent.getName()), childComponent);
            log.debug("Added component service with key '{}'", (Object)this.id);
        }
    }

    private HstComponentConfigurationService loadChildComponent(HstNode child, String rootNodeName, String rootConfigurationPathPrefix, Map<String, HstNode> referenceableContainers) {
        if (this.isHstComponentOrReferenceType(child)) {
            if (this.isPrototype() && this.isNotAllowedInPrototype(child)) {
                log.warn("Component child of type '{}' are not allowed in a prototype page. Skipping component '{}'.", (Object)child.getNodeTypeName(), (Object)child.getValueProvider().getPath());
                return null;
            }
            if (child.getValueProvider().hasProperty("hst:referencename")) {
                this.usedChildReferenceNames.add(StringPool.get((String)child.getValueProvider().getString("hst:referencename")));
            }
            try {
                if ("hst:containercomponentreference".equals(child.getNodeTypeName())) {
                    HstNode referencedContainerNode = this.getReferencedContainer(child, referenceableContainers);
                    if (referencedContainerNode == null) {
                        return null;
                    }
                    String explicitName = child.getValueProvider().getName();
                    return new HstComponentConfigurationService(referencedContainerNode, this, rootNodeName, false, referenceableContainers, rootConfigurationPathPrefix, explicitName);
                }
                return new HstComponentConfigurationService(child, this, rootNodeName, false, referenceableContainers, rootConfigurationPathPrefix, null);
            }
            catch (ModelLoadingException e) {
                if (log.isDebugEnabled()) {
                    log.warn("Skipping component '" + child.getValueProvider().getPath() + "'", (Throwable)e);
                } else if (log.isWarnEnabled()) {
                    log.warn("Skipping component '{}' : '{}'", (Object)child.getValueProvider().getPath(), (Object)e.toString());
                }
                return null;
            }
        }
        log.warn("Skipping node '{}' because is not of type '{}'", (Object)child.getValueProvider().getPath(), (Object)"hst:component");
        return null;
    }

    private boolean isHstComponentOrReferenceType(HstNode node) {
        return "hst:component".equals(node.getNodeTypeName()) || "hst:containercomponent".equals(node.getNodeTypeName()) || "hst:containeritemcomponent".equals(node.getNodeTypeName()) || "hst:containercomponentreference".equals(node.getNodeTypeName());
    }

    private boolean isNotAllowedInPrototype(HstNode node) {
        return "hst:containercomponentreference".equals(node.getNodeTypeName());
    }

    private HstNode getReferencedContainer(HstNode child, Map<String, HstNode> referenceableContainers) {
        if (referenceableContainers == null || referenceableContainers.isEmpty()) {
            log.warn("Component '{}' is of type '{}' but there are no referenceable containers at '{}'. Component '{}' will be ignored.", (Object[])new String[]{child.getValueProvider().getPath(), "hst:containercomponentreference", "hst:workspace/hst:containers", child.getValueProvider().getPath()});
            return null;
        }
        String reference = child.getValueProvider().getString("hst:referencecomponent");
        if (reference.startsWith("/")) {
            log.warn("Component '{}' has reference '{}' that starts with a '/'. Reference should not start with a slash and must be relative to '{}'. Removing leading slash");
            reference = reference.substring(1);
        }
        try {
            String[] elements = reference.split("/");
            HstNode refNode = null;
            HstNode hstNode = referenceableContainers.get(elements[0]);
            if (hstNode != null) {
                if (elements.length == 1) {
                    refNode = hstNode;
                } else {
                    String subPath = reference.substring(elements[0].length() + 1);
                    refNode = hstNode.getNode(subPath);
                }
            }
            if (refNode == null) {
                log.warn("Component '{}' contains an unresolvable reference '{}'. It should be a location relative to '{}'. Component '{}' will be ignored.", (Object[])new String[]{child.getValueProvider().getPath(), reference, "hst:workspace/hst:containers", child.getValueProvider().getPath()});
                return null;
            }
            if (!"hst:containercomponent".equals(refNode.getNodeTypeName())) {
                log.warn("Component '{}' contains an reference '{}' that does not point to a node of type '{}'. That is not allowed. Component '{}' will be ignored.", (Object[])new String[]{child.getValueProvider().getPath(), reference, "hst:workspace/hst:containers", child.getValueProvider().getPath()});
                return null;
            }
            log.debug("Succesfully found referenced containercomponent node '{}' for '{}'.", (Object)refNode.getValueProvider().getPath(), (Object)child.getValueProvider().getPath());
            return refNode;
        }
        catch (IllegalArgumentException e) {
            log.warn("Reference '{}' for '{}' is invalid : {}", (Object[])new String[]{reference, child.getValueProvider().getPath(), e.toString()});
            return null;
        }
    }

    public HstComponentConfiguration getParent() {
        return this.parent;
    }

    public String getComponentClassName() {
        return this.componentClassName;
    }

    public String getXType() {
        return this.xtype;
    }

    public HstComponentConfiguration.Type getComponentType() {
        return this.type;
    }

    public String getHstTemplate() {
        return this.hstTemplate;
    }

    public String getRenderPath() {
        if (this.isNamedRenderer) {
            return null;
        }
        return this.renderPath;
    }

    public String getNamedRenderer() {
        if (!this.isNamedRenderer) {
            return null;
        }
        return this.renderPath;
    }

    public String getHstResourceTemplate() {
        return this.hstResourceTemplate;
    }

    public String getServeResourcePath() {
        if (this.isNamedResourceServer) {
            return null;
        }
        return this.serveResourcePath;
    }

    public String getNamedResourceServer() {
        if (!this.isNamedResourceServer) {
            return null;
        }
        return this.serveResourcePath;
    }

    public String getParameter(String name) {
        return this.parameters.get(name);
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public Set<String> getParameterPrefixes() {
        return this.parameterNamePrefixSet;
    }

    public List<String> getVariants() {
        return this.variants;
    }

    public void setMountVariants(List<String> immutableMountVariants) {
        this.mountVariants = immutableMountVariants;
        for (HstComponentConfigurationService child : this.orderedListConfigs) {
            child.setMountVariants(immutableMountVariants);
        }
    }

    public List<String> getMountVariants() {
        return this.mountVariants;
    }

    public String getLocalParameter(String name) {
        return this.localParameters.get(name);
    }

    public Map<String, String> getLocalParameters() {
        return this.localParameters;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public void setReferenceName(String referenceName) {
        this.referenceName = referenceName;
    }

    public String getReferenceComponent() {
        return this.referenceComponent;
    }

    public String getPageErrorHandlerClassName() {
        return this.pageErrorHandlerClassName;
    }

    public String getComponentFilterTag() {
        return this.componentFilterTag;
    }

    public Map<String, HstComponentConfiguration> getChildren() {
        return this.componentConfigurations;
    }

    public HstComponentConfiguration getChildByName(String name) {
        return this.childConfByName.get(name);
    }

    public String getCanonicalStoredLocation() {
        return this.canonicalStoredLocation;
    }

    public String getCanonicalIdentifier() {
        return this.canonicalIdentifier;
    }

    public boolean isInherited() {
        return this.inherited;
    }

    public boolean isPrototype() {
        return this.prototype;
    }

    public boolean isStandalone() {
        return this.standalone == null ? true : this.standalone;
    }

    public boolean isAsync() {
        return this.async == null ? false : this.async;
    }

    public String getAsyncMode() {
        return this.asyncMode;
    }

    public boolean isCompositeCacheable() {
        return this.compositeCacheable;
    }

    public boolean isSuppressWasteMessage() {
        return this.suppressWasteMessage == null ? false : this.suppressWasteMessage;
    }

    public String getLabel() {
        return this.label;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    public String getLockedBy() {
        return this.lockedBy;
    }

    public Calendar getLockedOn() {
        return this.lockedOn;
    }

    public Calendar getLastModified() {
        return this.lastModified;
    }

    public boolean isMarkedDeleted() {
        return this.markedDeleted == null ? false : this.markedDeleted;
    }

    private HstComponentConfigurationService deepCopy(HstComponentConfigurationService parent, String newId, HstComponentConfigurationService child, List<HstComponentConfiguration> populated, Map<String, HstComponentConfiguration> rootComponentConfigurations) {
        if (child.getReferenceComponent() != null) {
            child.populateComponentReferences(rootComponentConfigurations, populated);
        }
        HstComponentConfigurationService copy = new HstComponentConfigurationService(newId);
        copy.parent = parent;
        copy.componentClassName = child.componentClassName;
        copy.name = child.name;
        copy.referenceName = child.referenceName;
        copy.hstTemplate = child.hstTemplate;
        copy.label = child.label;
        copy.iconPath = child.iconPath;
        copy.renderPath = child.renderPath;
        copy.isNamedRenderer = child.isNamedRenderer;
        copy.hstResourceTemplate = child.hstResourceTemplate;
        copy.serveResourcePath = child.serveResourcePath;
        copy.isNamedResourceServer = child.isNamedResourceServer;
        copy.referenceComponent = child.referenceComponent;
        copy.pageErrorHandlerClassName = child.pageErrorHandlerClassName;
        copy.xtype = child.xtype;
        copy.type = child.type;
        copy.canonicalStoredLocation = child.canonicalStoredLocation;
        copy.canonicalIdentifier = child.canonicalIdentifier;
        copy.componentFilterTag = child.componentFilterTag;
        copy.inherited = child.inherited;
        copy.standalone = child.standalone;
        copy.async = child.async;
        copy.asyncMode = child.asyncMode;
        copy.cacheable = child.cacheable;
        copy.suppressWasteMessage = child.suppressWasteMessage;
        copy.parameters = new LinkedHashMap<String, String>(child.parameters);
        copy.parameterNamePrefixSet = new HashSet<String>(child.parameterNamePrefixSet);
        copy.localParameters = new LinkedHashMap<String, String>(child.localParameters);
        copy.usedChildReferenceNames = new ArrayList<String>(child.usedChildReferenceNames);
        copy.lockedBy = child.lockedBy;
        copy.lockedOn = child.lockedOn;
        copy.lastModified = child.lastModified;
        copy.markedDeleted = child.markedDeleted;
        for (HstComponentConfigurationService descendant : child.orderedListConfigs) {
            String descId = StringPool.get((String)(copy.id + descendant.id));
            HstComponentConfigurationService copyDescendant = this.deepCopy(copy, descId, descendant, populated, rootComponentConfigurations);
            copy.componentConfigurations.put(copyDescendant.id, copyDescendant);
            copy.orderedListConfigs.add(copyDescendant);
            copy.childConfByName.put(StringPool.get((String)copyDescendant.getName()), copyDescendant);
        }
        populated.add(copy);
        return copy;
    }

    protected void populateComponentReferences(Map<String, HstComponentConfiguration> rootComponentConfigurations, List<HstComponentConfiguration> populated) {
        if (populated.contains(this)) {
            return;
        }
        populated.add(this);
        if (this.getReferenceComponent() != null) {
            HstComponentConfigurationService referencedComp = (HstComponentConfigurationService)rootComponentConfigurations.get(this.getReferenceComponent());
            if (referencedComp != null && !referencedComp.isMarkedDeleted()) {
                if (referencedComp == this) {
                    throw new ModelLoadingException("There is a component referencing itself: this is not allowed. The site configuration cannot be loaded. Incorrect ComponentId = " + this.getId());
                }
                if (referencedComp.getReferenceComponent() != null) {
                    referencedComp.populateComponentReferences(rootComponentConfigurations, populated);
                }
                if (this.componentClassName == null) {
                    this.componentClassName = referencedComp.componentClassName;
                }
                if (this.name == null) {
                    this.name = referencedComp.name;
                }
                if (this.referenceName == null) {
                    this.referenceName = referencedComp.referenceName;
                }
                if (this.referenceComponent == null) {
                    this.referenceComponent = referencedComp.referenceComponent;
                }
                if (this.hstTemplate == null) {
                    this.hstTemplate = referencedComp.hstTemplate;
                }
                if (this.label == null) {
                    this.label = referencedComp.label;
                }
                if (this.iconPath == null) {
                    this.iconPath = referencedComp.iconPath;
                }
                if (this.renderPath == null) {
                    this.renderPath = referencedComp.renderPath;
                    this.isNamedRenderer = referencedComp.isNamedRenderer;
                }
                if (this.hstResourceTemplate == null) {
                    this.hstResourceTemplate = referencedComp.hstResourceTemplate;
                }
                if (this.serveResourcePath == null) {
                    this.serveResourcePath = referencedComp.serveResourcePath;
                    this.isNamedResourceServer = referencedComp.isNamedResourceServer;
                }
                if (this.canonicalStoredLocation == null) {
                    this.canonicalStoredLocation = referencedComp.canonicalStoredLocation;
                }
                if (this.canonicalIdentifier == null) {
                    this.canonicalIdentifier = referencedComp.canonicalIdentifier;
                }
                if (this.pageErrorHandlerClassName == null) {
                    this.pageErrorHandlerClassName = referencedComp.pageErrorHandlerClassName;
                }
                if (this.xtype == null) {
                    this.xtype = referencedComp.xtype;
                }
                if (this.componentFilterTag == null) {
                    this.componentFilterTag = referencedComp.componentFilterTag;
                }
                if (this.standalone == null) {
                    this.standalone = referencedComp.standalone;
                }
                if (this.async == null) {
                    this.async = referencedComp.async;
                }
                if (this.asyncMode == null) {
                    this.asyncMode = referencedComp.asyncMode;
                }
                if (this.cacheable == null) {
                    this.cacheable = referencedComp.cacheable;
                }
                if (this.suppressWasteMessage == null) {
                    this.suppressWasteMessage = referencedComp.suppressWasteMessage;
                }
                if (this.lockedBy == null) {
                    this.lockedBy = referencedComp.lockedBy;
                }
                if (this.lockedOn == null) {
                    this.lockedOn = referencedComp.lockedOn;
                }
                if (this.lastModified == null) {
                    this.lastModified = referencedComp.lastModified;
                }
                if (!referencedComp.parameters.isEmpty()) {
                    for (Map.Entry entry : referencedComp.parameters.entrySet()) {
                        if (this.parameters.containsKey(entry.getKey())) continue;
                        this.parameters.put((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                if (!referencedComp.parameterNamePrefixSet.isEmpty()) {
                    for (String string : referencedComp.parameterNamePrefixSet) {
                        if (this.parameterNamePrefixSet.contains(string)) continue;
                        this.parameterNamePrefixSet.add(string);
                    }
                }
                this.usedChildReferenceNames.addAll(referencedComp.usedChildReferenceNames);
                for (HstComponentConfigurationService hstComponentConfigurationService : referencedComp.orderedListConfigs) {
                    if (hstComponentConfigurationService.getReferenceComponent() != null) {
                        hstComponentConfigurationService.populateComponentReferences(rootComponentConfigurations, populated);
                    }
                    if (this.childConfByName.get(hstComponentConfigurationService.name) != null) {
                        HstComponentConfigurationService existingChild = this.childConfByName.get(hstComponentConfigurationService.name);
                        existingChild.populateComponentReferences(rootComponentConfigurations, populated);
                        hstComponentConfigurationService.populateComponentReferences(rootComponentConfigurations, populated);
                        existingChild.combine(hstComponentConfigurationService, rootComponentConfigurations, populated);
                        continue;
                    }
                    this.addDeepCopy(hstComponentConfigurationService, populated, rootComponentConfigurations);
                }
            } else {
                log.warn("Cannot lookup referenced component '{}' for this component ['{}']. We skip this reference", (Object)this.getReferenceComponent(), (Object)this.getId());
            }
        }
    }

    private void combine(HstComponentConfigurationService childToMerge, Map<String, HstComponentConfiguration> rootComponentConfigurations, List<HstComponentConfiguration> populated) {
        if (this.type == HstComponentConfiguration.Type.CONTAINER_COMPONENT || childToMerge.type == HstComponentConfiguration.Type.CONTAINER_COMPONENT) {
            log.warn("Incorrect component configuration: *Container* Components are not allowed to be merged with other components. Cannot merge '{}' and '{}' because at least one of them is a Container component. Fix configuration.", (Object)childToMerge.getId(), (Object)this.getId());
            return;
        }
        if (this.type == HstComponentConfiguration.Type.CONTAINER_ITEM_COMPONENT || childToMerge.type == HstComponentConfiguration.Type.CONTAINER_ITEM_COMPONENT) {
            log.warn("Incorrect component configuration: *ContainerItem* Components are not allowed to be merged with other components. Cannot merge '{}' and '{}' because at least one of them is a ContainerItemComponent. Fix configuration.", (Object)childToMerge.getId(), (Object)this.getId());
            return;
        }
        if (this.componentClassName == null) {
            this.componentClassName = childToMerge.componentClassName;
        }
        if (this.hstTemplate == null) {
            this.hstTemplate = childToMerge.hstTemplate;
        }
        if (this.label == null) {
            this.label = childToMerge.label;
        }
        if (this.iconPath == null) {
            this.iconPath = childToMerge.iconPath;
        }
        if (this.hstResourceTemplate == null) {
            this.hstResourceTemplate = childToMerge.hstResourceTemplate;
        }
        if (this.name == null) {
            this.name = childToMerge.name;
        }
        if (this.referenceName == null) {
            this.referenceName = childToMerge.referenceName;
        }
        if (this.renderPath == null) {
            this.renderPath = childToMerge.renderPath;
            this.isNamedRenderer = childToMerge.isNamedRenderer;
        }
        if (this.referenceComponent == null) {
            this.referenceComponent = childToMerge.referenceComponent;
        }
        if (this.serveResourcePath == null) {
            this.serveResourcePath = childToMerge.serveResourcePath;
            this.isNamedResourceServer = childToMerge.isNamedResourceServer;
        }
        if (this.pageErrorHandlerClassName == null) {
            this.pageErrorHandlerClassName = childToMerge.pageErrorHandlerClassName;
        }
        if (this.xtype == null) {
            this.xtype = childToMerge.xtype;
        }
        if (this.componentFilterTag == null) {
            this.componentFilterTag = childToMerge.componentFilterTag;
        }
        if (this.standalone == null) {
            this.standalone = childToMerge.standalone;
        }
        if (this.async == null) {
            this.async = childToMerge.async;
        }
        if (this.asyncMode == null) {
            this.asyncMode = childToMerge.asyncMode;
        }
        if (this.cacheable == null) {
            this.cacheable = childToMerge.cacheable;
        }
        if (this.suppressWasteMessage == null) {
            this.suppressWasteMessage = childToMerge.suppressWasteMessage;
        }
        if (this.lockedBy == null) {
            this.lockedBy = childToMerge.lockedBy;
        }
        if (this.lockedOn == null) {
            this.lockedOn = childToMerge.lockedOn;
        }
        if (this.lastModified == null) {
            this.lastModified = childToMerge.lastModified;
        }
        if (!childToMerge.parameters.isEmpty()) {
            for (Map.Entry entry : childToMerge.parameters.entrySet()) {
                if (this.parameters.containsKey(entry.getKey())) continue;
                this.parameters.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (!childToMerge.parameterNamePrefixSet.isEmpty()) {
            for (String string : childToMerge.parameterNamePrefixSet) {
                if (this.parameterNamePrefixSet.contains(string)) continue;
                this.parameterNamePrefixSet.add(string);
            }
        }
        for (HstComponentConfigurationService hstComponentConfigurationService : childToMerge.orderedListConfigs) {
            HstComponentConfigurationService existingChild = this.childConfByName.get(hstComponentConfigurationService.name);
            if (existingChild != null) {
                existingChild.populateComponentReferences(rootComponentConfigurations, populated);
                hstComponentConfigurationService.populateComponentReferences(rootComponentConfigurations, populated);
                this.childConfByName.get(hstComponentConfigurationService.name).combine(hstComponentConfigurationService, rootComponentConfigurations, populated);
                continue;
            }
            this.addDeepCopy(hstComponentConfigurationService, populated, rootComponentConfigurations);
        }
    }

    private void addDeepCopy(HstComponentConfigurationService childToMerge, List<HstComponentConfiguration> populated, Map<String, HstComponentConfiguration> rootComponentConfigurations) {
        String newId = StringPool.get((String)(this.id + "-" + childToMerge.id));
        HstComponentConfigurationService copy = this.deepCopy(this, newId, childToMerge, populated, rootComponentConfigurations);
        this.componentConfigurations.put(copy.getId(), copy);
        this.childConfByName.put(copy.getName(), copy);
        this.orderedListConfigs.add(copy);
    }

    protected void setRenderPath(Map<String, HstComponentsConfigurationService.Template> templateResourceMap) {
        if (StringUtils.isNotEmpty((String)this.hstTemplate)) {
            HstComponentsConfigurationService.Template template = templateResourceMap.get(this.hstTemplate);
            if (template != null) {
                this.renderPath = StringPool.get((String)template.getEffectiveRenderPath());
                this.isNamedRenderer = template.isNamed();
            } else {
                log.warn("Cannot find hst:template '{}' for hst component '{}'.", (Object)this.hstTemplate, (Object)this.toString());
            }
            if (this.renderPath == null) {
                log.info("renderer '{}' for component '{}' can not be found. This component will not have a renderer by default. It can be set runtime or this component is used without renderer.", (Object)this.getHstTemplate(), (Object)this.id);
            }
        }
        for (HstComponentConfigurationService child : this.orderedListConfigs) {
            child.setRenderPath(templateResourceMap);
        }
    }

    protected void setServeResourcePath(Map<String, HstComponentsConfigurationService.Template> templateResourceMap) {
        HstComponentsConfigurationService.Template template = templateResourceMap.get(this.getHstResourceTemplate());
        if (template != null) {
            this.serveResourcePath = StringPool.get((String)template.getEffectiveRenderPath());
            this.isNamedResourceServer = template.isNamed();
        }
        for (HstComponentConfigurationService child : this.orderedListConfigs) {
            child.setServeResourcePath(templateResourceMap);
        }
    }

    protected void inheritParameters() {
        if (this.parent != null && this.parent.getParameters() != null) {
            for (Map.Entry entry : this.parent.getParameters().entrySet()) {
                String prefix;
                if (this.parameters.containsKey(entry.getKey())) {
                    log.debug("Skip adding parameter '{}' = '{}' to component {} from ancestor {} because parameter '{}' is already present ", new Object[]{entry.getKey(), entry.getValue(), this, this.parent, entry.getKey()});
                    continue;
                }
                String parameterName = (String)entry.getKey();
                log.debug("Adding inherited parameter '{}' = '{}' to component {} from ancestor {}", new Object[]{parameterName, entry.getValue(), this, this.parent});
                this.parameters.put(parameterName, (String)entry.getValue());
                if (parameterName.indexOf(65535) <= -1 || this.parameterNamePrefixSet.contains(prefix = parameterName.substring(0, parameterName.indexOf(65535)))) continue;
                this.parameterNamePrefixSet.add(prefix);
            }
        }
        for (HstComponentConfigurationService hstComponentConfigurationService : this.orderedListConfigs) {
            hstComponentConfigurationService.inheritParameters();
        }
    }

    protected void populateVariants() {
        HashSet<String> variantsSet = new HashSet<String>();
        for (HstComponentConfigurationService child : this.orderedListConfigs) {
            child.populateVariants();
            if (child.isAsync()) {
                this.onlyAddChildVariantsIfCurrentOrAncestorIsAlreadyAsync(variantsSet, child);
                continue;
            }
            variantsSet.addAll(child.getVariants());
        }
        variantsSet.addAll(this.getParameterPrefixes());
        if (!variantsSet.isEmpty()) {
            this.variants = Collections.unmodifiableList(new ArrayList<String>(variantsSet));
        }
    }

    private void onlyAddChildVariantsIfCurrentOrAncestorIsAlreadyAsync(Set<String> variantsSet, HstComponentConfigurationService asyncChild) {
        if (this.isAsync() || this.hasAsyncAncestor()) {
            variantsSet.addAll(asyncChild.getVariants());
        }
    }

    private boolean hasAsyncAncestor() {
        for (HstComponentConfiguration parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.isAsync()) continue;
            return true;
        }
        return false;
    }

    public void populateIsCompositeCacheable() {
        if (this.cacheable != null && !this.cacheable.booleanValue()) {
            this.compositeCacheable = false;
            if (!this.isAsync() || this.hasAsyncAncestor()) {
                for (HstComponentConfigurationService parent = (HstComponentConfigurationService)this.getParent(); parent != null; parent = (HstComponentConfigurationService)parent.getParent()) {
                    parent.compositeCacheable = false;
                    if (parent.isAsync() && !parent.hasAsyncAncestor()) break;
                }
            }
        }
        for (HstComponentConfigurationService child : this.orderedListConfigs) {
            child.populateIsCompositeCacheable();
        }
    }

    protected void makeCollectionsImmutableAndOptimize() {
        for (HstComponentConfigurationService child : this.orderedListConfigs) {
            child.makeCollectionsImmutableAndOptimize();
        }
        this.parameters = this.parameters.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.parameters);
        this.localParameters = this.localParameters.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.localParameters);
        this.componentConfigurations = this.componentConfigurations.isEmpty() ? Collections.emptyMap() : Collections.unmodifiableMap(this.componentConfigurations);
        this.parameterNamePrefixSet = this.parameterNamePrefixSet.isEmpty() ? Collections.emptySet() : Collections.unmodifiableSet(this.parameterNamePrefixSet);
        if (this.childConfByName.isEmpty()) {
            this.childConfByName = Collections.emptyMap();
        }
        if (this.orderedListConfigs.isEmpty()) {
            this.orderedListConfigs = Collections.emptyList();
        }
        if (this.usedChildReferenceNames.isEmpty()) {
            this.usedChildReferenceNames = Collections.emptyList();
        }
    }

    protected void autocreateReferenceNames() {
        for (HstComponentConfigurationService child : this.orderedListConfigs) {
            child.autocreateReferenceNames();
            if (child.getReferenceName() != null && !"".equals(child.getReferenceName())) continue;
            String autoRefName = "r" + ++this.autocreatedCounter;
            while (this.usedChildReferenceNames.contains(autoRefName)) {
                autoRefName = "r" + ++this.autocreatedCounter;
            }
            child.setReferenceName(StringPool.get((String)autoRefName));
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("HstComponentConfiguration [id=");
        builder.append(this.id).append(", stored jcr location=").append(this.canonicalStoredLocation).append(", className=").append(this.componentClassName).append(", template=").append(this.hstTemplate).append("]");
        return builder.toString();
    }
}

