/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.channel;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.channel.AbstractHstPropertyDefinition;
import org.hippoecm.hst.configuration.channel.ChannelException;
import org.hippoecm.hst.configuration.channel.ChannelInfo;
import org.hippoecm.hst.configuration.channel.ChannelInfoClassProcessor;
import org.hippoecm.hst.configuration.channel.HstPropertyDefinition;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.core.parameters.HstValueType;
import org.onehippo.cms7.services.hst.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelPropertyMapper {
    static final Logger log = LoggerFactory.getLogger(ChannelPropertyMapper.class);

    private ChannelPropertyMapper() {
    }

    public static Channel readBlueprintChannel(HstNode channelNode) {
        return ChannelPropertyMapper.readChannel(channelNode, null, false, null, true);
    }

    public static Channel readChannel(HstNode channelNode, HstNode configurationNode, String contextPath) {
        boolean channelSettingsEditable;
        String configurationPath = configurationNode == null ? null : configurationNode.getValueProvider().getPath();
        if ("hst:workspace".equals(channelNode.getParent().getNodeTypeName())) {
            HstNode configurationNodeOfChannelNode = channelNode.getParent().getParent();
            if (configurationNodeOfChannelNode.getValueProvider().getPath().equals(configurationPath)) {
                log.debug("'{}' node is a child node of '{}' and is not inherited but directly below '{}' hence the channel settings are editable.", new Object[]{"hst:channel", "hst:workspace", configurationPath});
                channelSettingsEditable = true;
            } else {
                channelSettingsEditable = false;
            }
        } else {
            channelSettingsEditable = false;
        }
        return ChannelPropertyMapper.readChannel(channelNode, configurationNode, channelSettingsEditable, contextPath, false);
    }

    static Channel readChannel(HstNode channelNode, HstNode configurationNode, boolean channelSettingsEditable, String contextPath, boolean isBlueprint) {
        String channelId = configurationNode == null ? null : configurationNode.getName();
        Channel channel = new Channel(channelId);
        channel.setName(channelId);
        channel.setChannelSettingsEditable(channelSettingsEditable);
        if (configurationNode != null && configurationNode.getValueProvider().hasProperty("hst:locked")) {
            channel.setConfigurationLocked(configurationNode.getValueProvider().getBoolean("hst:locked").booleanValue());
        }
        if (channelNode.getValueProvider().hasProperty("hst:name")) {
            channel.setName(channelNode.getValueProvider().getString("hst:name"));
        }
        if (channelNode.getValueProvider().hasProperty("hst:type")) {
            channel.setType(channelNode.getValueProvider().getString("hst:type"));
        }
        if (channelNode.getValueProvider().hasProperty("hst:defaultdevice")) {
            channel.setDefaultDevice(channelNode.getValueProvider().getString("hst:defaultdevice"));
        }
        if (channelNode.getValueProvider().hasProperty("hst:devices")) {
            String[] devices = channelNode.getValueProvider().getStrings("hst:devices");
            channel.setDevices(Arrays.asList(devices));
        }
        if (channelNode.getValueProvider().hasProperty("hst:deletable")) {
            channel.setDeletable(channelNode.getValueProvider().getBoolean("hst:deletable").booleanValue());
        }
        if (channelNode.getValueProvider().hasProperty("hst:lockedby")) {
            channel.setChannelNodeLockedBy(channelNode.getValueProvider().getString("hst:lockedby"));
        }
        if (channelNode.getValueProvider().hasProperty("hst:lastmodifiedby")) {
            channel.setLastModifiedBy(channelNode.getValueProvider().getString("hst:lastmodifiedby"));
        }
        if (channelNode.getValueProvider().hasProperty("hst:lastmodified")) {
            channel.setLastModified(channelNode.getValueProvider().getDate("hst:lastmodified"));
        }
        if (channelNode.getValueProvider().hasProperty("hst:lockedon")) {
            channel.setLockedOn(channelNode.getValueProvider().getDate("hst:lockedon"));
        }
        if (channelNode.getValueProvider().hasProperty("hst:channelinfoclass")) {
            String className = channelNode.getValueProvider().getString("hst:channelinfoclass");
            try {
                Class<?> clazz = ChannelPropertyMapper.class.getClassLoader().loadClass(className);
                if (!ChannelInfo.class.isAssignableFrom(clazz)) {
                    log.warn("Class " + className + " does not extend ChannelInfo");
                    return channel;
                }
                channel.setChannelInfoClassName(className);
                HstNode channelInfoNode = channelNode.getNode("hst:channelinfo");
                if (channelInfoNode != null) {
                    HashMap<String, Object> properties = new HashMap<String, Object>();
                    List<HstPropertyDefinition> propertyDefinitions = ChannelInfoClassProcessor.getProperties(clazz);
                    Map<HstPropertyDefinition, Object> values = ChannelPropertyMapper.loadProperties(channelInfoNode, propertyDefinitions);
                    for (HstPropertyDefinition def : propertyDefinitions) {
                        if (values.get(def) != null) {
                            properties.put(def.getName(), values.get(def));
                            continue;
                        }
                        if (def.getDefaultValue() == null) continue;
                        properties.put(def.getName(), def.getDefaultValue());
                    }
                    channel.setProperties(properties);
                }
            }
            catch (ClassNotFoundException e) {
                if (isBlueprint) {
                    if (log.isDebugEnabled()) {
                        log.warn("Could not load channel info class '{}' for channel '{}' for contextPath '{}'. The channel info class needs to be added to that webapp as well or set the property '{}' with the correct contextPath on the blueprint node.", new Object[]{className, channel.getId(), contextPath, "hst:contextpath", e});
                    } else {
                        log.warn("Could not load channel info class '{}' for channel '{}' for contextPath '{}'. The channel info class needs to be added to that webapp as well or set the property '{}' with the correct contextPath on the blueprint node: {}", new Object[]{className, channel.getId(), contextPath, "hst:contextpath", e.toString()});
                    }
                }
                if (contextPath == null) {
                    if (log.isDebugEnabled()) {
                        log.warn("Could not load channel info class '{}' for channel '{}' for contextPath that is null. For contextPath agnostic mounts, the channel info needs to be in every HST webapp. ", new Object[]{className, channel.getId(), e});
                    } else {
                        log.warn("Could not load channel info class '{}' for channel '{}' for contextPath that is null. For contextPath agnostic mounts, the channel info needs to be in every HST webapp : {}", new Object[]{className, channel.getId(), e.toString()});
                    }
                }
                if (log.isDebugEnabled()) {
                    log.warn("Could not load channel info class '{}' for channel '{}'", new Object[]{className, channel.getId(), e});
                }
                log.warn("Could not load channel info class '{}' for channel '{}' : {}", new Object[]{className, channel.getId(), e.toString()});
            }
        }
        return channel;
    }

    private static void savePropertyOrRemoveIfNull(Node node, String propertyName, String value) throws RepositoryException {
        if (value != null) {
            node.setProperty(propertyName, value);
        } else if (node.hasProperty(propertyName)) {
            node.getProperty(propertyName).remove();
        }
    }

    public static void saveChannel(Node channelNode, Channel channel) throws RepositoryException, ChannelException {
        long validateLastModifiedTimestamp = -1L;
        if (channel.getLastModified() != null) {
            validateLastModifiedTimestamp = channel.getLastModified().getTimeInMillis();
        }
        ChannelPropertyMapper.tryLockOnNodeIfNeeded(channelNode, validateLastModifiedTimestamp);
        ChannelPropertyMapper.savePropertyOrRemoveIfNull(channelNode, "hst:name", channel.getName());
        ChannelPropertyMapper.savePropertyOrRemoveIfNull(channelNode, "hst:type", channel.getType());
        ChannelPropertyMapper.savePropertyOrRemoveIfNull(channelNode, "hst:defaultdevice", channel.getDefaultDevice());
        if (channel.getDevices() != null) {
            channelNode.setProperty("hst:devices", channel.getDevices().toArray(new String[0]));
        } else if (channelNode.hasProperty("hst:devices")) {
            channelNode.getProperty("hst:devices").remove();
        }
        if (channel.isDeletable()) {
            channelNode.setProperty("hst:deletable", true);
        } else if (channelNode.hasProperty("hst:deletable")) {
            channelNode.getProperty("hst:deletable").remove();
        }
        String channelInfoClassName = channel.getChannelInfoClassName();
        if (channelInfoClassName != null) {
            channelNode.setProperty("hst:channelinfoclass", channelInfoClassName);
            Node channelPropsNode = !channelNode.hasNode("hst:channelinfo") ? channelNode.addNode("hst:channelinfo", "hst:channelinfo") : channelNode.getNode("hst:channelinfo");
            try {
                Class<?> channelInfoClass = ChannelPropertyMapper.class.getClassLoader().loadClass(channelInfoClassName);
                ChannelPropertyMapper.saveProperties(channelPropsNode, ChannelInfoClassProcessor.getProperties(channelInfoClass), channel.getProperties());
            }
            catch (ClassNotFoundException e) {
                log.warn("Could not find channel info class " + channelInfoClassName, (Throwable)e);
                throw new IllegalStateException("Could not find channel info class ", e);
            }
        } else if (channelNode.hasNode("hst:channelinfo")) {
            channelNode.getNode("hst:channelinfo").remove();
        }
    }

    static Map<HstPropertyDefinition, Object> loadProperties(HstNode channelInfoNode, List<HstPropertyDefinition> propertyDefinitions) {
        HashMap<HstPropertyDefinition, Object> properties = new HashMap<HstPropertyDefinition, Object>();
        if (propertyDefinitions != null) {
            for (HstPropertyDefinition pd : propertyDefinitions) {
                Object value = null;
                if (channelInfoNode.getValueProvider().hasProperty(pd.getName())) {
                    Object property = channelInfoNode.getValueProvider().getProperties().get(pd.getName());
                    value = ChannelPropertyMapper.getHstValueFromObject(pd, property);
                }
                properties.put(pd, value);
            }
        } else {
            for (Map.Entry property : channelInfoNode.getValueProvider().getProperties().entrySet()) {
                AbstractHstPropertyDefinition hpd = new AbstractHstPropertyDefinition((String)property.getKey()){};
                properties.put(hpd, ChannelPropertyMapper.getHstValueFromObject(hpd, property));
            }
        }
        return properties;
    }

    public static void saveProperties(Node node, List<HstPropertyDefinition> definitions, Map<String, Object> properties) throws RepositoryException {
        PropertyIterator propertyIterator = node.getProperties();
        while (propertyIterator.hasNext()) {
            Property prop = propertyIterator.nextProperty();
            if (prop.getDefinition().isProtected()) continue;
            prop.remove();
        }
        for (HstPropertyDefinition definition : definitions) {
            if (!properties.containsKey(definition.getName()) || properties.get(definition.getName()) == null) continue;
            ChannelPropertyMapper.setHstValueToJcr(node, definition, properties.get(definition.getName()));
        }
    }

    private static Object getHstValueFromObject(HstPropertyDefinition pd, Object property) {
        Object value;
        if (property.getClass().isArray()) {
            value = new LinkedList();
            List valueList = (List)value;
            for (Object propVal : (Object[])property) {
                if (ChannelPropertyMapper.correctType(propVal, pd.getValueType())) {
                    valueList.add(propVal);
                    continue;
                }
                valueList.add(pd.getDefaultValue());
            }
        } else {
            value = ChannelPropertyMapper.correctType(property, pd.getValueType()) ? property : pd.getDefaultValue();
        }
        return value;
    }

    private static boolean correctType(Object property, HstValueType valueType) {
        switch (valueType) {
            case STRING: {
                return property instanceof String;
            }
            case BOOLEAN: {
                return property instanceof Boolean;
            }
            case DATE: {
                return property instanceof Calendar;
            }
            case DOUBLE: {
                return property instanceof Double;
            }
            case INTEGER: {
                return property instanceof Long;
            }
            case LONG: {
                return property instanceof Long;
            }
        }
        return false;
    }

    private static void setHstValueToJcr(Node node, HstPropertyDefinition propDef, Object value) throws RepositoryException {
        ValueFactory vf = node.getSession().getValueFactory();
        if (value instanceof List) {
            Value[] values = new Value[((List)value).size()];
            int i = 0;
            for (Object val : (List)value) {
                values[i++] = ChannelPropertyMapper.javaToJcr(vf, val, propDef);
            }
            node.setProperty(propDef.getName(), values);
        } else {
            node.setProperty(propDef.getName(), ChannelPropertyMapper.javaToJcr(vf, value, propDef));
        }
    }

    private static Value javaToJcr(ValueFactory vf, Object value, HstPropertyDefinition propDef) throws RepositoryException {
        if (value instanceof String) {
            if (propDef.getValueType() != HstValueType.STRING) {
                log.warn("Cannot store a String '{}' for '{}'. Store default value instead", value, (Object)propDef.getName());
                return ChannelPropertyMapper.defaultValueToJcr(vf, propDef);
            }
            return vf.createValue((String)value);
        }
        if (value instanceof Boolean) {
            if (propDef.getValueType() != HstValueType.BOOLEAN) {
                log.warn("Cannot store a Boolean '{}' for '{}'. Store default value instead", value, (Object)propDef.getName());
                return ChannelPropertyMapper.defaultValueToJcr(vf, propDef);
            }
            return vf.createValue(((Boolean)value).booleanValue());
        }
        if (value instanceof Integer) {
            if (propDef.getValueType() != HstValueType.INTEGER) {
                log.warn("Cannot store a Integer (Long in jcr) '{}' for '{}'. Store default value instead", value, (Object)propDef.getName());
                return ChannelPropertyMapper.defaultValueToJcr(vf, propDef);
            }
            return vf.createValue(((Integer)value).longValue());
        }
        if (value instanceof Long) {
            if (propDef.getValueType() != HstValueType.LONG) {
                log.warn("Cannot store a Long '{}' for '{}'. Store default value instead", value, (Object)propDef.getName());
                return ChannelPropertyMapper.defaultValueToJcr(vf, propDef);
            }
            return vf.createValue(((Long)value).longValue());
        }
        if (value instanceof Double) {
            if (propDef.getValueType() != HstValueType.DOUBLE) {
                log.warn("Cannot store a Double '{}' for '{}'. Store default value instead", value, (Object)propDef.getName());
                return ChannelPropertyMapper.defaultValueToJcr(vf, propDef);
            }
            return vf.createValue(((Double)value).doubleValue());
        }
        if (value instanceof Calendar) {
            if (propDef.getValueType() != HstValueType.DATE) {
                log.warn("Cannot store a Calendar '{}' for '{}'. Store default value instead", value, (Object)propDef.getName());
                return ChannelPropertyMapper.defaultValueToJcr(vf, propDef);
            }
            return vf.createValue((Calendar)value);
        }
        throw new RepositoryException("Unable to find valid value type for " + value);
    }

    private static Value defaultValueToJcr(ValueFactory vf, HstPropertyDefinition propDef) throws RepositoryException {
        switch (propDef.getValueType()) {
            case STRING: {
                if (!(propDef.getDefaultValue() instanceof String)) {
                    log.warn("HstPropertyDefinition Default value '{}' incompatible with HstPropertyDefinition type '{}'. Return default value for type", propDef.getDefaultValue(), (Object)propDef.getValueType());
                    return vf.createValue("");
                }
                return vf.createValue((String)propDef.getDefaultValue());
            }
            case BOOLEAN: {
                if (!(propDef.getDefaultValue() instanceof Boolean)) {
                    log.warn("HstPropertyDefinition Default value '{}' incompatible with HstPropertyDefinition type '{}'. Return default value for type", propDef.getDefaultValue(), (Object)propDef.getValueType());
                    return vf.createValue(false);
                }
                return vf.createValue(((Boolean)propDef.getDefaultValue()).booleanValue());
            }
            case DATE: {
                if (!(propDef.getDefaultValue() instanceof Calendar)) {
                    log.warn("HstPropertyDefinition Default value '{}' incompatible with HstPropertyDefinition type '{}'. Return default value for type", propDef.getDefaultValue(), (Object)propDef.getValueType());
                    return vf.createValue(Calendar.getInstance());
                }
                return vf.createValue((Calendar)propDef.getDefaultValue());
            }
            case DOUBLE: {
                if (!(propDef.getDefaultValue() instanceof Double)) {
                    log.warn("HstPropertyDefinition Default value '{}' incompatible with HstPropertyDefinition type '{}'. Return default value for type", propDef.getDefaultValue(), (Object)propDef.getValueType());
                    return vf.createValue(0.0);
                }
                return vf.createValue(((Double)propDef.getDefaultValue()).doubleValue());
            }
            case INTEGER: {
                if (!(propDef.getDefaultValue() instanceof Integer)) {
                    log.warn("HstPropertyDefinition Default value '{}' incompatible with HstPropertyDefinition type '{}'. Return default value for type", propDef.getDefaultValue(), (Object)propDef.getValueType());
                    return vf.createValue(0L);
                }
                return vf.createValue(((Integer)propDef.getDefaultValue()).longValue());
            }
            case LONG: {
                if (!(propDef.getDefaultValue() instanceof Long)) {
                    log.warn("HstPropertyDefinition Default value '{}' incompatible with HstPropertyDefinition type '{}'. Return default value for type", propDef.getDefaultValue(), (Object)propDef.getValueType());
                    return vf.createValue(0L);
                }
                return vf.createValue(((Long)propDef.getDefaultValue()).longValue());
            }
        }
        throw new RuntimeException("Unexpected HstValueType " + propDef.getDefaultValue().getClass().getName());
    }

    public static boolean isLockedBySomeoneElse(Node configurationNode) throws RepositoryException {
        String holder = ChannelPropertyMapper.getLockedBy(configurationNode);
        if (StringUtils.isEmpty((String)holder)) {
            return false;
        }
        return !configurationNode.getSession().getUserID().equals(holder);
    }

    public static boolean isLockedBySession(Node configurationNode) throws RepositoryException {
        String holder = ChannelPropertyMapper.getLockedBy(configurationNode);
        if (StringUtils.isEmpty((String)holder)) {
            return false;
        }
        return configurationNode.getSession().getUserID().equals(holder);
    }

    public static String getLockedBy(Node configurationNode) throws RepositoryException {
        if (!configurationNode.hasProperty("hst:lockedby")) {
            return null;
        }
        return configurationNode.getProperty("hst:lockedby").getString();
    }

    public static void tryLockOnNodeIfNeeded(Node nodeToLock, long validateLastModifiedTimestamp) throws RepositoryException, ChannelException {
        long existingTimeStamp;
        Session session = nodeToLock.getSession();
        if (ChannelPropertyMapper.isLockedBySomeoneElse(nodeToLock)) {
            log.info("Node '{}' is already locked by someone else.", (Object)nodeToLock.getPath());
            throw new ChannelException("Node '" + nodeToLock.getPath() + "' is already locked by someone else.", ChannelException.Type.CHANNEL_LOCKED, new String[0]);
        }
        if (ChannelPropertyMapper.isLockedBySession(nodeToLock)) {
            log.debug("Container '{}' already has a lock for user '{}'.", (Object)nodeToLock.getPath(), (Object)session.getUserID());
            return;
        }
        if (nodeToLock.hasProperty("hst:lastmodified") && (existingTimeStamp = nodeToLock.getProperty("hst:lastmodified").getDate().getTimeInMillis()) != validateLastModifiedTimestamp) {
            Calendar existing = Calendar.getInstance();
            existing.setTimeInMillis(existingTimeStamp);
            Calendar validate = Calendar.getInstance();
            validate.setTimeInMillis(validateLastModifiedTimestamp);
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss:SSS zzz", Locale.US);
            log.info("Node '{}' has been modified at '{}' but validation timestamp was '{}'. Cannot acquire lock now for user '{}'.", (Object[])new String[]{nodeToLock.getPath(), dateFormat.format(existing.getTime()), dateFormat.format(validate.getTime()), session.getUserID()});
            throw new ChannelException("Node '" + nodeToLock.getPath() + "' cannot be changed because timestamp validation did not pass.", ChannelException.Type.CHANNEL_OUT_OF_SYNC, new String[0]);
        }
        log.info("Node '{}' gets a lock for user '{}'.", (Object)nodeToLock.getPath(), (Object)session.getUserID());
        nodeToLock.setProperty("hst:lockedby", session.getUserID());
        Calendar now = Calendar.getInstance();
        if (!nodeToLock.hasProperty("hst:lockedon")) {
            nodeToLock.setProperty("hst:lockedon", now);
        }
        nodeToLock.setProperty("hst:lastmodifiedby", session.getUserID());
        nodeToLock.setProperty("hst:lastmodified", Calendar.getInstance());
    }
}

