/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.channel;

import com.google.common.net.InetAddresses;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.jcr.Item;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeType;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.cache.HstNodeLoadingCache;
import org.hippoecm.hst.configuration.channel.Blueprint;
import org.hippoecm.hst.configuration.channel.ChannelException;
import org.hippoecm.hst.configuration.channel.ChannelManager;
import org.hippoecm.hst.configuration.channel.ChannelManagerEvent;
import org.hippoecm.hst.configuration.channel.ChannelManagerEventListener;
import org.hippoecm.hst.configuration.channel.ChannelManagerEventListenerException;
import org.hippoecm.hst.configuration.channel.ChannelPropertyMapper;
import org.hippoecm.hst.configuration.hosting.VirtualHosts;
import org.hippoecm.hst.configuration.model.EventPathsInvalidator;
import org.hippoecm.hst.container.RequestContextProvider;
import org.hippoecm.hst.util.JcrSessionUtils;
import org.hippoecm.repository.api.HippoNode;
import org.hippoecm.repository.api.HippoWorkspace;
import org.hippoecm.repository.api.StringCodec;
import org.hippoecm.repository.api.StringCodecFactory;
import org.hippoecm.repository.api.Workflow;
import org.hippoecm.repository.api.WorkflowException;
import org.hippoecm.repository.api.WorkflowManager;
import org.hippoecm.repository.standardworkflow.DefaultWorkflow;
import org.hippoecm.repository.standardworkflow.FolderWorkflow;
import org.hippoecm.repository.util.JcrUtils;
import org.onehippo.cms7.services.hst.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelManagerImpl
implements ChannelManager {
    private static final String DEFAULT_HST_SITES = "hst:sites";
    private static final String DEFAULT_CONTENT_ROOT = "/content/documents";
    static final Logger log = LoggerFactory.getLogger((String)ChannelManagerImpl.class.getName());
    private String sites = "hst:sites";
    private String contentRoot = "/content/documents";
    private final StringCodec CHANNEL_ID_CODEC = new StringCodecFactory.UriEncoding();
    private List<ChannelManagerEventListener> channelManagerEventListeners = Collections.synchronizedList(new ArrayList());
    private EventPathsInvalidator eventPathsInvalidator;
    private Object hstModelMutex;
    private HstNodeLoadingCache hstNodeLoadingCache;

    public void setHstModelMutex(Object hstModelMutex) {
        this.hstModelMutex = hstModelMutex;
    }

    public void setHstNodeLoadingCache(HstNodeLoadingCache hstNodeLoadingCache) {
        this.hstNodeLoadingCache = hstNodeLoadingCache;
    }

    public void setEventPathsInvalidator(EventPathsInvalidator eventPathsInvalidator) {
        this.eventPathsInvalidator = eventPathsInvalidator;
    }

    public void setContentRoot(String contentRoot) {
        this.contentRoot = contentRoot.trim();
    }

    public void addChannelManagerEventListeners(ChannelManagerEventListener ... listeners) {
        if (listeners == null) {
            return;
        }
        for (ChannelManagerEventListener listener : listeners) {
            this.channelManagerEventListeners.add(listener);
        }
    }

    public void removeChannelManagerEventListeners(ChannelManagerEventListener ... listeners) {
        if (listeners == null) {
            return;
        }
        for (ChannelManagerEventListener listener : listeners) {
            this.channelManagerEventListeners.remove(listener);
        }
    }

    public String persist(String blueprintId, Channel channel) throws ChannelException {
        Object object = this.hstModelMutex;
        synchronized (object) {
            Blueprint blueprint = ChannelManagerImpl.getVirtualHosts().getBlueprint(blueprintId);
            if (blueprint == null) {
                throw new ChannelException("Blueprint id " + blueprintId + " is not valid");
            }
            try {
                Session session = this.getSession();
                Node configNode = session.getNode(this.hstNodeLoadingCache.getRootPath());
                String channelName = this.createUniqueHstConfigurationName(channel.getName(), session);
                channel.setId(channelName);
                Node createdContentNode = this.createChannel(configNode, blueprint, session, channelName, channel);
                ChannelManagerEventImpl event = new ChannelManagerEventImpl(blueprint, channel, configNode);
                for (ChannelManagerEventListener listener : this.channelManagerEventListeners) {
                    try {
                        listener.channelCreated((ChannelManagerEvent)event);
                    }
                    catch (ChannelManagerEventListenerException e) {
                        if (e.getStatus() == ChannelManagerEventListenerException.Status.STOP_CHANNEL_PROCESSING) {
                            session.refresh(false);
                            if (createdContentNode != null) {
                                log.info("Removing just created root content node '{}' due ChannelManagerEventListenerException '{}'", (Object)createdContentNode.getPath(), (Object)e.toString());
                                createdContentNode.remove();
                                session.save();
                            }
                            throw new ChannelException("Channel creation stopped by listener '" + listener.getClass().getName() + "'", (Throwable)e, ChannelException.Type.STOPPED_BY_LISTENER, new String[]{e.getMessage()});
                        }
                        log.warn("Channel created event listener, " + listener + ", failed to handle the event. Continue channel processing", (Throwable)e);
                    }
                    catch (Exception listenerEx) {
                        log.warn("Channel created event listener, " + listener + ", failed to handle the event", (Throwable)listenerEx);
                    }
                }
                String[] pathsToBeChanged = JcrSessionUtils.getPendingChangePaths((Session)session, (Node)session.getNode(this.hstNodeLoadingCache.getRootPath()), (boolean)false);
                session.save();
                this.eventPathsInvalidator.eventPaths(pathsToBeChanged);
                return channelName;
            }
            catch (RepositoryException e) {
                throw new ChannelException("Unable to save channel to the repository", (Throwable)e);
            }
        }
    }

    protected String createUniqueHstConfigurationName(String channelName, Session session) throws ChannelException {
        if (StringUtils.isBlank((String)channelName)) {
            throw new ChannelException("Cannot create channel ID: channel name is blank");
        }
        try {
            String encodedChannelName = this.CHANNEL_ID_CODEC.encode(channelName);
            int retries = 0;
            Node rootNode = session.getNode(this.hstNodeLoadingCache.getRootPath());
            Node sitesNode = rootNode.getNode(this.sites);
            Node configurationsNode = rootNode.getNode("hst:configurations");
            while (configurationsNode.hasNode(encodedChannelName) || sitesNode.hasNode(encodedChannelName)) {
                StringBuilder builder = new StringBuilder(channelName);
                builder.append('-');
                builder.append(++retries);
                encodedChannelName = this.CHANNEL_ID_CODEC.encode(builder.toString());
            }
            return encodedChannelName;
        }
        catch (RepositoryException e) {
            throw new ChannelException("Cannot create channel ID for channelName '" + channelName + "'", (Throwable)e);
        }
    }

    @Deprecated
    public void save(Channel channel) throws ChannelException {
        String hostGroupForCmsHost = this.getHostGroupNameFromContext();
        this.save(hostGroupForCmsHost, channel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(String hostGroupName, Channel channel) throws ChannelException {
        Object object = this.hstModelMutex;
        synchronized (object) {
            try {
                Session session = this.getSession();
                Node configNode = session.getNode(this.hstNodeLoadingCache.getRootPath());
                this.updateChannel(configNode, hostGroupName, channel);
                ChannelManagerEventImpl event = new ChannelManagerEventImpl(null, channel, configNode);
                for (ChannelManagerEventListener listener : this.channelManagerEventListeners) {
                    try {
                        listener.channelUpdated((ChannelManagerEvent)event);
                    }
                    catch (ChannelManagerEventListenerException e) {
                        if (e.getStatus() == ChannelManagerEventListenerException.Status.STOP_CHANNEL_PROCESSING) {
                            session.refresh(false);
                            throw new ChannelException("Channel '" + channel.getId() + "' update stopped by listener '" + listener.getClass().getName() + "'", (Throwable)e, ChannelException.Type.STOPPED_BY_LISTENER, new String[]{e.getMessage()});
                        }
                        log.warn("Channel created event listener, " + listener + ", failed to handle the event. Continue channel processing", (Throwable)e);
                    }
                    catch (Exception listenerEx) {
                        log.error("Channel updated event listener, " + listener + ", failed to handle the event", (Throwable)listenerEx);
                    }
                }
                String[] pathsToBeChanged = JcrSessionUtils.getPendingChangePaths((Session)session, (Node)session.getNode(this.hstNodeLoadingCache.getRootPath()), (boolean)false);
                session.save();
                this.eventPathsInvalidator.eventPaths(pathsToBeChanged);
            }
            catch (IllegalArgumentException | RepositoryException e) {
                throw new ChannelException("Unable to save channel to the repository", e);
            }
        }
    }

    public synchronized boolean canUserModifyChannels() {
        try {
            Session session = this.getSession();
            return session.hasPermission(this.hstNodeLoadingCache.getRootPath() + "/" + "hst:channels" + "/accesstest", "add_node");
        }
        catch (RepositoryException e) {
            log.error("Repository error when determining channel manager access", (Throwable)e);
            return false;
        }
    }

    private Node createChannel(Node configRoot, Blueprint blueprint, Session session, String channelName, Channel channel) throws ChannelException, RepositoryException {
        Node contentRootNode = null;
        try {
            String channelContentRootPath;
            URI channelUri = this.getChannelUri(channel);
            Node virtualHost = this.getOrCreateVirtualHost(configRoot, channelUri.getHost());
            Node blueprintNode = session.getNode(blueprint.getPath());
            String hstConfigPath = this.reuseOrCopyConfiguration(session, configRoot, blueprintNode, channelName, channel);
            channel.setHstConfigPath(hstConfigPath);
            if (blueprint.getHasContentPrototype()) {
                contentRootNode = this.createContent(blueprint, session, channelName, channel);
                channelContentRootPath = contentRootNode.getPath();
                channel.setContentRoot(channelContentRootPath);
            } else {
                channelContentRootPath = channel.getContentRoot();
            }
            Node sitesNode = configRoot.getNode(this.sites);
            Node liveSiteNode = this.createSiteNode(sitesNode, channelName, channelContentRootPath);
            String mountPointPath = liveSiteNode.getPath();
            channel.setHstMountPoint(mountPointPath);
            Node mount = this.createMountNode(virtualHost, blueprintNode, channelUri.getPath());
            mount.setProperty("hst:contextpath", channel.getContextPath());
            mount.setProperty("hst:mountpoint", mountPointPath);
            String locale = channel.getLocale();
            if (locale != null) {
                mount.setProperty("hst:locale", locale);
            }
        }
        catch (ChannelException e) {
            if (contentRootNode != null) {
                session.refresh(false);
                contentRootNode.remove();
                session.save();
            }
            throw e;
        }
        return contentRootNode;
    }

    private String reuseOrCopyConfiguration(Session session, Node configRoot, Node blueprintNode, String channelName, Channel channel) throws ChannelException, RepositoryException {
        Node siteNode;
        Node hstConfigurations = configRoot.getNode("hst:configurations");
        if (blueprintNode.hasNode("hst:configuration")) {
            Node workspace;
            Node blueprintConfiguration = blueprintNode.getNode("hst:configuration");
            Node configuration = ChannelManagerImpl.copyNodes(blueprintConfiguration, hstConfigurations, channelName);
            if (!configuration.hasNode("hst:workspace")) {
                configuration.addNode("hst:workspace", "hst:workspace");
            }
            if (configuration.hasNode("hst:channel")) {
                session.move(configuration.getPath() + "/" + "hst:channel", configuration.getPath() + "/" + "hst:workspace" + "/" + "hst:channel");
            }
            if (!(workspace = configuration.getNode("hst:workspace")).hasNode("hst:channel")) {
                workspace.addNode("hst:channel", "hst:channel");
            }
            workspace.getNode("hst:channel").setProperty("hst:name", channel.getName());
            return configuration.getPath();
        }
        if (blueprintNode.hasNode("hst:site") && (siteNode = blueprintNode.getNode("hst:site")).hasProperty("hst:configurationpath")) {
            String configurationPath = siteNode.getProperty("hst:configurationpath").getString();
            if (!session.nodeExists(configurationPath)) {
                throw new ChannelException("Blueprint '" + blueprintNode.getPath() + "' does not have an hst:configuration node, and its hst:site node points to a non-existing node: '" + configurationPath + "'");
            }
            Node configuration = hstConfigurations.addNode(channelName, "hst:configuration");
            Node workspaceNode = configuration.addNode("hst:workspace", "hst:workspace");
            Node inherited = session.getNode(configurationPath);
            Object inheritedChannelNode = inherited.hasNode("hst:channel") ? inherited.getNode("hst:channel") : (inherited.hasNode("hst:workspace/hst:channel") ? inherited.getNode("hst:workspace/hst:channel") : null);
            if (inheritedChannelNode != null) {
                Node channelNode = JcrUtils.copy((Session)session, (String)inheritedChannelNode.getPath(), (String)(workspaceNode.getPath() + "/" + "hst:channel"));
                channelNode.setProperty("hst:name", channel.getName());
            } else {
                Node channelNode = workspaceNode.addNode("hst:channel", "hst:channel");
                channelNode.setProperty("hst:name", channel.getName());
            }
            configuration.setProperty("hst:inheritsfrom", new String[]{"../" + inherited.getName(), "../" + inherited.getName() + "/" + "hst:workspace"});
            return configuration.getPath();
        }
        throw new ChannelException("Blueprint '" + blueprintNode.getPath() + "' does not specify any hst:configuration to use. Either include an hst:configuration node to copy, or include an hst:site node with an existing hst:configurationpath property.");
    }

    private Node createMountNode(Node virtualHost, Node blueprintNode, String mountPath) throws ChannelException, RepositoryException {
        ArrayList<String> mountPathElements = new ArrayList<String>();
        mountPathElements.add("hst:root");
        mountPathElements.addAll(Arrays.asList(StringUtils.split((String)mountPath, (char)'/')));
        Node mount = virtualHost;
        for (int i = 0; i < mountPathElements.size() - 1; ++i) {
            String mountPathElement = (String)mountPathElements.get(i);
            if (!mount.hasNode(mountPathElement)) {
                throw ChannelManagerImpl.mountNotFoundException(mount.getPath() + "/" + mountPathElement);
            }
            mount = mount.getNode(mountPathElement);
        }
        String lastMountPathElementName = (String)mountPathElements.get(mountPathElements.size() - 1);
        if (mount.hasNode(lastMountPathElementName)) {
            throw ChannelManagerImpl.mountExistsException(mount.getPath() + '/' + lastMountPathElementName);
        }
        mount = blueprintNode.hasNode("hst:mount") ? ChannelManagerImpl.copyNodes(blueprintNode.getNode("hst:mount"), mount, lastMountPathElementName) : mount.addNode(lastMountPathElementName, "hst:mount");
        return mount;
    }

    private String getHostGroupNameFromContext() throws ChannelException {
        String hostGroupForCmsHost = (String)RequestContextProvider.get().getAttribute("HOST_GROUP_NAME_FOR_CMS_HOST");
        if (StringUtils.isEmpty((String)hostGroupForCmsHost)) {
            throw new ChannelException("There is no hostgroup for cms host available. Cannot get or create virtual hosts");
        }
        return hostGroupForCmsHost;
    }

    private Node getOrCreateVirtualHost(Node configRoot, String hostName) throws RepositoryException, ChannelException {
        return this.getOrCreateVirtualHost(configRoot, hostName, this.getHostGroupNameFromContext());
    }

    private Node getOrCreateVirtualHost(Node configRoot, String hostName, String hostGroupName) throws RepositoryException, ChannelException {
        String[] elements = InetAddresses.isInetAddress((String)hostName) ? new String[]{hostName} : hostName.split("[.]");
        Node host = configRoot.getNode("hst:hosts/" + hostGroupName);
        for (int i = elements.length - 1; i >= 0; --i) {
            host = ChannelManagerImpl.getOrAddNode(host, elements[i], "hst:virtualhost");
        }
        return host;
    }

    private Node createSiteNode(Node sitesNode, String siteNodeName, String contentRootPath) throws RepositoryException {
        log.debug("Creating site node '{}/{}'; content root='{}'", new Object[]{sitesNode.getPath(), siteNodeName, contentRootPath});
        Node siteNode = sitesNode.addNode(siteNodeName, "hst:site");
        siteNode.setProperty("hst:content", contentRootPath);
        return siteNode;
    }

    private Node createContent(Blueprint blueprint, Session session, String channelId, Channel channel) throws RepositoryException, ChannelException {
        String blueprintContentPath = blueprint.getContentRoot();
        if (blueprintContentPath == null) {
            blueprintContentPath = this.contentRoot;
        }
        log.debug("Creating new subsite content from blueprint '{}' under '{}'", (Object)blueprint.getId(), (Object)blueprintContentPath);
        FolderWorkflow fw = (FolderWorkflow)this.getWorkflow("subsite", session.getNode(blueprintContentPath));
        if (fw == null) {
            throw ChannelManagerImpl.cannotCreateContent(blueprintContentPath, null);
        }
        try {
            String contentRootPath = fw.add("new-subsite", blueprint.getId(), channelId);
            session.refresh(true);
            Node contentRootNode = session.getNode(contentRootPath);
            DefaultWorkflow defaultWorkflow = (DefaultWorkflow)this.getWorkflow("core", contentRootNode);
            defaultWorkflow.setDisplayName(channel.getName());
            session.refresh(true);
            return contentRootNode;
        }
        catch (WorkflowException e) {
            throw ChannelManagerImpl.cannotCreateContent(blueprintContentPath, e);
        }
        catch (RemoteException e) {
            throw ChannelManagerImpl.cannotCreateContent(blueprintContentPath, e);
        }
    }

    private static Node getOrAddNode(Node parent, String nodeName, String nodeType) throws RepositoryException {
        if (parent.hasNode(nodeName)) {
            return parent.getNode(nodeName);
        }
        return parent.addNode(nodeName, nodeType);
    }

    static Node copyNodes(Node source, Node parent, String name) throws RepositoryException {
        Node clone = parent.addNode(name, source.getPrimaryNodeType().getName());
        for (NodeType mixin : source.getMixinNodeTypes()) {
            clone.addMixin(mixin.getName());
        }
        PropertyIterator pi = source.getProperties();
        while (pi.hasNext()) {
            Property prop = pi.nextProperty();
            if (prop.getDefinition().isProtected()) continue;
            if (prop.isMultiple()) {
                clone.setProperty(prop.getName(), prop.getValues());
                continue;
            }
            clone.setProperty(prop.getName(), prop.getValue());
        }
        NodeIterator ni = source.getNodes();
        while (ni.hasNext()) {
            Node node = ni.nextNode();
            if (ChannelManagerImpl.isVirtual(node)) continue;
            ChannelManagerImpl.copyNodes(node, clone, node.getName());
        }
        return clone;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Workflow getWorkflow(String category, Node node) throws RepositoryException {
        Workspace workspace = node.getSession().getWorkspace();
        ClassLoader workspaceClassloader = workspace.getClass().getClassLoader();
        ClassLoader currentClassloader = Thread.currentThread().getContextClassLoader();
        try {
            if (workspaceClassloader != currentClassloader) {
                Thread.currentThread().setContextClassLoader(workspaceClassloader);
            }
            WorkflowManager wfm = ((HippoWorkspace)workspace).getWorkflowManager();
            Workflow workflow = wfm.getWorkflow(category, node);
            return workflow;
        }
        catch (RepositoryException e) {
            throw e;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.warn("Exception in workflow", (Throwable)e);
            } else {
                log.warn("Exception in workflow: {}", (Object)e.toString());
            }
        }
        finally {
            if (workspaceClassloader != currentClassloader) {
                Thread.currentThread().setContextClassLoader(currentClassloader);
            }
        }
        return null;
    }

    private static boolean isVirtual(Node node) throws RepositoryException {
        if (node instanceof HippoNode) {
            HippoNode hn = (HippoNode)node;
            try {
                Node canonicalNode = hn.getCanonicalNode();
                if (canonicalNode == null) {
                    return true;
                }
                if (!canonicalNode.isSame((Item)hn)) {
                    return true;
                }
            }
            catch (ItemNotFoundException infe) {
                return true;
            }
        }
        return false;
    }

    private void updateChannel(Node configRoot, String hostGroupName, Channel channel) throws ChannelException, RepositoryException {
        URI channelUri = this.getChannelUri(channel);
        Node virtualHost = this.getOrCreateVirtualHost(configRoot, channelUri.getHost(), hostGroupName);
        if (!virtualHost.hasNode("hst:root")) {
            throw ChannelManagerImpl.mountNotFoundException(virtualHost.getPath() + "/" + "hst:root");
        }
        Node mount = virtualHost.getNode("hst:root");
        String mountPath = channel.getMountPath();
        if (mountPath != null) {
            for (String mountPathElement : StringUtils.split((String)mountPath, (char)'/')) {
                if (!mount.hasNode(mountPathElement)) {
                    throw ChannelManagerImpl.mountNotFoundException(mount.getPath() + "/" + mountPathElement);
                }
                mount = mount.getNode(mountPathElement);
            }
        }
        ChannelPropertyMapper.saveChannel(configRoot.getSession().getNode(channel.getChannelPath()), channel);
    }

    private URI getChannelUri(Channel channel) throws ChannelException {
        URI uri;
        try {
            uri = new URI(channel.getUrl());
        }
        catch (URISyntaxException e) {
            throw new ChannelException("Invalid channel URL: '" + channel.getUrl() + "'");
        }
        if (!this.isSupportedScheme(uri.getScheme())) {
            throw new ChannelException("Illegal channel URL scheme: '" + uri.getScheme() + "'. Only 'http' and 'https' is currently supported");
        }
        if (StringUtils.isBlank((String)uri.getHost())) {
            throw new ChannelException("Channel URL '" + uri + "' does not contain a host name");
        }
        return uri;
    }

    private boolean isSupportedScheme(String scheme) {
        if (scheme == null) {
            return false;
        }
        return scheme.equals("http") || scheme.equals("https");
    }

    static ChannelException mountNotFoundException(String missingMount) {
        return new ChannelException("Mount not found: " + missingMount, ChannelException.Type.MOUNT_NOT_FOUND, new String[]{missingMount});
    }

    static ChannelException mountExistsException(String existingMount) {
        return new ChannelException("Mount already exists: " + existingMount, ChannelException.Type.MOUNT_EXISTS, new String[]{existingMount});
    }

    static ChannelException cannotCreateContent(String contentRoot, Throwable cause) {
        return new ChannelException("Could not create content at '" + contentRoot + "'", cause, ChannelException.Type.CANNOT_CREATE_CONTENT, new String[]{contentRoot});
    }

    private static VirtualHosts getVirtualHosts() {
        return RequestContextProvider.get().getVirtualHost().getVirtualHosts();
    }

    protected Session getSession() throws RepositoryException {
        return RequestContextProvider.get().getSession();
    }

    private static class ChannelManagerEventImpl
    implements ChannelManagerEvent {
        private Blueprint blueprint;
        private Channel channel;
        private Node configRootNode;

        private ChannelManagerEventImpl(Blueprint blueprint, Channel channel, Node configRootNode) {
            if (channel == null || configRootNode == null) {
                throw new IllegalArgumentException("Channel and configRootNode are not allowed to be null in a channel manager event");
            }
            this.blueprint = blueprint;
            this.channel = channel;
            this.configRootNode = configRootNode;
        }

        public Blueprint getBlueprint() {
            return this.blueprint;
        }

        @Deprecated
        public String getChannelId() {
            return this.channel.getId();
        }

        public Channel getChannel() {
            return this.channel;
        }

        public Node getConfigRootNode() {
            return this.configRootNode;
        }
    }
}

