/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.channel;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;
import javax.jcr.ItemNotFoundException;
import javax.jcr.RepositoryException;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.cache.HstNodeLoadingCache;
import org.hippoecm.hst.configuration.components.HstComponentConfiguration;
import org.hippoecm.hst.configuration.components.HstComponentsConfiguration;
import org.hippoecm.hst.configuration.internal.CanonicalInfo;
import org.hippoecm.hst.configuration.internal.ConfigurationLockInfo;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.model.ModelLoadingException;
import org.hippoecm.hst.configuration.site.HstSite;
import org.hippoecm.hst.configuration.sitemap.HstSiteMapItem;
import org.hippoecm.hst.configuration.sitemenu.HstSiteMenuConfiguration;
import org.hippoecm.repository.api.HippoWorkspace;
import org.onehippo.cms7.services.hst.Channel;
import org.onehippo.repository.security.SecurityService;
import org.onehippo.repository.security.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelLazyLoadingChangedBySet
implements Set<String> {
    private static final Logger log = LoggerFactory.getLogger(ChannelLazyLoadingChangedBySet.class);
    private Set<String> delegatee;
    private transient Set<String> usersWithMainConfigNodeChanges;
    private final transient HstSite previewHstSite;
    private final transient Channel channel;
    private final transient HstNodeLoadingCache hstNodeLoadingCache;

    public ChannelLazyLoadingChangedBySet(HstNode channelRootConfigNode, HstSite previewHstSite, Channel channel, HstNodeLoadingCache hstNodeLoadingCache) {
        for (HstNode mainConfigNode : channelRootConfigNode.getNodes()) {
            String lockedBy;
            if (this.usersWithMainConfigNodeChanges == null) {
                this.usersWithMainConfigNodeChanges = new HashSet<String>();
            }
            if ((lockedBy = mainConfigNode.getValueProvider().getString("hst:lockedby")) == null) continue;
            this.usersWithMainConfigNodeChanges.add(lockedBy);
        }
        this.previewHstSite = previewHstSite;
        this.channel = channel;
        this.hstNodeLoadingCache = hstNodeLoadingCache;
    }

    private synchronized void load() {
        if (this.delegatee != null) {
            return;
        }
        this.delegatee = new HashSet<String>();
        if (this.usersWithMainConfigNodeChanges != null) {
            this.delegatee.addAll(this.usersWithMainConfigNodeChanges);
        }
        this.delegatee.addAll(ChannelLazyLoadingChangedBySet.getAllUsersWithComponentLock(this.previewHstSite));
        this.delegatee.addAll(ChannelLazyLoadingChangedBySet.getAllUsersWithSiteMapItemLock(this.previewHstSite));
        this.delegatee.addAll(ChannelLazyLoadingChangedBySet.getAllUsersWithSiteMenuLock(this.previewHstSite));
        if (this.channel.getChannelNodeLockedBy() != null) {
            this.delegatee.add(this.channel.getChannelNodeLockedBy());
        }
        if (this.hstNodeLoadingCache != null && this.delegatee.size() > 0) {
            try (HstNodeLoadingCache.LazyCloseableSession lazyCloseableSession = this.hstNodeLoadingCache.createLazyCloseableSession();){
                SecurityService securityService = ((HippoWorkspace)lazyCloseableSession.getSession().getWorkspace()).getSecurityService();
                Iterator<String> iterator = this.delegatee.iterator();
                while (iterator.hasNext()) {
                    String userId = iterator.next();
                    try {
                        User user = securityService.getUser(userId);
                        if (!user.isSystemUser()) continue;
                        log.debug("Removing system user with Id '{}' from Changed By Set", (Object)userId);
                        iterator.remove();
                    }
                    catch (ItemNotFoundException e) {
                        log.info("User with userId '{}' does not exist (any more). Do not filter that user Id out because for sure it is not a system user.", (Object)userId);
                    }
                }
            }
            catch (RepositoryException e) {
                throw new ModelLoadingException("Repository exception while getting jcr session", e);
            }
        }
    }

    private static Set<String> getAllUsersWithSiteMapItemLock(HstSite previewHstSite) {
        HashSet<String> usersWithLock = new HashSet<String>();
        for (HstSiteMapItem siteMapItem : previewHstSite.getSiteMap().getSiteMapItems()) {
            ChannelLazyLoadingChangedBySet.addUsersWithSiteMapItemLock(siteMapItem, usersWithLock, previewHstSite.getConfigurationPath());
        }
        return usersWithLock;
    }

    private static void addUsersWithSiteMapItemLock(HstSiteMapItem item, Set<String> usersWithLock, String previewConfigurationPath) {
        boolean inherited;
        boolean bl = inherited = !((CanonicalInfo)item).getCanonicalPath().startsWith(previewConfigurationPath + "/");
        if (inherited) {
            return;
        }
        if (!(item instanceof ConfigurationLockInfo)) {
            return;
        }
        String lockedBy = ((ConfigurationLockInfo)item).getLockedBy();
        if (StringUtils.isNotBlank((String)lockedBy)) {
            usersWithLock.add(lockedBy);
        }
        for (HstSiteMapItem child : item.getChildren()) {
            ChannelLazyLoadingChangedBySet.addUsersWithSiteMapItemLock(child, usersWithLock, previewConfigurationPath);
        }
    }

    private static Set<String> getAllUsersWithComponentLock(HstSite previewHstSite) {
        HashSet<String> usersWithLock = new HashSet<String>();
        HstComponentsConfiguration componentsConfiguration = previewHstSite.getComponentsConfiguration();
        for (HstComponentConfiguration hstComponentConfiguration : componentsConfiguration.getComponentConfigurations().values()) {
            ChannelLazyLoadingChangedBySet.addUsersWithComponentLock(hstComponentConfiguration, usersWithLock);
        }
        return usersWithLock;
    }

    private static void addUsersWithComponentLock(HstComponentConfiguration config, Set<String> usersWithLock) {
        if (config.isInherited()) {
            return;
        }
        if (!(config instanceof ConfigurationLockInfo)) {
            return;
        }
        String lockedBy = ((ConfigurationLockInfo)config).getLockedBy();
        if (StringUtils.isNotBlank((String)lockedBy)) {
            usersWithLock.add(lockedBy);
        }
        for (HstComponentConfiguration hstComponentConfiguration : config.getChildren().values()) {
            ChannelLazyLoadingChangedBySet.addUsersWithComponentLock(hstComponentConfiguration, usersWithLock);
        }
    }

    private static Set<String> getAllUsersWithSiteMenuLock(HstSite previewHstSite) {
        HashSet<String> usersWithLock = new HashSet<String>();
        for (HstSiteMenuConfiguration config : previewHstSite.getSiteMenusConfiguration().getSiteMenuConfigurations().values()) {
            boolean inherited;
            if (!(config instanceof ConfigurationLockInfo)) continue;
            boolean bl = inherited = !((CanonicalInfo)config).getCanonicalPath().startsWith(previewHstSite.getConfigurationPath() + "/");
            if (inherited) continue;
            String lockedBy = ((ConfigurationLockInfo)config).getLockedBy();
            ChannelLazyLoadingChangedBySet.addUserWithSiteMenuLock(lockedBy, usersWithLock);
        }
        return usersWithLock;
    }

    private static void addUserWithSiteMenuLock(String lockedBy, Set<String> usersWithLock) {
        if (StringUtils.isNotBlank((String)lockedBy)) {
            usersWithLock.add(lockedBy);
        }
    }

    @Override
    public int size() {
        this.load();
        return this.delegatee.size();
    }

    @Override
    public boolean isEmpty() {
        this.load();
        return this.delegatee.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        this.load();
        return this.delegatee.contains(o);
    }

    @Override
    public Iterator<String> iterator() {
        this.load();
        return this.delegatee.iterator();
    }

    @Override
    public Object[] toArray() {
        this.load();
        return this.delegatee.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.load();
        return this.delegatee.toArray(a);
    }

    @Override
    public boolean removeIf(Predicate<? super String> filter) {
        throw new UnsupportedOperationException("#removeIf not supported in ChannelLazyLoadingChangedBySet");
    }

    @Override
    public boolean add(String string) {
        throw new UnsupportedOperationException("#add not supported in ChannelLazyLoadingChangedBySet");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("#remove not supported in ChannelLazyLoadingChangedBySet");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends String> c) {
        throw new UnsupportedOperationException("#addAll not supported in ChannelLazyLoadingChangedBySet");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("#retainAll not supported in ChannelLazyLoadingChangedBySet");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("#removeAll not supported in ChannelLazyLoadingChangedBySet");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("#clear not supported in ChannelLazyLoadingChangedBySet");
    }

    @Override
    public int hashCode() {
        this.load();
        return this.delegatee.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        this.load();
        return this.delegatee.equals(obj);
    }

    public String toString() {
        this.load();
        return "[ChannelLazyLoadingChangedBySet: " + this.delegatee.toString() + "]";
    }

    public Object clone() {
        throw new UnsupportedOperationException("#clone not supported in ChannelLazyLoadingChangedBySet");
    }
}

