/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.channel;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.hippoecm.hst.configuration.channel.AnnotationHstPropertyDefinition;
import org.hippoecm.hst.configuration.channel.ChannelInfo;
import org.hippoecm.hst.configuration.channel.HstPropertyDefinition;
import org.hippoecm.hst.core.parameters.Parameter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelInfoClassProcessor {
    private static final Logger log = LoggerFactory.getLogger(ChannelInfoClassProcessor.class);

    public static List<HstPropertyDefinition> getProperties(Class<? extends ChannelInfo> channelInfoClass) {
        ArrayList<HstPropertyDefinition> properties = new ArrayList<HstPropertyDefinition>();
        for (Method method : channelInfoClass.getMethods()) {
            if (!method.isAnnotationPresent(Parameter.class)) continue;
            Parameter propAnnotation = method.getAnnotation(Parameter.class);
            try {
                AnnotationHstPropertyDefinition prop = new AnnotationHstPropertyDefinition(propAnnotation, method.getReturnType(), method.getAnnotations());
                properties.add(prop);
            }
            catch (IllegalArgumentException e) {
                log.warn("Invalid parameterized method '{}' : {}", (Object)method.getName(), (Object)e.toString());
            }
        }
        return properties;
    }
}

