/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.channel;

import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.channel.Blueprint;
import org.hippoecm.hst.configuration.channel.ChannelPropertyMapper;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.model.ModelLoadingException;
import org.onehippo.cms7.services.hst.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlueprintHandler {
    static final Logger log = LoggerFactory.getLogger(BlueprintHandler.class);
    public static final String SUBSITE_TEMPLATES_PATH = "/hippo:configuration/hippo:queries/hippo:templates/new-subsite/hippostd:templates/";

    public static Blueprint buildBlueprint(HstNode blueprintNode, String blueprintContextPath) {
        HstNode channelNode;
        Blueprint blueprint = new Blueprint();
        blueprint.setPath(blueprintNode.getValueProvider().getPath());
        blueprint.setId(blueprintNode.getName());
        if (blueprintNode.getValueProvider().hasProperty("hst:name")) {
            blueprint.setName(blueprintNode.getValueProvider().getString("hst:name"));
        } else {
            blueprint.setName(blueprint.getId());
        }
        if (blueprintNode.getValueProvider().hasProperty("hst:description")) {
            blueprint.setDescription(blueprintNode.getValueProvider().getString("hst:description"));
        }
        if (blueprintNode.getValueProvider().hasProperty("hst:contentRoot")) {
            String location = blueprintNode.getValueProvider().getString("hst:contentRoot").trim();
            if (StringUtils.isEmpty((String)location) || !location.startsWith("/")) {
                log.warn("Skipping invalid '{}' of blueprint '{}' : The value should start with a / ", (Object)"hst:contentRoot", (Object)blueprint.getPath());
            } else {
                log.debug("Setting contentRoot for blueprint '{}' to '{}'", (Object)blueprint.getPath(), (Object)location);
                blueprint.setContentRoot(location);
            }
        }
        if ((channelNode = blueprintNode.getNode("hst:configuration/hst:workspace/hst:channel")) == null) {
            channelNode = blueprintNode.getNode("hst:configuration/hst:channel");
        }
        Channel channel = channelNode != null ? ChannelPropertyMapper.readBlueprintChannel(channelNode) : new Channel();
        channel.setContextPath(blueprintContextPath);
        blueprint.setPrototypeChannel(channel);
        BlueprintHandler.readMount(BlueprintHandler.readSite(blueprintNode, blueprint), blueprintNode, blueprint);
        return blueprint;
    }

    private static boolean readSite(HstNode blueprintNode, Blueprint blueprint) {
        HstNode blueprintSiteNode = blueprintNode.getNode("hst:site");
        if (blueprintSiteNode == null) {
            return false;
        }
        if (blueprintSiteNode.getValueProvider().hasProperty("hst:configurationpath")) {
            blueprint.getPrototypeChannel().setHstConfigPath(blueprintSiteNode.getValueProvider().getString("hst:configurationpath"));
        } else if (blueprintNode.getNode("hst:configuration") == null) {
            throw new ModelLoadingException(String.format("Blueprint %s has neither a hst:configuration node prototype or a fixed hst:configurationpath", blueprint.getId()));
        }
        if (blueprintSiteNode.getValueProvider().hasProperty("hst:content")) {
            String siteContentPath = blueprintSiteNode.getValueProvider().getString("hst:content");
            blueprint.getPrototypeChannel().setContentRoot(siteContentPath);
        }
        return true;
    }

    private static void readMount(boolean hasSite, HstNode blueprintNode, Blueprint blueprint) {
        HstNode blueprintMount = blueprintNode.getNode("hst:mount");
        if (blueprintMount != null) {
            HstNode prototypeMount = blueprintNode.getNode("hst:mount");
            if (prototypeMount.getValueProvider().hasProperty("hst:mountpoint")) {
                String mountPoint = prototypeMount.getValueProvider().getString("hst:mountpoint");
                if (hasSite) {
                    log.warn("Blueprint '{}' will ignore the static mount point '{}' because it also has a site node. Each channel created from this blueprint will therefore get a copy of the site node as its mount point.", (Object)blueprintNode.getValueProvider().getPath(), (Object)mountPoint);
                } else {
                    blueprint.getPrototypeChannel().setHstMountPoint(mountPoint);
                }
            }
            if (prototypeMount.getValueProvider().hasProperty("hst:locale")) {
                blueprint.getPrototypeChannel().setLocale(prototypeMount.getValueProvider().getString("hst:locale"));
            }
        }
    }
}

