/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.channel;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.hippoecm.hst.configuration.channel.AbstractHstPropertyDefinition;
import org.hippoecm.hst.core.parameters.HstValueType;
import org.hippoecm.hst.core.parameters.Parameter;

public class AnnotationHstPropertyDefinition
extends AbstractHstPropertyDefinition {
    private List<Annotation> annotations = new ArrayList<Annotation>();
    private static final List<Class<?>> supportedTypes = Arrays.asList(String.class, Boolean.class, Boolean.TYPE, Long.class, Long.TYPE, Integer.class, Integer.TYPE, Calendar.class, Double.class, Float.class, Double.TYPE, Float.TYPE);

    public AnnotationHstPropertyDefinition(Parameter propAnnotation, Class<?> returnType, Annotation[] annotations) {
        super(propAnnotation.name());
        this.type = AnnotationHstPropertyDefinition.getHstType(returnType);
        this.required = propAnnotation.required();
        this.defaultValue = this.type.from(propAnnotation.defaultValue());
        this.hiddenInChannelManager = propAnnotation.hideInChannelManager();
        for (Annotation annotation : annotations) {
            if (annotation == propAnnotation) continue;
            this.annotations.add(annotation);
        }
    }

    @Override
    public List<Annotation> getAnnotations() {
        return this.annotations;
    }

    private static HstValueType getHstType(Class<?> type) {
        if (type == String.class) {
            return HstValueType.STRING;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return HstValueType.BOOLEAN;
        }
        if (type == Long.class || type == Long.TYPE) {
            return HstValueType.LONG;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return HstValueType.INTEGER;
        }
        if (type == Calendar.class) {
            return HstValueType.DATE;
        }
        if (type == Double.class || type == Float.class || type == Double.TYPE || type == Float.TYPE) {
            return HstValueType.DOUBLE;
        }
        throw new IllegalArgumentException("Unsupported type '" + type + "'. Only supported types are '" + supportedTypes.toString() + "'");
    }
}

