/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.IdentityMap;
import org.hippoecm.hst.configuration.cache.WeakKeyTagRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeakTaggedCache<K, V, U> {
    private static final Logger log = LoggerFactory.getLogger(WeakTaggedCache.class);
    Map<K, WeakReference<V>> keyValueMap = new HashMap<K, WeakReference<V>>();
    Map<WeakReference<V>, K> valueKeyMap = new IdentityMap();
    private ReferenceQueue<V> cleanupQueue = new ReferenceQueue();
    WeakKeyTagRegistry<U, K> weakKeyTagRegistry = new WeakKeyTagRegistry();

    public void evictKeysByTag(U tag) {
        try {
            List<K> evictKeys = this.weakKeyTagRegistry.get(tag);
            for (K evictKey : evictKeys) {
                V remove = this.remove(evictKey);
                if (remove == null) continue;
                log.debug("Succesfully removed '{}' from cache BY tag '{}'", remove, tag);
            }
        }
        catch (Exception e) {
            log.warn("Exception during processing tag '" + tag.toString() + "'. Skip tag.", (Throwable)e);
        }
    }

    public void put(K key, V value, U tag) {
        this.expungeStaleEntries();
        this.store(key, value);
        this.weakKeyTagRegistry.put(tag, key);
    }

    public void put(K key, V value, U[] tags) {
        this.expungeStaleEntries();
        this.store(key, value);
        this.weakKeyTagRegistry.put(tags, key);
    }

    public V get(K key) {
        this.expungeStaleEntries();
        WeakReference<V> weakRef = this.keyValueMap.get(key);
        if (weakRef == null) {
            return null;
        }
        return (V)weakRef.get();
    }

    public V remove(K key) {
        this.expungeStaleEntries();
        WeakReference<V> weakRef = this.keyValueMap.remove(key);
        if (weakRef == null) {
            return null;
        }
        this.valueKeyMap.remove(weakRef);
        return (V)weakRef.get();
    }

    private void store(K key, V value) {
        WeakReference<V> weakCachedObj = new WeakReference<V>(value, this.cleanupQueue);
        this.keyValueMap.put(key, weakCachedObj);
        this.valueKeyMap.put((WeakReference<K>)weakCachedObj, (WeakReference<V>)key);
    }

    private void expungeStaleEntries() {
        Reference<V> cleaned;
        while ((cleaned = this.cleanupQueue.poll()) != null) {
            K weakRefMapKey = this.valueKeyMap.remove(cleaned);
            if (weakRefMapKey == null) continue;
            this.keyValueMap.remove(weakRefMapKey);
        }
    }
}

