/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.cache;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.map.IdentityMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeakKeyTagRegistry<U, K> {
    private static final Logger log = LoggerFactory.getLogger(WeakKeyTagRegistry.class);
    final Map<U, List<WeakReference<K>>> tagKeysMap = new HashMap<U, List<WeakReference<K>>>();
    final Map<WeakReference<K>, List<U>> keyTagsMap = new IdentityMap();
    private final ReferenceQueue<K> cleanupQueue = new ReferenceQueue();

    public void put(U tag, K key) {
        this.put(new Object[]{tag}, key);
    }

    public void put(U[] tags, K key) {
        this.expungeStaleEntries();
        WeakReference<K> weakCacheKey = new WeakReference<K>(key, this.cleanupQueue);
        for (U tag : tags) {
            log.debug("Register tag '{}' to key '{}'", tag, key);
            List<WeakReference<K>> cacheKeys = this.tagKeysMap.get(tag);
            if (cacheKeys == null) {
                cacheKeys = new ArrayList<WeakReference<K>>();
                cacheKeys.add(weakCacheKey);
                this.tagKeysMap.put(tag, cacheKeys);
                continue;
            }
            cacheKeys.add(weakCacheKey);
        }
        this.keyTagsMap.put(weakCacheKey, Arrays.asList(tags));
    }

    public List<K> get(U tag) {
        this.expungeStaleEntries();
        List<WeakReference<K>> weakReferences = this.tagKeysMap.get(tag);
        if (weakReferences == null) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList(weakReferences.size());
        for (WeakReference<K> weakReference : weakReferences) {
            Object v = weakReference.get();
            if (v == null) continue;
            result.add(v);
        }
        return result;
    }

    private void expungeStaleEntries() {
        Reference<K> garbaged;
        while ((garbaged = this.cleanupQueue.poll()) != null) {
            List<U> tags = this.keyTagsMap.remove(garbaged);
            if (tags == null) continue;
            for (U tag : tags) {
                List<WeakReference<K>> list = this.tagKeysMap.get(tag);
                if (list == null) continue;
                list.remove(garbaged);
                if (!list.isEmpty()) continue;
                this.tagKeysMap.remove(tag);
            }
        }
    }
}

