/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.cache;

import java.util.HashSet;
import java.util.Set;
import javax.jcr.Credentials;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.cache.HstEvent;
import org.hippoecm.hst.configuration.cache.HstEventConsumer;
import org.hippoecm.hst.configuration.cache.HstNodeImpl;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.model.ModelLoadingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstNodeLoadingCache
implements HstEventConsumer {
    private static final Logger log = LoggerFactory.getLogger(HstNodeLoadingCache.class);
    private String rootPath;
    private int rootPathLength;
    private HstNode rootNode;
    private Repository repository;
    private Credentials credentials;
    private Set<HstEvent> events;

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
        this.rootPathLength = rootPath.length();
    }

    @Override
    public void handleEvents(Set<HstEvent> events) {
        if (this.events != null) {
            this.events.addAll(events);
        } else {
            this.events = new HashSet<HstEvent>(events);
        }
    }

    public String getRootPath() {
        return this.rootPath;
    }

    public HstNode getNode(String absPath) {
        long getNodeStartTime = System.currentTimeMillis();
        if (!absPath.startsWith(this.rootPath)) {
            throw new IllegalArgumentException("Path for getting node from hst node cache must start with rootPath '" + this.rootPath + "' but was '" + absPath + "'.");
        }
        try (LazyCloseableSession lazyCloseableSession = this.createLazyCloseableSession();){
            if (this.rootNode == null) {
                this.rootNode = new HstNodeImpl(lazyCloseableSession.getSession().getNode(this.rootPath), null);
                this.events = null;
            } else if (this.events != null) {
                long start = System.currentTimeMillis();
                for (HstEvent event : this.events) {
                    HstNode nodeForEvent = this.fetchHstNode(event.getNodePath());
                    if (nodeForEvent == this.rootNode && !lazyCloseableSession.getSession().nodeExists(this.rootPath)) {
                        this.rootNode = null;
                        throw new ModelLoadingException("Cannot load hst model since root config node '" + this.rootPath + "' missing");
                    }
                    if (event.isPropertyEvent() && nodeForEvent != null) {
                        nodeForEvent.markStaleByPropertyEvent();
                        continue;
                    }
                    if (nodeForEvent != null) {
                        nodeForEvent.markStaleByNodeEvent();
                        continue;
                    }
                    HstNode ancestorNodeForEvent = this.getFirstNonNullAncestor(event.getNodePath());
                    ancestorNodeForEvent.markStaleByNodeEvent();
                }
                log.info("Processing '{}' events took '{}' ms.", (Object)this.events.size(), (Object)(System.currentTimeMillis() - start));
                this.events = null;
                start = System.currentTimeMillis();
                this.rootNode.update(lazyCloseableSession.getSession());
                log.info("Updating root HstNode took '{}' ms.", (Object)(System.currentTimeMillis() - start));
            }
        }
        catch (RepositoryException e) {
            throw new ModelLoadingException("Could not load hst node model due to RepositoryException : ", e);
        }
        HstNode result = absPath.equals(this.rootPath) ? this.rootNode : this.rootNode.getNode(absPath.substring(this.rootPathLength + 1));
        log.info("Getting HstNode '{}' took '{}' ms.", (Object)absPath, (Object)(System.currentTimeMillis() - getNodeStartTime));
        return result;
    }

    private HstNode fetchHstNode(String absPath) {
        if (!absPath.startsWith(this.rootPath)) {
            throw new IllegalArgumentException("Invalid absPath because does not start with '" + this.rootPath + "'");
        }
        if (absPath.equals(this.rootPath)) {
            return this.rootNode;
        }
        return this.rootNode.getNode(absPath.substring(this.rootPathLength + 1));
    }

    private HstNode getFirstNonNullAncestor(String absPath) {
        if (!absPath.startsWith(this.rootPath)) {
            throw new IllegalArgumentException("Invalid absPath because does not start with '" + this.rootPath + "'");
        }
        if (absPath.equals(this.rootPath)) {
            return this.rootNode;
        }
        String absParentPath = StringUtils.substringBeforeLast((String)absPath, (String)"/");
        if (absParentPath.equals(this.rootPath)) {
            return this.rootNode;
        }
        HstNode node = this.rootNode.getNode(absParentPath.substring(this.rootPathLength + 1));
        if (node != null) {
            return node;
        }
        return this.getFirstNonNullAncestor(absParentPath);
    }

    public LazyCloseableSession createLazyCloseableSession() {
        return new LazyCloseableSession();
    }

    public class LazyCloseableSession
    implements AutoCloseable {
        Session session;

        public Session getSession() {
            if (this.session != null) {
                return this.session;
            }
            try {
                this.session = HstNodeLoadingCache.this.repository.login(HstNodeLoadingCache.this.credentials);
            }
            catch (RepositoryException e) {
                throw new ModelLoadingException("Repository exception while getting jcr session", e);
            }
            return this.session;
        }

        @Override
        public void close() throws RepositoryException {
            if (this.session != null) {
                this.session.logout();
            }
        }
    }
}

