/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.cache;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.model.ModelLoadingException;
import org.hippoecm.hst.core.internal.StringPool;
import org.hippoecm.hst.provider.ValueProvider;
import org.hippoecm.hst.provider.jcr.JCRValueProvider;
import org.hippoecm.hst.provider.jcr.JCRValueProviderImpl;
import org.hippoecm.repository.util.JcrUtils;
import org.hippoecm.repository.util.NodeIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstNodeImpl
implements HstNode {
    private static final Logger log = LoggerFactory.getLogger(HstNodeImpl.class);
    private HstNode parent;
    private JCRValueProvider provider;
    private LinkedHashMap<String, HstNode> children = null;
    private String nodeTypeName;
    private boolean stale = false;
    private boolean staleChildren = false;

    public HstNodeImpl(Node jcrNode, HstNode parent) throws RepositoryException {
        this.parent = parent;
        this.provider = new JCRValueProviderImpl(jcrNode, false, true, false);
        this.nodeTypeName = StringPool.get((String)jcrNode.getPrimaryNodeType().getName());
        this.loadChildren(jcrNode);
        this.stale = false;
        this.provider.detach();
    }

    protected void loadChildren(Node jcrNode) throws RepositoryException {
        NodeIterator nodes = jcrNode.getNodes();
        long iteratorSizeBeforeLoop = nodes.getSize();
        while (nodes.hasNext()) {
            HstNodeImpl existing;
            Node child = nodes.nextNode();
            if (this.skipNode(child)) continue;
            HstNodeImpl childRepositoryNode = new HstNodeImpl(child, this);
            if (this.children == null) {
                this.children = new LinkedHashMap((int)iteratorSizeBeforeLoop * 4 / 3);
            }
            if ((existing = (HstNodeImpl)this.children.get(childRepositoryNode.getName())) != null) {
                log.warn("Ignoring node configuration at '{}' for '{}' because it is duplicate. This is not allowed", (Object)this.provider.getPath(), (Object)childRepositoryNode.getValueProvider().getPath());
                continue;
            }
            this.children.put(childRepositoryNode.getName(), childRepositoryNode);
        }
        long iteratorSizeAfterLoop = nodes.getSize();
        if (iteratorSizeBeforeLoop != iteratorSizeAfterLoop) {
            throw new ModelLoadingException("During building the in memory HST model, the hst configuration jcr nodes have changed.");
        }
    }

    private boolean skipNode(Node child) throws RepositoryException {
        if ("hst:upstream".equals(child.getName())) {
            log.debug("Skip hst:upstream node (and descendants)");
            return true;
        }
        return false;
    }

    public String getName() {
        return this.provider.getName();
    }

    public ValueProvider getValueProvider() {
        return this.provider;
    }

    public Map<String, HstNode> getChildren() {
        if (this.children == null) {
            return Collections.emptyMap();
        }
        return this.children;
    }

    public HstNode getNode(String relPath) throws IllegalArgumentException {
        if (relPath == null || "".equals(relPath) || relPath.startsWith("/")) {
            throw new IllegalArgumentException("Not a valid relPath '" + relPath + "'");
        }
        if (this.children == null) {
            return null;
        }
        relPath = StringUtils.stripEnd((String)relPath, (String)"/");
        String[] args = relPath.split("/");
        HstNode child = this.children.get(args[0]);
        for (int i = 1; i < args.length && child != null; ++i) {
            if (((HstNodeImpl)child).children == null) {
                child = null;
                break;
            }
            child = ((HstNodeImpl)child).children.get(args[i]);
        }
        if (child == null) {
            log.debug("Node at relPath '{}' cannot be found for ConfigNode '{}'", (Object)relPath, (Object)this.provider.getPath());
        }
        return child;
    }

    public void addNode(String name, HstNode hstNode) {
        if (this.children == null) {
            this.children = new LinkedHashMap();
        }
        this.children.put(name, hstNode);
    }

    public void removeNode(String name) {
        if (this.children == null) {
            return;
        }
        HstNode removed = (HstNode)this.children.remove(name);
        if (removed == null) {
            log.debug("Could not remove child '{}' from {} because does not exist.", (Object)name, (Object)this);
        }
    }

    public List<HstNode> getNodes() {
        if (this.children == null) {
            return Collections.emptyList();
        }
        return new ArrayList<HstNode>(this.children.values());
    }

    public List<HstNode> getNodes(String configNodeTypeName) {
        if (configNodeTypeName == null) {
            throw new IllegalArgumentException("configNodeTypeName is not allowed to be null");
        }
        if (this.children == null) {
            return Collections.emptyList();
        }
        ArrayList<HstNode> childrenOfType = new ArrayList<HstNode>();
        for (HstNode child : this.children.values()) {
            if (!configNodeTypeName.equals(child.getNodeTypeName())) continue;
            childrenOfType.add(child);
        }
        return childrenOfType;
    }

    public String getNodeTypeName() {
        return this.nodeTypeName;
    }

    public HstNode getParent() {
        return this.parent;
    }

    @Deprecated
    public void markStale() {
        this.stale = true;
    }

    public void markStaleByPropertyEvent() {
        this.stale = true;
    }

    public void markStaleByNodeEvent() {
        this.stale = true;
        this.staleChildren = true;
    }

    public boolean isStale() {
        return this.stale;
    }

    public void update(Session session) throws RepositoryException {
        if (!this.stale) {
            if (this.children == null) {
                return;
            }
            this.updateChildren(session);
            return;
        }
        log.debug("Reload provider for : " + this.getValueProvider().getPath());
        Node jcrNode = JcrUtils.getNodeIfExists((String)this.getValueProvider().getPath(), (Session)session);
        if (jcrNode == null) {
            if (this.parent != null) {
                log.debug("Removing path '{}' from HstNode tree.", (Object)this.getValueProvider().getPath());
                this.parent.removeNode(this.getName());
            }
            return;
        }
        this.setJCRValueProvider((JCRValueProvider)new JCRValueProviderImpl(jcrNode, false, true, false));
        this.nodeTypeName = StringPool.get((String)jcrNode.getPrimaryNodeType().getName());
        if (this.staleChildren) {
            log.debug("Children reload for '{}'", (Object)this.getValueProvider().getPath());
            this.childrenReload(jcrNode);
        } else if (this.children != null) {
            this.updateChildren(session);
        }
        this.stale = false;
        this.staleChildren = false;
    }

    private void updateChildren(Session session) throws RepositoryException {
        HstNode[] arr;
        for (HstNode child : arr = this.children.values().toArray(new HstNode[this.children.size()])) {
            child.update(session);
        }
    }

    private void childrenReload(Node jcrNode) throws RepositoryException {
        LinkedHashMap<String, HstNode> newChildren = new LinkedHashMap<String, HstNode>();
        for (Node jcrChildNode : new NodeIterable(jcrNode.getNodes())) {
            if (this.skipNode(jcrChildNode)) continue;
            String childName = jcrChildNode.getName();
            HstNode existing = this.getChild(childName);
            if (existing == null) {
                newChildren.put(childName, new HstNodeImpl(jcrChildNode, this));
                continue;
            }
            newChildren.put(childName, existing);
            existing.update(jcrNode.getSession());
        }
        this.children = newChildren.isEmpty() ? null : newChildren;
    }

    private HstNode getChild(String name) {
        if (this.children == null) {
            return null;
        }
        return this.children.get(name);
    }

    public void setJCRValueProvider(JCRValueProvider valueProvider) {
        this.provider = valueProvider;
        this.provider.detach();
        this.stale = false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[path=" + this.getValueProvider().getPath() + ", nodeTypeName=" + this.nodeTypeName + "]";
    }
}

