/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.cache;

import java.util.List;
import java.util.Set;
import org.hippoecm.hst.configuration.cache.HstEvent;
import org.hippoecm.hst.configuration.cache.HstEventConsumer;
import org.hippoecm.hst.configuration.cache.HstEventsCollector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstEventsDispatcher {
    private static final Logger log = LoggerFactory.getLogger(HstEventsDispatcher.class);
    private HstEventsCollector hstEventsCollector;
    private List<HstEventConsumer> hstEventConsumers;

    public void setHstEventConsumers(List<HstEventConsumer> hstEventConsumers) {
        this.hstEventConsumers = hstEventConsumers;
    }

    public void setHstEventsCollector(HstEventsCollector hstEventsCollector) {
        this.hstEventsCollector = hstEventsCollector;
    }

    HstEventsCollector getHstEventsCollector() {
        return this.hstEventsCollector;
    }

    public void dispatchHstEvents() {
        long start = System.currentTimeMillis();
        Set<HstEvent> events = this.hstEventsCollector.getAndClearEvents();
        for (HstEventConsumer consumer : this.hstEventConsumers) {
            consumer.handleEvents(events);
        }
        log.info("Dispatching '{}' events took '{}' ms.", (Object)events.size(), (Object)(System.currentTimeMillis() - start));
    }
}

