/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.cache;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.cache.HstEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstEventsCollector {
    private static final Logger log = LoggerFactory.getLogger(HstEventsCollector.class);
    private String rootPath;
    private Set<HstEvent> hstEvents = new HashSet<HstEvent>();

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public synchronized boolean hasEvents() {
        return !this.hstEvents.isEmpty();
    }

    public synchronized void collect(EventIterator events) {
        HashMap<String, Set<Integer>> movedNodeDetectionMap = new HashMap<String, Set<Integer>>();
        while (events.hasNext()) {
            try {
                this.addEvent(events.nextEvent(), movedNodeDetectionMap);
            }
            catch (RepositoryException e) {
                log.error("Exception while getting jcr event");
            }
        }
        for (String movedNodePath : movedNodeDetectionMap.keySet()) {
            if (((Set)movedNodeDetectionMap.get(movedNodePath)).size() != 2) continue;
            this.hstEvents.add(new HstEvent(StringUtils.substringBeforeLast((String)movedNodePath, (String)"/"), false));
        }
    }

    public synchronized void collect(String ... absEventPaths) {
        if (absEventPaths == null) {
            return;
        }
        for (String eventPath : absEventPaths) {
            this.addEvent(eventPath);
        }
    }

    public synchronized void clear() {
        this.hstEvents.clear();
    }

    public synchronized Set<HstEvent> getAndClearEvents() {
        if (this.hstEvents.isEmpty()) {
            return Collections.emptySet();
        }
        Set<HstEvent> events = Collections.unmodifiableSet(this.hstEvents);
        this.hstEvents = new HashSet<HstEvent>();
        return events;
    }

    synchronized Set<HstEvent> getHstEvents() {
        return Collections.unmodifiableSet(this.hstEvents);
    }

    private void addEvent(Event jcrEvent, Map<String, Set<Integer>> movedNodeDetectionMap) throws RepositoryException {
        HstEvent event;
        if ("hippo:ignorable".equals(jcrEvent.getUserData())) {
            log.debug("Ignore event '{}' because marked {}", (Object)jcrEvent.getPath(), (Object)"hippo:ignorable");
            return;
        }
        if (this.ignore(jcrEvent)) {
            log.debug("Ignore event '{}' because not an event below /hst:hst.", (Object)jcrEvent.getPath());
            return;
        }
        String path = jcrEvent.getPath();
        if (this.isPropertyEvent(jcrEvent)) {
            event = new HstEvent(StringUtils.substringBeforeLast((String)path, (String)"/"), true);
        } else {
            int type = jcrEvent.getType();
            if (type == 2 || type == 1) {
                if (!movedNodeDetectionMap.containsKey(path)) {
                    movedNodeDetectionMap.put(path, new HashSet());
                }
                movedNodeDetectionMap.get(path).add(type);
            }
            event = new HstEvent(path, false);
        }
        this.hstEvents.add(event);
        log.debug("Collected event {}", (Object)event);
    }

    private void addEvent(String nodePath) {
        if (this.ignore(nodePath)) {
            log.debug("Ignore event '{}'", (Object)nodePath);
            return;
        }
        this.hstEvents.add(new HstEvent(nodePath, false));
    }

    private boolean ignore(Event jcrEvent) throws RepositoryException {
        return this.ignore(jcrEvent.getPath());
    }

    private boolean ignore(String eventPath) {
        if (eventPath.contains("/hst:upstream/") || eventPath.endsWith("/hst:upstream")) {
            return true;
        }
        return !eventPath.startsWith(this.rootPath) || eventPath.equals(this.rootPath);
    }

    private boolean isPropertyEvent(Event jcrEvent) {
        return jcrEvent.getType() == 4 || jcrEvent.getType() == 16 || jcrEvent.getType() == 8;
    }
}

