/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.cache;

public class HstEvent {
    private final String nodePath;
    private final boolean propertyEvent;

    public HstEvent(String nodePath, boolean propertyEvent) {
        if (nodePath == null) {
            throw new IllegalArgumentException("nodePath is not allowed to be null");
        }
        this.nodePath = nodePath;
        this.propertyEvent = propertyEvent;
    }

    public String getNodePath() {
        return this.nodePath;
    }

    public boolean isPropertyEvent() {
        return this.propertyEvent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HstEvent hstEvent = (HstEvent)o;
        if (this.propertyEvent != hstEvent.propertyEvent) {
            return false;
        }
        return this.nodePath.equals(hstEvent.nodePath);
    }

    public int hashCode() {
        int result = this.nodePath.hashCode();
        result = 31 * result + (this.propertyEvent ? 1 : 0);
        return result;
    }

    public String toString() {
        return "HstEvent{nodePath='" + this.nodePath + '\'' + ", propertyEvent=" + this.propertyEvent + '}';
    }
}

