/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.cache;

import com.google.common.base.Optional;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.hippoecm.hst.configuration.cache.CompositeConfigurationNodes;
import org.hippoecm.hst.configuration.cache.HstEvent;
import org.hippoecm.hst.configuration.cache.HstEventConsumer;
import org.hippoecm.hst.configuration.cache.HstNodeLoadingCache;
import org.hippoecm.hst.configuration.cache.WeakTaggedCache;
import org.hippoecm.hst.configuration.channel.ChannelPropertyMapper;
import org.hippoecm.hst.configuration.components.HstComponentConfiguration;
import org.hippoecm.hst.configuration.components.HstComponentConfigurationService;
import org.hippoecm.hst.configuration.components.HstComponentsConfiguration;
import org.hippoecm.hst.configuration.components.HstComponentsConfigurationService;
import org.hippoecm.hst.configuration.model.HstNode;
import org.hippoecm.hst.configuration.model.ModelLoadingException;
import org.hippoecm.hst.configuration.sitemapitemhandler.HstSiteMapItemHandlersConfigurationService;
import org.hippoecm.hst.configuration.sitemapitemhandlers.HstSiteMapItemHandlersConfiguration;
import org.onehippo.cms7.services.hst.Channel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstConfigurationLoadingCache
implements HstEventConsumer {
    private static final Logger log = LoggerFactory.getLogger(HstConfigurationLoadingCache.class);
    private WeakTaggedCache<List<UUID>, Channel, String> liveChannelsCache = new WeakTaggedCache();
    private WeakTaggedCache<List<UUID>, Channel, String> previewChannelsCache = new WeakTaggedCache();
    private WeakTaggedCache<List<UUID>, HstComponentsConfiguration, String> componentsConfigurationCache = new WeakTaggedCache();
    private WeakTaggedCache<List<UUID>, HstSiteMapItemHandlersConfiguration, String> siteMapItemHandlerConfigurationCache = new WeakTaggedCache();
    private HstNodeLoadingCache hstNodeLoadingCache;
    private String rootConfigurationsPrefix;
    private String commonCatalogPath;
    private Optional<List<HstComponentConfiguration>> commonCatalogItems = null;

    public void setHstNodeLoadingCache(HstNodeLoadingCache hstNodeLoadingCache) {
        this.hstNodeLoadingCache = hstNodeLoadingCache;
    }

    public void setRootConfigurationsPrefix(String rootConfigurationsPrefix) {
        this.rootConfigurationsPrefix = rootConfigurationsPrefix;
        this.commonCatalogPath = rootConfigurationsPrefix + "hst:catalog";
    }

    @Override
    public void handleEvents(Set<HstEvent> events) {
        if (events == null || events.isEmpty()) {
            return;
        }
        HashSet<String> eventPaths = new HashSet<String>();
        for (HstEvent event : events) {
            try {
                log.debug("Processing event {}", (Object)event);
                String eventPath = this.getMainConfigOrRootConfigNodePath(event);
                if (eventPath == null) continue;
                if (eventPath.startsWith(this.commonCatalogPath)) {
                    this.commonCatalogItems = null;
                }
                eventPaths.add(eventPath);
            }
            catch (Exception e) {
                log.warn("Exception during processing event '" + event.toString() + "'. Skip event.", (Throwable)e);
            }
        }
        for (String eventPath : eventPaths) {
            this.liveChannelsCache.evictKeysByTag(eventPath);
            this.previewChannelsCache.evictKeysByTag(eventPath);
            this.componentsConfigurationCache.evictKeysByTag(eventPath);
            this.siteMapItemHandlerConfigurationCache.evictKeysByTag(eventPath);
        }
    }

    String getMainConfigOrRootConfigNodePath(HstEvent event) throws IllegalArgumentException {
        if (!this.isHstConfigurationsEvent(event)) {
            return null;
        }
        String eventPath = event.getNodePath();
        String pathFromMainConfig = eventPath.substring(this.rootConfigurationsPrefix.length());
        if (pathFromMainConfig.isEmpty()) {
            return null;
        }
        String[] elems = pathFromMainConfig.split("/");
        if (elems.length == 1) {
            return this.rootConfigurationsPrefix + elems[0];
        }
        if (elems.length > 2 && elems[1].equals("hst:workspace")) {
            return this.rootConfigurationsPrefix + elems[0] + "/" + elems[1] + "/" + elems[2];
        }
        return this.rootConfigurationsPrefix + elems[0] + "/" + elems[1];
    }

    private boolean isHstConfigurationsEvent(HstEvent event) {
        return event.getNodePath().startsWith(this.rootConfigurationsPrefix);
    }

    public Channel loadChannel(String configurationPath, boolean isPreviewSite, String mountIdentifier, String contextPath) {
        CompositeConfigurationNodes ccn = this.getCompositeConfigurationNodes(configurationPath, "hst:channel");
        List<UUID> cachekey = ccn.getCacheKey();
        cachekey.add(UUID.fromString(mountIdentifier));
        HstNode rootConfigNode = this.hstNodeLoadingCache.getNode(configurationPath);
        cachekey.add(UUID.fromString(rootConfigNode.getValueProvider().getIdentifier()));
        WeakTaggedCache<List<UUID>, Channel, String> channelsCache = isPreviewSite ? this.previewChannelsCache : this.liveChannelsCache;
        Channel channel = channelsCache.get(cachekey);
        if (channel != null) {
            return this.clone(channel);
        }
        CompositeConfigurationNodes.CompositeConfigurationNode channelCompositeNode = ccn.getCompositeConfigurationNodes().get("hst:channel");
        if (channelCompositeNode == null) {
            log.debug("No channel node present for '{}'. Return null", (Object)configurationPath);
            return null;
        }
        HstNode channelNode = channelCompositeNode.getMainConfigNode();
        if (channelNode == null) {
            log.debug("No channel node present for '{}'. Return null", (Object)configurationPath);
            return null;
        }
        channel = ChannelPropertyMapper.readChannel(channelNode, rootConfigNode, contextPath);
        channel.setChannelPath(channelNode.getValueProvider().getPath());
        List<String> events = ccn.getCompositeConfigurationDependencyPaths();
        if (isPreviewSite && !configurationPath.endsWith("-preview")) {
            events.add(configurationPath + "-preview");
            events.add(configurationPath + "-preview/hst:channel");
            events.add(configurationPath + "-preview/hst:workspace/hst:channel");
        }
        channelsCache.put(cachekey, channel, (String[])events.toArray(new String[events.size()]));
        return this.clone(channel);
    }

    private Channel clone(Channel channel) {
        return new Channel(channel);
    }

    public HstComponentsConfiguration getComponentsConfiguration(String configurationPath, boolean createIfNotInCache) throws ModelLoadingException {
        CompositeConfigurationNodes ccn = this.getCompositeConfigurationNodes(configurationPath, "hst:abstractpages", "hst:pages", "hst:prototypepages", "hst:components", "hst:templates", "hst:workspace/hst:containers", "hst:catalog");
        List<UUID> cachekey = ccn.getCacheKey();
        HstComponentsConfiguration hstComponentsConfiguration = this.componentsConfigurationCache.get(cachekey);
        if (hstComponentsConfiguration != null) {
            log.debug("Return cached HstComponentsConfiguration because exact same configuration. We do not build HstComponentsConfiguration for '{}' but use existing version.", (Object)ccn.getConfigurationRootNode().getValueProvider().getPath());
            return hstComponentsConfiguration;
        }
        if (!createIfNotInCache) {
            return null;
        }
        if (this.commonCatalogItems == null) {
            HstNode commonCatalogNode = this.hstNodeLoadingCache.getNode(this.commonCatalogPath);
            this.commonCatalogItems = commonCatalogNode == null ? Optional.absent() : Optional.of(this.getCommonCatalog(commonCatalogNode));
        }
        hstComponentsConfiguration = new HstComponentsConfigurationService(ccn, (List)this.commonCatalogItems.orNull());
        List<String> events = ccn.getCompositeConfigurationDependencyPaths();
        events.add(this.commonCatalogPath);
        this.componentsConfigurationCache.put(cachekey, hstComponentsConfiguration, (String[])events.toArray(new String[events.size()]));
        return hstComponentsConfiguration;
    }

    public HstSiteMapItemHandlersConfiguration getSiteMapItemHandlersConfiguration(String configurationPath, boolean createIfNotInCache) throws ModelLoadingException {
        CompositeConfigurationNodes ccn = this.getCompositeConfigurationNodes(configurationPath, "hst:sitemapitemhandlers");
        CompositeConfigurationNodes.CompositeConfigurationNode compositeSiteMapItemHandlersNode = ccn.getCompositeConfigurationNodes().get("hst:sitemapitemhandlers");
        if (compositeSiteMapItemHandlersNode == null) {
            return HstSiteMapItemHandlersConfiguration.NOOP;
        }
        List<UUID> cachekey = ccn.getCacheKey();
        HstSiteMapItemHandlersConfiguration siteMapItemHandlerConfiguration = this.siteMapItemHandlerConfigurationCache.get(cachekey);
        if (siteMapItemHandlerConfiguration != null) {
            log.debug("Return cached HstSiteMapItemHandlersConfigurationService because exact same configuration. We do not (re)build HstSiteMapItemHandlersConfigurationService for '{}' but use existing version.", (Object)ccn.getConfigurationRootNode().getValueProvider().getPath());
            return siteMapItemHandlerConfiguration;
        }
        if (!createIfNotInCache) {
            return null;
        }
        siteMapItemHandlerConfiguration = new HstSiteMapItemHandlersConfigurationService(compositeSiteMapItemHandlersNode);
        List<String> events = ccn.getCompositeConfigurationDependencyPaths();
        this.siteMapItemHandlerConfigurationCache.put(cachekey, siteMapItemHandlerConfiguration, (String[])events.toArray(new String[events.size()]));
        return siteMapItemHandlerConfiguration;
    }

    public CompositeConfigurationNodes getCompositeConfigurationNodes(String configurationPath, String ... relPaths) {
        HstNode rootConfigNode = this.hstNodeLoadingCache.getNode(configurationPath);
        if (rootConfigNode == null) {
            throw new ModelLoadingException("No configuration node found at '" + configurationPath + "'. Cannot load model for it.");
        }
        if (!"hst:configuration".equals(rootConfigNode.getNodeTypeName())) {
            throw new ModelLoadingException("Configuration node for '" + configurationPath + "' must be of type '" + "hst:configuration" + "'");
        }
        return new CompositeConfigurationNodes(rootConfigNode, relPaths);
    }

    private List<HstComponentConfiguration> getCommonCatalog(HstNode commonCatalog) {
        ArrayList<HstComponentConfiguration> commonCatalogItemsList = new ArrayList<HstComponentConfiguration>();
        for (HstNode itemPackage : commonCatalog.getNodes()) {
            if ("hst:containeritempackage".equals(itemPackage.getNodeTypeName())) {
                for (HstNode containerItem : itemPackage.getNodes()) {
                    if ("hst:containeritemcomponent".equals(containerItem.getNodeTypeName())) {
                        try {
                            HstComponentConfigurationService componentConfiguration = new HstComponentConfigurationService(containerItem, null, "hst:components", true, null, this.commonCatalogPath, null);
                            commonCatalogItemsList.add(componentConfiguration);
                            log.debug("Added catalog component to availableContainerItems with key '{}'", (Object)componentConfiguration.getId());
                        }
                        catch (ModelLoadingException e) {
                            if (log.isDebugEnabled()) {
                                log.warn("Skipping catalog component '" + containerItem.getValueProvider().getPath() + "'", (Throwable)e);
                                continue;
                            }
                            if (!log.isWarnEnabled()) continue;
                            log.warn("Skipping catalog component '{}' : '{}'", (Object)containerItem.getValueProvider().getPath(), (Object)e.toString());
                        }
                        continue;
                    }
                    log.warn("Skipping catalog component '{}' because is not of type '{}'", (Object)containerItem.getValueProvider().getPath(), (Object)"hst:component");
                }
                continue;
            }
            log.warn("Skipping node '{}' because is not of type '{}'", (Object)itemPackage.getValueProvider().getPath(), (Object)"hst:containeritempackage");
        }
        return commonCatalogItemsList;
    }
}

