/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.configuration.cache;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.hippoecm.hst.configuration.cache.HstNodeImpl;
import org.hippoecm.hst.configuration.model.HstNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeConfigurationNodes {
    private static final Logger log = LoggerFactory.getLogger(HstNodeImpl.class);
    private List<String> compositeConfigurationDependenyPaths = new ArrayList<String>();
    private HstNode configurationRootNode;
    private Map<String, CompositeConfigurationNode> compositeConfigurationNodes = new HashMap<String, CompositeConfigurationNode>();
    private List<String> compositeConfigurationNodeRelPaths;
    private boolean compositeConfigurationNodesLoaded;
    private List<HstNode> orderedRootConfigurationNodeInheritanceList = new ArrayList<HstNode>();
    private List<UUID> cacheKey;

    public CompositeConfigurationNodes(HstNode configurationRootNode, String ... relPaths) {
        HstNode defaultConfigurationRootHstNode;
        this.configurationRootNode = configurationRootNode;
        this.compositeConfigurationNodeRelPaths = Arrays.asList(relPaths);
        this.compositeConfigurationDependenyPaths.add(configurationRootNode.getValueProvider().getPath());
        this.compositeConfigurationDependenyPaths.addAll(this.createDependencyPaths(configurationRootNode.getValueProvider().getPath(), relPaths, true));
        HstNode configurationsNode = configurationRootNode.getParent();
        String defaultConfigurationRootPath = configurationsNode.getValueProvider().getPath() + "/" + "hst:default";
        this.compositeConfigurationDependenyPaths.add(defaultConfigurationRootPath);
        this.compositeConfigurationDependenyPaths.addAll(this.createDependencyPaths(defaultConfigurationRootPath, relPaths, false));
        if (configurationRootNode.getValueProvider().hasProperty("hst:inheritsfrom")) {
            String[] inherits;
            HashSet<String> alreadyInherited = new HashSet<String>();
            for (String inheritPath : inherits = configurationRootNode.getValueProvider().getStrings("hst:inheritsfrom")) {
                this.addInherited(configurationRootNode, configurationsNode, inheritPath, relPaths, alreadyInherited);
            }
        }
        if ((defaultConfigurationRootHstNode = configurationsNode.getNode("hst:default")) != null) {
            this.orderedRootConfigurationNodeInheritanceList.add(defaultConfigurationRootHstNode);
        }
    }

    private void addInherited(HstNode currentConfigurationRootNode, HstNode configurationsNode, String inheritPath, String[] relPaths, Set<String> alreadyInherited) {
        String hstConfigsInheritedRelPath = inheritPath.substring(3);
        String absHstConfigsInheritedPath = configurationsNode.getValueProvider().getPath() + "/" + hstConfigsInheritedRelPath;
        HstNode inheritConfig = configurationsNode.getNode(hstConfigsInheritedRelPath);
        this.compositeConfigurationDependenyPaths.add(absHstConfigsInheritedPath);
        this.compositeConfigurationDependenyPaths.addAll(this.createDependencyPaths(absHstConfigsInheritedPath, relPaths, false));
        if (inheritConfig != null) {
            if (alreadyInherited.contains(inheritConfig.getValueProvider().getIdentifier() + "-" + inheritPath)) {
                log.debug("Already inherited configuration '{}' for '{}'", (Object)currentConfigurationRootNode.getValueProvider().getPath(), (Object)inheritPath);
                return;
            }
            alreadyInherited.add(inheritConfig.getValueProvider().getIdentifier() + "-" + inheritPath);
            if (!this.isValidInheritedNode(inheritConfig)) {
                log.error("Relative inherit path '{}' for node '{}' does not point to a node of type '{}' or '{}', or it does not point to a child node of '{}', or it does not exist. Fix this path.", (Object[])new String[]{inheritPath, currentConfigurationRootNode.getValueProvider().getPath(), "hst:configuration", "hst:workspace", "hst:workspace"});
                return;
            }
            this.orderedRootConfigurationNodeInheritanceList.add(inheritConfig);
            HstNode rootInheritedConfiguration = this.getHstConfiguration(inheritConfig);
            this.populateCascadingInheritanceList(currentConfigurationRootNode, configurationsNode, relPaths, alreadyInherited, hstConfigsInheritedRelPath, rootInheritedConfiguration);
        } else {
            if (!hstConfigsInheritedRelPath.contains("/")) {
                return;
            }
            String rootName = StringUtils.substringBefore((String)hstConfigsInheritedRelPath, (String)"/");
            HstNode rootInheritedConfiguration = configurationsNode.getNode(rootName);
            if (rootInheritedConfiguration != null) {
                this.populateCascadingInheritanceList(currentConfigurationRootNode, configurationsNode, relPaths, alreadyInherited, hstConfigsInheritedRelPath, rootInheritedConfiguration);
            }
        }
    }

    private void populateCascadingInheritanceList(HstNode configurationRootNode, HstNode configurationsNode, String[] relPaths, Set<String> alreadyInherited, String hstConfigsInheritedRelPath, HstNode rootInheritedConfiguration) {
        if (rootInheritedConfiguration.getValueProvider().hasProperty("hst:inheritsfrom")) {
            String[] cascadingInheritedPaths;
            for (String cascadingInheritedPath : cascadingInheritedPaths = rootInheritedConfiguration.getValueProvider().getStrings("hst:inheritsfrom")) {
                if (hstConfigsInheritedRelPath.contains("/")) {
                    String relPath = StringUtils.substringAfter((String)hstConfigsInheritedRelPath, (String)"/");
                    if (cascadingInheritedPath.endsWith("/" + relPath)) {
                        HstNode cascading = configurationsNode.getNode(StringUtils.substringBefore((String)hstConfigsInheritedRelPath, (String)"/"));
                        if (cascading == null) {
                            log.debug("No cascading config present at '{}' for '{}'. Skip it.", (Object)relPath, (Object)configurationRootNode.getValueProvider().getPath());
                            continue;
                        }
                        this.addInherited(cascading, configurationsNode, cascadingInheritedPath, relPaths, alreadyInherited);
                        continue;
                    }
                    log.debug("Do not cascade inheritance for '{}' for '{}'", (Object)cascadingInheritedPath, (Object)configurationRootNode.getValueProvider().getPath());
                    continue;
                }
                HstNode cascading = configurationsNode.getNode(hstConfigsInheritedRelPath);
                if (cascading == null) {
                    log.debug("No cascading config present at '{}' for '{}'. Skip it.", (Object)hstConfigsInheritedRelPath, (Object)configurationRootNode.getValueProvider().getPath());
                    continue;
                }
                this.addInherited(cascading, configurationsNode, cascadingInheritedPath, relPaths, alreadyInherited);
            }
        }
    }

    private HstNode getHstConfiguration(HstNode inheritConfig) {
        if ("hst:configuration".equals(inheritConfig.getNodeTypeName())) {
            return inheritConfig;
        }
        if ("hst:workspace".equals(inheritConfig.getNodeTypeName())) {
            return inheritConfig.getParent();
        }
        if ("hst:workspace".equals(inheritConfig.getParent().getNodeTypeName())) {
            return inheritConfig.getParent().getParent();
        }
        throw new IllegalArgumentException(String.format("Illegal Inherited configuration '%s' should not be possible at this point.", inheritConfig.getValueProvider().getPath()));
    }

    private boolean isValidInheritedNode(HstNode inheritConfig) {
        return "hst:configuration".equals(inheritConfig.getNodeTypeName()) || "hst:workspace".equals(inheritConfig.getNodeTypeName()) || "hst:workspace".equals(inheritConfig.getParent().getNodeTypeName());
    }

    public HstNode getConfigurationRootNode() {
        return this.configurationRootNode;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Map<String, CompositeConfigurationNode> getCompositeConfigurationNodes() {
        if (this.compositeConfigurationNodesLoaded) {
            return this.compositeConfigurationNodes;
        }
        this.compositeConfigurationNodesLoaded = true;
        Iterator<String> iterator = this.compositeConfigurationNodeRelPaths.iterator();
        while (iterator.hasNext()) {
            String compositeConfigurationNodeRelPath = iterator.next();
            HstNode mainConfigNode = this.configurationRootNode.getNode(compositeConfigurationNodeRelPath);
            if (mainConfigNode == null) {
                mainConfigNode = this.configurationRootNode.getNode("hst:workspace/" + compositeConfigurationNodeRelPath);
            }
            ArrayList<HstNode> fallbackMainConfigNodes = new ArrayList<HstNode>();
            String relativeInheritPath = compositeConfigurationNodeRelPath;
            boolean isMainConfigNodeInherited = mainConfigNode == null;
            for (HstNode inherited : this.orderedRootConfigurationNodeInheritanceList) {
                String workspaceAccountedRelativeInheritPath;
                block14: {
                    block15: {
                        workspaceAccountedRelativeInheritPath = relativeInheritPath;
                        if (!relativeInheritPath.startsWith("hst:workspace")) break block15;
                        if (inherited.getNodeTypeName().equals("hst:workspace")) {
                            log.debug("Merging explicitly inherited workspace configuration for '{}'", (Object)inherited.getValueProvider().getPath());
                            workspaceAccountedRelativeInheritPath = relativeInheritPath.substring("hst:workspace".length() + 1);
                            break block14;
                        } else if (inherited.getParent().getNodeTypeName().equals("hst:workspace") && inherited.getValueProvider().getPath().endsWith(relativeInheritPath)) {
                            log.debug("Merging explicitly inherited workspace configuration for '{}'", (Object)inherited.getValueProvider().getPath());
                            workspaceAccountedRelativeInheritPath = "";
                            break block14;
                        } else {
                            log.debug("Do not merge workspace nodes since not explicitly inherited");
                            continue;
                        }
                    }
                    if (inherited.getParent().getNodeTypeName().equals("hst:workspace")) {
                        if (inherited.getValueProvider().getPath().endsWith(relativeInheritPath)) {
                            log.debug("Merging explicitly inherited workspace child configuration for '{}'", (Object)inherited.getValueProvider().getPath());
                            workspaceAccountedRelativeInheritPath = "";
                        } else {
                            log.debug("Do not merge workspace nodes '{}' since '{}' is explicitly inherited", (Object)relativeInheritPath, (Object)inherited.getValueProvider().getPath());
                            continue;
                        }
                    }
                }
                if (mainConfigNode == null) {
                    if (workspaceAccountedRelativeInheritPath.isEmpty()) {
                        mainConfigNode = inherited;
                        continue;
                    }
                    mainConfigNode = inherited.getNode(workspaceAccountedRelativeInheritPath);
                    continue;
                }
                HstNode inheritedMainConfigNode = workspaceAccountedRelativeInheritPath.isEmpty() ? inherited : inherited.getNode(workspaceAccountedRelativeInheritPath);
                if (inheritedMainConfigNode == null) continue;
                fallbackMainConfigNodes.add(inheritedMainConfigNode);
            }
            if (mainConfigNode == null) continue;
            CompositeConfigurationNode compositeConfigurationNode = new CompositeConfigurationNode(mainConfigNode, fallbackMainConfigNodes, isMainConfigNodeInherited);
            this.compositeConfigurationNodes.put(compositeConfigurationNodeRelPath, compositeConfigurationNode);
        }
        return this.compositeConfigurationNodes;
    }

    public List<UUID> getCacheKey() {
        if (this.cacheKey != null) {
            return this.cacheKey;
        }
        long start = System.currentTimeMillis();
        ArrayList<UUID> uuids = new ArrayList<UUID>();
        for (CompositeConfigurationNode compositeConfigurationNode : this.getCompositeConfigurationNodes().values()) {
            uuids.add(UUID.fromString(compositeConfigurationNode.getMainConfigNode().getValueProvider().getIdentifier()));
            for (HstNode compositeChild : compositeConfigurationNode.getCompositeChildren().values()) {
                uuids.add(UUID.fromString(compositeChild.getValueProvider().getIdentifier()));
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Creating cachekey took {} ms.", (Object)(System.currentTimeMillis() - start));
        }
        this.cacheKey = uuids;
        return this.cacheKey;
    }

    private List<String> createDependencyPaths(String rootPath, String[] relPaths, boolean includeWorkspacePath) {
        ArrayList<String> paths = new ArrayList<String>();
        boolean isInheritedWorkspace = false;
        if (rootPath.contains("/hst:workspace")) {
            isInheritedWorkspace = true;
            String mainConfigNodeName = StringUtils.substringAfter((String)rootPath, (String)"/hst:workspace/");
            if (!mainConfigNodeName.isEmpty()) {
                paths.add(rootPath);
                return paths;
            }
        }
        for (String relPath : relPaths) {
            if (isInheritedWorkspace) {
                if (relPath.startsWith("hst:workspace/")) {
                    paths.add(rootPath + relPath.substring("hst:workspace".length()));
                    continue;
                }
                paths.add(rootPath + "/" + relPath);
                continue;
            }
            paths.add(rootPath + "/" + relPath);
            if (!includeWorkspacePath || relPath.startsWith("hst:workspace")) continue;
            paths.add(rootPath + "/" + "hst:workspace" + "/" + relPath);
        }
        return paths;
    }

    public List<String> getCompositeConfigurationDependencyPaths() {
        return this.compositeConfigurationDependenyPaths;
    }

    public static class CompositeConfigurationNode {
        private HstNode mainConfigNode;
        private Map<String, HstNode> compositeChildren = new HashMap<String, HstNode>();

        public CompositeConfigurationNode(HstNode mainConfigNode, List<HstNode> fallbackMainConfigNodes, boolean isMainConfigNodeInherited) {
            this.mainConfigNode = mainConfigNode;
            HstNode mainConfigNodeInWorkspace = null;
            HstNode parent = mainConfigNode.getParent();
            if (!parent.getName().equals("hst:workspace") && !isMainConfigNodeInherited) {
                mainConfigNodeInWorkspace = parent.getNode("hst:workspace/" + mainConfigNode.getName());
            }
            for (HstNode child : mainConfigNode.getNodes()) {
                this.compositeChildren.put(child.getName(), child);
            }
            if (mainConfigNodeInWorkspace != null) {
                for (HstNode child : mainConfigNodeInWorkspace.getNodes()) {
                    if (this.compositeChildren.containsKey(child.getName())) {
                        HstNode present = this.compositeChildren.get(child.getName());
                        log.warn("Please correct the configuration because duplicate configuration nodes found. Not allowed to have same node names in hst:workspace below main config nodes (like hst:sitemap, hst:sitemenu, etc). Duplicates are '{}' and '{}'. Node from workspace won't be used.", (Object)present.toString(), (Object)child.toString());
                        continue;
                    }
                    this.compositeChildren.put(child.getName(), child);
                }
            }
            for (HstNode fallbackMainConfigNode : fallbackMainConfigNodes) {
                for (HstNode fallBackChild : fallbackMainConfigNode.getNodes()) {
                    if (this.compositeChildren.containsKey(fallBackChild.getName())) continue;
                    this.compositeChildren.put(fallBackChild.getName(), fallBackChild);
                }
            }
        }

        public HstNode getMainConfigNode() {
            return this.mainConfigNode;
        }

        public Map<String, HstNode> getCompositeChildren() {
            return this.compositeChildren;
        }
    }
}

