/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.channelmanager.security;

import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.EventIterator;
import org.hippoecm.hst.channelmanager.security.SecurityModel;
import org.hippoecm.hst.core.jcr.GenericEventListener;
import org.hippoecm.repository.util.JcrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityModelImpl
implements SecurityModel {
    private static final Logger log = LoggerFactory.getLogger(SecurityModelImpl.class);
    private Repository repository;
    private Credentials credentials;
    private String rootPath;
    private String jcrPathTemplateComposer;
    private volatile Map<String, PrivilegePathMapping> mappingModel;

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public void setCredentials(Credentials credentials) {
        this.credentials = credentials;
    }

    public void setRootPath(String rootPath) {
        this.rootPath = rootPath;
    }

    public void setJcrPathTemplateComposer(String jcrPathTemplateComposer) {
        this.jcrPathTemplateComposer = jcrPathTemplateComposer;
    }

    public Principal getUserPrincipal(Session session) {
        return () -> ((Session)session).getUserID();
    }

    public boolean isUserInRole(Session session, String functionalRole) {
        if ("ChannelManagerAdmin".equals(functionalRole)) {
            Map<String, PrivilegePathMapping> mapping = this.getMappingModel();
            PrivilegePathMapping privilegePathMappging = mapping.get(functionalRole);
            if (privilegePathMappging == null) {
                log.info("No PrivilegePathMapping for role '{}'.", (Object)functionalRole);
                return false;
            }
            try {
                return session.hasPermission(privilegePathMappging.privilegePath, privilegePathMappging.privilege);
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Exception while checking permissions.", e);
            }
        }
        if ("ChannelWebmaster".equals(functionalRole)) {
            try {
                return session.hasPermission(this.rootPath + "/accesstest", "set_property");
            }
            catch (RepositoryException e) {
                log.warn("Could not determine authorization", (Throwable)e);
                throw new IllegalStateException("Exception while checking permissions.", e);
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported Functional role '%s'.", functionalRole));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Map<String, PrivilegePathMapping> getMappingModel() {
        Map<String, PrivilegePathMapping> mapping = this.mappingModel;
        if (mapping != null) {
            return mapping;
        }
        SecurityModelImpl securityModelImpl = this;
        synchronized (securityModelImpl) {
            mapping = this.mappingModel;
            if (mapping != null) {
                return mapping;
            }
            this.mappingModel = mapping = new HashMap<String, PrivilegePathMapping>();
            Session session = null;
            try {
                session = this.repository.login(this.credentials);
                Node templateComposerNode = JcrUtils.getNodeIfExists((String)this.jcrPathTemplateComposer, (Session)session);
                if (templateComposerNode == null) {
                    log.warn("Missing jcr node at '{}' to read required configured admin privileges from: Return empty SecurityModel.", (Object)this.jcrPathTemplateComposer);
                    Map<String, PrivilegePathMapping> map = mapping;
                    return map;
                }
                String manageChangesPrivileges = JcrUtils.getStringProperty((Node)templateComposerNode, (String)"manage.changes.privileges", null);
                String manageChangesPrivilegesPath = JcrUtils.getStringProperty((Node)templateComposerNode, (String)"manage.changes.privileges.path", null);
                if (manageChangesPrivileges == null || manageChangesPrivilegesPath == null) {
                    log.warn("Missing properties '{}' and/or '{}' at '{}' : Return empty SecurityModel.", new Object[]{"manage.changes.privileges", "manage.changes.privileges.path", this.jcrPathTemplateComposer});
                    Map<String, PrivilegePathMapping> map = mapping;
                    return map;
                }
                PrivilegePathMapping manageChangesMappging = new PrivilegePathMapping(manageChangesPrivileges, manageChangesPrivilegesPath);
                mapping.put("ChannelManagerAdmin", manageChangesMappging);
                Map<String, PrivilegePathMapping> map = mapping;
                return map;
            }
            catch (RepositoryException e) {
                throw new IllegalStateException("Failed to build security model", e);
            }
            finally {
                if (session != null) {
                    session.logout();
                }
            }
        }
    }

    private void invalidate() {
        this.mappingModel = null;
    }

    public static class SecurityModelEventListener
    extends GenericEventListener {
        private SecurityModelImpl securityModel;

        public void setSecurityModel(SecurityModelImpl securityModel) {
            this.securityModel = securityModel;
        }

        public void onEvent(EventIterator events) {
            this.securityModel.invalidate();
        }
    }

    private static class PrivilegePathMapping {
        private final String privilege;
        private final String privilegePath;

        public PrivilegePathMapping(String privilege, String privilegePath) {
            this.privilege = privilege;
            this.privilegePath = privilegePath;
        }
    }
}

