/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.cache.webfiles;

import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.hippoecm.hst.cache.CompositeHstCache;
import org.hippoecm.hst.cache.HstCache;
import org.hippoecm.hst.cache.PageCacheEventListener;
import org.hippoecm.hst.core.container.RequestInfoCacheKeyFragmentCreator;
import org.hippoecm.hst.core.container.WebFileValve;
import org.hippoecm.hst.core.jcr.GenericEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebFilesEventListener
extends GenericEventListener {
    private static final Logger log = LoggerFactory.getLogger(PageCacheEventListener.class);
    private HstCache pageCache;
    private WebFileValve webFileValve;
    private RequestInfoCacheKeyFragmentCreator requestInfoCacheKeyFragmentCreator;

    public void setPageCache(CompositeHstCache pageCache) {
        this.pageCache = pageCache;
    }

    public void setWebFileValve(WebFileValve webFileValve) {
        this.webFileValve = webFileValve;
    }

    public void setRequestInfoCacheKeyFragmentCreator(RequestInfoCacheKeyFragmentCreator requestInfoCacheKeyFragmentCreator) {
        this.requestInfoCacheKeyFragmentCreator = requestInfoCacheKeyFragmentCreator;
    }

    public void onEvent(EventIterator events) {
        boolean pageCacheCleared = false;
        while (events.hasNext()) {
            try {
                Event event = events.nextEvent();
                if (this.eventIgnorable(event)) continue;
                if (!pageCacheCleared) {
                    pageCacheCleared = true;
                    this.pageCache.clear();
                }
                if (this.requestInfoCacheKeyFragmentCreator != null) {
                    this.requestInfoCacheKeyFragmentCreator.reset();
                }
                this.webFileValve.onEvent(event);
            }
            catch (RepositoryException e) {
                log.error("Error processing event");
            }
        }
    }
}

