/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.cache.webfiles;

import java.io.IOException;
import java.io.Serializable;
import java.util.Calendar;
import org.hippoecm.hst.cache.webfiles.CacheableBinary;
import org.onehippo.cms7.services.webfiles.Binary;
import org.onehippo.cms7.services.webfiles.WebFile;

public class CacheableWebFile
implements WebFile,
Serializable {
    private final String path;
    private final String name;
    private final String encoding;
    private final Calendar lastModified;
    private final String mimeType;
    private final Binary binary;
    private final String version;

    public CacheableWebFile(WebFile resource, String version) throws IOException {
        this.path = resource.getPath();
        this.name = resource.getName();
        this.encoding = resource.getEncoding();
        this.lastModified = resource.getLastModified();
        this.mimeType = resource.getMimeType();
        this.binary = new CacheableBinary(resource.getBinary());
        this.version = version;
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return this.name;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public Calendar getLastModified() {
        return this.lastModified;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Binary getBinary() {
        return this.binary;
    }

    public String getVersion() {
        return this.version;
    }
}

