/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.cache.webfiles;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.ArrayUtils;
import org.onehippo.cms7.services.webfiles.Binary;

public class CacheableBinary
implements Binary,
Serializable {
    private byte[] data = ArrayUtils.EMPTY_BYTE_ARRAY;

    public CacheableBinary(Binary binary) throws IOException {
        InputStream stream = binary.getStream();
        try {
            this.data = IOUtils.toByteArray((InputStream)stream);
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    public InputStream getStream() {
        return new ByteArrayInputStream(this.data);
    }

    public long getSize() {
        return this.data.length;
    }

    public void dispose() {
        this.data = null;
    }
}

