/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.cache.jmx;

import java.util.concurrent.atomic.AtomicLong;
import net.sf.ehcache.Ehcache;
import org.hippoecm.hst.cache.jmx.CacheStatsMXBean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheStats
implements CacheStatsMXBean {
    private static final Logger log = LoggerFactory.getLogger(CacheStats.class);
    private AtomicLong cacheHits = new AtomicLong();
    private AtomicLong cacheMisses = new AtomicLong();
    private AtomicLong firstLevelCachePuts = new AtomicLong();
    private AtomicLong firstLevelCacheHits = new AtomicLong();
    private AtomicLong firstLevelCacheMisses = new AtomicLong();
    private AtomicLong secondLevelCachePuts = new AtomicLong();
    private AtomicLong secondLevelCacheHits = new AtomicLong();
    private AtomicLong secondLevelCacheMisses = new AtomicLong();
    private AtomicLong staleCachePuts = new AtomicLong();
    private AtomicLong staleCacheHits = new AtomicLong();
    private AtomicLong staleCacheMisses = new AtomicLong();
    private Ehcache firstLevelCache;

    public void setFirstLevelCache(Ehcache firstLevelCache) {
        this.firstLevelCache = firstLevelCache;
    }

    @Override
    public long getCacheHits() {
        return this.cacheHits.get();
    }

    @Override
    public long getCacheMisses() {
        return this.cacheMisses.get();
    }

    @Override
    public double getCacheHitRate() {
        return this.hitRate(this.cacheHits, this.cacheMisses);
    }

    @Override
    public double getCacheMissRate() {
        return this.missRate(this.cacheHits, this.cacheMisses);
    }

    @Override
    public void reset() {
        this.cacheHits.set(0L);
        this.cacheMisses.set(0L);
    }

    @Override
    public long getFirstLevelCachePuts() {
        return this.firstLevelCachePuts.get();
    }

    @Override
    public long getFirstLevelCacheHits() {
        return this.firstLevelCacheHits.get();
    }

    @Override
    public long getFirstLevelCacheMisses() {
        return this.firstLevelCacheMisses.get();
    }

    @Override
    public double getFirstLevelCacheHitRate() {
        return this.hitRate(this.firstLevelCacheHits, this.firstLevelCacheMisses);
    }

    @Override
    public double getFirstLevelCacheMissRate() {
        return this.missRate(this.firstLevelCacheHits, this.firstLevelCacheMisses);
    }

    @Override
    public int getFirstLevelCacheSize() {
        return this.firstLevelCache.getSize();
    }

    @Override
    public int getFirstLevelCacheMaxSize() {
        return new Long(this.firstLevelCache.getCacheConfiguration().getMaxEntriesLocalHeap()).intValue() + (int)this.firstLevelCache.getCacheConfiguration().getMaxEntriesLocalDisk();
    }

    @Override
    public long getFirstLevelCacheTimeToLiveSeconds() {
        return this.firstLevelCache.getCacheConfiguration().getTimeToLiveSeconds();
    }

    @Override
    public long getFirstLevelCacheTimeToIdleSeconds() {
        return this.firstLevelCache.getCacheConfiguration().getTimeToIdleSeconds();
    }

    @Override
    public void resetFirstLevelCache() {
        this.firstLevelCachePuts.set(0L);
        this.firstLevelCacheHits.set(0L);
        this.firstLevelCacheMisses.set(0L);
    }

    @Override
    public long getSecondLevelCachePuts() {
        return this.secondLevelCachePuts.get();
    }

    @Override
    public long getSecondLevelCacheHits() {
        return this.secondLevelCacheHits.get();
    }

    @Override
    public long getSecondLevelCacheMisses() {
        return this.secondLevelCacheMisses.get();
    }

    @Override
    public double getSecondLevelCacheHitRate() {
        return this.hitRate(this.secondLevelCacheHits, this.secondLevelCacheMisses);
    }

    @Override
    public double getSecondLevelCacheMissRate() {
        return this.missRate(this.secondLevelCacheHits, this.secondLevelCacheMisses);
    }

    @Override
    public void resetSecondLevelCache() {
        this.secondLevelCachePuts.set(0L);
        this.secondLevelCacheHits.set(0L);
        this.secondLevelCacheMisses.set(0L);
    }

    @Override
    public long getStaleCachePuts() {
        return this.staleCachePuts.get();
    }

    @Override
    public long getStaleCacheHits() {
        return this.staleCacheHits.get();
    }

    @Override
    public long getStaleCacheMisses() {
        return this.staleCacheMisses.get();
    }

    @Override
    public double getStaleCacheHitRate() {
        return this.hitRate(this.staleCacheHits, this.staleCacheMisses);
    }

    @Override
    public double getStaleCacheMissRate() {
        return this.missRate(this.staleCacheHits, this.staleCacheMisses);
    }

    @Override
    public void resetStaleCache() {
        this.staleCachePuts.set(0L);
        this.staleCacheHits.set(0L);
        this.staleCacheMisses.set(0L);
    }

    public void incrementCacheHits() {
        log.debug("Increment cache hit");
        this.cacheHits.incrementAndGet();
    }

    public void incrementCacheMisses() {
        log.debug("Increment cache miss");
        this.cacheMisses.incrementAndGet();
    }

    public void incrementFirstLevelCachePuts() {
        log.debug("Increment first level cache puts");
        this.firstLevelCachePuts.incrementAndGet();
    }

    public void incrementFirstLevelCacheHits() {
        log.debug("Increment first level cache hits");
        this.firstLevelCacheHits.incrementAndGet();
    }

    public void incrementFirstLevelCacheMisses() {
        log.debug("Increment first level cache misses");
        this.firstLevelCacheMisses.incrementAndGet();
    }

    public void incrementSecondLevelCachePuts() {
        log.debug("Increment second level cache puts");
        this.secondLevelCachePuts.incrementAndGet();
    }

    public void incrementSecondLevelCacheHits() {
        log.debug("Increment second level cache hits");
        this.secondLevelCacheHits.incrementAndGet();
    }

    public void incrementSecondLevelCacheMisses() {
        log.debug("Increment second level cache misses");
        this.secondLevelCacheMisses.incrementAndGet();
    }

    public void incrementStaleCachePuts() {
        log.debug("Increment stale cache puts");
        this.staleCachePuts.incrementAndGet();
    }

    public void incrementStaleCacheHits() {
        log.debug("Increment stale cache hits");
        this.staleCacheHits.incrementAndGet();
    }

    public void incrementStaleCacheMisses() {
        log.debug("Increment stale cache misses");
        this.staleCacheMisses.incrementAndGet();
    }

    private double hitRate(AtomicLong hits, AtomicLong misses) {
        long hitNr = hits.get();
        long missNr = misses.get();
        if (hitNr == 0L && missNr == 0L) {
            return 0.0;
        }
        return (double)hitNr * 1.0 / (double)(hitNr + missNr);
    }

    private double missRate(AtomicLong hits, AtomicLong misses) {
        long hitNr = hits.get();
        long missNr = misses.get();
        if (hitNr == 0L && missNr == 0L) {
            return 0.0;
        }
        return 1.0 - this.hitRate(hits, misses);
    }

    @Override
    public void resetAll() {
        this.reset();
        this.resetFirstLevelCache();
        this.resetSecondLevelCache();
        this.resetStaleCache();
    }
}

