/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.cache.esi;

import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hippoecm.hst.cache.esi.ESICommentFragment;
import org.hippoecm.hst.cache.esi.ESICommentFragmentInfo;
import org.hippoecm.hst.cache.esi.ESIElementFragment;
import org.hippoecm.hst.cache.esi.ESIElementFragmentInfo;
import org.hippoecm.hst.cache.esi.ESIFragmentInfo;
import org.hippoecm.hst.cache.esi.ESIFragmentType;
import org.hippoecm.hst.core.component.SerializableElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class ESIPageScanner {
    private static Logger log = LoggerFactory.getLogger(ESIPageScanner.class);
    private String ESI_COMMENT_START = "<!--esi";
    private String ESI_COMMENT_END = "-->";
    private String ESI_TAG_START_END = ">";
    private String ESI_TAG_END_EMPTY = "/>";
    private String ESI_INCLUDE_TAG_START = "<esi:include";
    private String ESI_INCLUDE_TAG_END = "</esi:include>";
    private String ESI_COMMENT_TAG_START = "<esi:comment";
    private String ESI_COMMENT_TAG_END = "</esi:comment>";
    private String ESI_REMOVE_TAG_START = "<esi:remove";
    private String ESI_REMOVE_TAG_END = "</esi:remove>";
    private String ESI_VARS_TAG_START = "<esi:vars";
    private String ESI_VARS_TAG_END = "</esi:vars>";
    private Pattern ESI_TAG_START_PATTERN = Pattern.compile("(<!--esi|<esi:include|<esi:comment|<esi:remove|<esi:vars)", 32);

    public List<ESIFragmentInfo> scanFragmentInfos(String bodyContent) throws IOException {
        LinkedList<ESIFragmentInfo> fragmentInfos = new LinkedList<ESIFragmentInfo>();
        log.debug("[INFO] bodyContent: {}", (Object)bodyContent);
        int begin = 0;
        int end = 0;
        int offset = -1;
        Matcher m = this.ESI_TAG_START_PATTERN.matcher(bodyContent);
        while (m.find(end)) {
            ESIFragmentInfo fragmentInfo;
            String fragmentSource;
            MatchResult mr = m.toMatchResult();
            begin = mr.start();
            end = mr.end();
            String prefix = mr.group(1);
            ESIFragmentType fragmentType = this.getFragmentTypeByTagPrefix(prefix);
            if (fragmentType == ESIFragmentType.COMMENT_BLOCK) {
                offset = bodyContent.indexOf(this.ESI_COMMENT_END, end);
                if (offset == -1) {
                    log.warn("Invalid esi comment at index, {}. No comment ending: {}", (Object)begin, (Object)mr.group());
                    continue;
                }
                end = offset + this.ESI_COMMENT_END.length();
                fragmentSource = bodyContent.substring(begin, end);
                log.debug("fragmentSource: {}", (Object)fragmentSource);
                try {
                    fragmentInfo = this.createCommentFragmentInfo(fragmentSource, begin, end);
                    fragmentInfos.add(fragmentInfo);
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.warn("Failed to create fragment info.", (Throwable)e);
                        continue;
                    }
                    log.warn("Failed to create fragment info. {}", (Object)e.toString());
                }
                continue;
            }
            offset = bodyContent.indexOf(this.ESI_TAG_END_EMPTY, end);
            if (bodyContent.indexOf(this.ESI_TAG_START_END, end) < offset) {
                offset = -1;
            }
            if (offset != -1) {
                end = offset + this.ESI_TAG_END_EMPTY.length();
                fragmentSource = bodyContent.substring(begin, end);
                log.debug("fragmentSource: {}", (Object)fragmentSource);
                try {
                    fragmentInfo = this.createElementFragmentInfo(fragmentType, fragmentSource, begin, end);
                    fragmentInfos.add(fragmentInfo);
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.warn("Failed to create fragment info.", (Throwable)e);
                        continue;
                    }
                    log.warn("Failed to create fragment info. {}", (Object)e.toString());
                }
                continue;
            }
            String fragmentEndTag = this.getEndTagStringByFragmentType(fragmentType);
            offset = bodyContent.indexOf(fragmentEndTag, end);
            if (offset == -1) {
                log.warn("Invalid esi tag at index, {}. No element ending: {}", (Object)begin, (Object)mr.group());
                continue;
            }
            end = offset + fragmentEndTag.length();
            String fragmentSource2 = bodyContent.substring(begin, end);
            log.debug("fragmentSource: {}", (Object)fragmentSource2);
            try {
                ESIFragmentInfo fragmentInfo2 = this.createElementFragmentInfo(fragmentType, fragmentSource2, begin, end);
                fragmentInfos.add(fragmentInfo2);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.warn("Failed to create fragment info.", (Throwable)e);
                    continue;
                }
                log.warn("Failed to create fragment info. {}", (Object)e.toString());
            }
        }
        return fragmentInfos;
    }

    private ESIFragmentInfo createCommentFragmentInfo(String fragmentSource, int begin, int end) throws Exception {
        String uncommentedFragmentSource = fragmentSource.substring(this.ESI_COMMENT_START.length(), fragmentSource.length() - this.ESI_COMMENT_END.length());
        ESICommentFragment fragment = new ESICommentFragment(ESIFragmentType.COMMENT_BLOCK, uncommentedFragmentSource);
        ESICommentFragmentInfo fragmentInfo = new ESICommentFragmentInfo(fragment, begin, end);
        List<ESIFragmentInfo> elementFragmentInfos = this.scanFragmentInfos(uncommentedFragmentSource);
        for (ESIFragmentInfo elementFragmentInfo : elementFragmentInfos) {
            if (elementFragmentInfo.getFragment().getType() == ESIFragmentType.COMMENT_BLOCK) {
                log.warn("Weird unlikely situation. Parsed ESI comment block must not have a child comment block.");
                continue;
            }
            fragmentInfo.addFragmentInfo(elementFragmentInfo);
        }
        return fragmentInfo;
    }

    private ESIFragmentInfo createElementFragmentInfo(ESIFragmentType type, String fragmentSource, int begin, int end) throws Exception {
        if (type == ESIFragmentType.VARS_TAG) {
            int start = fragmentSource.indexOf(this.ESI_TAG_START_END);
            int stop = fragmentSource.indexOf(this.ESI_VARS_TAG_END);
            if (start != -1 && end != -1 && start < end) {
                fragmentSource = fragmentSource.substring(start + 1, stop);
            } else {
                log.warn("Invalid vars tag fragment: {}", (Object)fragmentSource);
                fragmentSource = "";
            }
        }
        ESIElementFragment fragment = new ESIElementFragment(type, fragmentSource);
        if (type == ESIFragmentType.INCLUDE_TAG) {
            DocumentBuilderFactory dbfac = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = dbfac.newDocumentBuilder();
            Document doc = docBuilder.parse(new InputSource(new StringReader(fragmentSource)));
            Element element = doc.getDocumentElement();
            fragment.setElement(new SerializableElement(element));
        }
        ESIElementFragmentInfo fragmentInfo = new ESIElementFragmentInfo(fragment, begin, end);
        return fragmentInfo;
    }

    private ESIFragmentType getFragmentTypeByTagPrefix(String prefix) {
        if (this.ESI_COMMENT_START.equals(prefix)) {
            return ESIFragmentType.COMMENT_BLOCK;
        }
        if (this.ESI_COMMENT_TAG_START.equals(prefix)) {
            return ESIFragmentType.COMMENT_TAG;
        }
        if (this.ESI_INCLUDE_TAG_START.equals(prefix)) {
            return ESIFragmentType.INCLUDE_TAG;
        }
        if (this.ESI_REMOVE_TAG_START.equals(prefix)) {
            return ESIFragmentType.REMOVE_TAG;
        }
        if (this.ESI_VARS_TAG_START.equals(prefix)) {
            return ESIFragmentType.VARS_TAG;
        }
        throw new IllegalArgumentException("Cannot find fragment type by the prefix, '" + prefix + "'.");
    }

    private String getEndTagStringByFragmentType(ESIFragmentType type) {
        if (type == ESIFragmentType.COMMENT_TAG) {
            return this.ESI_COMMENT_TAG_END;
        }
        if (type == ESIFragmentType.INCLUDE_TAG) {
            return this.ESI_INCLUDE_TAG_END;
        }
        if (type == ESIFragmentType.REMOVE_TAG) {
            return this.ESI_REMOVE_TAG_END;
        }
        if (type == ESIFragmentType.VARS_TAG) {
            return this.ESI_VARS_TAG_END;
        }
        throw new IllegalArgumentException("Cannot find fragment end tag string by the type, " + (Object)((Object)type) + ".");
    }
}

