/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.cache.esi;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.constructs.web.GenericResponseWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.james.mime4j.util.MimeUtil;
import org.hippoecm.hst.cache.esi.ESICommentFragmentInfo;
import org.hippoecm.hst.cache.esi.ESIElementFragment;
import org.hippoecm.hst.cache.esi.ESIFragment;
import org.hippoecm.hst.cache.esi.ESIFragmentInfo;
import org.hippoecm.hst.cache.esi.ESIFragmentType;
import org.hippoecm.hst.cache.esi.ESIHstPageInfo;
import org.hippoecm.hst.cache.esi.ESIVarsPlaceholderResolver;
import org.hippoecm.hst.configuration.hosting.MatchException;
import org.hippoecm.hst.configuration.model.HstManager;
import org.hippoecm.hst.container.HstContainerConfigImpl;
import org.hippoecm.hst.container.RequestContextProvider;
import org.hippoecm.hst.core.container.ComponentManager;
import org.hippoecm.hst.core.container.ComponentManagerAware;
import org.hippoecm.hst.core.container.ContainerException;
import org.hippoecm.hst.core.container.HstContainerConfig;
import org.hippoecm.hst.core.container.HstContainerURL;
import org.hippoecm.hst.core.container.Pipeline;
import org.hippoecm.hst.core.container.Pipelines;
import org.hippoecm.hst.core.internal.HstMutableRequestContext;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.hippoecm.hst.core.request.ResolvedMount;
import org.hippoecm.hst.core.util.PropertyParser;
import org.hippoecm.hst.util.HstRequestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESIPageRenderer
implements ComponentManagerAware {
    private static Logger log = LoggerFactory.getLogger(ESIPageRenderer.class);
    private HstManager hstManager;
    private ComponentManager componentManager;
    private String esiIncludePipelineName;
    private HstContainerConfig requestContainerConfig;

    public void setComponentManager(ComponentManager componentManager) {
        this.componentManager = componentManager;
    }

    public void setHstManager(HstManager hstManager) {
        this.hstManager = hstManager;
    }

    public void setEsiIncludePipelineName(String esiIncludePipelineName) {
        this.esiIncludePipelineName = esiIncludePipelineName;
    }

    public void render(Writer writer, HttpServletRequest request, ESIHstPageInfo pageInfo) {
        HstRequestContext requestContext = RequestContextProvider.get();
        PropertyParser propertyParser = this.createESIPropertyParser(request);
        if (this.requestContainerConfig == null && requestContext != null) {
            this.requestContainerConfig = new HstContainerConfigImpl(requestContext.getServletContext(), Thread.currentThread().getContextClassLoader());
        }
        String bodyContent = pageInfo.getUngzippedBodyAsString();
        List<ESIFragmentInfo> fragmentInfos = pageInfo.getFragmentInfos();
        if (fragmentInfos.isEmpty()) {
            ESIPageRenderer.writeQuietly(writer, bodyContent);
            return;
        }
        HashMap<ESIElementFragment, String> esiIncludeElementContents = new HashMap<ESIElementFragment, String>();
        this.fetchESIIncludeElementContents(fragmentInfos, propertyParser, esiIncludeElementContents);
        int beginIndex = 0;
        for (ESIFragmentInfo fragmentInfo : fragmentInfos) {
            ESIFragment fragment = fragmentInfo.getFragment();
            ESIFragmentType type = fragment.getType();
            ESIPageRenderer.writeQuietly(writer, bodyContent.substring(beginIndex, fragmentInfo.getBeginIndex()));
            beginIndex = fragmentInfo.getEndIndex();
            if (type == ESIFragmentType.COMMENT_BLOCK) {
                String uncommentedSource = fragment.getSource();
                if (!((ESICommentFragmentInfo)fragmentInfo).hasAnyFragmentInfo()) {
                    ESIPageRenderer.writeQuietly(writer, uncommentedSource);
                    continue;
                }
                List<ESIFragmentInfo> embeddedFragmentInfos = ((ESICommentFragmentInfo)fragmentInfo).getFragmentInfos();
                int embeddedBeginIndex = 0;
                for (ESIFragmentInfo embeddedFragmentInfo : embeddedFragmentInfos) {
                    ESIElementFragment embeddedElementFragment;
                    String includeContent;
                    ESIFragment embeddedFragment = embeddedFragmentInfo.getFragment();
                    ESIFragmentType embeddedFragmentType = embeddedFragment.getType();
                    ESIPageRenderer.writeQuietly(writer, uncommentedSource.substring(embeddedBeginIndex, embeddedFragmentInfo.getBeginIndex()));
                    embeddedBeginIndex = embeddedFragmentInfo.getEndIndex();
                    if (embeddedFragmentType != ESIFragmentType.INCLUDE_TAG || (includeContent = (String)esiIncludeElementContents.get(embeddedElementFragment = (ESIElementFragment)embeddedFragment)) == null) continue;
                    ESIPageRenderer.writeQuietly(writer, includeContent);
                }
                ESIPageRenderer.writeQuietly(writer, uncommentedSource.substring(embeddedFragmentInfos.get(embeddedFragmentInfos.size() - 1).getEndIndex()));
                continue;
            }
            if (type == ESIFragmentType.INCLUDE_TAG) {
                ESIElementFragment elementFragment = (ESIElementFragment)fragment;
                String includeContent = (String)esiIncludeElementContents.get(elementFragment);
                if (includeContent == null) continue;
                ESIPageRenderer.writeQuietly(writer, includeContent);
                continue;
            }
            if (type != ESIFragmentType.VARS_TAG) continue;
            this.writeNonIncludeElementFragment(writer, (ESIElementFragment)fragment, propertyParser);
        }
        ESIPageRenderer.writeQuietly(writer, bodyContent.substring(fragmentInfos.get(fragmentInfos.size() - 1).getEndIndex()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchESIIncludeElementContents(List<ESIFragmentInfo> fragmentInfos, PropertyParser propertyParser, Map<ESIElementFragment, String> esiIncludeElementContents) {
        for (ESIFragmentInfo fragmentInfo : fragmentInfos) {
            StringWriter writer;
            block16: {
                ESIFragment fragment = fragmentInfo.getFragment();
                ESIFragmentType type = fragment.getType();
                if (type == ESIFragmentType.COMMENT_BLOCK) {
                    if (!((ESICommentFragmentInfo)fragmentInfo).hasAnyFragmentInfo()) continue;
                    List<ESIFragmentInfo> embeddedFragmentInfos = ((ESICommentFragmentInfo)fragmentInfo).getFragmentInfos();
                    for (ESIFragmentInfo embeddedFragmentInfo : embeddedFragmentInfos) {
                        StringWriter writer2;
                        block15: {
                            ESIFragment embeddedFragment = embeddedFragmentInfo.getFragment();
                            ESIFragmentType embeddedFragmentType = embeddedFragment.getType();
                            if (embeddedFragmentType != ESIFragmentType.INCLUDE_TAG) continue;
                            ESIElementFragment embeddedElementFragment = (ESIElementFragment)embeddedFragment;
                            String onerror = embeddedElementFragment.getElement().getAttribute("onerror");
                            if (StringUtils.isNotEmpty((String)onerror) && !StringUtils.equals((String)"continue", (String)onerror)) {
                                log.warn("The onerror attribute of <esi:include/> currently support only 'continue'. Other values ('{}') are NOT YET SUPPORTED.", (Object)onerror);
                            }
                            writer2 = null;
                            try {
                                writer2 = new StringWriter(512);
                                this.writeIncludeElementFragment(writer2, embeddedElementFragment, propertyParser);
                                if (writer2.getBuffer().length() <= 0) break block15;
                                esiIncludeElementContents.put(embeddedElementFragment, writer2.toString());
                            }
                            catch (IOException e) {
                                try {
                                    if (!StringUtils.equals((String)"continue", (String)onerror)) {
                                        // empty if block
                                    }
                                }
                                catch (Throwable throwable) {
                                    IOUtils.closeQuietly(writer2);
                                    throw throwable;
                                }
                                IOUtils.closeQuietly((Writer)writer2);
                                continue;
                            }
                        }
                        IOUtils.closeQuietly((Writer)writer2);
                    }
                    continue;
                }
                if (type != ESIFragmentType.INCLUDE_TAG) continue;
                ESIElementFragment elementFragment = (ESIElementFragment)fragment;
                String onerror = elementFragment.getElement().getAttribute("onerror");
                if (StringUtils.isNotEmpty((String)onerror) && !StringUtils.equals((String)"continue", (String)onerror)) {
                    log.warn("The onerror attribute of <esi:include/> currently support only 'continue'. Other values ('{}') are NOT YET SUPPORTED.", (Object)onerror);
                }
                writer = null;
                try {
                    writer = new StringWriter(512);
                    this.writeIncludeElementFragment(writer, elementFragment, propertyParser);
                    if (writer.getBuffer().length() <= 0) break block16;
                    esiIncludeElementContents.put(elementFragment, writer.toString());
                }
                catch (IOException e) {
                    try {
                        if (!StringUtils.equals((String)"continue", (String)onerror)) {
                            // empty if block
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(writer);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((Writer)writer);
                    continue;
                }
            }
            IOUtils.closeQuietly((Writer)writer);
        }
    }

    protected void writeNonIncludeElementFragment(Writer writer, ESIElementFragment fragment, PropertyParser propertyParser) {
        ESIFragmentType type = fragment.getType();
        if (type == ESIFragmentType.VARS_TAG) {
            this.writeVarsElementFragment(writer, fragment, propertyParser);
        }
    }

    protected void writeIncludeElementFragment(Writer writer, ESIElementFragment fragment, PropertyParser propertyParser) throws IOException {
        String src = fragment.getElement().getAttribute("src");
        String alt = fragment.getElement().getAttribute("alt");
        if (src != null) {
            src = (String)propertyParser.resolveProperty(this.getClass().getSimpleName(), src);
        }
        if (alt != null) {
            alt = (String)propertyParser.resolveProperty(this.getClass().getSimpleName(), alt);
        }
        URI uri = null;
        try {
            uri = URI.create(src);
        }
        catch (Exception e) {
            log.warn("Invalid ESI include url: '{}'.", (Object)src);
            return;
        }
        HstContainerURL localContainerURL = null;
        if (this.hstManager != null) {
            try {
                HstRequestContext requestContext = RequestContextProvider.get();
                ResolvedMount curResolvedMount = requestContext.getResolvedMount();
                HstContainerURL curBaseURL = requestContext.getBaseURL();
                String curContextPath = curBaseURL.getContextPath();
                String requestPathFromURL = uri.getPath();
                if (curResolvedMount.getMount().getVirtualHost().isContextPathInUrl()) {
                    requestPathFromURL = StringUtils.substringAfter((String)uri.getPath(), (String)curContextPath);
                }
                Map queryParams = HstRequestUtils.parseQueryString((URI)uri, (String)curBaseURL.getURIEncoding());
                localContainerURL = requestContext.getContainerURLProvider().parseURL(curResolvedMount, curContextPath, requestPathFromURL, queryParams, curBaseURL.getCharacterEncoding(), curBaseURL.getURIEncoding());
            }
            catch (MatchException e) {
                log.debug("The host is not matched by local HST virtual hosts configuration. It might be a remote URL: '{}'.", (Object)uri);
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.warn("Errors while trying to resolve container URL.", (Throwable)e);
                }
                log.warn("Errors while trying to resolve container URL. {}", (Object)e.toString());
            }
        }
        try {
            if (localContainerURL != null) {
                this.includeLocalURL(writer, uri, localContainerURL);
            } else {
                this.includeRemoteURL(writer, uri);
            }
        }
        catch (IOException e) {
            if (StringUtils.isNotEmpty((String)alt)) {
                if (log.isDebugEnabled()) {
                    log.warn("IOException when processing ESI include element for the source, '" + uri + "'. ALT text, '" + alt + "', is being rendered.", (Throwable)e);
                } else {
                    log.warn("IOException when processing ESI include element for the source, '{}'. ALT text, '{}', is being rendered. " + e, (Object)uri, (Object)alt);
                }
                ESIPageRenderer.writeQuietly(writer, alt);
            }
            throw e;
        }
    }

    protected void includeLocalURL(Writer writer, URI uri, HstContainerURL localContainerURL) throws IOException {
        if (localContainerURL.getComponentRenderingWindowReferenceNamespace() != null || localContainerURL.getResourceWindowReferenceNamespace() != null) {
            this.includeLocalESIPipelineURL(writer, uri, localContainerURL);
        } else if (RequestContextProvider.get().getVirtualHost().getVirtualHosts().isHstFilterExcludedPath(uri.getPath())) {
            this.includeLocalDispatchURL(writer, uri, localContainerURL);
        } else {
            log.warn("Ignoring ESI Include Tag. ESI Include Tag for a local HST navigational URL (neither componentRendering nor resource URL) is not supported yet: '{}'.", (Object)uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void includeLocalESIPipelineURL(Writer writer, URI uri, HstContainerURL localContainerURL) throws IOException {
        Pipeline pipeline = this.getESIIncludePipeline();
        if (pipeline == null) {
            log.warn("No pipeline found for ESI includes: '{}'.", (Object)this.esiIncludePipelineName);
            return;
        }
        HstRequestContext requestContext = RequestContextProvider.get();
        HttpServletRequest request = requestContext.getServletRequest();
        HttpServletResponse response = requestContext.getServletResponse();
        HstContainerURL baseURL = requestContext.getBaseURL();
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            ContentBufferingResponseWrapper responseWrapper = new ContentBufferingResponseWrapper(requestContext.getServletResponse(), baos);
            ((HstMutableRequestContext)requestContext).setServletResponse((HttpServletResponse)responseWrapper);
            ((HstMutableRequestContext)requestContext).setBaseURL(localContainerURL);
            try {
                pipeline.initialize();
                pipeline.invoke(this.requestContainerConfig, requestContext, request, (HttpServletResponse)responseWrapper);
            }
            catch (ContainerException e) {
                if (log.isDebugEnabled()) {
                    log.warn("Failed to invoke content window rendering pipeline.", (Throwable)e);
                } else {
                    log.warn("Failed to invoke content window rendering pipeline. {}", (Object)e.toString());
                }
            }
            finally {
                try {
                    pipeline.cleanup(this.requestContainerConfig, requestContext, request, (HttpServletResponse)responseWrapper);
                }
                catch (ContainerException e) {
                    if (log.isDebugEnabled()) {
                        log.warn("Failed to clean up content window rendering pipeline.", (Throwable)e);
                    }
                    log.warn("Failed to clean up content window rendering pipeline. {}", (Object)e.toString());
                }
            }
            responseWrapper.flush();
            String charset = responseWrapper.getCharacterEncoding();
            if (StringUtils.isEmpty((String)charset)) {
                Map params = MimeUtil.getHeaderParams((String)responseWrapper.getContentType());
                charset = StringUtils.defaultIfEmpty((String)((String)params.get("charset")), (String)"UTF-8");
            }
            String contentBody = baos.toString(charset);
            writer.write(contentBody);
        }
        finally {
            ((HstMutableRequestContext)requestContext).setServletResponse(response);
            ((HstMutableRequestContext)requestContext).setBaseURL(baseURL);
        }
    }

    protected void includeLocalDispatchURL(Writer writer, URI uri, HstContainerURL localContainerURL) throws IOException {
        HstRequestContext requestContext = RequestContextProvider.get();
        try {
            RequestDispatcher disp = this.getRequestDispatcherForLocalURL(uri, localContainerURL);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            ContentBufferingResponseWrapper responseWrapper = new ContentBufferingResponseWrapper(requestContext.getServletResponse(), baos);
            disp.include((ServletRequest)requestContext.getServletRequest(), (ServletResponse)responseWrapper);
            responseWrapper.flush();
            String charset = responseWrapper.getCharacterEncoding();
            if (StringUtils.isEmpty((String)charset)) {
                Map params = MimeUtil.getHeaderParams((String)responseWrapper.getContentType());
                charset = StringUtils.defaultIfEmpty((String)((String)params.get("charset")), (String)"UTF-8");
            }
            String contentBody = baos.toString(charset);
            writer.write(contentBody);
        }
        catch (ServletException e) {
            if (log.isDebugEnabled()) {
                log.warn("Failed to include dispatcher for ESI Include Tag: '{}'.", (Object)uri, (Object)e);
            }
            log.warn("Failed to include dispatcher for ESI Include Tag: '{}'. {}", (Object)uri, (Object)e);
        }
    }

    protected RequestDispatcher getRequestDispatcherForLocalURL(URI uri, HstContainerURL localContainerURL) throws IOException {
        HstRequestContext requestContext = RequestContextProvider.get();
        String requestPath = localContainerURL.getRequestPath();
        String contextRelPath = StringUtils.isEmpty((String)uri.getRawQuery()) ? requestPath : new StringBuilder(80).append(requestPath).append('?').append(uri.getRawQuery()).toString();
        return requestContext.getServletContext().getRequestDispatcher(contextRelPath);
    }

    protected void includeRemoteURL(Writer writer, URI uri) throws IOException {
        log.warn("Ignoring ESI Include Tag. ESI Include Tag for remote URL is not supported yet: '{}'.", (Object)uri);
    }

    protected void writeVarsElementFragment(Writer writer, ESIElementFragment fragment, PropertyParser propertyParser) {
        String source = fragment.getSource();
        if (source != null) {
            source = (String)propertyParser.resolveProperty(this.getClass().getSimpleName(), source);
            ESIPageRenderer.writeQuietly(writer, source);
        }
    }

    protected Pipeline getESIIncludePipeline() {
        Pipelines pipelines;
        Pipeline pipeline = null;
        if (this.componentManager != null && this.esiIncludePipelineName != null && (pipelines = (Pipelines)this.componentManager.getComponent(Pipelines.class.getName())) != null) {
            pipeline = pipelines.getPipeline(this.esiIncludePipelineName);
        }
        return pipeline;
    }

    protected PropertyParser createESIPropertyParser(HttpServletRequest request) {
        PropertyParser propertyParser = new PropertyParser(null, "$(", ")", null, true);
        propertyParser.setPlaceholderResolver(new ESIVarsPlaceholderResolver(request));
        return propertyParser;
    }

    private static void writeQuietly(Writer writer, String data) {
        try {
            writer.write(data);
        }
        catch (IOException e) {
            log.error("Failed to write data.", (Throwable)e);
        }
    }

    private static class ContentBufferingResponseWrapper
    extends GenericResponseWrapper {
        private static final long serialVersionUID = 1L;

        private ContentBufferingResponseWrapper(HttpServletResponse response, OutputStream out) {
            super(response, out);
        }

        public boolean isCommitted() {
            return false;
        }
    }
}

