/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.cache.esi;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.constructs.web.Header;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.james.mime4j.util.MimeUtil;
import org.hippoecm.hst.cache.HstPageInfo;
import org.hippoecm.hst.cache.esi.ESIFragmentInfo;
import org.hippoecm.hst.cache.esi.ESIPageRenderer;
import org.hippoecm.hst.container.RequestContextProvider;
import org.hippoecm.hst.core.request.HstRequestContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ESIHstPageInfo
extends HstPageInfo {
    private static final Logger log = LoggerFactory.getLogger(ESIHstPageInfo.class);
    private static final long serialVersionUID = 1L;
    private String ungzippedBodyAsString;
    private List<ESIFragmentInfo> fragmentInfos;
    private transient ESIPageRenderer esiPageRenderer;

    public ESIHstPageInfo(int statusCode, String contentType, Collection cookies, byte[] body, String characterEncoding, long timeToLiveSeconds, Collection<Header<? extends Serializable>> headers) throws UnsupportedEncodingException {
        this(statusCode, contentType, cookies, ESIHstPageInfo.bytesToString(body, characterEncoding, contentType), characterEncoding, timeToLiveSeconds, headers);
    }

    public ESIHstPageInfo(int statusCode, String contentType, Collection cookies, String ungzippedBodyAsString, String characterEncoding, long timeToLiveSeconds, Collection<Header<? extends Serializable>> headers) {
        super(statusCode, contentType, cookies, ArrayUtils.EMPTY_BYTE_ARRAY, characterEncoding, timeToLiveSeconds, headers);
        this.ungzippedBodyAsString = ungzippedBodyAsString;
    }

    public String getUngzippedBodyAsString() {
        return this.ungzippedBodyAsString;
    }

    public void addAllFragmentInfos(Collection<ESIFragmentInfo> fragmentInfos) {
        if (this.fragmentInfos == null) {
            this.fragmentInfos = new LinkedList<ESIFragmentInfo>();
        }
        this.fragmentInfos.addAll(fragmentInfos);
    }

    public void addFragmentInfo(ESIFragmentInfo fragmentInfo) {
        if (this.fragmentInfos == null) {
            this.fragmentInfos = new LinkedList<ESIFragmentInfo>();
        }
        this.fragmentInfos.add(fragmentInfo);
    }

    public void removeAllFragmentInfos() {
        if (this.fragmentInfos != null) {
            this.fragmentInfos.clear();
        }
    }

    public List<ESIFragmentInfo> getFragmentInfos() {
        if (this.fragmentInfos != null) {
            return Collections.unmodifiableList(this.fragmentInfos);
        }
        return Collections.emptyList();
    }

    public boolean hasAnyFragmentInfo() {
        return this.fragmentInfos != null && !this.fragmentInfos.isEmpty();
    }

    private static String bytesToString(byte[] body, String characterEncoding, String contentType) throws UnsupportedEncodingException {
        Map params;
        String charset;
        if (body == null || body.length == 0) {
            return "";
        }
        if (characterEncoding == null && contentType != null && StringUtils.isNotBlank((String)(charset = (String)(params = MimeUtil.getHeaderParams((String)contentType)).get("charset")))) {
            characterEncoding = charset;
        }
        return new String(body, characterEncoding);
    }

    public void setESIPageRenderer(ESIPageRenderer esiPageRenderer) {
        this.esiPageRenderer = esiPageRenderer;
    }

    @Override
    public void writeContent(HttpServletResponse response) throws IOException {
        if (this.esiPageRenderer == null) {
            log.warn("ESIHstPageInfo misses esiPageRenderer and thus cannot render ESI includes.");
            super.writeContent(response);
            return;
        }
        HstRequestContext requestContext = RequestContextProvider.get();
        BufferedWriter writer = new BufferedWriter(response.getWriter());
        this.esiPageRenderer.render(writer, requestContext.getServletRequest(), this);
        ((Writer)writer).flush();
    }
}

