/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.cache;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.servlet.http.HttpServletResponse;
import net.sf.ehcache.constructs.web.Header;
import net.sf.ehcache.constructs.web.PageInfo;
import org.apache.commons.lang.StringUtils;
import org.apache.james.mime4j.util.MimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HstPageInfo
extends PageInfo {
    private static final Logger log = LoggerFactory.getLogger(HstPageInfo.class);
    private static final long serialVersionUID = 1L;
    private String characterEncoding;
    private Boolean isNoCachePresentOrExpiresImmediately;

    public HstPageInfo() {
        super(200, null, null, null, false, 0L, null);
    }

    public HstPageInfo(int statusCode, String contentType, Collection cookies, byte[] body, String characterEncoding, long timeToLiveSeconds, Collection<Header<? extends Serializable>> headers) {
        super(statusCode, contentType, cookies, body, false, timeToLiveSeconds, headers);
        this.characterEncoding = characterEncoding;
    }

    public String getCharacterEncoding() {
        String contentType;
        if (this.characterEncoding == null && (contentType = this.getContentType()) != null) {
            Map params = MimeUtil.getHeaderParams((String)contentType);
            this.characterEncoding = (String)params.get("charset");
        }
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public boolean isNoCachePresentOrExpiresImmediately() {
        if (this.isNoCachePresentOrExpiresImmediately == null) {
            this.isNoCachePresentOrExpiresImmediately = Boolean.FALSE;
            List headers = this.getHeaders();
            for (Header header : headers) {
                if ("Pragma".equalsIgnoreCase(header.getName()) && "no-cache".equals(header.getValue())) {
                    this.isNoCachePresentOrExpiresImmediately = Boolean.TRUE;
                    continue;
                }
                if ("Cache-Control".equalsIgnoreCase(header.getName()) && StringUtils.contains((String)String.valueOf(header.getValue()), (String)"no-cache")) {
                    this.isNoCachePresentOrExpiresImmediately = Boolean.TRUE;
                    continue;
                }
                if (!"Expires".equalsIgnoreCase(header.getName())) continue;
                try {
                    long time = this.getTime(header);
                    if (time > System.currentTimeMillis()) continue;
                    this.isNoCachePresentOrExpiresImmediately = Boolean.TRUE;
                }
                catch (ParseException e) {
                    log.warn("Could not parse 'Expires' header because has value '{}'.", (Object)header.getValue());
                }
            }
        }
        return this.isNoCachePresentOrExpiresImmediately;
    }

    public Long getExpiresInSeconds() {
        List headers = this.getHeaders();
        for (Header header : headers) {
            if (!"Expires".equalsIgnoreCase(header.getName())) continue;
            try {
                long time = this.getTime(header);
                return (time - System.currentTimeMillis()) / 1000L;
            }
            catch (ParseException e) {
                log.warn("Could not parse 'Expires' header because has value '{}'.", (Object)header.getValue());
                return null;
            }
        }
        return null;
    }

    public void writeContent(HttpServletResponse response) throws IOException {
        byte[] body = this.getUngzippedBody();
        response.setContentLength(body != null ? body.length : 0);
        BufferedOutputStream out = new BufferedOutputStream((OutputStream)response.getOutputStream());
        ((OutputStream)out).write(body);
        ((OutputStream)out).flush();
    }

    private long getTime(Header expiresHeader) throws ParseException {
        try {
            return Long.parseLong(String.valueOf(expiresHeader.getValue()));
        }
        catch (NumberFormatException e) {
            SimpleDateFormat rfc1123DateFormat = HstPageInfo.getRFC1123DateFormat();
            return rfc1123DateFormat.parse(String.valueOf(expiresHeader.getValue())).getTime();
        }
    }

    static SimpleDateFormat getRFC1123DateFormat() {
        SimpleDateFormat rfc1123DateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
        rfc1123DateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        return rfc1123DateFormat;
    }
}

