/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.hst.cache;

import java.util.Optional;
import java.util.concurrent.Callable;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.InvalidConfigurationException;
import net.sf.ehcache.config.PersistenceConfiguration;
import org.apache.commons.collections.map.LRUMap;
import org.hippoecm.hst.cache.CacheElement;
import org.hippoecm.hst.cache.HstCache;
import org.hippoecm.hst.cache.ehcache.CacheElementEhCacheImpl;
import org.hippoecm.hst.cache.jmx.CacheStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.Cache;

public class CompositeHstCache
implements HstCache {
    private static final Logger log = LoggerFactory.getLogger(CompositeHstCache.class);
    final Ehcache ehcache;
    private Cache staleCache;
    private Cache secondLevelCache;
    private LRUMap uncacheableKeys;
    private static final Boolean DUMMY_VALUE = Boolean.TRUE;
    private volatile int invalidationCounter;
    CacheStats cacheStats = new CacheStats();

    public CompositeHstCache(Ehcache ehcache) {
        this(ehcache, new PersistenceConfiguration().strategy(PersistenceConfiguration.Strategy.NONE));
    }

    public CompositeHstCache(Ehcache ehcache, PersistenceConfiguration persistenceConfiguration) {
        this.ehcache = ehcache;
        try {
            ehcache.getCacheConfiguration().addPersistence(persistenceConfiguration);
        }
        catch (InvalidConfigurationException e) {
            log.warn("Cannot add PersistenceConfiguration since deprecated 'overflowToDisk' or 'diskPersistent' is still configured.");
        }
    }

    public void setCacheStats(CacheStats cacheStats) {
        this.cacheStats = cacheStats;
        cacheStats.setFirstLevelCache(this.ehcache);
    }

    public void setStaleCache(Cache staleCache) {
        this.staleCache = staleCache;
    }

    public void setStaleCache(Optional<Cache> staleCacheOptional) {
        if (staleCacheOptional.isPresent()) {
            this.staleCache = staleCacheOptional.get();
        }
    }

    public void setSecondLevelCache(Cache secondLevelCache) {
        this.secondLevelCache = secondLevelCache;
        this.uncacheableKeys = new LRUMap(1000);
    }

    public void setSecondLevelCache(Optional<Cache> secondLevelCacheOptional) {
        if (secondLevelCacheOptional.isPresent()) {
            this.secondLevelCache = secondLevelCacheOptional.get();
            this.uncacheableKeys = new LRUMap(1000);
        }
    }

    public CacheElement get(Object key) {
        CacheElement cached = this.doGet(key);
        if (cached != null) {
            this.cacheStats.incrementCacheHits();
            return cached;
        }
        this.cacheStats.incrementCacheMisses();
        return null;
    }

    private CacheElement doGet(Object key) {
        Element element = this.ehcache.get(key);
        if (element != null) {
            if (log.isDebugEnabled()) {
                log.debug("Serving cached element created at '{}' from primary cache.", (Object)element.getCreationTime());
            }
            this.cacheStats.incrementFirstLevelCacheHits();
            return new CacheElementEhCacheImpl(element);
        }
        this.cacheStats.incrementFirstLevelCacheMisses();
        if (this.secondLevelCache != null && !this.uncacheableKeys.containsKey(key)) {
            Element secondLevelElement = (Element)this.secondLevelCache.get(key, Element.class);
            if (secondLevelElement == null) {
                this.cacheStats.incrementSecondLevelCacheMisses();
            } else {
                long newTTL;
                this.cacheStats.incrementSecondLevelCacheHits();
                log.debug("Found element in second level cache for key : {}", key);
                Element elementBasedOnKeyInstance = new Element(key, secondLevelElement.getObjectValue());
                long timeLived = (System.currentTimeMillis() - secondLevelElement.getCreationTime() + 999L) / 1000L;
                if (secondLevelElement.getTimeToLive() == 0) {
                    log.info("second level cache entry for '{}' has a TTL of '0' implying forever valid. Restoring it in primary cache with TTL forever", secondLevelElement.getObjectKey());
                    newTTL = 0L;
                } else {
                    newTTL = (long)secondLevelElement.getTimeToLive() - timeLived;
                    log.info("second level cache entry for '{}' has a TTL of '{}' and has lived for '{}' hence restoring it  in primary cache with TTL '{}'", new Object[]{secondLevelElement.getObjectKey(), secondLevelElement.getTimeToLive(), timeLived, newTTL});
                }
                if (newTTL <= 0L) {
                    if (this.staleCache != null) {
                        log.info("Temporarily restoring stale element in primary cache. Current thread will continue recreating the element to be cached which will later on replace the stale item in primary cache and stale page cache.");
                        this.cacheStats.incrementFirstLevelCacheHits();
                        this.ehcache.put(elementBasedOnKeyInstance);
                    }
                    return null;
                }
                elementBasedOnKeyInstance.setTimeToLive((int)newTTL);
                this.cacheStats.incrementFirstLevelCachePuts();
                this.ehcache.put(elementBasedOnKeyInstance);
                return new CacheElementEhCacheImpl(elementBasedOnKeyInstance);
            }
        }
        if (this.staleCache != null) {
            Element staleElement = (Element)this.staleCache.get(key, Element.class);
            if (staleElement == null) {
                this.cacheStats.incrementStaleCacheMisses();
            } else {
                this.cacheStats.incrementStaleCacheHits();
                log.debug("Temporarily restoring stale element created at '{}' in primary cache. Current thread will continue recreating the element to be cached which will later on replace the stale item in primary cache.", (Object)staleElement.getCreationTime());
                Element elementBasedOnKeyInstance = new Element(key, staleElement.getObjectValue(), 1L, staleElement.getCreationTime(), 0L, 0L, 0L);
                this.cacheStats.incrementFirstLevelCachePuts();
                this.ehcache.put(elementBasedOnKeyInstance);
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheElement get(Object key, Callable<? extends CacheElement> valueLoader) throws Exception {
        if (valueLoader == null) {
            throw new IllegalArgumentException("valueLoader is not allowed to be null");
        }
        CacheElement cached = this.get(key);
        if (cached != null) {
            return cached;
        }
        int preCallInvalidationCounter = this.invalidationCounter;
        CacheElement element = null;
        try {
            element = valueLoader.call();
            if (element == null) {
                log.debug("valueLoader '{}#call()' did return null for key '{}'", (Object)valueLoader.getClass().getName(), key);
            }
        }
        finally {
            int postCallInvalidationCounter = this.invalidationCounter;
            if (element == null) {
                element = this.createElement(key, null);
                this.put(element);
            } else if (postCallInvalidationCounter != preCallInvalidationCounter) {
                this.put(this.createElement(key, null));
                if (this.staleCache != null) {
                    CacheElementEhCacheImpl cacheElem = (CacheElementEhCacheImpl)element;
                    this.cacheStats.incrementStaleCachePuts();
                    this.staleCache.put(cacheElem.getElement().getObjectKey(), (Object)cacheElem.getElement());
                }
            } else {
                this.put(element);
            }
        }
        return element;
    }

    public int getTimeToIdleSeconds() {
        return (int)this.ehcache.getCacheConfiguration().getTimeToIdleSeconds();
    }

    public int getTimeToLiveSeconds() {
        return (int)this.ehcache.getCacheConfiguration().getTimeToLiveSeconds();
    }

    public boolean isKeyInCache(Object key) {
        return this.ehcache.isKeyInCache(key);
    }

    public void put(CacheElement element) {
        if (!element.isCacheable()) {
            CacheElement uncacheable = this.createElement(element.getKey(), null);
            this.ehcache.put(((CacheElementEhCacheImpl)uncacheable).getElement());
            if (this.secondLevelCache != null && this.uncacheableKeys != null) {
                this.uncacheableKeys.put(element.getKey(), (Object)DUMMY_VALUE);
            }
            return;
        }
        CacheElementEhCacheImpl cacheElem = (CacheElementEhCacheImpl)element;
        this.cacheStats.incrementFirstLevelCachePuts();
        this.ehcache.put(cacheElem.getElement());
        if (this.secondLevelCache != null) {
            try {
                this.cacheStats.incrementSecondLevelCachePuts();
                Element clone = (Element)cacheElem.getElement().clone();
                clone.setTimeToLive(cacheElem.getElement().getTimeToLive());
                this.secondLevelCache.put(cacheElem.getKey(), (Object)clone);
            }
            catch (CloneNotSupportedException e) {
                log.warn("Could not clone '{}' : {}", cacheElem.getElement().getObjectKey(), (Object)e.toString());
            }
        }
        if (this.staleCache != null) {
            this.cacheStats.incrementStaleCachePuts();
            this.staleCache.put(cacheElem.getElement().getObjectKey(), (Object)cacheElem.getElement());
        }
    }

    public CacheElement createElement(Object key, Object content) {
        return new CacheElementEhCacheImpl(key, content);
    }

    public CacheElement createUncacheableElement(Object key, Object content) {
        return new CacheElementEhCacheImpl(key, content, false);
    }

    public boolean remove(Object key) {
        return this.ehcache.remove(key);
    }

    public void clear() {
        ++this.invalidationCounter;
        this.ehcache.removeAll();
    }

    public int getSize() {
        return this.ehcache.getSize();
    }

    public int getMaxSize() {
        return new Long(this.ehcache.getCacheConfiguration().getMaxEntriesLocalHeap()).intValue() + (int)this.ehcache.getCacheConfiguration().getMaxEntriesLocalDisk();
    }
}

