/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.logout;

import javax.jcr.RepositoryException;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.Panel;
import org.hippoecm.frontend.dialog.IDialogService;
import org.hippoecm.frontend.plugins.logout.LogoutDialog;
import org.hippoecm.frontend.service.ILogoutService;
import org.hippoecm.frontend.session.UserSession;
import org.hippoecm.repository.api.HippoNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogoutLink
extends Panel {
    private static final Logger log = LoggerFactory.getLogger(LogoutLink.class);

    public LogoutLink(String id, final ILogoutService logoutService, final IDialogService dialogService) {
        super(id);
        AjaxLink logoutLink = new AjaxLink("logout-link"){

            public void onClick(AjaxRequestTarget target) {
                UserSession userSession = UserSession.get();
                try {
                    HippoNode rootNode = userSession.getRootNode();
                    if (rootNode != null && rootNode.getSession().hasPendingChanges()) {
                        LogoutDialog dialog = new LogoutDialog(logoutService);
                        dialogService.show((IDialogService.Dialog)dialog);
                    } else {
                        logoutService.logout();
                    }
                }
                catch (RepositoryException e) {
                    log.error("Error while logging out", (Throwable)e);
                }
            }
        };
        this.add(new Component[]{logoutLink});
        logoutLink.add(new Component[]{new Label("logout-label", "Logout")});
    }
}

