/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.property;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.PropertyDefinition;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteSettings;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.value.IValueMap;
import org.apache.wicket.util.value.ValueMap;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.model.IModelReference;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.hippoecm.frontend.plugins.standards.list.resolvers.CssClass;
import org.hippoecm.frontend.plugins.standards.list.resolvers.TitleAttribute;
import org.hippoecm.frontend.session.UserSession;
import org.hippoecm.frontend.widgets.AutoCompleteTextFieldWidget;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wicket.contrib.input.events.EventType;
import wicket.contrib.input.events.InputBehavior;
import wicket.contrib.input.events.key.KeyType;

public class PropertyDialog
extends AbstractDialog<Node> {
    private static final Logger log = LoggerFactory.getLogger(PropertyDialog.class);
    private static final List<String> ALL_TYPES = new ArrayList<String>(11);
    private static final IValueMap DIALOG_PROPERTIES;
    private String name;
    private String type = "String";
    private Boolean isMultiple = Boolean.FALSE;
    private List<String> values;
    private IModel<Map<String, List<PropertyDefinition>>> choiceModel;
    private final IModelReference<Node> modelReference;
    private boolean focusOnLatestValue;

    public PropertyDialog(IModelReference<Node> modelReference) {
        this.modelReference = modelReference;
        final IModel model = modelReference.getModel();
        this.getParent().add(new Behavior[]{CssClass.append((String)"property-dialog")});
        this.choiceModel = new LoadableDetachableModel<Map<String, List<PropertyDefinition>>>(){

            protected Map<String, List<PropertyDefinition>> load() {
                HashMap<String, List<PropertyDefinition>> choices = new HashMap<String, List<PropertyDefinition>>();
                Node node = (Node)model.getObject();
                try {
                    NodeType pnt = node.getPrimaryNodeType();
                    for (PropertyDefinition propertyDefinition : pnt.getPropertyDefinitions()) {
                        ArrayList<PropertyDefinition> list = (ArrayList<PropertyDefinition>)choices.get(propertyDefinition.getName());
                        if (list == null) {
                            list = new ArrayList<PropertyDefinition>(5);
                        }
                        list.add(propertyDefinition);
                        choices.put(propertyDefinition.getName(), list);
                    }
                    for (PropertyDefinition propertyDefinition : node.getMixinNodeTypes()) {
                        for (PropertyDefinition pd : propertyDefinition.getPropertyDefinitions()) {
                            ArrayList<PropertyDefinition> list = (ArrayList<PropertyDefinition>)choices.get(pd.getName());
                            if (list == null) {
                                list = new ArrayList<PropertyDefinition>(5);
                            }
                            list.add(pd);
                            choices.put(pd.getName(), list);
                        }
                    }
                    HashSet properties = new HashSet(choices.keySet());
                    for (String property : properties) {
                        if (PropertyDialog.this.isResidual(property) || !node.hasProperty(property)) continue;
                        choices.remove(property);
                    }
                }
                catch (RepositoryException e) {
                    log.warn("Unable to populate autocomplete list for property names", (Throwable)e);
                }
                return choices;
            }
        };
        CheckBox checkBox = new CheckBox("isMultiple", (IModel)new Model<Boolean>(){

            public void setObject(Boolean multiple) {
                PropertyDialog.this.isMultiple = multiple;
            }

            public Boolean getObject() {
                List propdefs;
                if (PropertyDialog.this.name != null && (propdefs = (List)((Map)PropertyDialog.this.choiceModel.getObject()).get(PropertyDialog.this.name)) != null) {
                    for (PropertyDefinition pd : propdefs) {
                        if (!PropertyType.nameFromValue((int)pd.getRequiredType()).equals(PropertyDialog.this.type)) continue;
                        PropertyDialog.this.isMultiple = pd.isMultiple();
                        return pd.isMultiple();
                    }
                }
                return PropertyDialog.this.isMultiple;
            }
        });
        checkBox.setOutputMarkupId(true);
        this.add(new Component[]{checkBox});
        DropDownChoice<String> ddChoice = new DropDownChoice<String>("types"){

            public List<? extends String> getChoices() {
                List propdefs;
                if (PropertyDialog.this.name != null && (propdefs = (List)((Map)PropertyDialog.this.choiceModel.getObject()).get(PropertyDialog.this.name)) != null) {
                    ArrayList<String> result = new ArrayList<String>(propdefs.size());
                    for (PropertyDefinition pd : propdefs) {
                        result.add(PropertyType.nameFromValue((int)pd.getRequiredType()));
                    }
                    return result;
                }
                return ALL_TYPES;
            }
        };
        ddChoice.setModel((IModel)new Model<String>((DropDownChoice)ddChoice){
            final /* synthetic */ DropDownChoice val$ddChoice;
            {
                this.val$ddChoice = dropDownChoice;
            }

            public void setObject(String object) {
                PropertyDialog.this.type = object;
            }

            public String getObject() {
                List choices = this.val$ddChoice.getChoices();
                if (choices.size() == 1) {
                    PropertyDialog.this.type = (String)choices.iterator().next();
                }
                return PropertyDialog.this.type;
            }
        });
        ddChoice.setRequired(true);
        ddChoice.setOutputMarkupId(true);
        ddChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
            }
        }});
        this.add(new Component[]{ddChoice});
        this.values = new LinkedList<String>();
        this.values.add("");
        final WebMarkupContainer valuesContainer = new WebMarkupContainer("valuesContainer");
        valuesContainer.setOutputMarkupId(true);
        this.add(new Component[]{valuesContainer});
        valuesContainer.add(new Component[]{new ListView<String>("values", this.values){

            protected void populateItem(final ListItem<String> item) {
                TextField textField = new TextField("val", item.getModel());
                textField.add(new Behavior[]{new OnChangeAjaxBehavior(){

                    protected void onUpdate(AjaxRequestTarget target) {
                    }
                }});
                item.add(new Component[]{textField});
                if (PropertyDialog.this.focusOnLatestValue && item.getIndex() == PropertyDialog.this.values.size() - 1) {
                    AjaxRequestTarget ajax = (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
                    if (ajax != null) {
                        ajax.focusComponent((Component)textField);
                    }
                    PropertyDialog.this.focusOnLatestValue = false;
                }
                final AjaxLink deleteLink = new AjaxLink("removeLink"){

                    public void onClick(AjaxRequestTarget target) {
                        PropertyDialog.this.values.remove(item.getIndex());
                        target.add(new Component[]{valuesContainer});
                    }

                    public boolean isVisible() {
                        return super.isVisible() && item.getIndex() > 0;
                    }
                };
                deleteLink.add(new Behavior[]{TitleAttribute.set((String)this.getString("property.value.remove"))});
                deleteLink.add(new Behavior[]{new InputBehavior(new KeyType[]{KeyType.Enter}, EventType.click){

                    protected String getTarget() {
                        return "'" + deleteLink.getMarkupId() + "'";
                    }
                }});
                item.add(new Component[]{deleteLink});
            }
        }});
        final AjaxLink addLink = new AjaxLink("addLink"){

            public void onClick(AjaxRequestTarget target) {
                PropertyDialog.this.values.add("");
                target.add(new Component[]{valuesContainer});
                PropertyDialog.this.focusOnLatestValue = true;
            }

            public boolean isVisible() {
                return PropertyDialog.this.isMultiple;
            }
        };
        addLink.add(new Behavior[]{TitleAttribute.set((String)this.getString("property.value.add"))});
        addLink.add(new Behavior[]{new InputBehavior(new KeyType[]{KeyType.Enter}, EventType.click){

            protected String getTarget() {
                return "'" + addLink.getMarkupId() + "'";
            }
        }});
        valuesContainer.add(new Component[]{addLink});
        checkBox.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("onchange"){

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{valuesContainer});
                if (!PropertyDialog.this.isMultiple.booleanValue() && PropertyDialog.this.values.size() > 1) {
                    String first = (String)PropertyDialog.this.values.get(0);
                    PropertyDialog.this.values.clear();
                    PropertyDialog.this.values.add(first);
                }
            }
        }});
        AutoCompleteSettings settings = new AutoCompleteSettings();
        settings.setAdjustInputWidth(false);
        settings.setUseSmartPositioning(true);
        settings.setShowCompleteListOnFocusGain(true);
        settings.setShowListOnEmptyInput(true);
        settings.setMaxHeightInPx(400);
        AutoCompleteTextFieldWidget<String> nameField = new AutoCompleteTextFieldWidget<String>("name", (IModel)PropertyModel.of((Object)((Object)this), (String)"name"), settings, (DropDownChoice)ddChoice, checkBox, valuesContainer){
            final /* synthetic */ DropDownChoice val$ddChoice;
            final /* synthetic */ CheckBox val$checkBox;
            final /* synthetic */ WebMarkupContainer val$valuesContainer;
            {
                this.val$ddChoice = dropDownChoice;
                this.val$checkBox = checkBox;
                this.val$valuesContainer = webMarkupContainer;
                super(x0, x1, x2);
            }

            protected Iterator<String> getChoices(String input) {
                ArrayList<String> result = new ArrayList<String>();
                for (String propName : ((Map)PropertyDialog.this.choiceModel.getObject()).keySet()) {
                    if (!propName.contains(input)) continue;
                    result.add(propName);
                }
                return result.iterator();
            }

            protected void onUpdate(AjaxRequestTarget target) {
                super.onUpdate(target);
                target.add(new Component[]{this.val$ddChoice});
                target.add(new Component[]{this.val$checkBox});
                target.add(new Component[]{this.val$valuesContainer});
                PropertyDialog.this.focusOnLatestValue = true;
            }
        };
        nameField.setRequired(true);
        this.add(new Component[]{nameField});
        this.setFocus((Component)nameField);
    }

    public IModel<String> getTitle() {
        return Model.of((Serializable)((Object)"Add a new Property"));
    }

    public void onOk() {
        try {
            IModel nodeModel = this.modelReference.getModel();
            Node node = (Node)nodeModel.getObject();
            int propertyType = PropertyType.valueFromName((String)this.type);
            if (this.isMultiple.booleanValue()) {
                node.setProperty(this.name, this.getJcrValues(propertyType), propertyType);
            } else {
                node.setProperty(this.name, this.getJcrValue(propertyType), propertyType);
            }
            this.modelReference.setModel((IModel)new JcrNodeModel(node));
        }
        catch (ConstraintViolationException e) {
            this.error((Serializable)((Object)("It is not allowed to add the property '" + this.name + "' on this node.")));
            log.info(((Object)((Object)e)).getClass().getName() + " : " + e.getMessage());
        }
        catch (ValueFormatException e) {
            this.error((Serializable)((Object)e.toString()));
            log.info(((Object)((Object)e)).getClass().getName() + " : " + e.getMessage());
        }
        catch (RepositoryException e) {
            this.error((Serializable)((Object)e.toString()));
            log.error(((Object)((Object)e)).getClass().getName() + " : " + e.getMessage(), (Throwable)e);
        }
    }

    public IValueMap getProperties() {
        return DIALOG_PROPERTIES;
    }

    protected void onDetach() {
        this.choiceModel.detach();
        super.onDetach();
    }

    private boolean isResidual(String propertyName) {
        return propertyName.equals("*");
    }

    private Value getJcrValue(int propertyType) throws RepositoryException {
        String value = this.values.get(0);
        return this.getValueFactory().createValue(value == null ? "" : value, propertyType);
    }

    private Value[] getJcrValues(int propertyType) throws RepositoryException {
        ValueFactory factory = this.getValueFactory();
        Value[] jcrValues = new Value[this.values.size()];
        for (int i = 0; i < jcrValues.length; ++i) {
            String value = this.values.get(i);
            jcrValues[i] = factory.createValue(value == null ? "" : value, propertyType);
        }
        return jcrValues;
    }

    private ValueFactory getValueFactory() throws RepositoryException {
        return UserSession.get().getJcrSession().getValueFactory();
    }

    static {
        ALL_TYPES.add("Boolean");
        ALL_TYPES.add("Date");
        ALL_TYPES.add("Double");
        ALL_TYPES.add("Long");
        ALL_TYPES.add("Name");
        ALL_TYPES.add("Path");
        ALL_TYPES.add("Reference");
        ALL_TYPES.add("String");
        ALL_TYPES.add("Decimal");
        ALL_TYPES.add("URI");
        ALL_TYPES.add("WeakReference");
        DIALOG_PROPERTIES = new ValueMap("width=420,height=300").makeImmutable();
    }
}

