/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.patch;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.bind.JAXBException;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.time.Time;
import org.hippoecm.frontend.plugin.config.IPluginConfig;
import org.hippoecm.frontend.plugins.console.dialog.MultiStepDialog;
import org.hippoecm.frontend.session.UserSession;
import org.hippoecm.frontend.widgets.download.DownloadLink;
import org.hippoecm.repository.api.ReferenceWorkspace;
import org.onehippo.cms7.jcrdiff.JcrDiffException;
import org.onehippo.cms7.jcrdiff.content.TreeItem;
import org.onehippo.cms7.jcrdiff.content.jcr.JcrTreeNode;
import org.onehippo.cms7.jcrdiff.delta.Patch;
import org.onehippo.cms7.jcrdiff.match.Matcher;
import org.onehippo.cms7.jcrdiff.match.MatcherItemInfo;
import org.onehippo.cms7.jcrdiff.match.PatchFactory;
import org.onehippo.cms7.jcrdiff.patch.PatchFilter;
import org.onehippo.cms7.jcrdiff.serialization.PatchWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreatePatchDialog
extends MultiStepDialog<Node> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(CreatePatchDialog.class);
    private final Label diff = new Label("diff");
    private String path;
    private List<MultiStepDialog.Step> steps;
    private final List<String> excludedPaths;

    public CreatePatchDialog(IPluginConfig config, IModel<Node> model) {
        super(model);
        this.diff.setOutputMarkupId(true);
        this.add(new Component[]{this.diff});
        PatchDownloadLink link = new PatchDownloadLink("download-link");
        link.add(new Component[]{new Label("download-link-text", "Download (or right click and choose \"Save as...\")")});
        this.add(new Component[]{link});
        this.excludedPaths = Arrays.asList(config.getStringArray("excludedPaths"));
        try {
            this.path = ((Node)this.getModelObject()).getPath();
            if (!this.isPathValid(this.path)) {
                this.error((Serializable)((Object)("Creating a diff for path " + this.path + " is not supported")));
                this.setOkEnabled(false);
                link.setEnabled(false);
            }
        }
        catch (RepositoryException e) {
            this.setOkEnabled(false);
        }
    }

    public IModel<String> getTitle() {
        return new Model((Serializable)((Object)("Create Diff for " + this.path)));
    }

    @Override
    protected List<MultiStepDialog.Step> getSteps() {
        if (this.steps == null) {
            this.steps = new ArrayList<MultiStepDialog.Step>(2);
            this.steps.add(new CreatePatchStep());
            this.steps.add(new MultiStepDialog.DoneStep());
        }
        return this.steps;
    }

    private boolean isPathValid(String path) {
        if (path.equals("/")) {
            return false;
        }
        for (String illegalPath : this.excludedPaths) {
            if (!path.startsWith(illegalPath)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createDiff(Writer writer) {
        Session session = null;
        try {
            ReferenceWorkspace referenceWorkspace = UserSession.get().getHippoRepository().getOrCreateReferenceWorkspace();
            if (referenceWorkspace == null) {
                this.error((Serializable)((Object)"This functionality is not available in your environment"));
                return;
            }
            session = referenceWorkspace.login();
            if (!session.nodeExists("/hippo:configuration")) {
                referenceWorkspace.bootstrap();
            }
            if (!session.nodeExists(this.path)) {
                this.error((Serializable)((Object)("No node at " + this.path + " in reference repository")));
            }
            Patch patch = this.createPatch((Node)this.getModelObject(), session.getNode(this.path));
            PatchWriter patchWriter = new PatchWriter(patch, writer);
            patchWriter.writePatch();
            writer.write("\n\n");
        }
        catch (IOException | RepositoryException | JAXBException | JcrDiffException e) {
            String message = "An unexpected error occurred while creating diff: " + e.getMessage();
            this.error((Serializable)((Object)message));
            log.error(message, e);
        }
        finally {
            if (session != null) {
                session.logout();
            }
        }
    }

    private Patch createPatch(Node currentNode, Node referenceNode) throws JcrDiffException, JAXBException, IOException {
        Matcher matcher = new Matcher();
        MatcherItemInfo currentInfo = new MatcherItemInfo(matcher.getContext(), (TreeItem)new JcrTreeNode(currentNode));
        MatcherItemInfo referenceInfo = new MatcherItemInfo(matcher.getContext(), (TreeItem)new JcrTreeNode(referenceNode));
        matcher.setSource(referenceInfo);
        matcher.setResult(currentInfo);
        matcher.match();
        PatchFactory factory = new PatchFactory();
        return factory.createPatch(referenceInfo, currentInfo, new PatchFilter(){

            public boolean isIncluded(MatcherItemInfo info) {
                return CreatePatchDialog.this.isPathValid(info.getPath());
            }
        });
    }

    private class PatchDownloadLink
    extends DownloadLink {
        private static final long serialVersionUID = 1L;
        private File tempFile;

        public PatchDownloadLink(String id) {
            super(id);
        }

        protected String getFilename() {
            return "patch.txt";
        }

        protected void onDownloadTargetDetach() {
            if (this.tempFile != null) {
                this.tempFile.delete();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected InputStream getContent() {
            FileInputStream fileInputStream;
            FileWriter writer = null;
            try {
                this.tempFile = File.createTempFile("patch-" + Time.now(), ".txt");
                writer = new FileWriter(this.tempFile);
                CreatePatchDialog.this.createDiff(writer);
                fileInputStream = new FileInputStream(this.tempFile);
            }
            catch (IOException e) {
                try {
                    String message = "IOException while creating patch: " + e.getMessage();
                    this.error((Serializable)((Object)message));
                    log.error(message, (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(writer);
                    throw throwable;
                }
                IOUtils.closeQuietly((Writer)writer);
                return null;
            }
            IOUtils.closeQuietly((Writer)writer);
            return fileInputStream;
        }
    }

    private class CreatePatchStep
    extends MultiStepDialog.Step {
        private static final long serialVersionUID = 1L;

        private CreatePatchStep() {
        }

        @Override
        protected int execute() {
            StringWriter writer = new StringWriter();
            CreatePatchDialog.this.createDiff(writer);
            CreatePatchDialog.this.diff.setDefaultModel((IModel)new Model((Serializable)((Object)writer.getBuffer().toString())));
            ((AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class)).add(new Component[]{CreatePatchDialog.this.diff});
            return 1;
        }

        @Override
        protected IModel<String> getOkLabel() {
            return new Model((Serializable)((Object)"Show Diff"));
        }
    }
}

