/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.patch;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.io.IOUtils;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.util.time.Time;
import org.hippoecm.frontend.plugins.console.dialog.MultiStepDialog;
import org.hippoecm.frontend.session.UserSession;
import org.onehippo.cms7.jcrdiff.content.TreeNode;
import org.onehippo.cms7.jcrdiff.content.jcr.JcrTreeNode;
import org.onehippo.cms7.jcrdiff.delta.Operation;
import org.onehippo.cms7.jcrdiff.delta.Patch;
import org.onehippo.cms7.jcrdiff.patch.PatchLog;
import org.onehippo.cms7.jcrdiff.patch.Patcher;
import org.onehippo.cms7.jcrdiff.serialization.PatchReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplyPatchDialog
extends MultiStepDialog<Node> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ApplyPatchDialog.class);
    private final TextArea<String> textArea = new TextArea("log", (IModel)new Model());
    private final FileUploadField fileUploadField;
    private List<MultiStepDialog.Step> steps;
    private File tempFile;

    public ApplyPatchDialog(IModel<Node> model) {
        super(model);
        this.textArea.setOutputMarkupId(true);
        this.add(new Component[]{this.textArea});
        this.setMultiPart(true);
        Component[] componentArray = new Component[1];
        this.fileUploadField = new FileUploadField("fileInput");
        componentArray[0] = this.fileUploadField;
        this.add(componentArray);
        this.fileUploadField.setOutputMarkupId(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean uploadPatch() {
        boolean result;
        block34: {
            String target;
            FileUpload upload = this.fileUploadField.getFileUpload();
            if (upload == null) {
                this.error((Serializable)((Object)"No file selected"));
                return false;
            }
            result = false;
            InputStream uis = null;
            FileInputStream fis = null;
            FileOutputStream fos = null;
            StringBuilder sb = new StringBuilder();
            try {
                uis = upload.getInputStream();
                this.tempFile = File.createTempFile("patch-" + Time.now(), ".xml");
                fos = new FileOutputStream(this.tempFile);
                IOUtils.copy((InputStream)uis, (OutputStream)fos);
                fis = new FileInputStream(this.tempFile);
                Patch patch = this.parsePatch(fis);
                target = patch.getTarget();
                if (target != null && !target.equals(((Node)this.getModelObject()).getPath())) {
                    sb.append("The patch seems to be targeted at a different node than the one to which you are about to apply it.");
                    sb.append(" Patch is targeted at ").append(target).append(".");
                    sb.append(" About to apply patch to ").append(((Node)this.getModelObject()).getPath()).append(".");
                    sb.append(" Continue?");
                }
                if (patch.getOperations().isEmpty()) {
                    sb.append("The patch is empty.");
                }
                result = true;
            }
            catch (IOException e) {
                String message2 = "An unexpected error occurred: " + e.getMessage();
                this.error((Serializable)((Object)message2));
                log.error(message2, (Throwable)e);
                IOUtils.closeQuietly((InputStream)uis);
                IOUtils.closeQuietly((OutputStream)fos);
                IOUtils.closeQuietly(fis);
                String message22 = sb.toString();
                if (!message22.isEmpty()) {
                    this.info((Serializable)((Object)message22));
                }
                if (!result) break block34;
                AjaxRequestTarget target2 = (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
                try {
                    fis = new FileInputStream(this.tempFile);
                    this.textArea.setDefaultModelObject((Object)new String(IOUtils.toCharArray((InputStream)fis)));
                    target2.add(new Component[]{this.textArea});
                }
                catch (IOException e2) {
                    log.error(e2.getClass().getName() + ": " + e2.getMessage(), (Throwable)e2);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)fis);
                }
                this.fileUploadField.setEnabled(false);
                target2.add(new Component[]{this.fileUploadField});
            }
            catch (RepositoryException e2) {
                String message3 = "An unexpected error occurred: " + e2.getMessage();
                this.error((Serializable)((Object)message3));
                log.error(message3, (Throwable)e2);
                {
                    catch (Throwable throwable) {
                        block38: {
                            IOUtils.closeQuietly((InputStream)uis);
                            IOUtils.closeQuietly(fos);
                            IOUtils.closeQuietly(fis);
                            String message32 = sb.toString();
                            if (!message32.isEmpty()) {
                                this.info((Serializable)((Object)message32));
                            }
                            if (!result) break block38;
                            AjaxRequestTarget target3 = (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
                            try {
                                fis = new FileInputStream(this.tempFile);
                                this.textArea.setDefaultModelObject((Object)new String(IOUtils.toCharArray((InputStream)fis)));
                                target3.add(new Component[]{this.textArea});
                            }
                            catch (IOException e3) {
                                try {
                                    log.error(e3.getClass().getName() + ": " + e3.getMessage(), (Throwable)e3);
                                }
                                catch (Throwable throwable2) {
                                    IOUtils.closeQuietly(fis);
                                    throw throwable2;
                                }
                                IOUtils.closeQuietly((InputStream)fis);
                            }
                            IOUtils.closeQuietly((InputStream)fis);
                            this.fileUploadField.setEnabled(false);
                            target3.add(new Component[]{this.fileUploadField});
                        }
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)uis);
                IOUtils.closeQuietly((OutputStream)fos);
                IOUtils.closeQuietly(fis);
                String message4 = sb.toString();
                if (!message4.isEmpty()) {
                    this.info((Serializable)((Object)message4));
                }
                if (!result) break block34;
                AjaxRequestTarget target4 = (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
                try {
                    fis = new FileInputStream(this.tempFile);
                    this.textArea.setDefaultModelObject((Object)new String(IOUtils.toCharArray((InputStream)fis)));
                    target4.add(new Component[]{this.textArea});
                }
                catch (IOException e4) {
                    log.error(e4.getClass().getName() + ": " + e4.getMessage(), (Throwable)e4);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)fis);
                }
                this.fileUploadField.setEnabled(false);
                target4.add(new Component[]{this.fileUploadField});
            }
            IOUtils.closeQuietly((InputStream)uis);
            IOUtils.closeQuietly((OutputStream)fos);
            IOUtils.closeQuietly((InputStream)fis);
            String message = sb.toString();
            if (!message.isEmpty()) {
                this.info((Serializable)((Object)message));
            }
            if (result) {
                target = (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
                try {
                    fis = new FileInputStream(this.tempFile);
                    this.textArea.setDefaultModelObject((Object)new String(IOUtils.toCharArray((InputStream)fis)));
                    target.add(new Component[]{this.textArea});
                }
                catch (IOException e) {
                    log.error(e.getClass().getName() + ": " + e.getMessage(), (Throwable)e);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)fis);
                }
                this.fileUploadField.setEnabled(false);
                target.add(new Component[]{this.fileUploadField});
            }
        }
        return result;
    }

    private Patch parsePatch(InputStream is) throws IOException, RepositoryException {
        PatchReader patchReader = new PatchReader((Reader)new InputStreamReader(is), UserSession.get().getJcrSession());
        return patchReader.readPatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - bad return control flow
     */
    private boolean applyPatch() {
        boolean bl;
        StringBuilder logMessage = new StringBuilder();
        ByteArrayInputStream bais = null;
        try {
            bais = new ByteArrayInputStream(((String)this.textArea.getModelObject()).getBytes());
            Patch patch = this.parsePatch(bais);
            Session session = UserSession.get().getJcrSession();
            Node atticNode = session.getRootNode().addNode("hippo:patch-attic");
            Patcher patcher = new Patcher((TreeNode)new JcrTreeNode((Node)this.getModelObject()), (TreeNode)new JcrTreeNode(atticNode));
            MyPatchLog patchLog = new MyPatchLog(logMessage);
            patcher.applyPatch(patch, (PatchLog)patchLog);
            atticNode.remove();
            if (patchLog.errors) {
                this.warn((Serializable)((Object)"Some patch operations failed"));
            }
            bl = true;
        }
        catch (RepositoryException e) {
            String message = "An unexpected error occurred: " + e.getMessage();
            this.error((Serializable)((Object)message));
            log.error(message, (Throwable)e);
            IOUtils.closeQuietly((InputStream)bais);
            this.textArea.setDefaultModel((IModel)new Model((Serializable)((Object)logMessage.toString())));
            ((AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class)).add(new Component[]{this.textArea});
        }
        catch (IOException e2) {
            String message = "An unexpected error occurred: " + e2.getMessage();
            this.error((Serializable)((Object)message));
            log.error(message);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(bais);
                    this.textArea.setDefaultModel((IModel)new Model((Serializable)((Object)logMessage.toString())));
                    ((AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class)).add(new Component[]{this.textArea});
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((InputStream)bais);
            this.textArea.setDefaultModel((IModel)new Model((Serializable)((Object)logMessage.toString())));
            ((AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class)).add(new Component[]{this.textArea});
        }
        IOUtils.closeQuietly((InputStream)bais);
        this.textArea.setDefaultModel((IModel)new Model((Serializable)((Object)logMessage.toString())));
        ((AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class)).add(new Component[]{this.textArea});
        return bl;
        return false;
    }

    @Override
    protected List<MultiStepDialog.Step> getSteps() {
        if (this.steps == null) {
            this.steps = new ArrayList<MultiStepDialog.Step>(3);
            this.steps.add(new UploadPatchStep());
            this.steps.add(new ApplyPatchStep());
            this.steps.add(new MultiStepDialog.DoneStep());
        }
        return this.steps;
    }

    public IModel getTitle() {
        return new Model((Serializable)((Object)"Apply patch"));
    }

    private class ApplyPatchStep
    extends MultiStepDialog.Step {
        private static final long serialVersionUID = 1L;

        private ApplyPatchStep() {
        }

        @Override
        protected int execute() {
            return ApplyPatchDialog.this.applyPatch() ? 1 : 0;
        }

        @Override
        protected IModel<String> getOkLabel() {
            return new Model((Serializable)((Object)"Apply patch"));
        }
    }

    private class UploadPatchStep
    extends MultiStepDialog.Step {
        private static final long serialVersionUID = 1L;

        private UploadPatchStep() {
        }

        @Override
        protected int execute() {
            return ApplyPatchDialog.this.uploadPatch() ? 1 : 0;
        }

        @Override
        protected IModel<String> getOkLabel() {
            return new Model((Serializable)((Object)"Upload patch"));
        }
    }

    private static class MyPatchLog
    implements PatchLog {
        private final StringBuilder logMessage;
        private boolean errors = false;

        public MyPatchLog(StringBuilder logMessage) {
            this.logMessage = logMessage;
        }

        public void logOperation(Operation action, boolean success) {
            this.errors |= !success;
            this.logMessage.append("Action : ").append(action).append(": success = ").append(success).append("\n");
        }
    }
}

