/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu;

import java.io.Serializable;
import javax.jcr.Node;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.hippoecm.frontend.PluginRequestTarget;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.dialog.DialogLink;
import org.hippoecm.frontend.dialog.IDialogFactory;
import org.hippoecm.frontend.dialog.IDialogService;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.hippoecm.frontend.plugin.IPluginContext;
import org.hippoecm.frontend.plugin.config.IPluginConfig;
import org.hippoecm.frontend.plugins.console.NodeModelReference;
import org.hippoecm.frontend.plugins.console.Shortcuts;
import org.hippoecm.frontend.plugins.console.editor.EditorUpdate;
import org.hippoecm.frontend.plugins.console.menu.copy.CopyDialog;
import org.hippoecm.frontend.plugins.console.menu.delete.DeleteDialog;
import org.hippoecm.frontend.plugins.console.menu.deletemultiple.DeleteMultipleDialog;
import org.hippoecm.frontend.plugins.console.menu.help.HelpDialog;
import org.hippoecm.frontend.plugins.console.menu.move.MoveDialog;
import org.hippoecm.frontend.plugins.console.menu.node.NodeDialog;
import org.hippoecm.frontend.plugins.console.menu.open.OpenDialog;
import org.hippoecm.frontend.plugins.console.menu.property.PropertyDialog;
import org.hippoecm.frontend.plugins.console.menu.rename.RenameDialog;
import org.hippoecm.frontend.plugins.console.menu.reset.ResetDialog;
import org.hippoecm.frontend.plugins.console.menu.save.SaveDialog;
import org.hippoecm.frontend.plugins.console.menu.save.SaveDialogLink;
import org.hippoecm.frontend.plugins.standards.sort.NodeSortPanel;
import org.hippoecm.frontend.service.render.RenderPlugin;

public class MenuPlugin
extends RenderPlugin {
    private static final long serialVersionUID = 1L;
    public static final JavaScriptResourceReference SCRIPT_REFERENCE = new JavaScriptResourceReference(MenuPlugin.class, "MenuPlugin.js");
    private SaveDialogLink saveDialogLink;
    private NodeSortPanel sorter;

    public MenuPlugin(IPluginContext context, IPluginConfig config) {
        super(context, config);
        IDialogService dialogService = this.getDialogService();
        Object dialogFactory = new IDialogFactory(){
            private static final long serialVersionUID = 1L;

            public AbstractDialog<Node> createDialog() {
                return new NodeDialog(new NodeModelReference((Component)MenuPlugin.this, (IModel<Node>)((JcrNodeModel)MenuPlugin.this.getDefaultModel())));
            }
        };
        this.add(new Component[]{new DialogLink("node-dialog", (IModel)new Model((Serializable)((Object)"Add")), dialogFactory, dialogService, Shortcuts.CTRL_N)});
        dialogFactory = new IDialogFactory(){
            private static final long serialVersionUID = 1L;

            public AbstractDialog<Node> createDialog() {
                return new DeleteDialog(new NodeModelReference((Component)MenuPlugin.this, (IModel<Node>)((JcrNodeModel)MenuPlugin.this.getDefaultModel())));
            }
        };
        this.add(new Component[]{new DialogLink("delete-dialog", (IModel)new Model((Serializable)((Object)"Delete")), dialogFactory, dialogService)});
        dialogFactory = new IDialogFactory(){
            private static final long serialVersionUID = 1L;

            public AbstractDialog<Node> createDialog() {
                return new SaveDialog(){

                    @Override
                    public void onOk() {
                        super.onOk();
                        MenuPlugin.this.redrawEditor();
                    }
                };
            }
        };
        this.saveDialogLink = new SaveDialogLink("save-dialog", (IModel<String>)new Model((Serializable)((Object)"Write changes to repository")), (IDialogFactory)dialogFactory, dialogService);
        this.add(new Component[]{this.saveDialogLink});
        dialogFactory = new IDialogFactory(){
            private static final long serialVersionUID = 1L;

            public AbstractDialog<Node> createDialog() {
                return new ResetDialog(){

                    @Override
                    public void onOk() {
                        super.onOk();
                        MenuPlugin.this.redrawEditor();
                    }
                };
            }
        };
        this.add(new Component[]{new DialogLink("reset-dialog", (IModel)new Model((Serializable)((Object)"Reset")), dialogFactory, dialogService)});
        dialogFactory = new IDialogFactory(){
            private static final long serialVersionUID = 1L;

            public AbstractDialog<Node> createDialog() {
                return new PropertyDialog(new NodeModelReference((Component)MenuPlugin.this, (IModel<Node>)((JcrNodeModel)MenuPlugin.this.getDefaultModel()))){

                    @Override
                    public void onOk() {
                        super.onOk();
                        MenuPlugin.this.redrawEditor();
                    }
                };
            }
        };
        this.add(new Component[]{new DialogLink("property-dialog", (IModel)new Model((Serializable)((Object)"Add Property")), dialogFactory, dialogService, Shortcuts.CTRL_P)});
        dialogFactory = new IDialogFactory(){
            private static final long serialVersionUID = 1L;

            public AbstractDialog<Node> createDialog() {
                return new RenameDialog(new NodeModelReference((Component)MenuPlugin.this, (IModel<Node>)((JcrNodeModel)MenuPlugin.this.getDefaultModel())));
            }
        };
        this.add(new Component[]{new DialogLink("rename-dialog", (IModel)new Model((Serializable)((Object)"Rename")), dialogFactory, dialogService)});
        dialogFactory = new IDialogFactory(){
            private static final long serialVersionUID = 1L;

            public AbstractDialog<Node> createDialog() {
                return new MoveDialog(new NodeModelReference((Component)MenuPlugin.this, (IModel<Node>)((JcrNodeModel)MenuPlugin.this.getDefaultModel())));
            }
        };
        this.add(new Component[]{new DialogLink("move-dialog", (IModel)new Model((Serializable)((Object)"Move")), dialogFactory, dialogService)});
        dialogFactory = new IDialogFactory(){
            private static final long serialVersionUID = 1L;

            public AbstractDialog<Node> createDialog() {
                return new CopyDialog(new NodeModelReference((Component)MenuPlugin.this, (IModel<Node>)((JcrNodeModel)MenuPlugin.this.getDefaultModel())));
            }
        };
        this.add(new Component[]{new DialogLink("copy-dialog", (IModel)new Model((Serializable)((Object)"Copy")), dialogFactory, dialogService)});
        dialogFactory = new IDialogFactory(){
            private static final long serialVersionUID = 1L;

            public AbstractDialog<Node> createDialog() {
                return new OpenDialog(new NodeModelReference((Component)MenuPlugin.this, (IModel<Node>)((JcrNodeModel)MenuPlugin.this.getDefaultModel())));
            }
        };
        this.add(new Component[]{new DialogLink("open-dialog", (IModel)new Model((Serializable)((Object)"Open")), dialogFactory, dialogService, Shortcuts.CTRL_O)});
        dialogFactory = new IDialogFactory(){
            private static final long serialVersionUID = 1L;

            public AbstractDialog<Node> createDialog() {
                return new DeleteMultipleDialog(new NodeModelReference((Component)MenuPlugin.this, (IModel<Node>)((JcrNodeModel)MenuPlugin.this.getDefaultModel())));
            }
        };
        this.add(new Component[]{new DialogLink("delete-multiple-dialog", (IModel)new Model((Serializable)((Object)"Delete *")), dialogFactory, dialogService, Shortcuts.CTRL_M)});
        dialogFactory = new IDialogFactory(){
            private static final long serialVersionUID = 1L;

            public AbstractDialog<Void> createDialog() {
                return new HelpDialog();
            }
        };
        this.add(new Component[]{new DialogLink("help-dialog", (IModel)new Model((Serializable)((Object)"?")), dialogFactory, dialogService, Shortcuts.CTRL_H)});
        Component[] componentArray = new Component[1];
        this.sorter = new NodeSortPanel("sorter-panel");
        componentArray[0] = this.sorter;
        this.add(componentArray);
        this.sorter.setDefaultModel(this.getDefaultModel());
    }

    private void redrawEditor() {
        AjaxRequestTarget target = (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class);
        if (target != null) {
            this.send((IEventSink)this.getPage(), Broadcast.DEPTH, new EditorUpdate(target));
        }
    }

    protected void onModelChanged() {
        this.sorter.setDefaultModel(this.getDefaultModel());
    }

    public void render(PluginRequestTarget target) {
        super.render(target);
        if (target != null) {
            this.saveDialogLink.update(target);
            if (this.sorter.isDirty()) {
                target.add(new Component[]{this.sorter});
            }
            target.appendJavaScript((CharSequence)"Hippo.ConsoleMenuPlugin.render();");
        }
    }

    public void renderHead(IHeaderResponse response) {
        super.renderHead(response);
        response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)SCRIPT_REFERENCE));
    }
}

