/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.dialog;

import java.io.Serializable;
import java.util.List;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.hippoecm.frontend.dialog.AbstractDialog;

public abstract class MultiStepDialog<T>
extends AbstractDialog<T> {
    private int currentStep = 0;

    public MultiStepDialog() {
        this(null);
    }

    public MultiStepDialog(IModel<T> model) {
        super(model);
        this.updateLabels();
    }

    private void updateLabels() {
        List<Step> steps = this.getSteps();
        if (steps.size() > this.currentStep) {
            Step step = steps.get(this.currentStep);
            this.setOkLabel(step.getOkLabel());
            this.setCancelLabel(step.getCancelLabel());
            String info = step.getInfo();
            if (info != null) {
                this.info((Serializable)((Object)info));
            }
        }
    }

    protected void handleSubmit() {
        List<Step> steps = this.getSteps();
        if (steps.size() > this.currentStep) {
            int result = steps.get(this.currentStep).execute();
            this.currentStep += result;
            if (result != 0) {
                this.updateLabels();
            }
        } else {
            this.closeDialog();
        }
    }

    protected abstract List<Step> getSteps();

    public class DoneStep
    extends Step {
        private static final long serialVersionUID = 1L;

        @Override
        public int execute() {
            MultiStepDialog.this.closeDialog();
            return 0;
        }

        @Override
        protected IModel<String> getOkLabel() {
            return new Model((Serializable)((Object)"Done"));
        }
    }

    protected abstract class Step
    implements Serializable {
        private static final long serialVersionUID = 1L;

        protected Step() {
        }

        protected abstract int execute();

        protected IModel<String> getOkLabel() {
            return new Model((Serializable)((Object)"OK"));
        }

        protected IModel<String> getCancelLabel() {
            return new Model((Serializable)((Object)"Cancel"));
        }

        public String getInfo() {
            return null;
        }
    }
}

