/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.dialog;

import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.tree.ITreeState;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.hippoecm.frontend.model.tree.IJcrTreeModel;
import org.hippoecm.frontend.model.tree.IJcrTreeNode;
import org.hippoecm.frontend.plugins.console.browser.JcrConsoleTree;
import org.hippoecm.frontend.plugins.console.dialog.LookupDialog;

class LookupTargetTreeView
extends JcrConsoleTree {
    private static final long serialVersionUID = 1L;
    private IJcrTreeNode selectedNode;
    private LookupDialog dialog;

    LookupTargetTreeView(String id, TreeModel treeModel, LookupDialog dialog) {
        super(id, treeModel);
        this.dialog = dialog;
    }

    protected void onNodeLinkClicked(AjaxRequestTarget target, TreeNode treeNode) {
        if (treeNode instanceof IJcrTreeNode) {
            IJcrTreeNode jcrTreeNode;
            this.selectedNode = jcrTreeNode = (IJcrTreeNode)treeNode;
            this.dialog.setModel(jcrTreeNode.getNodeModel());
        }
    }

    IJcrTreeNode getSelectedNode() {
        return this.selectedNode;
    }

    void setSelectedNode(JcrNodeModel selectedNode, IJcrTreeModel treeModel) {
        ITreeState treeState = this.getTreeState();
        TreePath treePath = treeModel.lookup(selectedNode);
        if (treePath != null) {
            for (Object component : treePath.getPath()) {
                treeState.expandNode((Object)((TreeNode)component));
            }
            TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
            treeState.selectNode((Object)((TreeNode)treePath.getLastPathComponent()), true);
            if (treeNode instanceof IJcrTreeNode) {
                this.selectedNode = (IJcrTreeNode)treeNode;
            }
        }
    }
}

