/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.browser;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AbstractDefaultAjaxBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.tree.DefaultTreeState;
import org.apache.wicket.extensions.markup.html.tree.ITreeState;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.markup.head.JavaScriptHeaderItem;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.panel.EmptyPanel;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.IRequestParameters;
import org.apache.wicket.request.cycle.RequestCycle;
import org.apache.wicket.request.resource.JavaScriptResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.string.StringValue;
import org.hippoecm.frontend.PluginRequestTarget;
import org.hippoecm.frontend.behaviors.IContextMenu;
import org.hippoecm.frontend.behaviors.IContextMenuManager;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.dialog.DialogLink;
import org.hippoecm.frontend.dialog.IDialogFactory;
import org.hippoecm.frontend.dialog.IDialogService;
import org.hippoecm.frontend.model.JcrNodeModel;
import org.hippoecm.frontend.model.event.IObserver;
import org.hippoecm.frontend.model.tree.IJcrTreeNode;
import org.hippoecm.frontend.model.tree.JcrTreeModel;
import org.hippoecm.frontend.model.tree.JcrTreeNode;
import org.hippoecm.frontend.model.tree.JcrTreeNodeComparator;
import org.hippoecm.frontend.plugin.IPluginContext;
import org.hippoecm.frontend.plugin.config.IPluginConfig;
import org.hippoecm.frontend.plugins.console.NodeModelReference;
import org.hippoecm.frontend.plugins.console.browser.JcrConsoleTree;
import org.hippoecm.frontend.plugins.console.browser.TreeNavigator;
import org.hippoecm.frontend.plugins.console.icons.FontAwesomeIcon;
import org.hippoecm.frontend.plugins.console.menu.content.ContentExportDialog;
import org.hippoecm.frontend.plugins.console.menu.content.ContentImportDialog;
import org.hippoecm.frontend.plugins.console.menu.copy.CopyDialog;
import org.hippoecm.frontend.plugins.console.menu.delete.DeleteDialog;
import org.hippoecm.frontend.plugins.console.menu.move.MoveDialog;
import org.hippoecm.frontend.plugins.console.menu.node.NodeDialog;
import org.hippoecm.frontend.plugins.console.menu.property.PropertyDialog;
import org.hippoecm.frontend.plugins.console.menu.recompute.RecomputeDialog;
import org.hippoecm.frontend.plugins.console.menu.rename.RenameDialog;
import org.hippoecm.frontend.plugins.console.menu.t9ids.T9idsDialog;
import org.hippoecm.frontend.plugins.standards.list.resolvers.CssClass;
import org.hippoecm.frontend.plugins.yui.rightclick.RightClickBehavior;
import org.hippoecm.frontend.plugins.yui.scrollbehavior.ScrollBehavior;
import org.hippoecm.frontend.plugins.yui.widget.tree.TreeWidgetBehavior;
import org.hippoecm.frontend.plugins.yui.widget.tree.TreeWidgetSettings;
import org.hippoecm.frontend.service.render.RenderPlugin;
import org.hippoecm.frontend.widgets.JcrTree;
import org.hippoecm.repository.api.HippoNode;
import org.hippoecm.repository.util.JcrUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrowserPlugin
extends RenderPlugin<Node> {
    private static final long serialVersionUID = 1L;
    public static final Logger log = LoggerFactory.getLogger(BrowserPlugin.class);
    private static final JavaScriptResourceReference NAVIGATION_JS = new JavaScriptResourceReference(BrowserPlugin.class, "navigation.js");
    protected final JcrTree tree;
    private TreeWidgetBehavior treeBehavior;
    private volatile boolean navigating;
    protected final JcrTreeModel treeModel;
    protected final IJcrTreeNode rootNode = new JcrTreeNode((IModel)new JcrNodeModel("/"), null, (Comparator)new JcrTreeNodeComparator());

    public BrowserPlugin(IPluginContext context, IPluginConfig config) {
        super(context, config);
        this.treeModel = new JcrTreeModel(this.rootNode);
        context.registerService((IClusterable)this.treeModel, IObserver.class.getName());
        this.tree = this.newTree(this.treeModel);
        this.add(new Component[]{this.tree});
        this.add(new Behavior[]{new ScrollBehavior()});
        this.onModelChanged();
    }

    protected JcrTree newTree(JcrTreeModel treeModel) {
        final BrowserTree newTree = new BrowserTree(treeModel);
        Behavior[] behaviorArray = new Behavior[1];
        this.treeBehavior = new TreeWidgetBehavior(new TreeWidgetSettings());
        behaviorArray[0] = this.treeBehavior;
        newTree.add(behaviorArray);
        newTree.add(new Behavior[]{new AbstractDefaultAjaxBehavior(){
            final TreeNavigator navigator;
            {
                this.navigator = new TreeNavigator(newTree.getTreeState());
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void respond(AjaxRequestTarget target) {
                BrowserPlugin.this.navigating = true;
                try {
                    RequestCycle rc = RequestCycle.get();
                    String key = rc.getRequest().getQueryParameters().getParameterValue("key").toString();
                    if ("Up".equals(key)) {
                        this.navigator.up();
                        this.updateModel(target);
                    } else if ("Down".equals(key)) {
                        this.navigator.down();
                        this.updateModel(target);
                    } else if ("Left".equals(key)) {
                        this.navigator.left();
                    } else if ("Right".equals(key)) {
                        this.navigator.right();
                    }
                }
                finally {
                    BrowserPlugin.this.navigating = false;
                }
            }

            private void updateModel(AjaxRequestTarget target) {
                Object treeNode;
                Collection selectedNodes = newTree.getTreeState().getSelectedNodes();
                if (selectedNodes.size() == 1 && (treeNode = selectedNodes.iterator().next()) instanceof IJcrTreeNode) {
                    BrowserPlugin.this.onSelect((IJcrTreeNode)treeNode, target);
                }
            }

            public void renderHead(Component component, IHeaderResponse response) {
                super.renderHead(component, response);
                response.render((HeaderItem)OnDomReadyHeaderItem.forScript((CharSequence)("Hippo.Tree.addShortcuts('" + this.getCallbackUrl() + "');")));
            }
        }});
        return newTree;
    }

    protected void onSelect(IJcrTreeNode treeNodeModel, AjaxRequestTarget target) {
        this.setDefaultModel(treeNodeModel.getNodeModel());
        IContextMenuManager manager = (IContextMenuManager)this.findParent(IContextMenuManager.class);
        if (manager != null) {
            manager.collapseAllContextMenus();
        }
    }

    public void render(PluginRequestTarget target) {
        super.render(target);
        if (target != null) {
            this.tree.updateTree();
        }
        this.treeBehavior.render((AjaxRequestTarget)target);
    }

    public void onModelChanged() {
        super.onModelChanged();
        JcrNodeModel model = (JcrNodeModel)this.getDefaultModel();
        TreePath treePath = this.treeModel.lookup(model);
        if (treePath != null) {
            ITreeState treeState = this.tree.getTreeState();
            if (!this.navigating) {
                for (Object node : treePath.getPath()) {
                    TreeNode treeNode = (TreeNode)node;
                    if (treeState.isNodeExpanded((Object)treeNode)) continue;
                    treeState.expandNode((Object)treeNode);
                }
            }
            treeState.selectNode(treePath.getLastPathComponent(), true);
        }
    }

    private IRequestParameters getRequestParameters() {
        return RequestCycle.get().getRequest().getRequestParameters();
    }

    private class BrowserTree
    extends JcrConsoleTree {
        private static final long serialVersionUID = 1L;

        public BrowserTree(JcrTreeModel treeModel) {
            super("tree", (TreeModel)treeModel);
        }

        public void renderHead(IHeaderResponse response) {
            super.renderHead(response);
            response.render((HeaderItem)JavaScriptHeaderItem.forReference((ResourceReference)NAVIGATION_JS));
        }

        public boolean isVirtual(IJcrTreeNode jcrNode) {
            try {
                HippoNode hippoNode = (HippoNode)jcrNode;
                return hippoNode.isVirtual();
            }
            catch (RepositoryException e) {
                log.info("Cannot determine whether node '{}' is virtual, assuming it's not", (Object)JcrUtils.getNodePathQuietly((Node)((Node)jcrNode)), (Object)e);
                return false;
            }
        }

        protected ITreeState newTreeState() {
            DefaultTreeState state = new DefaultTreeState();
            JcrTreeModel model = (JcrTreeModel)this.getModelObject();
            model.setTreeState(state);
            return state;
        }

        protected void populateTreeItem(WebMarkupContainer item, int level) {
            super.populateTreeItem(item, level);
            Object object = item.getDefaultModelObject();
            if (object instanceof IJcrTreeNode) {
                IJcrTreeNode treeNode = (IJcrTreeNode)object;
                final WebMarkupContainer menu = this.createContextMenu("contextMenu", (JcrNodeModel)treeNode.getNodeModel());
                item.add(new Component[]{menu});
                item.add(new Behavior[]{new RightClickBehavior((MarkupContainer)menu, (MarkupContainer)item){
                    private static final long serialVersionUID = 1L;

                    protected void respond(AjaxRequestTarget target) {
                        this.getContextmenu().setVisible(true);
                        target.add(new Component[]{this.getComponentToUpdate()});
                        IContextMenuManager menuManager = (IContextMenuManager)BrowserTree.this.findParent(IContextMenuManager.class);
                        if (menuManager != null) {
                            menuManager.showContextMenu((IContextMenu)this);
                            IRequestParameters requestParameters = BrowserPlugin.this.getRequestParameters();
                            StringValue x = requestParameters.getParameterValue("x");
                            StringValue y = requestParameters.getParameterValue("y");
                            target.appendJavaScript((CharSequence)("Hippo.ContextMenu.renderAtPosition('" + menu.getMarkupId() + "', " + x + ", " + y + ");"));
                        }
                    }
                }});
            } else {
                item.add(new Component[]{new EmptyPanel("contextMenu")});
            }
        }

        protected void onNodeLinkClicked(AjaxRequestTarget target, TreeNode clickedNode) {
            if (clickedNode instanceof IJcrTreeNode) {
                IJcrTreeNode treeNodeModel = (IJcrTreeNode)clickedNode;
                BrowserPlugin.this.onSelect(treeNodeModel, target);
            }
        }

        private WebMarkupContainer createContextMenu(String contextMenu, final JcrNodeModel model) {
            Fragment menuContainer = new Fragment(contextMenu, "menu", (MarkupContainer)this);
            menuContainer.setOutputMarkupId(true);
            menuContainer.setVisible(false);
            Object dialogFactory = new IDialogFactory(){
                private static final long serialVersionUID = 1L;

                public AbstractDialog<Node> createDialog() {
                    return new NodeDialog(new NodeModelReference((Component)BrowserPlugin.this, (IModel<Node>)model));
                }
            };
            menuContainer.add(new Component[]{new DialogLink("add-node", (IModel)new Model((Serializable)((Object)this.getString("add.node"))), dialogFactory, BrowserPlugin.this.getDialogService())});
            Label iconAddNode = new Label("icon-add-node", "");
            iconAddNode.add(new Behavior[]{CssClass.append((String)FontAwesomeIcon.PLUS.cssClass())});
            iconAddNode.add(new Behavior[]{CssClass.append((String)"add-icon")});
            menuContainer.add(new Component[]{iconAddNode});
            dialogFactory = new IDialogFactory(){
                private static final long serialVersionUID = 1L;

                public AbstractDialog<Node> createDialog() {
                    return new DeleteDialog(new NodeModelReference((Component)BrowserPlugin.this, (IModel<Node>)model));
                }
            };
            menuContainer.add(new Component[]{new DialogLink("delete-node", (IModel)new Model((Serializable)((Object)this.getString("delete.node"))), dialogFactory, BrowserPlugin.this.getDialogService())});
            Label iconDeleteNode = new Label("icon-delete-node", "");
            iconDeleteNode.add(new Behavior[]{CssClass.append((String)FontAwesomeIcon.TIMES.cssClass())});
            iconDeleteNode.add(new Behavior[]{CssClass.append((String)"delete-icon")});
            menuContainer.add(new Component[]{iconDeleteNode});
            dialogFactory = new IDialogFactory(){
                private static final long serialVersionUID = 1L;

                public AbstractDialog<Node> createDialog() {
                    return new PropertyDialog(new NodeModelReference((Component)BrowserPlugin.this, (IModel<Node>)model));
                }
            };
            menuContainer.add(new Component[]{new DialogLink("add-property", (IModel)new Model((Serializable)((Object)this.getString("add.property"))), dialogFactory, BrowserPlugin.this.getDialogService())});
            Label addProperty = new Label("icon-add-property", "");
            addProperty.add(new Behavior[]{CssClass.append((String)FontAwesomeIcon.PLUS.cssClass())});
            addProperty.add(new Behavior[]{CssClass.append((String)"add-property-icon")});
            menuContainer.add(new Component[]{addProperty});
            dialogFactory = new IDialogFactory(){
                private static final long serialVersionUID = 1L;

                public AbstractDialog<Node> createDialog() {
                    return new CopyDialog(new NodeModelReference((Component)BrowserPlugin.this, (IModel<Node>)model));
                }
            };
            menuContainer.add(new Component[]{new DialogLink("copy-node", (IModel)new Model((Serializable)((Object)this.getString("copy.node"))), dialogFactory, BrowserPlugin.this.getDialogService())});
            Label iconCopyNode = new Label("icon-copy-node", "");
            iconCopyNode.add(new Behavior[]{CssClass.append((String)FontAwesomeIcon.FILES_O.cssClass())});
            iconCopyNode.add(new Behavior[]{CssClass.append((String)"copy-icon")});
            menuContainer.add(new Component[]{iconCopyNode});
            dialogFactory = new IDialogFactory(){
                private static final long serialVersionUID = 1L;

                public AbstractDialog<Node> createDialog() {
                    return new MoveDialog(new NodeModelReference((Component)BrowserPlugin.this, (IModel<Node>)model));
                }
            };
            menuContainer.add(new Component[]{new DialogLink("move-node", (IModel)new Model((Serializable)((Object)this.getString("move.node"))), dialogFactory, BrowserPlugin.this.getDialogService())});
            Label iconMoveNode = new Label("icon-move-node", "");
            iconMoveNode.add(new Behavior[]{CssClass.append((String)FontAwesomeIcon.BARS.cssClass())});
            iconMoveNode.add(new Behavior[]{CssClass.append((String)"move-icon")});
            menuContainer.add(new Component[]{iconMoveNode});
            dialogFactory = new IDialogFactory(){
                private static final long serialVersionUID = 1L;

                public AbstractDialog<Node> createDialog() {
                    return new RenameDialog(new NodeModelReference((Component)BrowserPlugin.this, (IModel<Node>)model));
                }
            };
            menuContainer.add(new Component[]{new DialogLink("rename-node", (IModel)new Model((Serializable)((Object)this.getString("rename.node"))), dialogFactory, BrowserPlugin.this.getDialogService())});
            Label iconRenameNode = new Label("icon-rename-node", "");
            iconRenameNode.add(new Behavior[]{CssClass.append((String)FontAwesomeIcon.PENCIL_SQUARE_O.cssClass())});
            iconRenameNode.add(new Behavior[]{CssClass.append((String)"rename-icon")});
            menuContainer.add(new Component[]{iconRenameNode});
            dialogFactory = new IDialogFactory(){
                private static final long serialVersionUID = 1L;

                public IDialogService.Dialog createDialog() {
                    return new ContentExportDialog(new NodeModelReference((Component)BrowserPlugin.this, (IModel<Node>)model));
                }
            };
            menuContainer.add(new Component[]{new DialogLink("xml-export", (IModel)new Model((Serializable)((Object)this.getString("xml.export"))), dialogFactory, BrowserPlugin.this.getDialogService())});
            Label iconXmlExport = new Label("icon-xml-export", "");
            iconXmlExport.add(new Behavior[]{CssClass.append((IModel)new Model((Serializable)((Object)FontAwesomeIcon.DOWNLOAD.cssClass())))});
            iconXmlExport.add(new Behavior[]{CssClass.append((IModel)new Model((Serializable)((Object)"xml-export-icon")))});
            menuContainer.add(new Component[]{iconXmlExport});
            dialogFactory = new IDialogFactory(){
                private static final long serialVersionUID = 1L;

                public IDialogService.Dialog createDialog() {
                    return new ContentImportDialog(new NodeModelReference((Component)BrowserPlugin.this, (IModel<Node>)model));
                }
            };
            menuContainer.add(new Component[]{new DialogLink("xml-import", (IModel)new Model((Serializable)((Object)this.getString("xml.import"))), dialogFactory, BrowserPlugin.this.getDialogService())});
            Label iconXmlImport = new Label("icon-xml-import", "");
            iconXmlImport.add(new Behavior[]{CssClass.append((String)FontAwesomeIcon.UPLOAD.cssClass())});
            iconXmlImport.add(new Behavior[]{CssClass.append((String)"xml-import-icon")});
            menuContainer.add(new Component[]{iconXmlImport});
            dialogFactory = new IDialogFactory(){
                private static final long serialVersionUID = 1L;

                public IDialogService.Dialog createDialog() {
                    return new T9idsDialog((IModel<Node>)model);
                }
            };
            menuContainer.add(new Component[]{new DialogLink("t9ids", (IModel)new Model((Serializable)((Object)this.getString("new.translation.ids"))), dialogFactory, BrowserPlugin.this.getDialogService())});
            Label iconT9ids = new Label("icon-t9ids", "");
            iconT9ids.add(new Behavior[]{CssClass.append((String)FontAwesomeIcon.FLAG_O.cssClass())});
            iconT9ids.add(new Behavior[]{CssClass.append((String)"t9ids-icon")});
            menuContainer.add(new Component[]{iconT9ids});
            dialogFactory = new IDialogFactory(){
                private static final long serialVersionUID = 1L;

                public IDialogService.Dialog createDialog() {
                    return new RecomputeDialog((IModel<Node>)model);
                }
            };
            menuContainer.add(new Component[]{new DialogLink("recompute", (IModel)new Model((Serializable)((Object)this.getString("recompute.derived"))), dialogFactory, BrowserPlugin.this.getDialogService())});
            Label iconHippoPaths = new Label("icon-recompute", "");
            iconHippoPaths.add(new Behavior[]{CssClass.append((String)FontAwesomeIcon.CALCULATOR.cssClass())});
            iconHippoPaths.add(new Behavior[]{CssClass.append((String)"recompute-icon")});
            menuContainer.add(new Component[]{iconHippoPaths});
            return menuContainer;
        }
    }
}

