/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.t9ids;

import java.util.UUID;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.visitor.FilteringItemVisitor;
import org.hippoecm.frontend.plugins.console.menu.t9ids.IsNotVirtualPredicate;

public class GenerateNewTranslationIdsVisitor
extends FilteringItemVisitor {
    private String handleId;
    private String handleT9Id;

    public GenerateNewTranslationIdsVisitor() {
        this.setWalkProperties(false);
        this.setTraversalPredicate(IsNotVirtualPredicate.INSTANCE);
    }

    protected void entering(Property property, int level) throws RepositoryException {
    }

    protected void leaving(Property property, int level) throws RepositoryException {
    }

    protected void entering(Node node, int level) throws RepositoryException {
        if (node.isNodeType("hippo:handle")) {
            this.handleId = node.getIdentifier();
            this.handleT9Id = UUID.randomUUID().toString();
        }
        if (node.hasProperty("hippotranslation:id")) {
            String newTranslationId = this.createTranslationId(node);
            node.setProperty("hippotranslation:id", newTranslationId);
        }
    }

    private String createTranslationId(Node node) throws RepositoryException {
        return this.parentIsHandle(node) ? this.handleT9Id : UUID.randomUUID().toString();
    }

    private boolean parentIsHandle(Node node) throws RepositoryException {
        if (this.handleId != null) {
            Node parent = node.getParent();
            return parent != null && parent.getIdentifier().equals(this.handleId);
        }
        return false;
    }

    protected void leaving(Node node, int level) throws RepositoryException {
        if (node.isNodeType("hippo:handle")) {
            this.handleId = null;
            this.handleT9Id = null;
        }
    }
}

