/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.save;

import java.io.Serializable;
import javax.jcr.AccessDeniedException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.value.IValueMap;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.dialog.DialogConstants;
import org.hippoecm.frontend.plugins.console.menu.content.ContentImportDialog;
import org.hippoecm.frontend.session.UserSession;
import org.hippoecm.repository.api.HippoNode;
import org.onehippo.cms7.event.HippoEvent;
import org.onehippo.cms7.services.HippoServiceRegistry;
import org.onehippo.cms7.services.eventbus.HippoEventBus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaveDialog
extends AbstractDialog<Node> {
    private static final long serialVersionUID = 1L;
    private static final Logger log = LoggerFactory.getLogger(ContentImportDialog.class);

    public SaveDialog() {
        Label message;
        try {
            HippoNode rootNode = (HippoNode)UserSession.get().getJcrSession().getRootNode();
            if (rootNode.getSession().hasPendingChanges()) {
                StringBuilder buf = new StringBuilder("Pending changes:\n");
                this.appendPendingChangesFromNodeToBuffer(rootNode, buf, "\n");
                message = new MultiLineLabel("message", buf.toString());
            } else {
                message = new Label("message", "There are no pending changes");
                this.setOkVisible(false);
                this.setFocusOnCancel();
            }
        }
        catch (RepositoryException e) {
            log.error("Error while rendering save dialog", (Throwable)e);
            message = new Label("message", "exception: " + e.getMessage());
            this.setOkVisible(false);
            this.setFocusOnCancel();
        }
        this.add(new Component[]{message});
        this.setFocusOnOk();
    }

    public void onOk() {
        try {
            Session jcrSession = UserSession.get().getJcrSession();
            HippoNode rootNode = (HippoNode)jcrSession.getRootNode();
            StringBuilder buffer = new StringBuilder("User made changes at: ");
            this.appendPendingChangesFromNodeToBuffer(rootNode, buffer, ",");
            jcrSession.save();
            this.logEvent("write-changes", jcrSession.getUserID(), buffer.toString());
            jcrSession.refresh(false);
        }
        catch (AccessDeniedException e) {
            this.error((Serializable)((Object)(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage())));
        }
        catch (RepositoryException e) {
            log.error("Error while saving content from the console", (Throwable)e);
            this.error((Serializable)((Object)(((Object)((Object)e)).getClass().getName() + ": " + e.getMessage())));
        }
    }

    private void appendPendingChangesFromNodeToBuffer(HippoNode rootNode, StringBuilder buf, String delimiter) throws RepositoryException {
        NodeIterator it = rootNode.pendingChanges();
        if (it.hasNext()) {
            while (it.hasNext()) {
                Node node = it.nextNode();
                buf.append(node.getPath());
                if (!it.hasNext()) continue;
                buf.append(delimiter);
            }
        }
    }

    private void logEvent(String action, String user, String message) {
        HippoEventBus eventBus = (HippoEventBus)HippoServiceRegistry.getService(HippoEventBus.class);
        if (eventBus != null) {
            HippoEvent event = new HippoEvent("console");
            event.category("console").user(user).action(action);
            event.message(message);
            eventBus.post((Object)event);
        }
    }

    public IModel getTitle() {
        return new Model((Serializable)((Object)"Save Session"));
    }

    public IValueMap getProperties() {
        return DialogConstants.MEDIUM;
    }
}

