/*
 * Decompiled with CFR 0.152.
 */
package org.hippoecm.frontend.plugins.console.menu.reset;

import java.io.Serializable;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.basic.MultiLineLabel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.value.IValueMap;
import org.hippoecm.frontend.dialog.AbstractDialog;
import org.hippoecm.frontend.dialog.DialogConstants;
import org.hippoecm.frontend.session.UserSession;
import org.hippoecm.repository.api.HippoNode;

public class ResetDialog
extends AbstractDialog<Node> {
    private static final long serialVersionUID = 1L;
    protected boolean hasPendingChanges;

    public ResetDialog() {
        Label message;
        try {
            HippoNode rootNode = (HippoNode)UserSession.get().getJcrSession().getRootNode();
            if (rootNode.getSession().hasPendingChanges()) {
                this.hasPendingChanges = true;
                StringBuffer buf = new StringBuffer("Pending changes:\n");
                NodeIterator it = rootNode.pendingChanges();
                if (it.hasNext()) {
                    while (it.hasNext()) {
                        Node node = it.nextNode();
                        buf.append(node.getPath()).append("\n");
                    }
                }
                message = new MultiLineLabel("message", buf.toString());
            } else {
                message = new Label("message", "There are no pending changes");
            }
        }
        catch (RepositoryException e) {
            message = new Label("message", "exception: " + e.getMessage());
            e.printStackTrace();
        }
        this.add(new Component[]{message});
        this.setFocusOnOk();
    }

    public void onOk() {
        try {
            Node rootNode = UserSession.get().getJcrSession().getRootNode();
            rootNode.refresh(false);
        }
        catch (RepositoryException ex) {
            this.error((Serializable)((Object)ex.getMessage()));
        }
    }

    public IModel getTitle() {
        return new Model((Serializable)((Object)"Refresh Session"));
    }

    public IValueMap getProperties() {
        return DialogConstants.MEDIUM;
    }
}

